/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.redis.introspector;

import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DataSourceBriefConfig;
import com.intellij.database.dataSource.DatabaseConnectionCore;
import com.intellij.database.dataSource.url.HostPort;
import com.intellij.database.dialects.base.introspector.BaseIntrospectionFunctions;
import com.intellij.database.dialects.base.introspector.BaseIntrospector;
import com.intellij.database.dialects.base.introspector.BaseNativeIntrospector;
import com.intellij.database.dialects.base.introspector.BaseSingleDatabaseIntrospector;
import com.intellij.database.dialects.redis.RedisDbms;
import com.intellij.database.dialects.redis.RedisDefaultKeyFilterOption;
import com.intellij.database.dialects.redis.RedisScanCountOption;
import com.intellij.database.dialects.redis.introspector.RedisIntroQueries;
import com.intellij.database.dialects.redis.introspector.RedisIntrospector;
import com.intellij.database.dialects.redis.introspector.RedisIntrospector$applySchemas$lambda$15$;
import com.intellij.database.dialects.redis.model.RedisDataStructureKey;
import com.intellij.database.dialects.redis.model.RedisHashTableKey;
import com.intellij.database.dialects.redis.model.RedisJsonDocumentKey;
import com.intellij.database.dialects.redis.model.RedisKey;
import com.intellij.database.dialects.redis.model.RedisListKey;
import com.intellij.database.dialects.redis.model.RedisRoot;
import com.intellij.database.dialects.redis.model.RedisSchema;
import com.intellij.database.dialects.redis.model.RedisSetKey;
import com.intellij.database.dialects.redis.model.RedisSortedSetKey;
import com.intellij.database.dialects.redis.model.RedisStreamKey;
import com.intellij.database.dialects.redis.model.RedisStringKey;
import com.intellij.database.dialects.redis.model.RedisUnknownKey;
import com.intellij.database.introspection.DBIntrospectionContext;
import com.intellij.database.introspection.DBIntrospector;
import com.intellij.database.layoutedQueries.DBTransaction;
import com.intellij.database.model.BaseModel;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ElementCacheKt;
import com.intellij.database.model.ElementCacheOptimizersKt;
import com.intellij.database.model.ElementSearchCache;
import com.intellij.database.model.ElementSearcher;
import com.intellij.database.model.ElementSearcherNN;
import com.intellij.database.model.FamilySearcher;
import com.intellij.database.model.ModelFactory;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.PerObjectVersion;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModMateNamespace;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModNamedElement;
import com.intellij.database.model.basic.BasicModSchema;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.families.ModNamingFamily;
import com.intellij.database.model.families.NamingFamily;
import com.intellij.database.model.meta.BasicMetaUtils;
import com.intellij.database.remote.jdba.exceptions.DBFetchingException;
import com.intellij.database.remote.jdba.exceptions.DBSchemaAccessDeniedException;
import com.intellij.database.remote.jdbc.helpers.JdbcNativeUtil;
import com.intellij.database.util.TreePattern;
import com.intellij.database.util.Version;
import com.intellij.util.text.StringKt;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00be\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0004RSTUB\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010\u001f\u001a\u00020\u000b*\u0004\u0018\u00010\u000fH\u0002J$\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010!2\u0006\u0010#\u001a\u00020$2\b\u0010%\u001a\u0004\u0018\u00010&H\u0016J\b\u0010'\u001a\u00020(H\u0014J\b\u0010)\u001a\u00020(H\u0002J\b\u0010*\u001a\u00020(H\u0002J\u0012\u0010+\u001a\u0004\u0018\u00010\f2\u0006\u0010,\u001a\u00020-H\u0002J\u0016\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010/\u001a\u000200H\u0002J\u0010\u00101\u001a\u00020\u001e2\u0006\u00102\u001a\u000203H\u0002J\u0010\u00104\u001a\u00020\u000b2\u0006\u00105\u001a\u00020\u000fH\u0002J\u000f\u00106\u001a\t\u0018\u00010\u000f\u00a2\u0006\u0002\b7H\u0002J\u0010\u00108\u001a\u00020(2\u0006\u00105\u001a\u00020\u000fH\u0002J&\u00109\u001a\u00020(2\u0006\u0010:\u001a\u00020;2\f\u0010<\u001a\b\u0012\u0004\u0012\u00020\u00030\u001d2\u0006\u0010=\u001a\u00020\u000bH\u0014J\b\u0010>\u001a\u00020(H\u0016J\u0010\u0010?\u001a\u00020(2\u0006\u0010:\u001a\u00020;H\u0014J\b\u0010@\u001a\u00020(H\u0002J\u0012\u0010A\u001a\u00020\u000b2\b\u0010B\u001a\u0004\u0018\u00010CH\u0002J\u0010\u0010A\u001a\u00020(2\u0006\u0010D\u001a\u00020EH\u0002J0\u0010A\u001a\u00020(\"\u0004\b\u0000\u0010F2\f\u0010G\u001a\b\u0012\u0004\u0012\u0002HF0\u001d2\u0012\u0010H\u001a\u000e\u0012\u0004\u0012\u0002HF\u0012\u0004\u0012\u00020\u000f0IH\u0002J4\u0010J\u001a\u001e\u0012\u0004\u0012\u00020\u00020KR\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030L2\u0006\u0010M\u001a\u00020;2\u0006\u0010N\u001a\u00020\u0002H\u0014J4\u0010O\u001a\u001e\u0012\u0004\u0012\u00020\u00030PR\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030L2\u0006\u0010M\u001a\u00020;2\u0006\u0010Q\u001a\u00020\u0003H\u0014R\u0018\u0010\n\u001a\u00020\u000b*\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\rR\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0012R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0019R\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006V"}, d2={"Lcom/intellij/database/dialects/redis/introspector/RedisIntrospector;", "Lcom/intellij/database/dialects/base/introspector/BaseSingleDatabaseIntrospector;", "Lcom/intellij/database/dialects/redis/model/RedisRoot;", "Lcom/intellij/database/dialects/redis/model/RedisSchema;", "context", "Lcom/intellij/database/introspection/DBIntrospectionContext;", "modelFactory", "Lcom/intellij/database/model/ModelFactory;", "<init>", "(Lcom/intellij/database/introspection/DBIntrospectionContext;Lcom/intellij/database/model/ModelFactory;)V", "isSupported", "", "Lcom/intellij/database/dialects/redis/introspector/RedisIntrospector$Mode;", "(Lcom/intellij/database/dialects/redis/introspector/RedisIntrospector$Mode;)Z", "keyPattern", "", "scanCount", "", "Ljava/lang/Long;", "mode", "modules", "", "Lcom/intellij/database/model/ObjectKind;", "supportsKeysScanWithType", "getSupportsKeysScanWithType", "()Z", "requiresAllClusterNodesIntrospection", "getRequiresAllClusterNodesIntrospection", "clusterNodes", "", "Lcom/intellij/database/dataSource/url/HostPort;", "isClusterCompliantKeyPattern", "init", "Lcom/intellij/database/model/basic/BasicModModel;", "model", "dsConfig", "Lcom/intellij/database/dataSource/DataSourceBriefConfig;", "introspectionScope", "Lcom/intellij/database/util/TreePattern;", "initConnectionRelatedState", "", "initVersionParameters", "initServerConfiguration", "extractMode", "serverInfo", "Lcom/intellij/database/dialects/redis/introspector/RedisIntroQueries$ServerInfo;", "extractModules", "modulesInfo", "Lcom/intellij/database/dialects/redis/introspector/RedisIntroQueries$ModulesInfo;", "extractMasterNode", "slotsInfo", "Lcom/intellij/database/dialects/redis/introspector/RedisIntroQueries$SlotsInfo;", "isCurrentSchema", "name", "getSchema", "Lorg/jetbrains/annotations/Nullable;", "setSchema", "introspectSchemasAuto", "tran", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "schemas", "whole", "retrieveAndApplySchemas", "introspectNamespacesInTran", "applyClusterSchema", "applySchemas", "dbCountInfo", "Lcom/intellij/database/dialects/redis/introspector/RedisIntroQueries$DbCountInfo;", "keyspaceInfo", "Lcom/intellij/database/dialects/redis/introspector/RedisIntroQueries$KeyspaceInfo;", "T", "dbs", "nameGetter", "Lkotlin/Function1;", "createDatabaseRetriever", "Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector$AbstractDatabaseRetriever;", "Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector;", "transaction", "database", "createSchemaRetriever", "Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector$AbstractSchemaRetriever;", "schema", "Factory", "DefaultNature", "Mode", "RedisSchemaRetriever", "intellij.database.dialects.redis"})
@SourceDebugExtension(value={"SMAP\nRedisIntrospector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RedisIntrospector.kt\ncom/intellij/database/dialects/redis/introspector/RedisIntrospector\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 DataSourceBriefConfig.kt\ncom/intellij/database/dataSource/DataSourceBriefConfigs\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 ModelFun.kt\ncom/intellij/database/model/ModelFun\n+ 6 ElementCache.kt\ncom/intellij/database/model/FamilySearcher\n*L\n1#1,356:1\n1#2:357\n1#2:398\n44#3,2:358\n39#3:360\n39#3:361\n1557#4:362\n1628#4,3:363\n1863#4:395\n1864#4:408\n417#5,10:366\n427#5,9:386\n436#5:396\n428#5:397\n429#5,9:399\n438#5,3:409\n430#5:412\n431#5:414\n189#6,10:376\n202#6:413\n*S KotlinDebug\n*F\n+ 1 RedisIntrospector.kt\ncom/intellij/database/dialects/redis/introspector/RedisIntrospector\n*L\n229#1:398\n105#1:358,2\n105#1:360\n107#1:361\n130#1:362\n130#1:363,3\n229#1:395\n229#1:408\n229#1:366,10\n229#1:386,9\n229#1:396\n229#1:397\n229#1:399,9\n229#1:409,3\n229#1:412\n229#1:414\n229#1:376,10\n229#1:413\n*E\n"})
public final class RedisIntrospector
extends BaseSingleDatabaseIntrospector<RedisRoot, RedisSchema> {
    @Nullable
    private String keyPattern;
    @Nullable
    private Long scanCount;
    @Nullable
    private Mode mode;
    @NotNull
    private Set<? extends ObjectKind> modules;
    @NotNull
    private List<? extends HostPort> clusterNodes;

    public RedisIntrospector(@NotNull DBIntrospectionContext context, @NotNull ModelFactory modelFactory) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)modelFactory, (String)"modelFactory");
        BaseIntrospector.Nature nature = DefaultNature.INSTANCE;
        Dbms dbms = RedisDbms.REDIS;
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"REDIS");
        super(context, nature, dbms, modelFactory);
        this.modules = SetsKt.emptySet();
        this.clusterNodes = CollectionsKt.emptyList();
    }

    private final boolean isSupported(Mode $this$isSupported) {
        Version supportedSinceDriverVersion = switch (WhenMappings.$EnumSwitchMapping$0[$this$isSupported.ordinal()]) {
            case 1 -> Version.ZERO;
            case 2 -> {
                int[] var3_2 = new int[]{1, 4};
                yield Version.of(var3_2);
            }
            case 3 -> Version.INFINITY;
            default -> throw new NoWhenBranchMatchedException();
        };
        return this.getDriverVersion().isOrGreater(supportedSinceDriverVersion);
    }

    private final boolean getSupportsKeysScanWithType() {
        int[] nArray = new int[]{6};
        return this.getServerVersion().isOrGreater(nArray);
    }

    private final boolean getRequiresAllClusterNodesIntrospection() {
        return this.mode == Mode.CLUSTER && !this.isClusterCompliantKeyPattern(this.keyPattern);
    }

    private final boolean isClusterCompliantKeyPattern(String $this$isClusterCompliantKeyPattern) {
        if ($this$isClusterCompliantKeyPattern == null) {
            return false;
        }
        Integer n = StringsKt.indexOf$default((CharSequence)$this$isClusterCompliantKeyPattern, (String)"{", (int)0, (boolean)false, (int)6, null);
        int it = ((Number)n).intValue();
        boolean bl = false;
        Integer n2 = it != -1 ? n : null;
        if (n2 == null) {
            return false;
        }
        int hashTagStart = n2;
        Integer n3 = StringsKt.indexOf$default((CharSequence)$this$isClusterCompliantKeyPattern, (String)"}", (int)(hashTagStart + 1), (boolean)false, (int)4, null);
        int it2 = ((Number)n3).intValue();
        boolean bl2 = false;
        Integer n4 = it2 != -1 ? n3 : null;
        if (n4 == null) {
            return false;
        }
        int hashTagEnd = n4;
        return hashTagEnd != hashTagStart + 1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public BasicModModel init(@Nullable BasicModModel model, @NotNull DataSourceBriefConfig dsConfig, @Nullable TreePattern introspectionScope) {
        Object object;
        String string;
        Intrinsics.checkNotNullParameter((Object)dsConfig, (String)"dsConfig");
        RedisIntrospector redisIntrospector = this;
        Object $this$getStringOptionValue_u24default$iv = dsConfig;
        Object default$iv = null;
        boolean $i$f$getStringOptionValue = false;
        DataSourceBriefConfig $this$getOptionValue$iv$iv = $this$getStringOptionValue_u24default$iv;
        boolean $i$f$getOptionValue = false;
        String string2 = (String)$this$getOptionValue$iv$iv.getProvidedOptionValue(RedisDefaultKeyFilterOption.class);
        if (string2 == null || (string2 = ((Object)StringsKt.trim((CharSequence)string2)).toString()) == null || (string2 = StringKt.nullize$default((String)string2, (boolean)false, (int)1, null)) == null) {
            string2 = default$iv;
        }
        if ((string = string2) != null) {
            void it;
            default$iv = $this$getStringOptionValue_u24default$iv = string;
            RedisIntrospector redisIntrospector2 = redisIntrospector;
            boolean bl = false;
            boolean bl2 = !Intrinsics.areEqual((Object)it, (Object)RedisDefaultKeyFilterOption.getDefault());
            redisIntrospector = redisIntrospector2;
            object = bl2 ? $this$getStringOptionValue_u24default$iv : null;
        } else {
            object = null;
        }
        redisIntrospector.keyPattern = object;
        DataSourceBriefConfig $this$getOptionValue$iv = dsConfig;
        boolean $i$f$getOptionValue2 = false;
        this.scanCount = (Long)$this$getOptionValue$iv.getProvidedOptionValue(RedisScanCountOption.class);
        return super.init(model, dsConfig, introspectionScope);
    }

    @Override
    protected void initConnectionRelatedState() {
        super.initConnectionRelatedState();
        this.initVersionParameters();
        this.initServerConfiguration();
    }

    private final void initVersionParameters() {
        BaseIntrospectionFunctions.setMajorVersionParameters(this.getServerVersion(), 5, this.getParametersMap());
        BaseIntrospectionFunctions.setMajorVersionParameters(this.getServerVersion(), 6, this.getParametersMap());
        BaseIntrospectionFunctions.setMajorVersionParameters(this.getServerVersion(), 7, this.getParametersMap());
    }

    /*
     * WARNING - void declaration
     */
    private final void initServerConfiguration() {
        RedisIntroQueries.ServerInfo serverInfo = (RedisIntroQueries.ServerInfo)this.inTransaction(RedisIntrospector::initServerConfiguration$lambda$3);
        this.mode = this.extractMode(serverInfo);
        RedisIntroQueries.ModulesInfo modulesInfo = (RedisIntroQueries.ModulesInfo)this.inTransaction(RedisIntrospector::initServerConfiguration$lambda$4);
        this.modules = this.extractModules(modulesInfo);
        if (this.getRequiresAllClusterNodesIntrospection()) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            List slotsInfos = (List)this.inTransaction(RedisIntrospector::initServerConfiguration$lambda$5);
            Iterable iterable = slotsInfos;
            RedisIntrospector redisIntrospector = this;
            boolean $i$f$map = false;
            void var6_7 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                RedisIntroQueries.SlotsInfo slotsInfo = (RedisIntroQueries.SlotsInfo)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(this.extractMasterNode((RedisIntroQueries.SlotsInfo)it));
            }
            redisIntrospector.clusterNodes = (List)destination$iv$iv;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final Mode extractMode(RedisIntroQueries.ServerInfo serverInfo) {
        Mode mode;
        Mode mode2;
        String string;
        block7: {
            block6: {
                Pattern pattern = Pattern.compile("redis_mode:(.+)");
                Matcher matcher = pattern.matcher(serverInfo.value);
                if (!matcher.find()) return null;
                string = matcher.group(1);
                if (string == null) return null;
                switch (string.hashCode()) {
                    case 872092154: {
                        if (string.equals("cluster")) break;
                        return null;
                    }
                    case 1262856228: {
                        if (!string.equals("sentinel")) {
                            return null;
                        }
                        break block6;
                    }
                    case -1284644795: {
                        if (!string.equals("standalone")) return null;
                        mode2 = Mode.STANDALONE;
                        break block7;
                    }
                }
                mode2 = Mode.CLUSTER;
                break block7;
            }
            mode2 = Mode.SENTINEL;
            break block7;
            return null;
        }
        Mode mode3 = mode = mode2;
        if (mode3 == null) return null;
        String it = string = mode3;
        boolean bl = false;
        if (!this.isSupported((Mode)((Object)it))) return null;
        String string2 = string;
        return string2;
    }

    private final Set<ObjectKind> extractModules(RedisIntroQueries.ModulesInfo modulesInfo) {
        Pattern pattern = Pattern.compile("module:name=([^,]+)");
        Matcher matcher = pattern.matcher(modulesInfo.value);
        Set modules = new LinkedHashSet();
        while (matcher.find()) {
            if (!Intrinsics.areEqual((Object)matcher.group(1), (Object)"ReJSON")) continue;
            ObjectKind objectKind = ObjectKind.JSON_DOCUMENT;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"JSON_DOCUMENT");
            modules.add(objectKind);
        }
        return modules;
    }

    private final HostPort extractMasterNode(RedisIntroQueries.SlotsInfo slotsInfo) {
        Long masterNodePort;
        List masterNodeInfo;
        Object object = ArraysKt.getOrNull((Object[])slotsInfo.value, (int)2);
        List list = masterNodeInfo = object instanceof List ? (List)object : null;
        Object object2 = list != null ? CollectionsKt.getOrNull((List)list, (int)0) : null;
        String masterNodeHost = object2 instanceof String ? (String)object2 : null;
        List list2 = masterNodeInfo;
        Object object3 = list2 != null ? CollectionsKt.getOrNull((List)list2, (int)1) : null;
        Long l = masterNodePort = object3 instanceof Long ? (Long)object3 : null;
        if (masterNodeHost == null || masterNodePort == null) {
            throw new DBFetchingException("Failed to process cluster slots information", null);
        }
        return new HostPort(masterNodeHost, (int)masterNodePort.longValue());
    }

    private final boolean isCurrentSchema(String name2) {
        return Intrinsics.areEqual((Object)name2, (Object)this.getSchema());
    }

    private final String getSchema() {
        return (String)JdbcNativeUtil.computeSafe(() -> RedisIntrospector.getSchema$lambda$8(this));
    }

    private final void setSchema(String name2) {
        JdbcNativeUtil.performSafe(() -> RedisIntrospector.setSchema$lambda$10(this, name2));
    }

    @Override
    protected void introspectSchemasAuto(@NotNull DBTransaction tran, @NotNull List<? extends RedisSchema> schemas, boolean whole) {
        Intrinsics.checkNotNullParameter((Object)tran, (String)"tran");
        Intrinsics.checkNotNullParameter(schemas, (String)"schemas");
        for (RedisSchema redisSchema : schemas) {
            this.handleErrors("Introspect schema " + redisSchema.getName(), (Function0<Unit>)((Function0)() -> RedisIntrospector.introspectSchemasAuto$lambda$11(this, tran, redisSchema)));
        }
    }

    @Override
    public void retrieveAndApplySchemas() {
        this.inTransactionUnit((Function1<DBTransaction, Unit>)((Function1)arg_0 -> RedisIntrospector.retrieveAndApplySchemas$lambda$12(this, arg_0)));
    }

    @Override
    protected void introspectNamespacesInTran(@NotNull DBTransaction tran) {
        Intrinsics.checkNotNullParameter((Object)tran, (String)"tran");
        if (this.mode == Mode.CLUSTER) {
            this.applyClusterSchema();
            return;
        }
        RedisIntroQueries.DbCountInfo dbCountInfo = (RedisIntroQueries.DbCountInfo)JdbcNativeUtil.computeSafe(() -> RedisIntrospector.introspectNamespacesInTran$lambda$13(tran));
        if (this.applySchemas(dbCountInfo)) {
            return;
        }
        RedisIntroQueries.KeyspaceInfo keyspaceInfo = RedisIntroQueries.INSTANCE.retrieveKeyspaceInfo(tran);
        this.applySchemas(keyspaceInfo);
    }

    private final void applyClusterSchema() {
        List<Integer> list = Collections.singletonList(0);
        Intrinsics.checkNotNullExpressionValue(list, (String)"singletonList(...)");
        this.applySchemas(list, applyClusterSchema.1.INSTANCE);
    }

    private final boolean applySchemas(RedisIntroQueries.DbCountInfo dbCountInfo) {
        if (dbCountInfo == null) {
            return false;
        }
        Integer n = StringsKt.toIntOrNull((String)dbCountInfo.value);
        if (n == null) {
            return false;
        }
        int dbCount = n;
        List dbs2 = CollectionsKt.toList((Iterable)((Iterable)RangesKt.until((int)0, (int)dbCount)));
        this.applySchemas(dbs2, applySchemas.1.INSTANCE);
        return true;
    }

    private final void applySchemas(RedisIntroQueries.KeyspaceInfo keyspaceInfo) {
        Pattern pattern = Pattern.compile("db(\\d+):");
        Matcher matcher = pattern.matcher(keyspaceInfo.value);
        List dbs2 = new ArrayList();
        while (matcher.find()) {
            String string = matcher.group(1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"group(...)");
            dbs2.add(string);
        }
        this.applySchemas(dbs2, applySchemas.2.INSTANCE);
    }

    private final <T> void applySchemas(List<? extends T> dbs2, Function1<? super T, String> nameGetter) {
        this.inModel(arg_0 -> RedisIntrospector.applySchemas$lambda$15(dbs2, nameGetter, this, arg_0));
    }

    @Override
    @NotNull
    protected BaseNativeIntrospector.AbstractDatabaseRetriever<RedisRoot> createDatabaseRetriever(@NotNull DBTransaction transaction, @NotNull RedisRoot database) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)database, (String)"database");
        return new BaseNativeIntrospector.AbstractDatabaseRetriever<RedisRoot>(this, transaction, database){};
    }

    @Override
    @NotNull
    protected BaseNativeIntrospector.AbstractSchemaRetriever<RedisSchema> createSchemaRetriever(@NotNull DBTransaction transaction, @NotNull RedisSchema schema) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        return new RedisSchemaRetriever(transaction, schema);
    }

    private static final RedisIntroQueries.ServerInfo initServerConfiguration$lambda$3(DBTransaction tran) {
        Intrinsics.checkNotNullParameter((Object)tran, (String)"tran");
        return RedisIntroQueries.INSTANCE.retrieveServerInfo(tran);
    }

    private static final RedisIntroQueries.ModulesInfo initServerConfiguration$lambda$4(DBTransaction tran) {
        Intrinsics.checkNotNullParameter((Object)tran, (String)"tran");
        return RedisIntroQueries.INSTANCE.retrieveModulesInfo(tran);
    }

    private static final List initServerConfiguration$lambda$5(DBTransaction tran) {
        Intrinsics.checkNotNullParameter((Object)tran, (String)"tran");
        return RedisIntroQueries.INSTANCE.retrieveClusterSlots(tran);
    }

    private static final String getSchema$lambda$8(RedisIntrospector this$0) {
        DatabaseConnectionCore databaseConnectionCore = this$0.getDbConnection();
        return databaseConnectionCore != null && (databaseConnectionCore = databaseConnectionCore.getRemoteConnection()) != null ? databaseConnectionCore.getSchema() : null;
    }

    private static final void setSchema$lambda$10(RedisIntrospector this$0, String $name) {
        block0: {
            DatabaseConnectionCore databaseConnectionCore = this$0.getDbConnection();
            if (databaseConnectionCore == null) break block0;
            DatabaseConnectionCore it = databaseConnectionCore;
            boolean bl = false;
            it.getRemoteConnection().setSchema($name);
        }
    }

    private static final Unit introspectSchemasAuto$lambda$11(RedisIntrospector this$0, DBTransaction $tran, RedisSchema $schema) {
        BaseNativeIntrospector.AbstractSchemaRetriever<RedisSchema> retriever = this$0.createSchemaRetriever($tran, $schema);
        retriever.process();
        return Unit.INSTANCE;
    }

    private static final Unit retrieveAndApplySchemas$lambda$12(RedisIntrospector this$0, DBTransaction it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.introspectNamespacesInTran(it);
        return Unit.INSTANCE;
    }

    private static final RedisIntroQueries.DbCountInfo introspectNamespacesInTran$lambda$13(DBTransaction $tran) {
        return RedisIntroQueries.INSTANCE.retrieveDbCount($tran);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private static final Unit applySchemas$lambda$15(List $dbs, Function1 $nameGetter, RedisIntrospector this$0, RedisRoot r) {
        void $this$iv$iv$iv;
        void $this$applySchemasNamed$iv$iv;
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        NamingFamily namingFamily = r.getSchemas();
        Intrinsics.checkNotNullExpressionValue((Object)namingFamily, (String)"getSchemas(...)");
        NamingFamily $this$applySchemasNamed$iv = namingFamily;
        boolean $i$f$applySchemasNamed = false;
        NamingFamily namingFamily2 = $this$applySchemasNamed$iv;
        ElementSearchCache searchCache$iv$iv = new ElementSearchCache();
        boolean $i$f$applySchemasNamed2 = false;
        FamilySearcher familySearcher = ElementCacheOptimizersKt.byName(ElementCacheKt.searchElement(searchCache$iv$iv), (Function1)new Function1<T, String>($nameGetter){
            final /* synthetic */ Function1 $name;
            {
                this.$name = $name;
            }

            public final String invoke(T $this$byName) {
                return (String)this.$name.invoke($this$byName);
            }
        }).inFamily((Family)$this$applySchemasNamed$iv$iv);
        Function2 filler$iv$iv$iv = applySchemas$lambda$15$$inlined$applySchemasNamed$2.INSTANCE;
        boolean $i$f$orCreateBulk = false;
        ArrayList items$iv$iv$iv = new ArrayList();
        ElementSearcherNN searcher$iv$iv$iv = ElementCacheKt.orCreateElement((ElementSearcher)$this$iv$iv$iv, (Function1)new Function1<D, T>((FamilySearcher)$this$iv$iv$iv, filler$iv$iv$iv, items$iv$iv$iv){
            final /* synthetic */ FamilySearcher this$0;
            final /* synthetic */ Function2 $filler;
            final /* synthetic */ ArrayList $items;
            {
                this.this$0 = $receiver;
                this.$filler = $filler;
                this.$items = $items;
            }

            public final T invoke(D it) {
                T t = BasicMetaUtils.getMetaObject(this.this$0.getFamily()).newDataObject();
                Intrinsics.checkNotNullExpressionValue(t, (String)"newDataObject(...)");
                T t2 = t;
                FamilySearcher familySearcher = this.this$0;
                Function2 function2 = this.$filler;
                ArrayList arrayList = this.$items;
                T $this$invoke_u24lambda_u240 = t2;
                boolean bl = false;
                familySearcher.fillImpl($this$invoke_u24lambda_u240, it, function2);
                ((Collection)arrayList).add($this$invoke_u24lambda_u240);
                return t2;
            }
        });
        try {
            ElementSearcherNN schemas$iv$iv = searcher$iv$iv$iv;
            boolean bl = false;
            void $this$applySchemasImpl$iv$iv$iv = $this$applySchemasNamed$iv$iv;
            boolean $i$f$applySchemasImpl = false;
            $this$applySchemasImpl$iv$iv$iv.markChildrenAsSyncPending();
            Iterable $this$forEach$iv$iv$iv$iv = $dbs;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                void sc$iv$iv;
                Object element$iv$iv$iv$iv;
                Object sc$iv$iv$iv = element$iv$iv$iv$iv = iterator.next();
                boolean bl2 = false;
                Object t = sc$iv$iv$iv;
                void $this$applySchemasNamed_u24lambda_u2420_u24lambda_u2419$iv$iv = $this$applySchemasImpl$iv$iv$iv;
                boolean bl3 = false;
                BasicModMateNamespace $this$applySchemasNamed_u24lambda_u2420_u24lambda_u2419_u24lambda_u2418$iv$iv = (BasicModMateNamespace)schemas$iv$iv.find(sc$iv$iv);
                boolean bl4 = false;
                void var29_30 = sc$iv$iv;
                RedisSchema $this$applySchemas_u24lambda_u2415_u24lambda_u2414 = (RedisSchema)$this$applySchemasNamed_u24lambda_u2420_u24lambda_u2419_u24lambda_u2418$iv$iv;
                boolean bl5 = false;
                String string = $this$applySchemas_u24lambda_u2415_u24lambda_u2414.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                $this$applySchemas_u24lambda_u2415_u24lambda_u2414.setCurrent(this$0.isCurrentSchema(string));
            }
            $this$applySchemasImpl$iv$iv$iv.removeSyncPendingChildren();
            $this$applySchemasImpl$iv$iv$iv.sort();
        }
        finally {
            Family family = $this$iv$iv$iv.getFamily();
            Intrinsics.checkNotNull(family, (String)"null cannot be cast to non-null type com.intellij.database.model.families.Family<T of com.intellij.database.model.FamilySearcher>");
            BaseModel.createBulk(family, items$iv$iv$iv);
        }
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007R\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lcom/intellij/database/dialects/redis/introspector/RedisIntrospector$DefaultNature;", "Lcom/intellij/database/dialects/base/introspector/BaseIntrospector$Nature;", "<init>", "()V", "supportServerObjects", "", "getSupportServerObjects", "()Z", "supportFragmentIntrospection", "getSupportFragmentIntrospection", "supportFragmentKinds", "", "Lcom/intellij/database/model/ObjectKind;", "getSupportFragmentKinds", "()Ljava/util/Set;", "intellij.database.dialects.redis"})
    private static final class DefaultNature
    implements BaseIntrospector.Nature {
        @NotNull
        public static final DefaultNature INSTANCE = new DefaultNature();

        private DefaultNature() {
        }

        @Override
        public boolean getSupportServerObjects() {
            return false;
        }

        @Override
        public boolean getSupportFragmentIntrospection() {
            return false;
        }

        @Override
        @NotNull
        public Set<ObjectKind> getSupportFragmentKinds() {
            return SetsKt.emptySet();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0017B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0012\u0010\u0014\u001a\u00020\u00052\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016\u00a8\u0006\u0018"}, d2={"Lcom/intellij/database/dialects/redis/introspector/RedisIntrospector$Factory;", "Lcom/intellij/database/introspection/DBIntrospector$Factory;", "<init>", "()V", "isSupported", "", "version", "Lcom/intellij/database/util/Version;", "createIntrospector", "Lcom/intellij/database/introspection/DBIntrospector;", "context", "Lcom/intellij/database/introspection/DBIntrospectionContext;", "dbms", "Lcom/intellij/database/Dbms;", "modelFactory", "Lcom/intellij/database/model/ModelFactory;", "getVersion", "", "kind", "Lcom/intellij/database/model/ObjectKind;", "isOutdatedCheckSupported", "e", "Lcom/intellij/database/model/basic/BasicElement;", "VERSION", "intellij.database.dialects.redis"})
    public static final class Factory
    implements DBIntrospector.Factory {
        @Override
        public boolean isSupported(@NotNull Version version) {
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            return true;
        }

        @Override
        @NotNull
        public DBIntrospector createIntrospector(@NotNull DBIntrospectionContext context, @NotNull Dbms dbms, @NotNull ModelFactory modelFactory) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
            Intrinsics.checkNotNullParameter((Object)modelFactory, (String)"modelFactory");
            return new RedisIntrospector(context, modelFactory);
        }

        @Override
        public int getVersion(@NotNull ObjectKind kind) {
            Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
            return VERSION.INSTANCE.get(kind);
        }

        @Override
        public boolean isOutdatedCheckSupported(@Nullable BasicElement e) {
            return false;
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/intellij/database/dialects/redis/introspector/RedisIntrospector$Factory$VERSION;", "Lcom/intellij/database/model/PerObjectVersion;", "<init>", "()V", "intellij.database.dialects.redis"})
        public static final class VERSION
        extends PerObjectVersion {
            @NotNull
            public static final VERSION INSTANCE = new VERSION();

            private VERSION() {
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/database/dialects/redis/introspector/RedisIntrospector$Mode;", "", "<init>", "(Ljava/lang/String;I)V", "STANDALONE", "CLUSTER", "SENTINEL", "intellij.database.dialects.redis"})
    private static final class Mode
    extends Enum<Mode> {
        public static final /* enum */ Mode STANDALONE = new Mode();
        public static final /* enum */ Mode CLUSTER = new Mode();
        public static final /* enum */ Mode SENTINEL = new Mode();
        private static final /* synthetic */ Mode[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Mode[] values() {
            return (Mode[])$VALUES.clone();
        }

        public static Mode valueOf(String value) {
            return Enum.valueOf(Mode.class, value);
        }

        @NotNull
        public static EnumEntries<Mode> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = modeArray = new Mode[]{Mode.STANDALONE, Mode.CLUSTER, Mode.SENTINEL};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u001e\u0012\u0004\u0012\u00020\u00020\u0001R\u0014\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00020\u0003B\u0017\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0002\u00a2\u0006\u0004\b\b\u0010\tJ\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0014J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0016\u0010\u000f\u001a\u00020\u000e2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0011H\u0002J\b\u0010\u0012\u001a\u00020\u000eH\u0002J@\u0010\u0012\u001a\u00020\u000e\"\b\b\u0000\u0010\u0013*\u00020\u00142\b\b\u0002\u0010\u0015\u001a\u00020\u000b2\b\b\u0002\u0010\u0016\u001a\u00020\u000b2\u0018\u0010\u0017\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00130\u00190\u0018H\u0002J@\u0010\u001a\u001a\u00020\u000e\"\b\b\u0000\u0010\u0013*\u00020\u0014*\u00020\u00022\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u0002H\u00130\u00192\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0016\u001a\u00020\u000b2\n\b\u0002\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0002J0\u0010 \u001a\u0004\u0018\u00010\u0014*\u00020\u00022\f\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"2\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u000b0\u0018H\u0002R\u001a\u0010%\u001a\u0004\u0018\u00010&*\u00020\u001d8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010(\u00a8\u0006)"}, d2={"Lcom/intellij/database/dialects/redis/introspector/RedisIntrospector$RedisSchemaRetriever;", "Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector$AbstractSchemaRetriever;", "Lcom/intellij/database/dialects/redis/model/RedisSchema;", "Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector;", "Lcom/intellij/database/dialects/redis/model/RedisRoot;", "transaction", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "schema", "<init>", "(Lcom/intellij/database/dialects/redis/introspector/RedisIntrospector;Lcom/intellij/database/layoutedQueries/DBTransaction;Lcom/intellij/database/dialects/redis/model/RedisSchema;)V", "isPossibleToIntrospectSchemaIncrementally", "", "tran", "process", "", "withCorrectSearchPath", "action", "Lkotlin/Function0;", "retrieveKeys", "T", "Lcom/intellij/database/dialects/redis/model/RedisKey;", "fromModule", "isDefaultFamily", "familyInvoker", "Lkotlin/Function1;", "Lcom/intellij/database/model/families/ModNamingFamily;", "retrieveKeysImpl", "family", "familyKind", "Lcom/intellij/database/model/ObjectKind;", "node", "Lcom/intellij/database/dataSource/url/HostPort;", "getKey", "modelObjectsWithKeyName", "", "Lcom/intellij/database/model/DasObject;", "checkKind", "keyType", "", "getKeyType", "(Lcom/intellij/database/model/ObjectKind;)Ljava/lang/String;", "intellij.database.dialects.redis"})
    @SourceDebugExtension(value={"SMAP\nRedisIntrospector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RedisIntrospector.kt\ncom/intellij/database/dialects/redis/introspector/RedisIntrospector$RedisSchemaRetriever\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 BaseIntrospectionFunctions.kt\ncom/intellij/database/dialects/base/introspector/BaseIntrospectionFunctions\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,356:1\n1#2:357\n178#3,5:358\n183#3,3:365\n1863#4,2:363\n13402#5,2:368\n*S KotlinDebug\n*F\n+ 1 RedisIntrospector.kt\ncom/intellij/database/dialects/redis/introspector/RedisIntrospector$RedisSchemaRetriever\n*L\n300#1:358,5\n300#1:365,3\n303#1:363,2\n320#1:368,2\n*E\n"})
    private final class RedisSchemaRetriever
    extends BaseNativeIntrospector.AbstractSchemaRetriever<RedisSchema> {
        public RedisSchemaRetriever(@NotNull DBTransaction transaction, RedisSchema schema) {
            Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            super((BaseNativeIntrospector)RedisIntrospector.this, transaction, (BasicModSchema)schema);
        }

        @Override
        protected boolean isPossibleToIntrospectSchemaIncrementally(@NotNull DBTransaction tran, @NotNull RedisSchema schema) {
            Intrinsics.checkNotNullParameter((Object)tran, (String)"tran");
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            return false;
        }

        @Override
        public void process() {
            BaseIntrospector baseIntrospector = RedisIntrospector.this;
            String string = ((RedisSchema)this.getSchema()).getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            BaseIntrospector.reportIntrospectingSchema$default(baseIntrospector, string, null, null, 6, null);
            this.withCorrectSearchPath((Function0<Unit>)((Function0)() -> RedisSchemaRetriever.process$lambda$0(this)));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void withCorrectSearchPath(Function0<Unit> action) {
            if (((RedisSchema)this.getSchema()).isCurrent()) {
                action.invoke();
                return;
            }
            String string = ((RedisSchema)this.getSchema()).getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            String name2 = string;
            String currentName = RedisIntrospector.this.getSchema();
            RedisIntrospector.this.setSchema(name2);
            try {
                if (!RedisIntrospector.this.isCurrentSchema(name2)) {
                    throw new DBSchemaAccessDeniedException(new SQLException("Failed to connect to db " + name2 + " for introspection"), null);
                }
                action.invoke();
            }
            finally {
                String string2 = currentName;
                if (string2 != null) {
                    String string3 = string2;
                    RedisIntrospector redisIntrospector = RedisIntrospector.this;
                    String it = string3;
                    boolean bl = false;
                    redisIntrospector.setSchema(it);
                }
            }
        }

        private final void retrieveKeys() {
            if (!RedisIntrospector.this.getSupportsKeysScanWithType()) {
                RedisSchemaRetriever.retrieveKeys$default(this, false, false, RedisSchemaRetriever::retrieveKeys$lambda$2, 3, null);
                return;
            }
            RedisSchemaRetriever.retrieveKeys$default(this, false, false, RedisSchemaRetriever::retrieveKeys$lambda$3, 3, null);
            RedisSchemaRetriever.retrieveKeys$default(this, false, false, RedisSchemaRetriever::retrieveKeys$lambda$4, 3, null);
            RedisSchemaRetriever.retrieveKeys$default(this, false, false, RedisSchemaRetriever::retrieveKeys$lambda$5, 3, null);
            RedisSchemaRetriever.retrieveKeys$default(this, false, false, RedisSchemaRetriever::retrieveKeys$lambda$6, 3, null);
            RedisSchemaRetriever.retrieveKeys$default(this, false, false, RedisSchemaRetriever::retrieveKeys$lambda$7, 3, null);
            RedisSchemaRetriever.retrieveKeys$default(this, false, false, RedisSchemaRetriever::retrieveKeys$lambda$8, 3, null);
            RedisSchemaRetriever.retrieveKeys$default(this, true, false, RedisSchemaRetriever::retrieveKeys$lambda$9, 2, null);
            RedisSchemaRetriever.retrieveKeys$default(this, false, true, RedisSchemaRetriever::retrieveKeys$lambda$10, 1, null);
        }

        private final <T extends RedisKey> void retrieveKeys(boolean fromModule, boolean isDefaultFamily, Function1<? super RedisSchema, ? extends ModNamingFamily<T>> familyInvoker) {
            this.inSchema(arg_0 -> RedisSchemaRetriever.retrieveKeys$lambda$13(familyInvoker, RedisIntrospector.this, fromModule, this, isDefaultFamily, arg_0));
        }

        static /* synthetic */ void retrieveKeys$default(RedisSchemaRetriever redisSchemaRetriever, boolean bl, boolean bl2, Function1 function1, int n, Object object) {
            if ((n & 1) != 0) {
                bl = false;
            }
            if ((n & 2) != 0) {
                bl2 = false;
            }
            redisSchemaRetriever.retrieveKeys(bl, bl2, function1);
        }

        private final <T extends RedisKey> void retrieveKeysImpl(RedisSchema $this$retrieveKeysImpl, ModNamingFamily<T> family, ObjectKind familyKind, boolean isDefaultFamily, HostPort node) {
            Ref.LongRef cursor = new Ref.LongRef();
            do {
                RedisIntroQueries.INSTANCE.processKeysScan(this.getTransaction(), node, cursor.element, RedisIntrospector.this.keyPattern, RedisIntrospector.this.scanCount, this.getKeyType(familyKind), (Function1<? super RedisIntroQueries.KeysScanInfo, Unit>)((Function1)arg_0 -> RedisSchemaRetriever.retrieveKeysImpl$lambda$18(cursor, $this$retrieveKeysImpl, isDefaultFamily, this, family, familyKind, arg_0)));
            } while (cursor.element != 0L);
        }

        static /* synthetic */ void retrieveKeysImpl$default(RedisSchemaRetriever redisSchemaRetriever, RedisSchema redisSchema, ModNamingFamily modNamingFamily, ObjectKind objectKind, boolean bl, HostPort hostPort, int n, Object object) {
            if ((n & 8) != 0) {
                hostPort = null;
            }
            redisSchemaRetriever.retrieveKeysImpl(redisSchema, modNamingFamily, objectKind, bl, hostPort);
        }

        /*
         * Unable to fully structure code
         */
        private final RedisKey getKey(RedisSchema $this$getKey, Iterable<? extends DasObject> modelObjectsWithKeyName, Function1<? super ObjectKind, Boolean> checkKind) {
            block3: {
                var5_4 = modelObjectsWithKeyName;
                var6_5 = var5_4.iterator();
                while (var6_5.hasNext()) {
                    it = var7_6 = var6_5.next();
                    $i$a$-find-RedisIntrospector$RedisSchemaRetriever$getKey$1 = false;
                    if (!(it instanceof RedisKey) || !Intrinsics.areEqual((Object)((RedisKey)it).getSchema(), (Object)$this$getKey)) ** GOTO lbl-1000
                    v0 = ((RedisKey)it).getKind();
                    Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getKind(...)");
                    if (((Boolean)checkKind.invoke((Object)v0)).booleanValue()) {
                        v1 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v1 = false;
                    }
                    if (!v1) continue;
                    v2 = var7_6;
                    break block3;
                }
                v2 = null;
            }
            var4_9 = v2;
            return var4_9 instanceof RedisKey != false ? (RedisKey)var4_9 : null;
        }

        private final String getKeyType(ObjectKind $this$keyType) {
            ObjectKind objectKind = $this$keyType;
            return Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.STRING) ? "string" : (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.LIST) ? "list" : (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.SET) ? "set" : (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.SORTED_SET) ? "zset" : (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.HASH_TABLE) ? "hash" : (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.STREAM) ? "stream" : (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.JSON_DOCUMENT) ? "rejson-rl" : null))))));
        }

        private static final Unit process$lambda$0(RedisSchemaRetriever this$0) {
            this$0.prepareParameters();
            this$0.retrieveKeys();
            return Unit.INSTANCE;
        }

        private static final ModNamingFamily retrieveKeys$lambda$2(RedisSchema it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            ModNamingFamily<? extends RedisUnknownKey> modNamingFamily = it.getUnknownKeys();
            Intrinsics.checkNotNullExpressionValue(modNamingFamily, (String)"getUnknownKeys(...)");
            return modNamingFamily;
        }

        private static final ModNamingFamily retrieveKeys$lambda$3(RedisSchema it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            ModNamingFamily<? extends RedisStringKey> modNamingFamily = it.getStringKeys();
            Intrinsics.checkNotNullExpressionValue(modNamingFamily, (String)"getStringKeys(...)");
            return modNamingFamily;
        }

        private static final ModNamingFamily retrieveKeys$lambda$4(RedisSchema it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            ModNamingFamily<? extends RedisListKey> modNamingFamily = it.getListKeys();
            Intrinsics.checkNotNullExpressionValue(modNamingFamily, (String)"getListKeys(...)");
            return modNamingFamily;
        }

        private static final ModNamingFamily retrieveKeys$lambda$5(RedisSchema it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            ModNamingFamily<? extends RedisSetKey> modNamingFamily = it.getSetKeys();
            Intrinsics.checkNotNullExpressionValue(modNamingFamily, (String)"getSetKeys(...)");
            return modNamingFamily;
        }

        private static final ModNamingFamily retrieveKeys$lambda$6(RedisSchema it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            ModNamingFamily<? extends RedisSortedSetKey> modNamingFamily = it.getSortedSetKeys();
            Intrinsics.checkNotNullExpressionValue(modNamingFamily, (String)"getSortedSetKeys(...)");
            return modNamingFamily;
        }

        private static final ModNamingFamily retrieveKeys$lambda$7(RedisSchema it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            ModNamingFamily<? extends RedisHashTableKey> modNamingFamily = it.getHashTableKeys();
            Intrinsics.checkNotNullExpressionValue(modNamingFamily, (String)"getHashTableKeys(...)");
            return modNamingFamily;
        }

        private static final ModNamingFamily retrieveKeys$lambda$8(RedisSchema it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            ModNamingFamily<? extends RedisStreamKey> modNamingFamily = it.getStreamKeys();
            Intrinsics.checkNotNullExpressionValue(modNamingFamily, (String)"getStreamKeys(...)");
            return modNamingFamily;
        }

        private static final ModNamingFamily retrieveKeys$lambda$9(RedisSchema it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            ModNamingFamily<? extends RedisJsonDocumentKey> modNamingFamily = it.getJsonDocumentKeys();
            Intrinsics.checkNotNullExpressionValue(modNamingFamily, (String)"getJsonDocumentKeys(...)");
            return modNamingFamily;
        }

        private static final ModNamingFamily retrieveKeys$lambda$10(RedisSchema it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            ModNamingFamily<? extends RedisDataStructureKey> modNamingFamily = it.getDataStructureKeys();
            Intrinsics.checkNotNullExpressionValue(modNamingFamily, (String)"getDataStructureKeys(...)");
            return modNamingFamily;
        }

        private static final Unit retrieveKeys$lambda$13(Function1 $familyInvoker, RedisIntrospector this$0, boolean $fromModule, RedisSchemaRetriever this$1, boolean $isDefaultFamily, RedisSchema s) {
            Intrinsics.checkNotNullParameter((Object)s, (String)"s");
            ModNamingFamily family = (ModNamingFamily)$familyInvoker.invoke((Object)s);
            ObjectKind familyKind = family.getMetaObject().kind;
            Intrinsics.checkNotNull((Object)familyKind);
            this$0.reportRetrieving(familyKind);
            ModFamily $this$modifyAndCleanup_u24default$iv = family;
            boolean removeUnaffected$iv = true;
            boolean $i$f$modifyAndCleanup = false;
            $this$modifyAndCleanup_u24default$iv.markChildrenAsSyncPending();
            ModNamingFamily f = (ModNamingFamily)$this$modifyAndCleanup_u24default$iv;
            boolean bl = false;
            if (!$fromModule || this$0.modules.contains(familyKind)) {
                if (this$0.getRequiresAllClusterNodesIntrospection()) {
                    Iterable $this$forEach$iv = this$0.clusterNodes;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        HostPort it = (HostPort)element$iv;
                        boolean bl2 = false;
                        this$1.retrieveKeysImpl(s, f, familyKind, $isDefaultFamily, it);
                    }
                } else {
                    RedisSchemaRetriever.retrieveKeysImpl$default(this$1, s, f, familyKind, $isDefaultFamily, null, 8, null);
                }
            }
            $this$modifyAndCleanup_u24default$iv.removeSyncPendingChildren();
            $this$modifyAndCleanup_u24default$iv.sort();
            return Unit.INSTANCE;
        }

        private static final boolean retrieveKeysImpl$lambda$18$lambda$17$lambda$14(ObjectKind $familyKind, ObjectKind it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return !Intrinsics.areEqual((Object)it, (Object)$familyKind);
        }

        private static final boolean retrieveKeysImpl$lambda$18$lambda$17$lambda$15(ObjectKind $familyKind, ObjectKind it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return Intrinsics.areEqual((Object)it, (Object)$familyKind);
        }

        private static final Unit retrieveKeysImpl$lambda$18(Ref.LongRef $cursor, RedisSchema $this_retrieveKeysImpl, boolean $isDefaultFamily, RedisSchemaRetriever this$0, ModNamingFamily $family, ObjectKind $familyKind, RedisIntroQueries.KeysScanInfo keysScan) {
            Intrinsics.checkNotNullParameter((Object)keysScan, (String)"keysScan");
            Long l = StringsKt.toLongOrNull((String)keysScan.cursor);
            $cursor.element = l != null ? l : 0L;
            String[] $this$forEach$iv = keysScan.results;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int j = 0; j < n; ++j) {
                Collection<DasObject> modelObjectWithKeyName;
                RedisKey key2;
                String element$iv;
                String keyName = element$iv = $this$forEach$iv[j];
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue(((BasicModModel)$this_retrieveKeysImpl.getModel()).getNameIndex().getObjectsByName(keyName), (String)"getObjectsByName(...)");
                if ($isDefaultFamily && (key2 = this$0.getKey($this_retrieveKeysImpl, (Iterable<? extends DasObject>)modelObjectWithKeyName, (Function1<? super ObjectKind, Boolean>)((Function1)arg_0 -> RedisSchemaRetriever.retrieveKeysImpl$lambda$18$lambda$17$lambda$14($familyKind, arg_0)))) != null) continue;
                key2 = this$0.getKey($this_retrieveKeysImpl, (Iterable<? extends DasObject>)modelObjectWithKeyName, (Function1<? super ObjectKind, Boolean>)((Function1)arg_0 -> RedisSchemaRetriever.retrieveKeysImpl$lambda$18$lambda$17$lambda$15($familyKind, arg_0)));
                if (key2 != null) {
                    if (!key2.isSyncPending()) continue;
                    key2.resetSyncPending();
                    continue;
                }
                Object e = $family.createNewOne();
                RedisKey $this$retrieveKeysImpl_u24lambda_u2418_u24lambda_u2417_u24lambda_u2416 = (RedisKey)e;
                boolean bl2 = false;
                ((BasicModNamedElement)$this$retrieveKeysImpl_u24lambda_u2418_u24lambda_u2417_u24lambda_u2416).setName(keyName);
            }
            return Unit.INSTANCE;
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Mode.values().length];
            try {
                nArray[Mode.STANDALONE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Mode.CLUSTER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Mode.SENTINEL.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

