/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.mongo;

import com.intellij.database.data.types.BaseDomainRegistry;
import com.intellij.database.data.types.ConversionPoint;
import com.intellij.database.data.types.domain.BinaryDomain;
import com.intellij.database.data.types.domain.BooleanDomain;
import com.intellij.database.data.types.domain.Domain;
import com.intellij.database.data.types.domain.FloatDomain;
import com.intellij.database.data.types.domain.IntegerDomain;
import com.intellij.database.data.types.domain.Number2Domain;
import com.intellij.database.data.types.domain.OperationSupport;
import com.intellij.database.data.types.domain.SimpleDomain;
import com.intellij.database.data.types.domain.TextDomain;
import com.intellij.database.data.types.domain.TypeConversionHelper;
import com.intellij.database.data.types.domain.UnknownDomain;
import com.intellij.database.datagrid.mutating.ColumnDescriptor;
import com.intellij.openapi.util.text.StringUtil;
import java.math.BigDecimal;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MongoDomains
extends BaseDomainRegistry {
    private static final TypeConversionHelper INT_CONVERSION_HELPER = new TypeConversionHelper(){

        @Override
        public boolean willConvertedValueStayTheSame(@NotNull Domain newDomain, @Nullable Object value) {
            if (newDomain == null) {
                1.$$$reportNull$$$0(0);
            }
            return newDomain.simpleName().equals("Double");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newDomain", "com/intellij/database/dialects/mongo/MongoDomains$1", "willConvertedValueStayTheSame"));
        }
    };

    public MongoDomains() {
        this.add(new SimpleDomain("Object", ConversionPoint.MAP).withAliases("Map").withOperationSupport(OperationSupport.SUPPORTS_NOTHING));
        this.add(new TextDomain("String", ConversionPoint.TEXT, Integer.MAX_VALUE));
        this.add(new IntegerDomain("Int32", ConversionPoint.NUMBER, -2.147483648E9, 2.147483647E9){

            @Override
            public boolean isSuitable(@NotNull ColumnDescriptor descriptor2) {
                if (descriptor2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                return super.isSuitable(descriptor2) || StringUtil.equalsIgnoreCase((CharSequence)"Integer", (CharSequence)descriptor2.getTypeName());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/database/dialects/mongo/MongoDomains$2", "isSuitable"));
            }
        }.withTypeConversionHelper(INT_CONVERSION_HELPER));
        this.add(new IntegerDomain("Int64", ConversionPoint.NUMBER, -9.223372036854776E18, 9.223372036854776E18).withAliases("Long").withTypeConversionHelper(INT_CONVERSION_HELPER));
        this.add(new Number2Domain("Decimal128", ConversionPoint.BIG_DECIMAL, Integer.MAX_VALUE, Integer.MAX_VALUE, false).withTypeConversionHelper(new TypeConversionHelper(){

            @Override
            public boolean willConvertedValueStayTheSame(@NotNull Domain newDomain, @Nullable Object value) {
                if (newDomain == null) {
                    3.$$$reportNull$$$0(0);
                }
                return value instanceof BigDecimal && ((BigDecimal)value).scale() == 0 && newDomain.simpleName().equals("Double");
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newDomain", "com/intellij/database/dialects/mongo/MongoDomains$3", "willConvertedValueStayTheSame"));
            }
        }));
        this.add(new BooleanDomain("Boolean", ConversionPoint.BOOLEAN));
        this.add(new FloatDomain("Double", ConversionPoint.DOUBLE_PRECISION, -1.7976931348623157E308, Double.MAX_VALUE));
        this.add(new SimpleDomain("Array", ConversionPoint.JSON).withAliases("List"));
        this.add(new SimpleDomain("ObjectId", ConversionPoint.UUID_TEXT));
        this.add(new SimpleDomain("UUID", ConversionPoint.UUID));
        this.add(new SimpleDomain("ISODate", ConversionPoint.TIMESTAMP).withAliases("Date"));
        this.add(new UnknownDomain("Timestamp"));
        this.add(new BinaryDomain("BinData", ConversionPoint.BLOB, Integer.MAX_VALUE));
        this.add(new UnknownDomain("MaxKey"));
        this.add(new UnknownDomain("MinKey"));
        this.add(new UnknownDomain("Regexp").withAliases("BsonRegularExpression"));
    }
}

