/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.clickhouse.introspector;

import com.intellij.database.Dbms;
import com.intellij.database.diagnostic.DataSourceDiagnosticRecorder;
import com.intellij.database.diagnostic.DiagnosticSectionReference;
import com.intellij.database.dialects.base.introspector.BaseIntrospectionFunctions;
import com.intellij.database.dialects.base.introspector.BaseIntrospector;
import com.intellij.database.dialects.base.introspector.BaseNativeIntrospector;
import com.intellij.database.dialects.base.introspector.BaseSingleDatabaseIntrospector;
import com.intellij.database.dialects.base.introspector.IntrospectionQueryContext;
import com.intellij.database.dialects.base.introspector.IntrospectorSqlHelper;
import com.intellij.database.dialects.clickhouse.introspector.CHouseIntroQueries;
import com.intellij.database.dialects.clickhouse.introspector.CHouseIntrospector$CHouseSchemaRetriever$retrieveColumns$;
import com.intellij.database.dialects.clickhouse.introspector.CHouseIntrospector$applySchemas$lambda$3$;
import com.intellij.database.dialects.clickhouse.introspector.CHouseIntrospectorKt;
import com.intellij.database.dialects.clickhouse.model.CHouseLikeColumn;
import com.intellij.database.dialects.clickhouse.model.CHouseLikeTable;
import com.intellij.database.dialects.clickhouse.model.CHouseMatView;
import com.intellij.database.dialects.clickhouse.model.CHouseRole;
import com.intellij.database.dialects.clickhouse.model.CHouseRoot;
import com.intellij.database.dialects.clickhouse.model.CHouseRoutine;
import com.intellij.database.dialects.clickhouse.model.CHouseSchema;
import com.intellij.database.dialects.clickhouse.model.CHouseTable;
import com.intellij.database.dialects.clickhouse.model.CHouseTableColumn;
import com.intellij.database.dialects.clickhouse.model.CHouseUser;
import com.intellij.database.dialects.clickhouse.model.CHouseView;
import com.intellij.database.introspection.DBIntrospectionContext;
import com.intellij.database.introspection.DBIntrospector;
import com.intellij.database.layoutedQueries.DBTransaction;
import com.intellij.database.model.BaseModel;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ElementCacheKt;
import com.intellij.database.model.ElementCacheOptimizersKt;
import com.intellij.database.model.ElementChecker;
import com.intellij.database.model.ElementSearchCache;
import com.intellij.database.model.ElementSearcher;
import com.intellij.database.model.ElementSearcherNN;
import com.intellij.database.model.FamilySearcher;
import com.intellij.database.model.ModelFactory;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.PerObjectVersion;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModMateNamespace;
import com.intellij.database.model.basic.BasicModSchema;
import com.intellij.database.model.basic.BasicModView;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.families.ModNamingFamily;
import com.intellij.database.model.families.NamingFamily;
import com.intellij.database.model.families.PositioningNamingFamily;
import com.intellij.database.model.meta.BasicMetaUtils;
import com.intellij.database.model.properties.ColumnKind;
import com.intellij.database.model.properties.CompositeText;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.database.remote.jdba.exceptions.DBException;
import com.intellij.database.types.DasTypeSystemBase;
import com.intellij.database.types.DasTypeSystems;
import com.intellij.database.util.Version;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.sql.psi.SqlCreateStatement;
import com.intellij.util.text.StringKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0004%&'(B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0014J\b\u0010\u000e\u001a\u00020\u000bH\u0016J\u0016\u0010\u000f\u001a\u00020\u000b2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0002J&\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00030\u00112\u0006\u0010\u0015\u001a\u00020\u0016H\u0014J\u0018\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u0003H\u0002J\u0010\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0014J\u0010\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J.\u0010\u001d\u001a\u0018\u0012\u0004\u0012\u00020\u00020\u001eR\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u0006\u0010\u001f\u001a\u00020\r2\u0006\u0010 \u001a\u00020\u0002H\u0014J.\u0010!\u001a\u0018\u0012\u0004\u0012\u00020\u00020\"R\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u0006\u0010\u001f\u001a\u00020\r2\u0006\u0010 \u001a\u00020\u0002H\u0014J\u001c\u0010#\u001a\u00060$R\u00020\u00002\u0006\u0010\u001f\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u0003H\u0014\u00a8\u0006)"}, d2={"Lcom/intellij/database/dialects/clickhouse/introspector/CHouseIntrospector;", "Lcom/intellij/database/dialects/base/introspector/BaseSingleDatabaseIntrospector;", "Lcom/intellij/database/dialects/clickhouse/model/CHouseRoot;", "Lcom/intellij/database/dialects/clickhouse/model/CHouseSchema;", "context", "Lcom/intellij/database/introspection/DBIntrospectionContext;", "modelFactory", "Lcom/intellij/database/model/ModelFactory;", "<init>", "(Lcom/intellij/database/introspection/DBIntrospectionContext;Lcom/intellij/database/model/ModelFactory;)V", "introspectNamespacesInTran", "", "tran", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "retrieveAndApplySchemas", "applySchemas", "newSchemas", "", "", "introspectSchemasAuto", "schemas", "whole", "", "introspectOneSchema", "schema", "introspectAllServerObjects", "retrieveFunctions", "retrieveUsers", "retrieveRoles", "createDatabaseRetriever", "Lcom/intellij/database/dialects/base/introspector/BaseSingleDatabaseIntrospector$BaseDatabaseRetriever;", "transaction", "database", "createNativeRetriever", "Lcom/intellij/database/dialects/base/introspector/BaseSingleDatabaseIntrospector$BaseNativeRetriever;", "createSchemaRetriever", "Lcom/intellij/database/dialects/clickhouse/introspector/CHouseIntrospector$CHouseSchemaRetriever;", "Factory", "CHouseDatabaseRetriever", "CHouseNativeRetriever", "CHouseSchemaRetriever", "intellij.database.dialects.clickhouse"})
@SourceDebugExtension(value={"SMAP\nCHouseIntrospector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CHouseIntrospector.kt\ncom/intellij/database/dialects/clickhouse/introspector/CHouseIntrospector\n+ 2 ModelFun.kt\ncom/intellij/database/model/ModelFun\n+ 3 ElementCache.kt\ncom/intellij/database/model/FamilySearcher\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 6 BaseIntrospectionFunctions.kt\ncom/intellij/database/dialects/base/introspector/BaseIntrospectionFunctions\n+ 7 BaseNativeIntrospector.kt\ncom/intellij/database/dialects/base/introspector/BaseNativeIntrospector\n*L\n1#1,364:1\n417#2,10:365\n427#2,9:385\n436#2:395\n428#2:396\n429#2,9:398\n438#2,3:408\n430#2:411\n431#2:413\n189#3,10:375\n202#3:412\n1863#4:394\n1864#4:407\n1#5:397\n178#6,5:414\n183#6,3:438\n178#6,5:441\n183#6,3:465\n178#6,5:468\n183#6,3:492\n503#7:419\n484#7,18:420\n503#7:446\n484#7,18:447\n503#7:473\n484#7,18:474\n*S KotlinDebug\n*F\n+ 1 CHouseIntrospector.kt\ncom/intellij/database/dialects/clickhouse/introspector/CHouseIntrospector\n*L\n53#1:365,10\n53#1:385,9\n53#1:395\n53#1:396\n53#1:398,9\n53#1:408,3\n53#1:411\n53#1:413\n53#1:375,10\n53#1:412\n53#1:394\n53#1:407\n53#1:397\n79#1:414,5\n79#1:438,3\n96#1:441,5\n96#1:465,3\n117#1:468,5\n117#1:492,3\n80#1:419\n80#1:420,18\n97#1:446\n97#1:447,18\n118#1:473\n118#1:474,18\n*E\n"})
public final class CHouseIntrospector
extends BaseSingleDatabaseIntrospector<CHouseRoot, CHouseSchema> {
    public CHouseIntrospector(@NotNull DBIntrospectionContext context, @NotNull ModelFactory modelFactory) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)modelFactory, (String)"modelFactory");
        BaseIntrospector.Nature nature = BaseIntrospector.DefaultNature.INSTANCE;
        Dbms dbms = Dbms.CLICKHOUSE;
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"CLICKHOUSE");
        super(context, nature, dbms, modelFactory);
    }

    @Override
    protected void introspectNamespacesInTran(@NotNull DBTransaction tran) {
        Intrinsics.checkNotNullParameter((Object)tran, (String)"tran");
        List<String> schemaNames2 = CHouseIntroQueries.INSTANCE.retrieveSchemas(tran);
        this.applySchemas(schemaNames2);
    }

    @Override
    public void retrieveAndApplySchemas() {
        List schemaNames2 = (List)this.inTransaction(CHouseIntrospector::retrieveAndApplySchemas$lambda$0);
        this.applySchemas(schemaNames2);
    }

    private final void applySchemas(List<String> newSchemas) {
        this.inModel(arg_0 -> CHouseIntrospector.applySchemas$lambda$3(newSchemas, arg_0));
    }

    @Override
    protected void introspectSchemasAuto(@NotNull DBTransaction tran, @NotNull List<? extends CHouseSchema> schemas, boolean whole) {
        Intrinsics.checkNotNullParameter((Object)tran, (String)"tran");
        Intrinsics.checkNotNullParameter(schemas, (String)"schemas");
        for (CHouseSchema cHouseSchema : schemas) {
            this.introspectOneSchema(tran, cHouseSchema);
        }
    }

    private final void introspectOneSchema(DBTransaction tran, CHouseSchema schema) {
        this.handleErrors("Introspect schema " + schema.getName(), (Function0<Unit>)((Function0)() -> CHouseIntrospector.introspectOneSchema$lambda$4(this, tran, schema)));
    }

    @Override
    protected void introspectAllServerObjects(@NotNull DBTransaction tran) {
        Intrinsics.checkNotNullParameter((Object)tran, (String)"tran");
        this.retrieveFunctions(tran);
        this.retrieveUsers(tran);
        this.retrieveRoles(tran);
    }

    private final void retrieveFunctions(DBTransaction tran) {
        this.reportRetrieving("server objects", "introspection.retrieve.serverObjects");
        this.inModel(arg_0 -> CHouseIntrospector.retrieveFunctions$lambda$8(this, tran, arg_0));
    }

    private final void retrieveUsers(DBTransaction tran) {
        this.reportRetrieving("server objects", "introspection.retrieve.serverObjects");
        this.inModel(arg_0 -> CHouseIntrospector.retrieveUsers$lambda$13(this, tran, arg_0));
    }

    private final void retrieveRoles(DBTransaction tran) {
        this.reportRetrieving("server objects", "introspection.retrieve.serverObjects");
        this.inModel(arg_0 -> CHouseIntrospector.retrieveRoles$lambda$18(this, tran, arg_0));
    }

    @Override
    @NotNull
    protected BaseSingleDatabaseIntrospector.BaseDatabaseRetriever<CHouseRoot> createDatabaseRetriever(@NotNull DBTransaction transaction, @NotNull CHouseRoot database) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)database, (String)"database");
        return new CHouseDatabaseRetriever(transaction);
    }

    @Override
    @NotNull
    protected BaseSingleDatabaseIntrospector.BaseNativeRetriever<CHouseRoot> createNativeRetriever(@NotNull DBTransaction transaction, @NotNull CHouseRoot database) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)database, (String)"database");
        return new CHouseNativeRetriever(transaction);
    }

    @NotNull
    protected CHouseSchemaRetriever createSchemaRetriever(@NotNull DBTransaction transaction, @NotNull CHouseSchema schema) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        return new CHouseSchemaRetriever(transaction, schema);
    }

    private static final List retrieveAndApplySchemas$lambda$0(DBTransaction tran) {
        Intrinsics.checkNotNullParameter((Object)tran, (String)"tran");
        return CHouseIntroQueries.INSTANCE.retrieveSchemas(tran);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private static final Unit applySchemas$lambda$3(List $newSchemas, CHouseRoot root) {
        void $this$iv$iv$iv;
        void $this$applySchemasNamed$iv$iv;
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        NamingFamily namingFamily = root.getSchemas();
        Intrinsics.checkNotNullExpressionValue((Object)namingFamily, (String)"getSchemas(...)");
        NamingFamily $this$applySchemasNamed$iv = namingFamily;
        boolean $i$f$applySchemasNamed = false;
        NamingFamily namingFamily2 = $this$applySchemasNamed$iv;
        ElementSearchCache searchCache$iv$iv = new ElementSearchCache();
        boolean $i$f$applySchemasNamed2 = false;
        FamilySearcher familySearcher = ElementCacheOptimizersKt.byName(ElementCacheKt.searchElement(searchCache$iv$iv), (Function1)new Function1<String, String>(){

            /*
             * Ignored method signature, as it can't be verified against descriptor
             * WARNING - void declaration
             */
            public final String invoke(Object $this$byName) {
                void var2_2;
                String it = (String)$this$byName;
                boolean bl = false;
                return var2_2;
            }
        }).inFamily((Family)$this$applySchemasNamed$iv$iv);
        Function2 filler$iv$iv$iv = applySchemas$lambda$3$$inlined$applySchemasNamed$2.INSTANCE;
        boolean $i$f$orCreateBulk = false;
        ArrayList items$iv$iv$iv = new ArrayList();
        ElementSearcherNN searcher$iv$iv$iv = ElementCacheKt.orCreateElement((ElementSearcher)$this$iv$iv$iv, (Function1)new Function1<D, T>((FamilySearcher)$this$iv$iv$iv, filler$iv$iv$iv, items$iv$iv$iv){
            final /* synthetic */ FamilySearcher this$0;
            final /* synthetic */ Function2 $filler;
            final /* synthetic */ ArrayList $items;
            {
                this.this$0 = $receiver;
                this.$filler = $filler;
                this.$items = $items;
            }

            public final T invoke(D it) {
                T t = BasicMetaUtils.getMetaObject(this.this$0.getFamily()).newDataObject();
                Intrinsics.checkNotNullExpressionValue(t, (String)"newDataObject(...)");
                T t2 = t;
                FamilySearcher familySearcher = this.this$0;
                Function2 function2 = this.$filler;
                ArrayList arrayList = this.$items;
                T $this$invoke_u24lambda_u240 = t2;
                boolean bl = false;
                familySearcher.fillImpl($this$invoke_u24lambda_u240, it, function2);
                ((Collection)arrayList).add($this$invoke_u24lambda_u240);
                return t2;
            }
        });
        try {
            ElementSearcherNN schemas$iv$iv = searcher$iv$iv$iv;
            boolean bl = false;
            void $this$applySchemasImpl$iv$iv$iv = $this$applySchemasNamed$iv$iv;
            boolean $i$f$applySchemasImpl = false;
            $this$applySchemasImpl$iv$iv$iv.markChildrenAsSyncPending();
            Iterable $this$forEach$iv$iv$iv$iv = $newSchemas;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                void sc;
                void sc$iv$iv;
                Object element$iv$iv$iv$iv;
                Object sc$iv$iv$iv = element$iv$iv$iv$iv = iterator.next();
                boolean bl2 = false;
                Object t = sc$iv$iv$iv;
                void $this$applySchemasNamed_u24lambda_u2420_u24lambda_u2419$iv$iv = $this$applySchemasImpl$iv$iv$iv;
                boolean bl3 = false;
                BasicModMateNamespace $this$applySchemasNamed_u24lambda_u2420_u24lambda_u2419_u24lambda_u2418$iv$iv = (BasicModMateNamespace)schemas$iv$iv.find(sc$iv$iv);
                boolean bl4 = false;
                String string = (String)sc$iv$iv;
                CHouseSchema $this$applySchemas_u24lambda_u243_u24lambda_u242 = (CHouseSchema)$this$applySchemasNamed_u24lambda_u2420_u24lambda_u2419_u24lambda_u2418$iv$iv;
                boolean bl5 = false;
                $this$applySchemas_u24lambda_u243_u24lambda_u242.setCurrent(Intrinsics.areEqual((Object)sc, (Object)CollectionsKt.first((List)$newSchemas)));
            }
            $this$applySchemasImpl$iv$iv$iv.removeSyncPendingChildren();
            $this$applySchemasImpl$iv$iv$iv.sort();
        }
        finally {
            Family family = $this$iv$iv$iv.getFamily();
            Intrinsics.checkNotNull(family, (String)"null cannot be cast to non-null type com.intellij.database.model.families.Family<T of com.intellij.database.model.FamilySearcher>");
            BaseModel.createBulk(family, items$iv$iv$iv);
        }
        return Unit.INSTANCE;
    }

    private static final Unit introspectOneSchema$lambda$4(CHouseIntrospector this$0, DBTransaction $tran, CHouseSchema $schema) {
        CHouseSchemaRetriever retriever = this$0.createSchemaRetriever($tran, $schema);
        retriever.process();
        return Unit.INSTANCE;
    }

    private static final Unit retrieveFunctions$lambda$8$lambda$7$lambda$6$lambda$5(CHouseRoot $root, CHouseIntroQueries.FunctionInfo r) {
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        CHouseRoutine routine2 = $root.getRoutines().createOrGet(r.name);
        Boolean bl = r.is_aggregate;
        routine2.setAggregate(bl != null ? bl : false);
        routine2.getArguments().clear();
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit retrieveFunctions$lambda$8(CHouseIntrospector this$0, DBTransaction $tran, CHouseRoot root) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        ModFamily $this$modifyAndCleanup_u24default$iv = root.getRoutines();
        boolean removeUnaffected$iv = true;
        boolean $i$f$modifyAndCleanup = false;
        $this$modifyAndCleanup_u24default$iv.markChildrenAsSyncPending();
        ModNamingFamily it = (ModNamingFamily)$this$modifyAndCleanup_u24default$iv;
        boolean bl = false;
        BaseNativeIntrospector this_$iv = this$0;
        boolean $i$f$continueOnDbError = false;
        BaseNativeIntrospector baseNativeIntrospector = this_$iv;
        Object whatsDoing$iv$iv = null;
        boolean $i$f$continueOnDbError2 = false;
        try {
            boolean bl2 = false;
            CHouseIntroQueries.INSTANCE.processFunctions($tran, (Function1<? super CHouseIntroQueries.FunctionInfo, Unit>)((Function1)arg_0 -> CHouseIntrospector.retrieveFunctions$lambda$8$lambda$7$lambda$6$lambda$5(root, arg_0)));
        }
        catch (DBException e$iv$iv) {
            StringBuilder stringBuilder;
            void this_$iv$iv;
            boolean expected$iv$iv = BaseNativeIntrospector.access$ignoreThisDbException((BaseNativeIntrospector)this_$iv$iv, e$iv$iv);
            StringBuilder $this$continueOnDbError_u24lambda_u2416$iv$iv = stringBuilder = new StringBuilder();
            boolean bl3 = false;
            $this$continueOnDbError_u24lambda_u2416$iv$iv.append(expected$iv$iv ? "Expected" : "Unexpected");
            $this$continueOnDbError_u24lambda_u2416$iv$iv.append(" DB error ").append(e$iv$iv.vendorErrorCode).append(" encountered (and ignored)");
            $this$continueOnDbError_u24lambda_u2416$iv$iv.append(". Exception message: ").append(e$iv$iv.getMessage());
            String message$iv$iv = stringBuilder.toString();
            if (expected$iv$iv) {
                this_$iv$iv.trace(message$iv$iv);
            } else {
                IntrospectionQueryContext.logWarn$default((IntrospectionQueryContext)this_$iv$iv, message$iv$iv, null, 2, null);
            }
            this_$iv$iv.getErrorSink().accept(null, e$iv$iv);
        }
        $this$modifyAndCleanup_u24default$iv.removeSyncPendingChildren();
        $this$modifyAndCleanup_u24default$iv.sort();
        return Unit.INSTANCE;
    }

    private static final Unit retrieveUsers$lambda$13$lambda$12$lambda$11$lambda$10(CHouseRoot $root, CHouseIntroQueries.UserInfo u) {
        CHouseUser cHouseUser;
        Intrinsics.checkNotNullParameter((Object)u, (String)"u");
        CHouseUser $this$retrieveUsers_u24lambda_u2413_u24lambda_u2412_u24lambda_u2411_u24lambda_u2410_u24lambda_u249 = cHouseUser = $root.getUsers().createOrGet(u.name);
        boolean bl = false;
        $this$retrieveUsers_u24lambda_u2413_u24lambda_u2412_u24lambda_u2411_u24lambda_u2410_u24lambda_u249.setAuthType(u.auth_type);
        $this$retrieveUsers_u24lambda_u2413_u24lambda_u2412_u24lambda_u2411_u24lambda_u2410_u24lambda_u249.setHostIp(ArraysKt.toList((Object[])u.host_ip));
        $this$retrieveUsers_u24lambda_u2413_u24lambda_u2412_u24lambda_u2411_u24lambda_u2410_u24lambda_u249.setHostNames(ArraysKt.toList((Object[])u.host_names));
        $this$retrieveUsers_u24lambda_u2413_u24lambda_u2412_u24lambda_u2411_u24lambda_u2410_u24lambda_u249.setHostNamesLike(ArraysKt.toList((Object[])u.host_names_like));
        $this$retrieveUsers_u24lambda_u2413_u24lambda_u2412_u24lambda_u2411_u24lambda_u2410_u24lambda_u249.setHostNamesRegexp(ArraysKt.toList((Object[])u.host_names_regexp));
        $this$retrieveUsers_u24lambda_u2413_u24lambda_u2412_u24lambda_u2411_u24lambda_u2410_u24lambda_u249.setDefaultRolesAll(u.default_roles_all);
        $this$retrieveUsers_u24lambda_u2413_u24lambda_u2412_u24lambda_u2411_u24lambda_u2410_u24lambda_u249.setDefaultRolesList(ArraysKt.toList((Object[])(u.default_roles_all ? u.default_roles_except : u.default_roles_list)));
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit retrieveUsers$lambda$13(CHouseIntrospector this$0, DBTransaction $tran, CHouseRoot root) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        ModFamily $this$modifyAndCleanup_u24default$iv = root.getUsers();
        boolean removeUnaffected$iv = true;
        boolean $i$f$modifyAndCleanup = false;
        $this$modifyAndCleanup_u24default$iv.markChildrenAsSyncPending();
        ModNamingFamily it = (ModNamingFamily)$this$modifyAndCleanup_u24default$iv;
        boolean bl = false;
        BaseNativeIntrospector this_$iv = this$0;
        boolean $i$f$continueOnDbError = false;
        BaseNativeIntrospector baseNativeIntrospector = this_$iv;
        Object whatsDoing$iv$iv = null;
        boolean $i$f$continueOnDbError2 = false;
        try {
            boolean bl2 = false;
            CHouseIntroQueries.INSTANCE.processUsers($tran, (Function1<? super CHouseIntroQueries.UserInfo, Unit>)((Function1)arg_0 -> CHouseIntrospector.retrieveUsers$lambda$13$lambda$12$lambda$11$lambda$10(root, arg_0)));
        }
        catch (DBException e$iv$iv) {
            StringBuilder stringBuilder;
            void this_$iv$iv;
            boolean expected$iv$iv = BaseNativeIntrospector.access$ignoreThisDbException((BaseNativeIntrospector)this_$iv$iv, e$iv$iv);
            StringBuilder $this$continueOnDbError_u24lambda_u2416$iv$iv = stringBuilder = new StringBuilder();
            boolean bl3 = false;
            $this$continueOnDbError_u24lambda_u2416$iv$iv.append(expected$iv$iv ? "Expected" : "Unexpected");
            $this$continueOnDbError_u24lambda_u2416$iv$iv.append(" DB error ").append(e$iv$iv.vendorErrorCode).append(" encountered (and ignored)");
            $this$continueOnDbError_u24lambda_u2416$iv$iv.append(". Exception message: ").append(e$iv$iv.getMessage());
            String message$iv$iv = stringBuilder.toString();
            if (expected$iv$iv) {
                this_$iv$iv.trace(message$iv$iv);
            } else {
                IntrospectionQueryContext.logWarn$default((IntrospectionQueryContext)this_$iv$iv, message$iv$iv, null, 2, null);
            }
            this_$iv$iv.getErrorSink().accept(null, e$iv$iv);
        }
        $this$modifyAndCleanup_u24default$iv.removeSyncPendingChildren();
        $this$modifyAndCleanup_u24default$iv.sort();
        return Unit.INSTANCE;
    }

    private static final Unit retrieveRoles$lambda$18$lambda$17$lambda$16$lambda$15(CHouseRoot $root, CHouseIntroQueries.RoleInfo r) {
        CHouseRole cHouseRole;
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        CHouseRole $this$retrieveRoles_u24lambda_u2418_u24lambda_u2417_u24lambda_u2416_u24lambda_u2415_u24lambda_u2414 = cHouseRole = $root.getRoles().createOrGet(r.name);
        boolean bl = false;
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit retrieveRoles$lambda$18(CHouseIntrospector this$0, DBTransaction $tran, CHouseRoot root) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        ModFamily $this$modifyAndCleanup_u24default$iv = root.getRoles();
        boolean removeUnaffected$iv = true;
        boolean $i$f$modifyAndCleanup = false;
        $this$modifyAndCleanup_u24default$iv.markChildrenAsSyncPending();
        ModNamingFamily it = (ModNamingFamily)$this$modifyAndCleanup_u24default$iv;
        boolean bl = false;
        BaseNativeIntrospector this_$iv = this$0;
        boolean $i$f$continueOnDbError = false;
        BaseNativeIntrospector baseNativeIntrospector = this_$iv;
        Object whatsDoing$iv$iv = null;
        boolean $i$f$continueOnDbError2 = false;
        try {
            boolean bl2 = false;
            CHouseIntroQueries.INSTANCE.processRoles($tran, (Function1<? super CHouseIntroQueries.RoleInfo, Unit>)((Function1)arg_0 -> CHouseIntrospector.retrieveRoles$lambda$18$lambda$17$lambda$16$lambda$15(root, arg_0)));
        }
        catch (DBException e$iv$iv) {
            StringBuilder stringBuilder;
            void this_$iv$iv;
            boolean expected$iv$iv = BaseNativeIntrospector.access$ignoreThisDbException((BaseNativeIntrospector)this_$iv$iv, e$iv$iv);
            StringBuilder $this$continueOnDbError_u24lambda_u2416$iv$iv = stringBuilder = new StringBuilder();
            boolean bl3 = false;
            $this$continueOnDbError_u24lambda_u2416$iv$iv.append(expected$iv$iv ? "Expected" : "Unexpected");
            $this$continueOnDbError_u24lambda_u2416$iv$iv.append(" DB error ").append(e$iv$iv.vendorErrorCode).append(" encountered (and ignored)");
            $this$continueOnDbError_u24lambda_u2416$iv$iv.append(". Exception message: ").append(e$iv$iv.getMessage());
            String message$iv$iv = stringBuilder.toString();
            if (expected$iv$iv) {
                this_$iv$iv.trace(message$iv$iv);
            } else {
                IntrospectionQueryContext.logWarn$default((IntrospectionQueryContext)this_$iv$iv, message$iv$iv, null, 2, null);
            }
            this_$iv$iv.getErrorSink().accept(null, e$iv$iv);
        }
        $this$modifyAndCleanup_u24default$iv.removeSyncPendingChildren();
        $this$modifyAndCleanup_u24default$iv.sort();
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u0018\u0012\u0004\u0012\u00020\u00020\u0001R\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00040\u0003B\u000f\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/database/dialects/clickhouse/introspector/CHouseIntrospector$CHouseDatabaseRetriever;", "Lcom/intellij/database/dialects/base/introspector/BaseSingleDatabaseIntrospector$BaseDatabaseRetriever;", "Lcom/intellij/database/dialects/clickhouse/model/CHouseRoot;", "Lcom/intellij/database/dialects/base/introspector/BaseSingleDatabaseIntrospector;", "Lcom/intellij/database/dialects/clickhouse/model/CHouseSchema;", "transaction", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "<init>", "(Lcom/intellij/database/dialects/clickhouse/introspector/CHouseIntrospector;Lcom/intellij/database/layoutedQueries/DBTransaction;)V", "process", "", "intellij.database.dialects.clickhouse"})
    private final class CHouseDatabaseRetriever
    extends BaseSingleDatabaseIntrospector.BaseDatabaseRetriever<CHouseRoot> {
        public CHouseDatabaseRetriever(DBTransaction transaction) {
            Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
            super(transaction);
        }

        @Override
        public void process() {
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0000\b\u0082\u0004\u0018\u00002\u0018\u0012\u0004\u0012\u00020\u00020\u0001R\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00040\u0003B\u000f\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ8\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0018\u0010\u0010\u001a\u0014\u0012\u0004\u0012\u00020\u000f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u00120\u0011H\u0014\u00a8\u0006\u0014"}, d2={"Lcom/intellij/database/dialects/clickhouse/introspector/CHouseIntrospector$CHouseNativeRetriever;", "Lcom/intellij/database/dialects/base/introspector/BaseSingleDatabaseIntrospector$BaseNativeRetriever;", "Lcom/intellij/database/dialects/clickhouse/model/CHouseRoot;", "Lcom/intellij/database/dialects/base/introspector/BaseSingleDatabaseIntrospector;", "Lcom/intellij/database/dialects/clickhouse/model/CHouseSchema;", "transaction", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "<init>", "(Lcom/intellij/database/dialects/clickhouse/introspector/CHouseIntrospector;Lcom/intellij/database/layoutedQueries/DBTransaction;)V", "retrieveNativeDefinitionsFor", "", "kind", "Lcom/intellij/database/model/ObjectKind;", "elements", "", "Lcom/intellij/database/model/basic/BasicElement;", "result", "", "", "", "intellij.database.dialects.clickhouse"})
    private final class CHouseNativeRetriever
    extends BaseSingleDatabaseIntrospector.BaseNativeRetriever<CHouseRoot> {
        public CHouseNativeRetriever(DBTransaction transaction) {
            Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
            super(transaction);
        }

        @Override
        protected void retrieveNativeDefinitionsFor(@NotNull ObjectKind kind, @NotNull Iterable<? extends BasicElement> elements, @NotNull Map<BasicElement, String[]> result2) {
            Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            Intrinsics.checkNotNullParameter(result2, (String)"result");
            if (!(Intrinsics.areEqual((Object)kind, (Object)ObjectKind.TABLE) || Intrinsics.areEqual((Object)kind, (Object)ObjectKind.VIEW) || Intrinsics.areEqual((Object)kind, (Object)ObjectKind.MAT_VIEW))) {
                return;
            }
            for (BasicElement basicElement : elements) {
                Map<BasicElement, String[]> map2 = result2;
                String[] stringArray = new String[1];
                DBTransaction dBTransaction = this.getTransaction();
                Intrinsics.checkNotNull((Object)basicElement, (String)"null cannot be cast to non-null type com.intellij.database.dialects.clickhouse.model.CHouseLikeTable");
                stringArray[0] = CHouseIntroQueries.INSTANCE.retrieveTableSource(dBTransaction, (CHouseLikeTable)basicElement);
                map2.put(basicElement, stringArray);
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0084\u0004\u0018\u00002\u001e\u0012\u0004\u0012\u00020\u00020\u0001R\u0014\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00020\u0003B\u0017\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0002\u00a2\u0006\u0004\b\b\u0010\tJ\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0014J\b\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\u0002H\u0002J\u0010\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J$\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00110\u00132\u000e\u0010\u0015\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00140\u0016H\u0002J\u0010\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\u0002H\u0002J\u0012\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0002J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0012\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010!\u001a\u00020\u001bH\u0002J\u0010\u0010\"\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\u0002H\u0002J\u0010\u0010#\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\u0002H\u0002J\u0010\u0010$\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\u0002H\u0002\u00a8\u0006%"}, d2={"Lcom/intellij/database/dialects/clickhouse/introspector/CHouseIntrospector$CHouseSchemaRetriever;", "Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector$AbstractSchemaRetriever;", "Lcom/intellij/database/dialects/clickhouse/model/CHouseSchema;", "Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector;", "Lcom/intellij/database/dialects/clickhouse/model/CHouseRoot;", "tran", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "schema", "<init>", "(Lcom/intellij/database/dialects/clickhouse/introspector/CHouseIntrospector;Lcom/intellij/database/layoutedQueries/DBTransaction;Lcom/intellij/database/dialects/clickhouse/model/CHouseSchema;)V", "isPossibleToIntrospectSchemaIncrementally", "", "process", "", "retrieveTables", "patchMvEngineEntry", "t", "Lcom/intellij/database/dialects/clickhouse/introspector/CHouseIntroQueries$TableInfo;", "matViewSearcher", "Lcom/intellij/database/model/ElementSearcherNN;", "Lcom/intellij/database/dialects/clickhouse/model/CHouseMatView;", "views", "Lcom/intellij/database/model/families/ModNamingFamily;", "retrieveColumns", "getColumnKind", "Lcom/intellij/database/model/properties/ColumnKind;", "extra", "", "retrieveTableSource", "table", "Lcom/intellij/database/dialects/clickhouse/model/CHouseLikeTable;", "getCreate", "Lcom/intellij/sql/psi/SqlCreateStatement;", "src", "retrieveViewSources", "retrieveMatViewSources", "retrieveTableSources", "intellij.database.dialects.clickhouse"})
    @SourceDebugExtension(value={"SMAP\nCHouseIntrospector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CHouseIntrospector.kt\ncom/intellij/database/dialects/clickhouse/introspector/CHouseIntrospector$CHouseSchemaRetriever\n+ 2 BaseIntrospectionFunctions.kt\ncom/intellij/database/dialects/base/introspector/BaseIntrospectionFunctions\n+ 3 BaseNativeIntrospector.kt\ncom/intellij/database/dialects/base/introspector/BaseNativeIntrospector\n+ 4 ElementCache.kt\ncom/intellij/database/model/ElementChecker\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 6 IntrospectorSqlHelper.kt\ncom/intellij/database/dialects/base/introspector/IntrospectorSqlHelper\n+ 7 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 8 BaseIntrospector.kt\ncom/intellij/database/dialects/base/introspector/BaseIntrospector\n*L\n1#1,364:1\n195#2,8:365\n204#2,5:392\n322#2:398\n325#2:405\n326#2:425\n330#2:430\n503#3:373\n484#3,2:374\n487#3,15:377\n503#3:406\n484#3,18:407\n139#3,2:431\n142#3,8:434\n382#3:443\n383#3,2:449\n30#4:376\n30#4:397\n1863#5,2:399\n1863#5,2:401\n1863#5,2:403\n1863#5,2:426\n1863#5,2:428\n26#6:433\n1#7:442\n1039#8:444\n1134#8,2:445\n1040#8,2:447\n1044#8:451\n1139#8,2:452\n1045#8,2:454\n*S KotlinDebug\n*F\n+ 1 CHouseIntrospector.kt\ncom/intellij/database/dialects/clickhouse/introspector/CHouseIntrospector$CHouseSchemaRetriever\n*L\n185#1:365,8\n185#1:392,5\n260#1:398\n260#1:405\n260#1:425\n260#1:430\n186#1:373\n186#1:374,2\n186#1:377,15\n265#1:406\n265#1:407,18\n318#1:431,2\n318#1:434,8\n174#1:443\n174#1:449,2\n190#1:376\n243#1:397\n261#1:399,2\n262#1:401,2\n263#1:403,2\n262#1:426,2\n263#1:428,2\n318#1:433\n174#1:444\n174#1:445,2\n174#1:447,2\n174#1:451\n174#1:452,2\n174#1:454,2\n*E\n"})
    protected final class CHouseSchemaRetriever
    extends BaseNativeIntrospector.AbstractSchemaRetriever<CHouseSchema> {
        public CHouseSchemaRetriever(@NotNull DBTransaction tran, CHouseSchema schema) {
            Intrinsics.checkNotNullParameter((Object)tran, (String)"tran");
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            super((BaseNativeIntrospector)CHouseIntrospector.this, tran, (BasicModSchema)schema);
        }

        @Override
        protected boolean isPossibleToIntrospectSchemaIncrementally(@NotNull DBTransaction tran, @NotNull CHouseSchema schema) {
            Intrinsics.checkNotNullParameter((Object)tran, (String)"tran");
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            return false;
        }

        @Override
        public void process() {
            BaseIntrospector baseIntrospector = CHouseIntrospector.this;
            String string = ((CHouseSchema)this.getSchema()).getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            BaseIntrospector.reportIntrospectingSchema$default(baseIntrospector, string, this.getMode(), null, 4, null);
            this.prepareParameters();
            this.inSchema(arg_0 -> CHouseSchemaRetriever.process$lambda$0(this, arg_0));
            this.inSchema(arg_0 -> CHouseSchemaRetriever.process$lambda$1(this, arg_0));
            this.inSchema(arg_0 -> CHouseSchemaRetriever.process$lambda$3(CHouseIntrospector.this, this, arg_0));
        }

        /*
         * WARNING - void declaration
         */
        private final void retrieveTables(CHouseSchema schema) {
            void families$iv;
            CHouseIntrospector.this.reportRetrieving("tables and views", "introspection.retrieve.tablesViews");
            ModFamily[] modFamilyArray = new ModFamily[]{schema.getTables(), schema.getViews(), schema.getMatViews()};
            CHouseIntrospector cHouseIntrospector = CHouseIntrospector.this;
            boolean removeUnaffected$iv = true;
            boolean $i$f$modifyFamiliesAndCleanup = false;
            for (void f$iv : families$iv) {
                f$iv.markChildrenAsSyncPending();
            }
            boolean bl = false;
            BaseNativeIntrospector this_$iv = cHouseIntrospector;
            boolean $i$f$continueOnDbError = false;
            BaseNativeIntrospector baseNativeIntrospector = this_$iv;
            Object whatsDoing$iv$iv = null;
            boolean $i$f$continueOnDbError2 = false;
            try {
                void this_$iv2;
                boolean bl2 = false;
                ModNamingFamily<? extends CHouseMatView> modNamingFamily = schema.getMatViews();
                Intrinsics.checkNotNullExpressionValue(modNamingFamily, (String)"getMatViews(...)");
                ElementSearcherNN<CHouseMatView, CHouseIntroQueries.TableInfo> matViews = this.matViewSearcher(modNamingFamily);
                ElementChecker elementChecker = ElementCacheOptimizersKt.byName(this.searchInSchema(), CHouseSchemaRetriever::retrieveTables$lambda$11$lambda$10$lambda$4);
                boolean $i$f$prepare = false;
                void $this$retrieveTables_u24lambda_u2411_u24lambda_u2410_u24lambda_u248 = this_$iv2;
                boolean bl3 = false;
                ModNamingFamily<? extends CHouseTable> modNamingFamily2 = schema.getTables();
                Intrinsics.checkNotNullExpressionValue(modNamingFamily2, (String)"getTables(...)");
                ElementSearcherNN tables = $this$retrieveTables_u24lambda_u2411_u24lambda_u2410_u24lambda_u248.inFamily((Family)modNamingFamily2).orCreate(CHouseSchemaRetriever::retrieveTables$lambda$11$lambda$10$lambda$8$lambda$5);
                ModNamingFamily<? extends CHouseView> modNamingFamily3 = schema.getViews();
                Intrinsics.checkNotNullExpressionValue(modNamingFamily3, (String)"getViews(...)");
                ElementSearcherNN views = $this$retrieveTables_u24lambda_u2411_u24lambda_u2410_u24lambda_u248.inFamily((Family)modNamingFamily3).orCreate(CHouseSchemaRetriever::retrieveTables$lambda$11$lambda$10$lambda$8$lambda$6);
                ElementSearcherNN tableSearcher = $this$retrieveTables_u24lambda_u2411_u24lambda_u2410_u24lambda_u248.chooseNN(arg_0 -> CHouseSchemaRetriever.retrieveTables$lambda$11$lambda$10$lambda$8$lambda$7(views, matViews, tables, arg_0));
                CHouseIntroQueries.INSTANCE.processTables(this.getTransaction(), schema, (Function1<? super CHouseIntroQueries.TableInfo, Unit>)((Function1)arg_0 -> CHouseSchemaRetriever.retrieveTables$lambda$11$lambda$10$lambda$9(this, tableSearcher, matViews, arg_0)));
            }
            catch (DBException e$iv$iv) {
                StringBuilder stringBuilder;
                void this_$iv$iv;
                boolean expected$iv$iv = BaseNativeIntrospector.access$ignoreThisDbException((BaseNativeIntrospector)this_$iv$iv, e$iv$iv);
                StringBuilder $this$continueOnDbError_u24lambda_u2416$iv$iv = stringBuilder = new StringBuilder();
                boolean bl4 = false;
                $this$continueOnDbError_u24lambda_u2416$iv$iv.append(expected$iv$iv ? "Expected" : "Unexpected");
                $this$continueOnDbError_u24lambda_u2416$iv$iv.append(" DB error ").append(e$iv$iv.vendorErrorCode).append(" encountered (and ignored)");
                $this$continueOnDbError_u24lambda_u2416$iv$iv.append(". Exception message: ").append(e$iv$iv.getMessage());
                String message$iv$iv = stringBuilder.toString();
                if (expected$iv$iv) {
                    this_$iv$iv.trace(message$iv$iv);
                } else {
                    IntrospectionQueryContext.logWarn$default((IntrospectionQueryContext)this_$iv$iv, message$iv$iv, null, 2, null);
                }
                this_$iv$iv.getErrorSink().accept(null, e$iv$iv);
            }
            for (void f$iv : families$iv) {
                f$iv.removeSyncPendingChildren();
                f$iv.sort();
            }
        }

        private final boolean patchMvEngineEntry(CHouseIntroQueries.TableInfo t) {
            boolean bl;
            if (StringsKt.startsWith$default((String)t.name, (String)".inner_id.", (boolean)false, (int)2, null)) {
                t.comment = t.name;
                String string = t.name.substring(10);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                t.uuid = string;
                t.name = "";
                bl = true;
            } else if (StringsKt.startsWith$default((String)t.name, (String)".inner.", (boolean)false, (int)2, null)) {
                t.comment = t.name;
                String string = t.name.substring(7);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                t.name = string;
                t.uuid = "";
                bl = true;
            } else {
                bl = false;
            }
            return bl;
        }

        private final ElementSearcherNN<CHouseMatView, CHouseIntroQueries.TableInfo> matViewSearcher(ModNamingFamily<? extends CHouseMatView> views) {
            ElementChecker this_$iv = this.searchInSchema();
            boolean $i$f$prepare = false;
            ElementChecker $this$matViewSearcher_u24lambda_u2417 = this_$iv;
            boolean bl = false;
            FamilySearcher matViewsByName = ElementCacheOptimizersKt.byName($this$matViewSearcher_u24lambda_u2417, CHouseSchemaRetriever::matViewSearcher$lambda$17$lambda$12).inFamily((Family)views);
            FamilySearcher matViewsByUuid = CHouseIntrospectorKt.access$byUuid($this$matViewSearcher_u24lambda_u2417, CHouseSchemaRetriever::matViewSearcher$lambda$17$lambda$13).inFamily((Family)views);
            ElementSearcher matViewsByNameAndUuid = ElementCacheKt.or(matViewsByUuid, matViewsByName);
            return ElementCacheKt.orCreateElement($this$matViewSearcher_u24lambda_u2417.choose(arg_0 -> CHouseSchemaRetriever.matViewSearcher$lambda$17$lambda$14(matViewsByName, matViewsByUuid, matViewsByNameAndUuid, arg_0)), arg_0 -> CHouseSchemaRetriever.matViewSearcher$lambda$17$lambda$16(matViewsByName, arg_0));
        }

        /*
         * WARNING - void declaration
         */
        private final void retrieveColumns(CHouseSchema schema) {
            BasicModView v;
            ObjectKind objectKind = ObjectKind.COLUMN;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"COLUMN");
            CHouseIntrospector.this.reportRetrieving(objectKind);
            Ref.IntRef pos = new Ref.IntRef();
            pos.element = 1;
            Ref.ObjectRef tableName = new Ref.ObjectRef();
            tableName.element = "";
            CHouseIntrospector cHouseIntrospector = CHouseIntrospector.this;
            boolean $i$f$modifyFamiliesAndCleanup = false;
            Function1 it = CHouseSchemaRetriever$retrieveColumns$$inlined$modifyFamiliesAndCleanup$1.INSTANCE;
            boolean bl = false;
            ModNamingFamily<? extends CHouseTable> modNamingFamily = schema.getTables();
            Intrinsics.checkNotNullExpressionValue(modNamingFamily, (String)"getTables(...)");
            Iterable $this$forEach$iv = modNamingFamily;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                CHouseTable t = (CHouseTable)element$iv;
                boolean bl2 = false;
                PositioningNamingFamily positioningNamingFamily = t.getColumns();
                Intrinsics.checkNotNullExpressionValue((Object)positioningNamingFamily, (String)"getColumns(...)");
                it.invoke((Object)positioningNamingFamily);
            }
            ModNamingFamily<? extends CHouseView> modNamingFamily2 = schema.getViews();
            Intrinsics.checkNotNullExpressionValue(modNamingFamily2, (String)"getViews(...)");
            $this$forEach$iv = modNamingFamily2;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                v = (CHouseView)element$iv;
                boolean bl3 = false;
                PositioningNamingFamily positioningNamingFamily = v.getColumns();
                Intrinsics.checkNotNullExpressionValue((Object)positioningNamingFamily, (String)"getColumns(...)");
                it.invoke((Object)positioningNamingFamily);
            }
            ModNamingFamily<? extends CHouseMatView> modNamingFamily3 = schema.getMatViews();
            Intrinsics.checkNotNullExpressionValue(modNamingFamily3, (String)"getMatViews(...)");
            $this$forEach$iv = modNamingFamily3;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                v = (CHouseMatView)element$iv;
                boolean bl4 = false;
                PositioningNamingFamily positioningNamingFamily = v.getColumns();
                Intrinsics.checkNotNullExpressionValue((Object)positioningNamingFamily, (String)"getColumns(...)");
                it.invoke((Object)positioningNamingFamily);
            }
            boolean bl5 = false;
            BaseNativeIntrospector this_$iv = cHouseIntrospector;
            boolean $i$f$continueOnDbError = false;
            BaseNativeIntrospector $i$f$forEach2 = this_$iv;
            Object whatsDoing$iv$iv = null;
            boolean $i$f$continueOnDbError2 = false;
            try {
                boolean bl6 = false;
                CHouseIntroQueries.INSTANCE.processColumns(this.getTransaction(), schema, (Function1<? super CHouseIntroQueries.ColumnInfo, Unit>)((Function1)arg_0 -> CHouseSchemaRetriever.retrieveColumns$lambda$24$lambda$23$lambda$22(tableName, pos, schema, cHouseIntrospector, this, arg_0)));
            }
            catch (DBException e$iv$iv) {
                StringBuilder stringBuilder;
                void this_$iv$iv;
                boolean expected$iv$iv = BaseNativeIntrospector.access$ignoreThisDbException((BaseNativeIntrospector)this_$iv$iv, e$iv$iv);
                StringBuilder $this$continueOnDbError_u24lambda_u2416$iv$iv = stringBuilder = new StringBuilder();
                boolean bl7 = false;
                $this$continueOnDbError_u24lambda_u2416$iv$iv.append(expected$iv$iv ? "Expected" : "Unexpected");
                $this$continueOnDbError_u24lambda_u2416$iv$iv.append(" DB error ").append(e$iv$iv.vendorErrorCode).append(" encountered (and ignored)");
                $this$continueOnDbError_u24lambda_u2416$iv$iv.append(". Exception message: ").append(e$iv$iv.getMessage());
                String message$iv$iv = stringBuilder.toString();
                if (expected$iv$iv) {
                    this_$iv$iv.trace(message$iv$iv);
                } else {
                    IntrospectionQueryContext.logWarn$default((IntrospectionQueryContext)this_$iv$iv, message$iv$iv, null, 2, null);
                }
                this_$iv$iv.getErrorSink().accept(null, e$iv$iv);
            }
            it = CHouseSchemaRetriever$retrieveColumns$$inlined$modifyFamiliesAndCleanup$2.INSTANCE;
            $i$a$-modifyFamiliesAndCleanup-CHouseIntrospector$CHouseSchemaRetriever$retrieveColumns$1 = false;
            ModNamingFamily<? extends CHouseTable> modNamingFamily4 = schema.getTables();
            Intrinsics.checkNotNullExpressionValue(modNamingFamily4, (String)"getTables(...)");
            $this$forEach$iv = modNamingFamily4;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                CHouseTable t = (CHouseTable)element$iv;
                boolean bl8 = false;
                PositioningNamingFamily positioningNamingFamily = t.getColumns();
                Intrinsics.checkNotNullExpressionValue((Object)positioningNamingFamily, (String)"getColumns(...)");
                it.invoke((Object)positioningNamingFamily);
            }
            ModNamingFamily<? extends CHouseView> modNamingFamily5 = schema.getViews();
            Intrinsics.checkNotNullExpressionValue(modNamingFamily5, (String)"getViews(...)");
            $this$forEach$iv = modNamingFamily5;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                CHouseView v2 = (CHouseView)element$iv;
                boolean bl9 = false;
                PositioningNamingFamily positioningNamingFamily = v2.getColumns();
                Intrinsics.checkNotNullExpressionValue((Object)positioningNamingFamily, (String)"getColumns(...)");
                it.invoke((Object)positioningNamingFamily);
            }
            ModNamingFamily<? extends CHouseMatView> modNamingFamily6 = schema.getMatViews();
            Intrinsics.checkNotNullExpressionValue(modNamingFamily6, (String)"getMatViews(...)");
            $this$forEach$iv = modNamingFamily6;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                CHouseMatView v3 = (CHouseMatView)element$iv;
                boolean bl10 = false;
                PositioningNamingFamily positioningNamingFamily = v3.getColumns();
                Intrinsics.checkNotNullExpressionValue((Object)positioningNamingFamily, (String)"getColumns(...)");
                it.invoke((Object)positioningNamingFamily);
            }
        }

        private final ColumnKind getColumnKind(String extra) {
            if (extra == null) {
                return ColumnKind.NORMAL;
            }
            if (StringsKt.contains$default((CharSequence)extra, (CharSequence)"ALIAS", (boolean)false, (int)2, null)) {
                return ColumnKind.GENERATED_VIRTUAL;
            }
            if (StringsKt.contains$default((CharSequence)extra, (CharSequence)"MATERIALIZED", (boolean)false, (int)2, null)) {
                return ColumnKind.GENERATED_STORED;
            }
            return ColumnKind.NORMAL;
        }

        private final String retrieveTableSource(CHouseLikeTable table) {
            try {
                return CHouseIntroQueries.INSTANCE.retrieveTableSource(this.getTransaction(), table);
            }
            catch (DBException e) {
                CHouseIntrospector.this.getErrorSink().accept(e.getMessage(), e);
                return null;
            }
        }

        private final SqlCreateStatement getCreate(String src) {
            Object object;
            BaseNativeIntrospector this_$iv = CHouseIntrospector.this;
            boolean $i$f$parseStatement = false;
            try {
                IntrospectorSqlHelper this_$iv$iv = BaseNativeIntrospector.access$getSqlHelper(this_$iv);
                boolean $i$f$statements = false;
                object = this_$iv$iv.statements(src, SqlCreateStatement.class).first();
            }
            catch (ProcessCanceledException pce$iv) {
                throw pce$iv;
            }
            catch (Exception e$iv) {
                if (ApplicationManager.getApplication().isUnitTestMode()) {
                    this_$iv.log.error((Throwable)e$iv);
                }
                this_$iv.log.warn("Failed to parse sources", (Throwable)e$iv);
                object = null;
            }
            SqlCreateStatement createStatement = (SqlCreateStatement)object;
            if (createStatement == null) {
                this.log.warn("No create found in\n" + src);
                return null;
            }
            return createStatement;
        }

        private final void retrieveViewSources(CHouseSchema schema) {
            CHouseIntrospector.this.reportRetrieving("view sources", "introspection.retrieve.view.sources");
            for (CHouseView cHouseView : schema.getViews()) {
                Intrinsics.checkNotNull((Object)cHouseView);
                String string = this.retrieveTableSource(cHouseView);
                cHouseView.setSourceText(string != null ? BaseIntrospectionFunctions.toCompositeText(string, CompositeText.Kind.DECOMPILED_TEXT) : null);
            }
        }

        private final void retrieveMatViewSources(CHouseSchema schema) {
            CHouseIntrospector.this.reportRetrieving("materialized view sources", "introspection.retrieve.matView.sources");
            for (CHouseMatView cHouseMatView : schema.getMatViews()) {
                SqlCreateStatement stmt;
                String src;
                Intrinsics.checkNotNull((Object)cHouseMatView);
                String string = src = this.retrieveTableSource(cHouseMatView);
                cHouseMatView.setSourceText(string != null ? BaseIntrospectionFunctions.toCompositeText(string, CompositeText.Kind.DECOMPILED_TEXT) : null);
                if (src != null) {
                    String it;
                    boolean bl = false;
                    v1 = this.getCreate(it);
                } else {
                    v1 = stmt = null;
                }
                if (stmt == null) {
                    CHouseIntrospector.this.getErrorSink().accept("Failed to parse source of " + cHouseMatView.getName(), null);
                    continue;
                }
                CHouseIntrospector.this.getSqlHelper().getBuilder().build(cHouseMatView, (DasObject)stmt, CHouseIntrospector.this.getSqlHelper().getBuilderContext());
            }
        }

        private final void retrieveTableSources(CHouseSchema schema) {
            ObjectKind objectKind = ObjectKind.TABLE;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"TABLE");
            CHouseIntrospector.this.reportRetrieving(objectKind);
            for (CHouseTable cHouseTable : schema.getTables()) {
                String string = cHouseTable.getEngine();
                boolean bl = string != null ? StringsKt.startsWith$default((String)string, (String)"System", (boolean)false, (int)2, null) : false;
                if (bl) {
                    cHouseTable.setEngineParams(null);
                    continue;
                }
                Intrinsics.checkNotNull((Object)cHouseTable);
                String string2 = this.retrieveTableSource(cHouseTable);
                if (string2 == null) continue;
                String it = string2;
                boolean bl2 = false;
                SqlCreateStatement sqlCreateStatement = this.getCreate(it);
                string2 = sqlCreateStatement;
                if (sqlCreateStatement == null) {
                    continue;
                }
                String stmt = string2;
                CHouseIntrospector.this.getSqlHelper().getBuilder().build(cHouseTable, (DasObject)((Object)stmt), CHouseIntrospector.this.getSqlHelper().getBuilderContext());
            }
        }

        private static final Unit process$lambda$0(CHouseSchemaRetriever this$0, CHouseSchema schema) {
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            this$0.retrieveTables(schema);
            return Unit.INSTANCE;
        }

        private static final Unit process$lambda$1(CHouseSchemaRetriever this$0, CHouseSchema schema) {
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            this$0.retrieveColumns(schema);
            return Unit.INSTANCE;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        private static final Unit process$lambda$3(CHouseIntrospector this$0, CHouseSchemaRetriever this$1, CHouseSchema schema) {
            void this_$iv$iv;
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            BaseNativeIntrospector this_$iv = this$0;
            boolean $i$f$writeSources = false;
            BaseIntrospector baseIntrospector = this_$iv;
            String name$iv$iv = "WriteSources";
            boolean $i$f$doSection = false;
            CharSequence message$iv$iv$iv = null;
            boolean $i$f$logSectionBegin = false;
            DataSourceDiagnosticRecorder dataSourceDiagnosticRecorder = BaseIntrospector.access$getDiagnosticRecorder((BaseIntrospector)this_$iv$iv);
            DiagnosticSectionReference ref$iv$iv = dataSourceDiagnosticRecorder != null ? dataSourceDiagnosticRecorder.recordSectionBegin(name$iv$iv, message$iv$iv$iv) : null;
            try {
                boolean bl = false;
                this_$iv.getModel().writeSources(new Runnable(this$1, schema){
                    final /* synthetic */ CHouseSchemaRetriever this$0;
                    final /* synthetic */ CHouseSchema $schema$inlined;
                    {
                        this.this$0 = cHouseSchemaRetriever;
                        this.$schema$inlined = cHouseSchema;
                    }

                    public final void run() {
                        boolean bl = false;
                        CHouseSchemaRetriever.access$retrieveViewSources(this.this$0, this.$schema$inlined);
                        CHouseSchemaRetriever.access$retrieveMatViewSources(this.this$0, this.$schema$inlined);
                        CHouseSchemaRetriever.access$retrieveTableSources(this.this$0, this.$schema$inlined);
                    }
                });
            }
            finally {
                void this_$iv$iv$iv = this_$iv$iv;
                boolean $i$f$logSectionEnd = false;
                if (ref$iv$iv != null) {
                    DataSourceDiagnosticRecorder dataSourceDiagnosticRecorder2 = BaseIntrospector.access$getDiagnosticRecorder((BaseIntrospector)this_$iv$iv$iv);
                    if (dataSourceDiagnosticRecorder2 != null) {
                        DataSourceDiagnosticRecorder.recordSectionEnd$default(dataSourceDiagnosticRecorder2, ref$iv$iv, null, 2, null);
                    }
                }
            }
            return Unit.INSTANCE;
        }

        private static final String retrieveTables$lambda$11$lambda$10$lambda$4(CHouseIntroQueries.TableInfo $this$byName) {
            Intrinsics.checkNotNullParameter((Object)$this$byName, (String)"$this$byName");
            return $this$byName.name;
        }

        private static final Unit retrieveTables$lambda$11$lambda$10$lambda$8$lambda$5(CHouseLikeTable $this$orCreate, CHouseIntroQueries.TableInfo it) {
            Intrinsics.checkNotNullParameter((Object)$this$orCreate, (String)"$this$orCreate");
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return Unit.INSTANCE;
        }

        private static final Unit retrieveTables$lambda$11$lambda$10$lambda$8$lambda$6(CHouseLikeTable $this$orCreate, CHouseIntroQueries.TableInfo it) {
            Intrinsics.checkNotNullParameter((Object)$this$orCreate, (String)"$this$orCreate");
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return Unit.INSTANCE;
        }

        private static final ElementSearcherNN retrieveTables$lambda$11$lambda$10$lambda$8$lambda$7(ElementSearcherNN $views, ElementSearcherNN $matViews, ElementSearcherNN $tables, CHouseIntroQueries.TableInfo $this$chooseNN) {
            ElementSearcherNN elementSearcherNN;
            Intrinsics.checkNotNullParameter((Object)$this$chooseNN, (String)"$this$chooseNN");
            String string = $this$chooseNN.engine;
            if (Intrinsics.areEqual((Object)string, (Object)"View")) {
                elementSearcherNN = $views;
            } else if (Intrinsics.areEqual((Object)string, (Object)"MaterializedView")) {
                Intrinsics.checkNotNull((Object)$matViews, (String)"null cannot be cast to non-null type com.intellij.database.model.ElementSearcherNN<com.intellij.database.dialects.clickhouse.model.CHouseLikeTable, com.intellij.database.dialects.clickhouse.introspector.CHouseIntroQueries.TableInfo>");
                elementSearcherNN = $matViews;
            } else {
                elementSearcherNN = $tables;
            }
            return elementSearcherNN;
        }

        private static final Unit retrieveTables$lambda$11$lambda$10$lambda$9(CHouseSchemaRetriever this$0, ElementSearcherNN $tableSearcher, ElementSearcherNN $matViews, CHouseIntroQueries.TableInfo t) {
            Intrinsics.checkNotNullParameter((Object)t, (String)"t");
            if (!this$0.patchMvEngineEntry(t)) {
                CHouseLikeTable o = (CHouseLikeTable)$tableSearcher.find(t);
                o.setName(t.name);
                o.setUuid(t.uuid);
                o.setTemporary(t.is_temporary);
                o.setComment(t.comment);
                if (o instanceof CHouseTable) {
                    ((CHouseTable)o).setEngine(t.engine);
                }
            } else {
                CHouseMatView o = (CHouseMatView)$matViews.find(t);
                o.setEngine(t.engine);
            }
            return Unit.INSTANCE;
        }

        private static final String matViewSearcher$lambda$17$lambda$12(CHouseIntroQueries.TableInfo $this$byName) {
            Intrinsics.checkNotNullParameter((Object)$this$byName, (String)"$this$byName");
            return $this$byName.name;
        }

        private static final String matViewSearcher$lambda$17$lambda$13(CHouseIntroQueries.TableInfo $this$byUuid) {
            Intrinsics.checkNotNullParameter((Object)$this$byUuid, (String)"$this$byUuid");
            return $this$byUuid.uuid;
        }

        private static final ElementSearcher matViewSearcher$lambda$17$lambda$14(FamilySearcher $matViewsByName, FamilySearcher $matViewsByUuid, ElementSearcher $matViewsByNameAndUuid, CHouseIntroQueries.TableInfo $this$choose) {
            Intrinsics.checkNotNullParameter((Object)$this$choose, (String)"$this$choose");
            return ((CharSequence)$this$choose.uuid).length() == 0 ? (ElementSearcher)$matViewsByName : (((CharSequence)$this$choose.name).length() == 0 ? (ElementSearcher)$matViewsByUuid : $matViewsByNameAndUuid);
        }

        private static final Unit matViewSearcher$lambda$17$lambda$16$lambda$15(CHouseMatView $this$create, CHouseIntroQueries.TableInfo d) {
            Intrinsics.checkNotNullParameter((Object)$this$create, (String)"$this$create");
            Intrinsics.checkNotNullParameter((Object)d, (String)"d");
            $this$create.setUuid(d.uuid);
            return Unit.INSTANCE;
        }

        private static final CHouseMatView matViewSearcher$lambda$17$lambda$16(FamilySearcher $matViewsByName, CHouseIntroQueries.TableInfo it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return (CHouseMatView)$matViewsByName.create(it, CHouseSchemaRetriever::matViewSearcher$lambda$17$lambda$16$lambda$15);
        }

        private static final Unit retrieveColumns$lambda$24$lambda$23$lambda$22(Ref.ObjectRef $tableName, Ref.IntRef $pos, CHouseSchema $schema, CHouseIntrospector this$0, CHouseSchemaRetriever this$1, CHouseIntroQueries.ColumnInfo c2) {
            CHouseLikeTable cHouseLikeTable;
            Intrinsics.checkNotNullParameter((Object)c2, (String)"c");
            if (Intrinsics.areEqual((Object)$tableName.element, (Object)c2.table)) {
                ++$pos.element;
                int cfr_ignored_0 = $pos.element;
            } else {
                $tableName.element = c2.table;
                $pos.element = 1;
            }
            CHouseTable cHouseTable = (CHouseTable)$schema.getTables().get((String)$tableName.element);
            if (cHouseTable != null) {
                cHouseLikeTable = cHouseTable;
            } else {
                CHouseView cHouseView = (CHouseView)$schema.getViews().get((String)$tableName.element);
                if (cHouseView != null) {
                    cHouseLikeTable = cHouseView;
                } else {
                    CHouseMatView cHouseMatView = (CHouseMatView)$schema.getMatViews().get((String)$tableName.element);
                    if (cHouseMatView != null) {
                        cHouseLikeTable = cHouseMatView;
                    } else {
                        return Unit.INSTANCE;
                    }
                }
            }
            CHouseLikeTable table = cHouseLikeTable;
            CHouseLikeColumn column2 = (CHouseLikeColumn)table.getColumns().createOrGet(c2.name);
            String nullable = "Nullable(";
            String lowCard = "LowCardinality(";
            boolean colNullable = StringsKt.startsWith$default((String)c2.type, (String)nullable, (boolean)false, (int)2, null);
            if (colNullable) {
                String string = c2.type.substring(nullable.length(), c2.type.length() - 1);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                c2.type = string;
            } else if (StringsKt.startsWith$default((String)c2.type, (String)lowCard, (boolean)false, (int)2, null) && StringsKt.startsWith$default((String)c2.type, (String)nullable, (int)lowCard.length(), (boolean)false, (int)4, null)) {
                colNullable = true;
                String string = c2.type.substring(nullable.length() + lowCard.length(), c2.type.length() - 1);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                c2.type = lowCard + string;
            }
            column2.setPosition((short)$pos.element);
            DasTypeSystemBase dasTypeSystemBase = DasTypeSystems.getTypeSystem(this$0.dbms);
            DataType dataType = DataTypeFactory.of(c2.type);
            Intrinsics.checkNotNullExpressionValue((Object)dataType, (String)"of(...)");
            column2.setStoredType(dasTypeSystemBase.createDasType(dataType));
            column2.setNotNull(!colNullable);
            column2.setComment(c2.comment);
            if (column2 instanceof CHouseTableColumn) {
                String string = c2.default_expression;
                ((CHouseTableColumn)column2).setDefaultExpression(string != null ? StringKt.nullize$default((String)string, (boolean)false, (int)1, null) : null);
                ((CHouseTableColumn)column2).setColumnKind(this$1.getColumnKind(c2.default_kind));
            }
            return Unit.INSTANCE;
        }

        public static final /* synthetic */ void access$retrieveViewSources(CHouseSchemaRetriever $this, CHouseSchema schema) {
            $this.retrieveViewSources(schema);
        }

        public static final /* synthetic */ void access$retrieveMatViewSources(CHouseSchemaRetriever $this, CHouseSchema schema) {
            $this.retrieveMatViewSources(schema);
        }

        public static final /* synthetic */ void access$retrieveTableSources(CHouseSchemaRetriever $this, CHouseSchema schema) {
            $this.retrieveTableSources(schema);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0017B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0012\u0010\u0014\u001a\u00020\u00052\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016\u00a8\u0006\u0018"}, d2={"Lcom/intellij/database/dialects/clickhouse/introspector/CHouseIntrospector$Factory;", "Lcom/intellij/database/introspection/DBIntrospector$Factory;", "<init>", "()V", "isSupported", "", "version", "Lcom/intellij/database/util/Version;", "createIntrospector", "Lcom/intellij/database/introspection/DBIntrospector;", "context", "Lcom/intellij/database/introspection/DBIntrospectionContext;", "dbms", "Lcom/intellij/database/Dbms;", "modelFactory", "Lcom/intellij/database/model/ModelFactory;", "getVersion", "", "kind", "Lcom/intellij/database/model/ObjectKind;", "isOutdatedCheckSupported", "e", "Lcom/intellij/database/model/basic/BasicElement;", "VERSION", "intellij.database.dialects.clickhouse"})
    public static final class Factory
    implements DBIntrospector.Factory {
        @Override
        public boolean isSupported(@NotNull Version version) {
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            return true;
        }

        @Override
        @NotNull
        public DBIntrospector createIntrospector(@NotNull DBIntrospectionContext context, @NotNull Dbms dbms, @NotNull ModelFactory modelFactory) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
            Intrinsics.checkNotNullParameter((Object)modelFactory, (String)"modelFactory");
            return new CHouseIntrospector(context, modelFactory);
        }

        @Override
        public int getVersion(@NotNull ObjectKind kind) {
            Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
            return VERSION.INSTANCE.get(kind);
        }

        @Override
        public boolean isOutdatedCheckSupported(@Nullable BasicElement e) {
            return false;
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/intellij/database/dialects/clickhouse/introspector/CHouseIntrospector$Factory$VERSION;", "Lcom/intellij/database/model/PerObjectVersion;", "<init>", "()V", "intellij.database.dialects.clickhouse"})
        public static final class VERSION
        extends PerObjectVersion {
            @NotNull
            public static final VERSION INSTANCE = new VERSION();

            private VERSION() {
            }
        }
    }
}

