/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.Dbms;
import com.intellij.database.access.DatabaseCredentials;
import com.intellij.database.actions.DatabaseViewActions;
import com.intellij.database.autoconfig.DataSourceConfigUtil;
import com.intellij.database.autoconfig.DataSourceConfiguration;
import com.intellij.database.autoconfig.DataSourceDetector;
import com.intellij.database.autoconfig.DataSourceRegistry;
import com.intellij.database.connectivity.dataSource.AbstractDataSourceManager;
import com.intellij.database.dataSource.DataSourceConfigurable;
import com.intellij.database.dataSource.DataSourceStorage;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.DatabaseDriverImpl;
import com.intellij.database.dataSource.DatabaseDriverManager;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.editor.DatabaseEditorHelper;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.database.util.DbUtil;
import com.intellij.database.vfs.DbStorageFileType;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ex.MainMenuPresentationAware;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.psi.SqlPsiFacade;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import icons.DatabaseIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;

public final class LocalDataSourceManager
extends AbstractDataSourceManager<LocalDataSource> {
    private static final String LRU_KEY = "DatabaseDriversLRU";
    private final DataSourceStorage myProjectStorage;

    @NotNull
    public static LocalDataSourceManager getInstance(@NotNull Project project) {
        if (project == null) {
            LocalDataSourceManager.$$$reportNull$$$0(0);
        }
        LocalDataSourceManager localDataSourceManager = Objects.requireNonNull((LocalDataSourceManager)ContainerUtil.findInstance((Iterable)EP_NAME.getExtensions((AreaInstance)project), LocalDataSourceManager.class));
        if (localDataSourceManager == null) {
            LocalDataSourceManager.$$$reportNull$$$0(1);
        }
        return localDataSourceManager;
    }

    public LocalDataSourceManager(@NotNull Project project) {
        if (project == null) {
            LocalDataSourceManager.$$$reportNull$$$0(2);
        }
        super(project, DataSourceStorage.getProjectStorage(project).getDataSources());
        this.myProjectStorage = DataSourceStorage.getProjectStorage(project);
        project.getMessageBus().connect().subscribe(DataSourceStorage.TOPIC, (Object)new DataSourceStorage.Listener(){

            @Override
            public void dataSourceAdded(@NotNull LocalDataSource dataSource) {
                if (dataSource == null) {
                    1.$$$reportNull$$$0(0);
                }
                LocalDataSourceManager.migrateConsolesIfNeeded(Collections.singletonList(dataSource));
                LocalDataSourceManager.this.attachDataSource(dataSource);
            }

            @Override
            public void dataSourceRemoved(@NotNull LocalDataSource dataSource) {
                if (dataSource == null) {
                    1.$$$reportNull$$$0(1);
                }
                LocalDataSourceManager.this.detachDataSource(dataSource);
            }

            @Override
            public void dataSourceChanged(@Nullable LocalDataSource dataSource) {
                if (dataSource == null) {
                    LocalDataSourceManager.this.resetElementMap(LocalDataSourceManager.this.myProjectStorage.getDataSources());
                } else {
                    LocalDataSourceManager.this.updateDataSource(dataSource);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "dataSource";
                objectArray2[1] = "com/intellij/database/dataSource/LocalDataSourceManager$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "dataSourceAdded";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "dataSourceRemoved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        LocalDataSourceManager.migrateConsolesIfNeeded(this.myProjectStorage.getOwnDataSources());
    }

    private static void migrateConsolesIfNeeded(@NotNull List<LocalDataSource> dataSources) {
        if (dataSources == null) {
            LocalDataSourceManager.$$$reportNull$$$0(3);
        }
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            for (LocalDataSource dataSource : dataSources) {
                DatabaseEditorHelper.migrateConsolesIfNeeded(dataSource);
            }
        }
    }

    @Override
    public boolean isLoading(@NotNull LocalDataSource element) {
        if (element == null) {
            LocalDataSourceManager.$$$reportNull$$$0(4);
        }
        return this.myProjectStorage.isLoading(element);
    }

    @Override
    public void addDataSource(@NotNull LocalDataSource element) {
        if (element == null) {
            LocalDataSourceManager.$$$reportNull$$$0(5);
        }
        this.myProjectStorage.addDataSource(element);
    }

    @Override
    public void removeDataSource(@NotNull LocalDataSource element) {
        if (element == null) {
            LocalDataSourceManager.$$$reportNull$$$0(6);
        }
        this.myProjectStorage.removeDataSource(element);
    }

    @Override
    public void renameDataSource(@NotNull LocalDataSource element, @NotNull String name2) {
        if (element == null) {
            LocalDataSourceManager.$$$reportNull$$$0(7);
        }
        if (name2 == null) {
            LocalDataSourceManager.$$$reportNull$$$0(8);
        }
        element.setName(name2);
        this.myProjectStorage.updateDataSource(element);
    }

    @Override
    protected void saveDataSource(@NotNull LocalDataSource dataSource) {
        if (dataSource == null) {
            LocalDataSourceManager.$$$reportNull$$$0(9);
        }
        this.myProjectStorage.updateDataSource(dataSource);
    }

    @Override
    @NotNull
    public Configurable createDataSourceEditor(@NotNull LocalDataSource element) {
        if (element == null) {
            LocalDataSourceManager.$$$reportNull$$$0(10);
        }
        return new DataSourceConfigurable(this, element, this.myProject);
    }

    @Override
    @NotNull
    public AnAction getCreateDataSourceAction(@NotNull Consumer<? super LocalDataSource> consumer) {
        if (consumer == null) {
            LocalDataSourceManager.$$$reportNull$$$0(11);
        }
        List<AnAction> actions = this.getCreateDataSourceActions(DatabaseDriverManager.getInstance().getDrivers(), consumer);
        NewDataSourceActionGroup group = new NewDataSourceActionGroup(actions);
        group.setPopup(true);
        group.getTemplatePresentation().setIcon(DatabaseIcons.Dbms);
        NewDataSourceActionGroup newDataSourceActionGroup = group;
        if (newDataSourceActionGroup == null) {
            LocalDataSourceManager.$$$reportNull$$$0(12);
        }
        return newDataSourceActionGroup;
    }

    @Override
    @NotNull
    public LocalDataSource createEmpty() {
        return new LocalDataSource();
    }

    @NotNull
    public List<AnAction> getCreateDataSourceActions(@NotNull Collection<? extends DatabaseDriver> allDrivers, @NotNull Consumer<? super LocalDataSource> consumer) {
        if (allDrivers == null) {
            LocalDataSourceManager.$$$reportNull$$$0(13);
        }
        if (consumer == null) {
            LocalDataSourceManager.$$$reportNull$$$0(14);
        }
        Consumer cachingConsumer = driver -> {
            DatabaseViewActions.addToLRUNames(this.myProject, 5, LRU_KEY, this.getDriverKey((DatabaseDriver)driver));
            consumer.consume((Object)driver.createDataSource(null));
        };
        List<String> lruNames = DatabaseViewActions.getLRUNames(this.myProject, LRU_KEY);
        LinkedHashMap<String, DatabaseDriver> fromLru = new LinkedHashMap<String, DatabaseDriver>();
        LinkedHashMap<String, DatabaseDriver> completeSupport = new LinkedHashMap<String, DatabaseDriver>();
        LinkedHashMap<String, DatabaseDriver> userCreated = new LinkedHashMap<String, DatabaseDriver>();
        LinkedHashMap<String, DatabaseDriver> basicSupport = new LinkedHashMap<String, DatabaseDriver>();
        MultiMap allDriversMap = MultiMap.createLinked();
        for (DatabaseDriver databaseDriver : allDrivers) {
            String key2 = this.getDriverKey(databaseDriver);
            allDriversMap.putValue((Object)key2, (Object)databaseDriver);
            if (lruNames.contains(key2)) {
                fromLru.putIfAbsent(key2, databaseDriver);
                if (!databaseDriver.isPredefined() || !LocalDataSourceManager.isGenericSupport(databaseDriver)) continue;
                basicSupport.putIfAbsent(key2, databaseDriver);
                continue;
            }
            if (!databaseDriver.isPredefined()) {
                userCreated.putIfAbsent(key2, databaseDriver);
                continue;
            }
            if (!LocalDataSourceManager.isGenericSupport(databaseDriver)) {
                completeSupport.putIfAbsent(key2, databaseDriver);
                continue;
            }
            basicSupport.putIfAbsent(key2, databaseDriver);
        }
        List topLevel = ContainerUtil.mapNotNull((Collection)allDriversMap.entrySet(), e -> (DatabaseDriver)ContainerUtil.getFirstItem((Collection)((Collection)e.getValue())));
        Function<DatabaseDriver, @NlsActions.ActionText String> function = LocalDataSourceManager.getDisplayDriverNamer(topLevel);
        Function<DatabaseDriver, Collection<? extends DatabaseDriver>> children2 = d -> allDriversMap.get((Object)this.getDriverKey((DatabaseDriver)d));
        Comparator<DatabaseDriver> comparator = Comparator.comparing(function);
        ArrayList<AnAction> result2 = new ArrayList<AnAction>();
        this.addActions(Separator.create((String)DatabaseBundle.message("separator.data.sources.recent", new Object[0])), result2, fromLru.values(), Comparator.comparingInt(o -> lruNames.indexOf(this.getDriverKey((DatabaseDriver)o))).thenComparing(comparator), (Consumer<? super DatabaseDriver>)cachingConsumer, function, children2);
        this.addActions(Separator.create((String)DatabaseBundle.message("separator.user.drivers", new Object[0])), result2, userCreated.values(), comparator, (Consumer<? super DatabaseDriver>)cachingConsumer, function, children2);
        this.addActions(Separator.create((String)DatabaseBundle.message("separator.complete.support", new Object[0])), result2, completeSupport.values(), comparator, (Consumer<? super DatabaseDriver>)cachingConsumer, function, children2);
        if (!basicSupport.isEmpty()) {
            result2.add((AnAction)Separator.getInstance());
            DefaultActionGroup other = new DefaultActionGroup(DatabaseBundle.message("action.data.sources.other.text", new Object[0]), true);
            result2.add((AnAction)other);
            other.addSeparator(DatabaseBundle.message("separator.basic.support", new Object[0]));
            Comparator<DatabaseDriver> bc = Comparator.comparing(d -> LocalDataSourceManager.getExtraSection(d), Comparing::compare).thenComparing(comparator);
            String ps = null;
            for (DatabaseDriver driver3 : ContainerUtil.sorted(basicSupport.values(), bc)) {
                String section = LocalDataSourceManager.getExtraSection(driver3);
                if (!Objects.equals(ps, section)) {
                    other.addSeparator(section);
                    ps = section;
                }
                other.add(this.createAction((Consumer<? super DatabaseDriver>)cachingConsumer, driver3, children2.apply(driver3), function.apply(driver3)));
            }
        }
        ArrayList<AnAction> arrayList = result2;
        if (arrayList == null) {
            LocalDataSourceManager.$$$reportNull$$$0(15);
        }
        return arrayList;
    }

    public static boolean isGenericSupport(DatabaseDriver driver) {
        return DbImplUtil.isGenericSupport(DbImplUtilCore.getDbms(driver)) || LocalDataSourceManager.getExtraSection(driver) != null;
    }

    @NlsSafe
    @Nullable
    public static String getExtraSection(DatabaseDriver d) {
        String comment = d.getComment();
        return comment != null && comment.endsWith("drivers.xml") ? comment : null;
    }

    public void addActions(@Nullable Separator separator, List<? super AnAction> result2, Iterable<? extends DatabaseDriver> drivers, Comparator<? super DatabaseDriver> comparator, @NotNull Consumer<? super DatabaseDriver> consumer, @NotNull Function<DatabaseDriver, @NlsActions.ActionText String> driverNames, @NotNull Function<DatabaseDriver, Collection<? extends DatabaseDriver>> children2) {
        if (consumer == null) {
            LocalDataSourceManager.$$$reportNull$$$0(16);
        }
        if (driverNames == null) {
            LocalDataSourceManager.$$$reportNull$$$0(17);
        }
        if (children2 == null) {
            LocalDataSourceManager.$$$reportNull$$$0(18);
        }
        if (separator != null) {
            result2.add((AnAction)separator);
        }
        for (DatabaseDriver driver : ContainerUtil.sorted(drivers, comparator)) {
            result2.add((AnAction)this.createAction(consumer, driver, children2.apply(driver), driverNames.apply(driver)));
        }
    }

    @NotNull
    private AnAction createAction(final @NotNull Consumer<? super DatabaseDriver> consumer, final @NotNull DatabaseDriver defaultDriver, @NotNull Collection<? extends DatabaseDriver> subDrivers, @NlsActions.ActionText String name2) {
        if (consumer == null) {
            LocalDataSourceManager.$$$reportNull$$$0(19);
        }
        if (defaultDriver == null) {
            LocalDataSourceManager.$$$reportNull$$$0(20);
        }
        if (subDrivers == null) {
            LocalDataSourceManager.$$$reportNull$$$0(21);
        }
        final AnAction[] children2 = ContainerUtil.getOnlyItem(subDrivers) == defaultDriver ? AnAction.EMPTY_ARRAY : ContainerUtil.map(subDrivers, d -> new DumbAwareAction(d.getName(), null, d.getIcon(0), (Consumer)consumer, (DatabaseDriver)d){
            final /* synthetic */ Consumer val$consumer;
            final /* synthetic */ DatabaseDriver val$d;
            {
                this.val$consumer = consumer;
                this.val$d = databaseDriver;
                super(arg0, arg1, arg2);
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                this.val$consumer.consume((Object)this.val$d);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/dataSource/LocalDataSourceManager$2", "actionPerformed"));
            }
        }).toArray(AnAction.EMPTY_ARRAY);
        return new ActionGroup(name2, null, defaultDriver.getIcon(0)){

            public boolean isDumbAware() {
                return true;
            }

            @NotNull
            public ActionUpdateThread getActionUpdateThread() {
                ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
                if (actionUpdateThread == null) {
                    3.$$$reportNull$$$0(0);
                }
                return actionUpdateThread;
            }

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(1);
                }
                super.update(e);
                e.getPresentation().setPerformGroup(true);
                e.getPresentation().setPopupGroup(true);
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(2);
                }
                consumer.consume((Object)defaultDriver);
            }

            public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
                AnAction[] anActionArray = e == null ? AnAction.EMPTY_ARRAY : children2;
                if (anActionArray == null) {
                    3.$$$reportNull$$$0(3);
                }
                return anActionArray;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 2;
                    case 1, 2 -> 3;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/database/dataSource/LocalDataSourceManager$3";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getActionUpdateThread";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/database/dataSource/LocalDataSourceManager$3";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getChildren";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "update";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "actionPerformed";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalStateException(string);
                    case 1, 2 -> new IllegalArgumentException(string);
                };
            }
        };
    }

    public String getDriverKey(DatabaseDriver o) {
        return o.isPredefined() && LocalDataSourceManager.getExtraSection(o) == null ? LocalDataSourceManager.predefinedDriverKey(o) : o.getId();
    }

    private static String predefinedDriverKey(DatabaseDriver o) {
        DatabaseDriverImpl d;
        if (o instanceof DatabaseDriverImpl && (d = (DatabaseDriverImpl)o).getGroupWithId() != null) {
            return d.getGroupWithId();
        }
        String id = o.getId();
        int dotIdx = id.lastIndexOf(".");
        String beforeDot = dotIdx == -1 ? id : id.substring(0, dotIdx);
        return StringUtil.trimEnd((String)beforeDot, (String)"_aurora");
    }

    public static @NotNull Function<DatabaseDriver, @NlsActions.ActionText String> getDisplayDriverNamer(Collection<DatabaseDriver> drivers) {
        MultiMap nameToDriver = MultiMap.create();
        HashMap<DatabaseDriver, @NlsActions.ActionText String> driverToName = new HashMap<DatabaseDriver, String>();
        for (DatabaseDriver driver : drivers) {
            String name2 = LocalDataSourceManager.getDisplayDriverName(driver);
            driverToName.put(driver, name2);
            nameToDriver.putValue((Object)name2, (Object)driver);
        }
        for (Map.Entry entry : nameToDriver.entrySet()) {
            if (((Collection)entry.getValue()).size() < 2) continue;
            for (DatabaseDriver driver : (Collection)entry.getValue()) {
                driverToName.put(driver, driver.getName());
            }
        }
        Function<DatabaseDriver, String> function = d -> driverToName.getOrDefault(d, d.getName());
        if (function == null) {
            LocalDataSourceManager.$$$reportNull$$$0(22);
        }
        return function;
    }

    @NlsActions.ActionText
    @NotNull
    private static String getDisplayDriverName(DatabaseDriver o) {
        Dbms dbms = DbImplUtilCore.getDbms(o);
        if (!o.isPredefined() || LocalDataSourceManager.getExtraSection(o) != null) {
            String string = o.getName();
            if (string == null) {
                LocalDataSourceManager.$$$reportNull$$$0(23);
            }
            return string;
        }
        String string = dbms == Dbms.UNKNOWN ? o.getName() : dbms.getDisplayName();
        if (string == null) {
            LocalDataSourceManager.$$$reportNull$$$0(24);
        }
        return string;
    }

    @Override
    @NotNull
    public LocalDataSource copyDataSource(@NotNull String newName, @NotNull LocalDataSource copyFrom) {
        if (newName == null) {
            LocalDataSourceManager.$$$reportNull$$$0(25);
        }
        if (copyFrom == null) {
            LocalDataSourceManager.$$$reportNull$$$0(26);
        }
        LocalDataSource result2 = copyFrom.copy(false);
        result2.setName(StringUtil.notNullize((String)newName));
        LocalDataSource localDataSource = result2;
        if (localDataSource == null) {
            LocalDataSourceManager.$$$reportNull$$$0(27);
        }
        return localDataSource;
    }

    @Override
    public boolean canCreateDataSourceByFiles(@NotNull Collection<VirtualFile> files2) {
        if (files2 == null) {
            LocalDataSourceManager.$$$reportNull$$$0(28);
        }
        for (VirtualFile file : files2) {
            if (!(file.getFileType() instanceof DbStorageFileType)) continue;
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public List<LocalDataSource> createDataSourceByFiles(@NotNull DatabaseCredentials credentials, @NotNull List<VirtualFile> files2) {
        if (credentials == null) {
            LocalDataSourceManager.$$$reportNull$$$0(29);
        }
        if (files2 == null) {
            LocalDataSourceManager.$$$reportNull$$$0(30);
        }
        final ArrayList<LocalDataSource> result2 = new ArrayList<LocalDataSource>();
        DataSourceRegistry registry = new DataSourceRegistry(this.myProject);
        registry.setImportedFlag(false);
        DataSourceDetector.Callback callback = new DataSourceDetector.Callback(){

            @Override
            public void onCreated(@NotNull DasDataSource dataSource) {
                if (dataSource == null) {
                    4.$$$reportNull$$$0(0);
                }
                result2.add((LocalDataSource)dataSource);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/dataSource/LocalDataSourceManager$4", "onCreated"));
            }
        };
        for (VirtualFile file : files2) {
            FileType fileType = file.getFileType();
            if (!(fileType instanceof DbStorageFileType)) continue;
            Dbms dbms = ((DbStorageFileType)fileType).getDbms();
            String defaultName = DbUtil.generateUniqueDataSourceName(this.myProject, file.getNameWithoutExtension());
            final String path = VfsUtilCore.virtualToIoFile((VirtualFile)file).getAbsolutePath();
            DataSourceConfigUtil.buildDataSource(dbms, defaultName, null, null, new DataSourceConfiguration(){

                @Override
                public String getDatabase() {
                    return path;
                }
            }, registry.getBuilder().withCallback(callback));
        }
        DataSourceConfigUtil.configureDetectedDataSources(this.myProject, registry, true, true, credentials);
        ArrayList<LocalDataSource> arrayList = result2;
        if (arrayList == null) {
            LocalDataSourceManager.$$$reportNull$$$0(31);
        }
        return arrayList;
    }

    @Override
    public boolean isMyDataSource(@NotNull Class<? extends DasDataSource> clazz) {
        if (clazz == null) {
            LocalDataSourceManager.$$$reportNull$$$0(32);
        }
        return LocalDataSource.class.isAssignableFrom(clazz);
    }

    public void fireDataSourceUpdated(@NotNull LocalDataSource dataSource) {
        if (dataSource == null) {
            LocalDataSourceManager.$$$reportNull$$$0(33);
        }
        this.myProjectStorage.updateDataSource(dataSource);
    }

    @Override
    @Nullable
    public DatabaseDialectEx getDatabaseDialect(@NotNull LocalDataSource element) {
        if (element == null) {
            LocalDataSourceManager.$$$reportNull$$$0(34);
        }
        return DbImplUtilCore.guessDatabaseDialect(element);
    }

    @Override
    @Nullable
    public Language getQueryLanguage(@NotNull LocalDataSource element) {
        Language language;
        if (element == null) {
            LocalDataSourceManager.$$$reportNull$$$0(35);
        }
        if ((language = DbSqlUtilCore.findLanguage(element)) instanceof SqlLanguageDialect) {
            SqlLanguageDialect sl = (SqlLanguageDialect)language;
            ApplicationManager.getApplication().executeOnPooledThread(() -> {
                VirtualFile file = DatabaseEditorHelper.getConsoleRootDir(element);
                if (file != null) {
                    SqlPsiFacade.getInstance((Project)this.myProject).getDialectPusherKey().setPersistentValue(file, (Object)sl);
                }
            });
        }
        return language;
    }

    @Override
    @Nullable
    public Language getPushedQueryLanguage(@NotNull LocalDataSource element) {
        VirtualFile file;
        if (element == null) {
            LocalDataSourceManager.$$$reportNull$$$0(36);
        }
        return (file = DatabaseEditorHelper.getConsoleRootDir(element)) == null ? null : (Language)SqlPsiFacade.getInstance((Project)this.myProject).getDialectPusherKey().getPersistentValue(file);
    }

    @Override
    @NotNull
    public Promise<?> getLoadingPromise(@NotNull LocalDataSource source) {
        if (source == null) {
            LocalDataSourceManager.$$$reportNull$$$0(37);
        }
        Promise<?> promise = this.myProjectStorage.getLoadingPromise(source);
        if (promise == null) {
            LocalDataSourceManager.$$$reportNull$$$0(38);
        }
        return promise;
    }

    public String toString() {
        return "%s(project %s and %d data sources)".formatted(LocalDataSourceManager.class.getSimpleName(), this.myProject.getName(), this.myProjectStorage.getCount());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 12, 15, 22, 23, 24, 27, 31, 38 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 12: 
            case 15: 
            case 22: 
            case 23: 
            case 24: 
            case 27: 
            case 31: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/LocalDataSourceManager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSources";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 34: 
            case 35: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 9: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 11: 
            case 14: 
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allDrivers";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "driverNames";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "children";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultDriver";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subDrivers";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "copyFrom";
                break;
            }
            case 28: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "credentials";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/LocalDataSourceManager";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getCreateDataSourceAction";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getCreateDataSourceActions";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayDriverNamer";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayDriverName";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "copyDataSource";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "createDataSourceByFiles";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getLoadingPromise";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: 
            case 12: 
            case 15: 
            case 22: 
            case 23: 
            case 24: 
            case 27: 
            case 31: 
            case 38: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "migrateConsolesIfNeeded";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isLoading";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addDataSource";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "removeDataSource";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "renameDataSource";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "saveDataSource";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createDataSourceEditor";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getCreateDataSourceAction";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getCreateDataSourceActions";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "addActions";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "createAction";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "copyDataSource";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "canCreateDataSourceByFiles";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "createDataSourceByFiles";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "isMyDataSource";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "fireDataSourceUpdated";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getDatabaseDialect";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getQueryLanguage";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getPushedQueryLanguage";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getLoadingPromise";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 12, 15, 22, 23, 24, 27, 31, 38 -> new IllegalStateException(string);
        };
    }

    static class NewDataSourceActionGroup
    extends DefaultActionGroup
    implements MainMenuPresentationAware {
        NewDataSourceActionGroup(List<AnAction> actions) {
            super(DatabaseBundle.messagePointer("default.datasource.name", new Object[0]), actions);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                NewDataSourceActionGroup.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                NewDataSourceActionGroup.$$$reportNull$$$0(1);
            }
            super.update(e);
            if (!DatabaseViewActions.isDataSourceActionsEnabled(e)) {
                e.getPresentation().setEnabledAndVisible(false);
            }
        }

        public boolean isDumbAware() {
            return true;
        }

        public boolean alwaysShowIconInMainMenu() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dataSource/LocalDataSourceManager$NewDataSourceActionGroup";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dataSource/LocalDataSourceManager$NewDataSourceActionGroup";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1 -> new IllegalArgumentException(string);
            };
        }
    }
}

