/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.intellij.database.dataSource.AbstractDataSource;
import com.intellij.database.dataSource.DataSourceStorage;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.RawDataSource;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.psi.DataSourceManager;
import com.intellij.database.view.DataSourceNode;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Service
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\b\u000e\b\u0007\u0018\u0000 92\u00020\u0001:\u00059:;<=B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u000fH\u0002J\b\u0010\u0014\u001a\u00020\u000fH\u0002J\u0010\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u0012H\u0002J\u0018\u0010\u0017\u001a\u00020\u000f2\u000e\u0010\u0018\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0019H\u0002J\b\u0010\u001a\u001a\u00020\u000fH\u0002J\b\u0010\u001b\u001a\u00020\u000fH\u0002J\u0010\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0016\u0010\u001d\u001a\u00020\u000f2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00060\u001fH\u0002J\u0010\u0010 \u001a\u00020\u000f2\u0006\u0010!\u001a\u00020\u0006H\u0002J\u0010\u0010\"\u001a\u00020\u00072\u0006\u0010!\u001a\u00020\u0006H\u0002J\u0010\u0010#\u001a\u00020\u00072\u0006\u0010!\u001a\u00020\u0006H\u0002J\u0010\u0010$\u001a\u00020\u000f2\u0006\u0010!\u001a\u00020\u0006H\u0002J\u0010\u0010%\u001a\u00020\u000f2\u0006\u0010!\u001a\u00020\u0006H\u0002J\u0010\u0010&\u001a\u0004\u0018\u00010\u00062\u0006\u0010'\u001a\u00020\tJ\u0010\u0010&\u001a\u0004\u0018\u00010\u00062\u0006\u0010(\u001a\u00020)J\u0010\u0010*\u001a\u0004\u0018\u00010+2\u0006\u0010'\u001a\u00020\tJ\u0010\u0010*\u001a\u0004\u0018\u00010+2\u0006\u0010(\u001a\u00020)J\u000e\u0010,\u001a\u00020\u00072\u0006\u0010-\u001a\u00020\u0006J\u0010\u0010,\u001a\u0004\u0018\u00010\u00072\u0006\u0010'\u001a\u00020\tJ\u0010\u0010,\u001a\u0004\u0018\u00010\u00072\u0006\u0010(\u001a\u00020)J\u0010\u0010.\u001a\u0004\u0018\u00010\u00072\u0006\u0010-\u001a\u00020\u0006J\u0010\u0010.\u001a\u0004\u0018\u00010\u00072\u0006\u0010'\u001a\u00020\tJ\u000e\u0010/\u001a\b\u0012\u0004\u0012\u00020\u000700H\u0007J\u0014\u00101\u001a\b\u0012\u0004\u0012\u00020\u00070\u001f2\u0006\u0010\u0011\u001a\u00020\u0012J\u0016\u00102\u001a\b\u0012\u0004\u0012\u00020\u00060\u001f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u00103\u001a\u00020\u000f2\u0006\u0010-\u001a\u00020\u0006H\u0002J\u0010\u00104\u001a\u00020\u000f2\u0006\u0010!\u001a\u00020\u0006H\u0002J\u0010\u00105\u001a\u00020\u000f2\u0006\u0010-\u001a\u00020\u0006H\u0002J\b\u00106\u001a\u00020\u000fH\u0016J\u0010\u00107\u001a\u00020\u000f2\u0006\u00108\u001a\u00020\u000bH\u0007R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006>"}, d2={"Lcom/intellij/database/BasicModelRegistry;", "Lcom/intellij/openapi/Disposable;", "<init>", "()V", "dataSourceNodes", "Lcom/github/benmanes/caffeine/cache/Cache;", "Lcom/intellij/database/model/RawDataSource;", "Lcom/intellij/database/view/DataSourceNode;", "models", "Lcom/intellij/database/model/basic/BasicModel;", "disposed", "", "listDataSourcesUsingStorages", "registerInAdvance", "subscribeToAllProjectsDataSourcesNotifications", "", "subscribeToProjectDataSourcesNotifications", "project", "Lcom/intellij/openapi/project/Project;", "collectAllDataSources", "collectAllDataSourcesUsingManagers", "collectDataSourcesUsingManagersForProject", "p", "collectDataSourcesUsingManagersForManager", "manager", "Lcom/intellij/database/psi/DataSourceManager;", "collectAllDataSourcesUsingStorages", "collectAllGlobalDataSourcesUsingStorages", "collectAllProjectDataSourcesUsingStorages", "registerDataSourcesAndModels", "dataSources", "Lkotlin/sequences/Sequence;", "registerDSN", "ds", "ensureDSN", "instantiateNewDSN", "invalidateModelByDataSource", "deregisterDataSource", "getDataSource", "model", "element", "Lcom/intellij/database/model/basic/BasicElement;", "getLocalDataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "getDataSourceNode", "dataSource", "getDataSourceNodeIfExists", "getAllRegisteredDataSourceNodes", "", "listDataSourceNodesForProject", "listDataSourcesForProject", "onDataSourceAdded", "onDataSourceChangeNotified", "onDataSourceRemoved", "dispose", "setRegisterInAdvance", "v", "Companion", "DataSourceListener", "StorageListener", "ManagerListener", "ProjectManagerEventListener", "intellij.database.core.impl"})
@SourceDebugExtension(value={"SMAP\nBasicModelRegistry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BasicModelRegistry.kt\ncom/intellij/database/BasicModelRegistry\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,312:1\n1#2:313\n*E\n"})
public final class BasicModelRegistry
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Cache<RawDataSource, DataSourceNode> dataSourceNodes;
    @NotNull
    private final Cache<BasicModel, RawDataSource> models;
    private boolean disposed;
    private final boolean listDataSourcesUsingStorages;
    private boolean registerInAdvance;
    @NotNull
    private static final String LIST_DATA_SOURCE_WAY_KEY = "database.datasource.registry.using.storages";
    @NotNull
    private static final String REGISTER_DATA_SOURCE_IN_ADVANCE_KEY = "database.datasource.registry.in.advance";

    public BasicModelRegistry() {
        Cache cache2 = Caffeine.newBuilder().weakKeys().weakValues().build();
        Intrinsics.checkNotNullExpressionValue((Object)cache2, (String)"build(...)");
        this.dataSourceNodes = cache2;
        Cache cache3 = Caffeine.newBuilder().weakKeys().weakValues().build();
        Intrinsics.checkNotNullExpressionValue((Object)cache3, (String)"build(...)");
        this.models = cache3;
        this.listDataSourcesUsingStorages = Registry.Companion.is(LIST_DATA_SOURCE_WAY_KEY);
        this.registerInAdvance = Registry.Companion.is(REGISTER_DATA_SOURCE_IN_ADVANCE_KEY);
        MessageBusConnection messageBusConnection = ApplicationManager.getApplication().getMessageBus().connect();
        Topic<AbstractDataSource.Listener> topic = AbstractDataSource.TOPIC;
        Intrinsics.checkNotNullExpressionValue(topic, (String)"TOPIC");
        messageBusConnection.subscribe(topic, (Object)new DataSourceListener());
        Topic<DataSourceStorage.Listener> topic2 = DataSourceStorage.TOPIC;
        Intrinsics.checkNotNullExpressionValue(topic2, (String)"TOPIC");
        messageBusConnection.subscribe(topic2, (Object)new StorageListener(null, true));
        Topic topic3 = ProjectManager.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic3, (String)"TOPIC");
        messageBusConnection.subscribe(topic3, (Object)new ProjectManagerEventListener());
        this.subscribeToAllProjectsDataSourcesNotifications();
        this.collectAllDataSources();
    }

    private final void subscribeToAllProjectsDataSourcesNotifications() {
        for (Project p2 : BasicModelRegistry.Companion.listOpenedProjects()) {
            this.subscribeToProjectDataSourcesNotifications(p2);
        }
    }

    private final void subscribeToProjectDataSourcesNotifications(Project project) {
        ManagerListener managerListener = new ManagerListener(project);
        StorageListener storageListener = new StorageListener(project, false);
        MessageBusConnection messageBusConnection = project.getMessageBus().connect((Disposable)project);
        Topic<DataSourceManager.Listener> topic = DataSourceManager.TOPIC;
        Intrinsics.checkNotNullExpressionValue(topic, (String)"TOPIC");
        messageBusConnection.subscribe(topic, (Object)managerListener);
        Topic<DataSourceStorage.Listener> topic2 = DataSourceStorage.TOPIC;
        Intrinsics.checkNotNullExpressionValue(topic2, (String)"TOPIC");
        messageBusConnection.subscribe(topic2, (Object)storageListener);
    }

    private final void collectAllDataSources() {
        boolean bl = this.listDataSourcesUsingStorages;
        if (!bl) {
            this.collectAllDataSourcesUsingManagers();
        } else if (bl) {
            this.collectAllDataSourcesUsingStorages();
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    private final void collectAllDataSourcesUsingManagers() {
        for (Project p2 : BasicModelRegistry.Companion.listOpenedProjects()) {
            this.collectDataSourcesUsingManagersForProject(p2);
        }
    }

    private final void collectDataSourcesUsingManagersForProject(Project p2) {
        List<DataSourceManager<?>> list = DataSourceManager.getManagers(p2);
        Intrinsics.checkNotNullExpressionValue(list, (String)"getManagers(...)");
        Collection managers = list;
        for (DataSourceManager manager : managers) {
            this.collectDataSourcesUsingManagersForManager(manager);
        }
    }

    private final void collectDataSourcesUsingManagersForManager(DataSourceManager<? extends RawDataSource> manager) {
        List<? extends RawDataSource> list = manager.getDataSources();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getDataSources(...)");
        Collection dataSources = list;
        for (RawDataSource ds : dataSources) {
            this.registerDSN(ds);
        }
    }

    private final void collectAllDataSourcesUsingStorages() {
        this.collectAllGlobalDataSourcesUsingStorages();
        for (Project p2 : BasicModelRegistry.Companion.listOpenedProjects()) {
            this.collectAllProjectDataSourcesUsingStorages(p2);
        }
    }

    private final void collectAllGlobalDataSourcesUsingStorages() {
        List<LocalDataSource> list = DataSourceStorage.getStorage().getDataSources();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getDataSources(...)");
        List<LocalDataSource> globalDataSources = list;
        this.registerDataSourcesAndModels((Sequence<? extends RawDataSource>)CollectionsKt.asSequence((Iterable)globalDataSources));
    }

    private final void collectAllProjectDataSourcesUsingStorages(Project project) {
        List<LocalDataSource> list = DataSourceStorage.getProjectStorage(project).getDataSources();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getDataSources(...)");
        Sequence projectDataSources = SequencesKt.filterNot((Sequence)CollectionsKt.asSequence((Iterable)list), BasicModelRegistry::collectAllProjectDataSourcesUsingStorages$lambda$0);
        this.registerDataSourcesAndModels((Sequence<? extends RawDataSource>)projectDataSources);
    }

    private final void registerDataSourcesAndModels(Sequence<? extends RawDataSource> dataSources) {
        for (RawDataSource ds : dataSources) {
            this.registerDSN(ds);
        }
    }

    private final void registerDSN(RawDataSource ds) {
        this.ensureDSN(ds);
    }

    private final DataSourceNode ensureDSN(RawDataSource ds) {
        Object object = this.dataSourceNodes.get((Object)ds, arg_0 -> BasicModelRegistry.ensureDSN$lambda$2(arg_0 -> BasicModelRegistry.ensureDSN$lambda$1(this, ds, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (DataSourceNode)object;
    }

    private final DataSourceNode instantiateNewDSN(RawDataSource ds) {
        BasicModel m;
        DataSourceNode dsn = new DataSourceNode(ds);
        DasModel dasModel = ds.getModel();
        BasicModel basicModel = m = dasModel instanceof BasicModel ? (BasicModel)dasModel : null;
        if (m != null) {
            this.models.put((Object)m, (Object)ds);
        }
        return dsn;
    }

    private final void invalidateModelByDataSource(RawDataSource ds) {
        Sequence ms = SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)this.models.asMap().entrySet()), arg_0 -> BasicModelRegistry.invalidateModelByDataSource$lambda$3(ds, arg_0)), BasicModelRegistry::invalidateModelByDataSource$lambda$4);
        for (BasicModel m : ms) {
            this.models.invalidate((Object)m);
        }
    }

    private final void deregisterDataSource(RawDataSource ds) {
        BasicModel m;
        DasModel dasModel = ds.getModel();
        BasicModel basicModel = m = dasModel instanceof BasicModel ? (BasicModel)dasModel : null;
        if (m != null) {
            this.models.invalidate((Object)m);
        }
    }

    @Nullable
    public final RawDataSource getDataSource(@NotNull BasicModel model) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        return (RawDataSource)this.models.getIfPresent((Object)model);
    }

    @Nullable
    public final RawDataSource getDataSource(@NotNull BasicElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        BasicModel basicModel = element.getModel();
        if (basicModel == null) {
            return null;
        }
        BasicModel model = basicModel;
        return this.getDataSource(model);
    }

    @Nullable
    public final LocalDataSource getLocalDataSource(@NotNull BasicModel model) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        RawDataSource rawDataSource = this.getDataSource(model);
        return rawDataSource instanceof LocalDataSource ? (LocalDataSource)rawDataSource : null;
    }

    @Nullable
    public final LocalDataSource getLocalDataSource(@NotNull BasicElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        RawDataSource rawDataSource = this.getDataSource(element);
        return rawDataSource instanceof LocalDataSource ? (LocalDataSource)rawDataSource : null;
    }

    @NotNull
    public final DataSourceNode getDataSourceNode(@NotNull RawDataSource dataSource) {
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        return this.ensureDSN(dataSource);
    }

    @Nullable
    public final DataSourceNode getDataSourceNode(@NotNull BasicModel model) {
        DataSourceNode dataSourceNode;
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        RawDataSource rawDataSource = (RawDataSource)this.models.getIfPresent((Object)model);
        if (rawDataSource != null) {
            RawDataSource p0 = rawDataSource;
            boolean bl = false;
            dataSourceNode = this.getDataSourceNode(p0);
        } else {
            dataSourceNode = null;
        }
        return dataSourceNode;
    }

    @Nullable
    public final DataSourceNode getDataSourceNode(@NotNull BasicElement element) {
        DataSourceNode dataSourceNode;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        BasicModel basicModel = element.getModel();
        if (basicModel != null) {
            BasicModel p0 = basicModel;
            boolean bl = false;
            dataSourceNode = this.getDataSourceNode(p0);
        } else {
            dataSourceNode = null;
        }
        return dataSourceNode;
    }

    @Nullable
    public final DataSourceNode getDataSourceNodeIfExists(@NotNull RawDataSource dataSource) {
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        return (DataSourceNode)this.dataSourceNodes.getIfPresent((Object)dataSource);
    }

    @Nullable
    public final DataSourceNode getDataSourceNodeIfExists(@NotNull BasicModel model) {
        DataSourceNode dataSourceNode;
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        RawDataSource rawDataSource = (RawDataSource)this.models.getIfPresent((Object)model);
        if (rawDataSource != null) {
            RawDataSource p0 = rawDataSource;
            boolean bl = false;
            dataSourceNode = this.getDataSourceNodeIfExists(p0);
        } else {
            dataSourceNode = null;
        }
        return dataSourceNode;
    }

    @TestOnly
    @NotNull
    public final Collection<DataSourceNode> getAllRegisteredDataSourceNodes() {
        return CollectionsKt.toList((Iterable)this.dataSourceNodes.asMap().values());
    }

    @NotNull
    public final Sequence<DataSourceNode> listDataSourceNodesForProject(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return SequencesKt.map(this.listDataSourcesForProject(project), arg_0 -> BasicModelRegistry.listDataSourceNodesForProject$lambda$7(this, arg_0));
    }

    private final Sequence<RawDataSource> listDataSourcesForProject(Project project) {
        List<DataSourceManager<?>> list = DataSourceManager.getManagers(project);
        Intrinsics.checkNotNullExpressionValue(list, (String)"getManagers(...)");
        List<DataSourceManager<?>> dsManagers = list;
        return SequencesKt.flatMapIterable((Sequence)CollectionsKt.asSequence((Iterable)dsManagers), BasicModelRegistry::listDataSourcesForProject$lambda$8);
    }

    private final void onDataSourceAdded(RawDataSource dataSource) {
        this.registerDSN(dataSource);
    }

    private final void onDataSourceChangeNotified(RawDataSource ds) {
        BasicModel m;
        DataSourceNode dsn = (DataSourceNode)this.dataSourceNodes.getIfPresent((Object)ds);
        DasModel dasModel = ds.getModel();
        BasicModel basicModel = m = dasModel instanceof BasicModel ? (BasicModel)dasModel : null;
        if (!(dsn != null || m != null && this.registerInAdvance)) {
            return;
        }
        if (m != null) {
            this.ensureDSN(ds);
            this.models.put((Object)m, (Object)ds);
        } else {
            this.invalidateModelByDataSource(ds);
        }
    }

    private final void onDataSourceRemoved(RawDataSource dataSource) {
        this.deregisterDataSource(dataSource);
    }

    public void dispose() {
        this.registerInAdvance = false;
        this.disposed = true;
        this.models.invalidateAll();
        this.dataSourceNodes.invalidateAll();
    }

    @TestOnly
    @ApiStatus.Internal
    public final void setRegisterInAdvance(boolean v) {
        this.registerInAdvance = v;
    }

    private static final boolean collectAllProjectDataSourcesUsingStorages$lambda$0(LocalDataSource it) {
        return it.isGlobal();
    }

    private static final DataSourceNode ensureDSN$lambda$1(BasicModelRegistry this$0, RawDataSource $ds, RawDataSource it) {
        return this$0.instantiateNewDSN($ds);
    }

    private static final DataSourceNode ensureDSN$lambda$2(Function1 $tmp0, Object p0) {
        return (DataSourceNode)$tmp0.invoke(p0);
    }

    private static final boolean invalidateModelByDataSource$lambda$3(RawDataSource $ds, Map.Entry entry) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"<destruct>");
        RawDataSource d = (RawDataSource)entry.getValue();
        return d == $ds;
    }

    private static final BasicModel invalidateModelByDataSource$lambda$4(Map.Entry entry) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"<destruct>");
        BasicModel m = (BasicModel)entry.getKey();
        return m;
    }

    private static final DataSourceNode listDataSourceNodesForProject$lambda$7(BasicModelRegistry this$0, RawDataSource ds) {
        Intrinsics.checkNotNullParameter((Object)ds, (String)"ds");
        return this$0.ensureDSN(ds);
    }

    private static final Iterable listDataSourcesForProject$lambda$8(DataSourceManager it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        List list = it.getDataSources();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getDataSources(...)");
        return list;
    }

    @JvmStatic
    @NotNull
    public static final BasicModelRegistry instance() {
        return Companion.instance();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0007J\u0015\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\nH\u0002\u00a2\u0006\u0002\u0010\fR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/database/BasicModelRegistry$Companion;", "", "<init>", "()V", "instance", "Lcom/intellij/database/BasicModelRegistry;", "LIST_DATA_SOURCE_WAY_KEY", "", "REGISTER_DATA_SOURCE_IN_ADVANCE_KEY", "listOpenedProjects", "", "Lcom/intellij/openapi/project/Project;", "()[Lcom/intellij/openapi/project/Project;", "intellij.database.core.impl"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final BasicModelRegistry instance() {
            Object object = ApplicationManager.getApplication().getService(BasicModelRegistry.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
            return (BasicModelRegistry)object;
        }

        private final Project[] listOpenedProjects() {
            Project[] projectArray = ProjectManager.getInstance().getOpenProjects();
            Intrinsics.checkNotNullExpressionValue((Object)projectArray, (String)"getOpenProjects(...)");
            return projectArray;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\tH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/database/BasicModelRegistry$DataSourceListener;", "Lcom/intellij/database/dataSource/AbstractDataSource$Listener;", "<init>", "(Lcom/intellij/database/BasicModelRegistry;)V", "onModelReplaced", "", "dataSource", "Lcom/intellij/database/model/RawDataSource;", "oldModel", "Lcom/intellij/database/model/basic/BasicModel;", "newModel", "intellij.database.core.impl"})
    private final class DataSourceListener
    implements AbstractDataSource.Listener {
        @Override
        public void onModelReplaced(@NotNull RawDataSource dataSource, @Nullable BasicModel oldModel, @Nullable BasicModel newModel) {
            Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
            if (BasicModelRegistry.this.disposed) {
                return;
            }
            if (oldModel != null) {
                BasicModelRegistry.this.models.invalidate((Object)oldModel);
            }
            if (newModel != null) {
                DataSourceNode dsn = BasicModelRegistry.this.getDataSourceNodeIfExists(dataSource);
                if (dsn == null && BasicModelRegistry.this.registerInAdvance) {
                    dsn = BasicModelRegistry.this.ensureDSN(dataSource);
                }
                if (dsn != null) {
                    BasicModelRegistry.this.models.put((Object)newModel, (Object)dataSource);
                }
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\b\u001a\u00020\t\"\b\b\u0000\u0010\n*\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\n0\r2\u0006\u0010\u000e\u001a\u0002H\nH\u0016\u00a2\u0006\u0002\u0010\u000fJ1\u0010\u0010\u001a\u00020\t\"\b\b\u0000\u0010\n*\u00020\u000b2\u000e\u0010\f\u001a\n\u0012\u0004\u0012\u0002H\n\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u0001H\nH\u0016\u00a2\u0006\u0002\u0010\u000fJ-\u0010\u0011\u001a\u00020\t\"\b\b\u0000\u0010\n*\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\n0\r2\u0006\u0010\u000e\u001a\u0002H\nH\u0016\u00a2\u0006\u0002\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/intellij/database/BasicModelRegistry$ManagerListener;", "Lcom/intellij/database/psi/DataSourceManager$Listener;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/database/BasicModelRegistry;Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "dataSourceAdded", "", "T", "Lcom/intellij/database/model/RawDataSource;", "manager", "Lcom/intellij/database/psi/DataSourceManager;", "dataSource", "(Lcom/intellij/database/psi/DataSourceManager;Lcom/intellij/database/model/RawDataSource;)V", "dataSourceChanged", "dataSourceRemoved", "intellij.database.core.impl"})
    private final class ManagerListener
    implements DataSourceManager.Listener {
        @NotNull
        private final Project project;

        public ManagerListener(Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            this.project = project;
        }

        @NotNull
        public final Project getProject() {
            return this.project;
        }

        @Override
        public <T extends RawDataSource> void dataSourceAdded(@NotNull DataSourceManager<T> manager, @NotNull T dataSource) {
            Intrinsics.checkNotNullParameter(manager, (String)"manager");
            Intrinsics.checkNotNullParameter(dataSource, (String)"dataSource");
            if (BasicModelRegistry.this.disposed) {
                return;
            }
            BasicModelRegistry.this.registerDSN(dataSource);
        }

        @Override
        public <T extends RawDataSource> void dataSourceChanged(@Nullable DataSourceManager<T> manager, @Nullable T dataSource) {
            if (BasicModelRegistry.this.disposed) {
                return;
            }
            if (dataSource != null) {
                BasicModelRegistry.this.onDataSourceChangeNotified(dataSource);
            } else if (manager != null) {
                BasicModelRegistry.this.collectDataSourcesUsingManagersForManager(manager);
            } else {
                BasicModelRegistry.this.collectDataSourcesUsingManagersForProject(this.project);
            }
        }

        @Override
        public <T extends RawDataSource> void dataSourceRemoved(@NotNull DataSourceManager<T> manager, @NotNull T dataSource) {
            Intrinsics.checkNotNullParameter(manager, (String)"manager");
            Intrinsics.checkNotNullParameter(dataSource, (String)"dataSource");
            BasicModelRegistry.this.onDataSourceRemoved(dataSource);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/database/BasicModelRegistry$ProjectManagerEventListener;", "Lcom/intellij/openapi/project/ProjectManagerListener;", "<init>", "(Lcom/intellij/database/BasicModelRegistry;)V", "projectOpened", "", "project", "Lcom/intellij/openapi/project/Project;", "projectClosed", "intellij.database.core.impl"})
    private final class ProjectManagerEventListener
    implements ProjectManagerListener {
        public void projectOpened(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            BasicModelRegistry.this.subscribeToProjectDataSourcesNotifications(project);
        }

        public void projectClosed(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0012\u0010\u0010\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J\u0010\u0010\u0011\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0012"}, d2={"Lcom/intellij/database/BasicModelRegistry$StorageListener;", "Lcom/intellij/database/dataSource/DataSourceStorage$Listener;", "project", "Lcom/intellij/openapi/project/Project;", "global", "", "<init>", "(Lcom/intellij/database/BasicModelRegistry;Lcom/intellij/openapi/project/Project;Z)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getGlobal", "()Z", "dataSourceAdded", "", "dataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "dataSourceChanged", "dataSourceRemoved", "intellij.database.core.impl"})
    private final class StorageListener
    implements DataSourceStorage.Listener {
        @Nullable
        private final Project project;
        private final boolean global;

        public StorageListener(Project project, boolean global) {
            this.project = project;
            this.global = global;
        }

        @Nullable
        public final Project getProject() {
            return this.project;
        }

        public final boolean getGlobal() {
            return this.global;
        }

        @Override
        public void dataSourceAdded(@NotNull LocalDataSource dataSource) {
            Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
            if (BasicModelRegistry.this.disposed) {
                return;
            }
            BasicModelRegistry.this.onDataSourceAdded(dataSource);
        }

        @Override
        public void dataSourceChanged(@Nullable LocalDataSource dataSource) {
            if (dataSource == null && this.project == null || BasicModelRegistry.this.disposed) {
                return;
            }
            if (BasicModelRegistry.this.disposed) {
                return;
            }
            if (dataSource != null) {
                BasicModelRegistry.this.onDataSourceChangeNotified(dataSource);
            } else if (this.global) {
                BasicModelRegistry.this.collectAllDataSourcesUsingStorages();
            } else if (this.project != null) {
                BasicModelRegistry.this.collectAllProjectDataSourcesUsingStorages(this.project);
            }
        }

        @Override
        public void dataSourceRemoved(@NotNull LocalDataSource dataSource) {
            Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
            BasicModelRegistry.this.onDataSourceRemoved(dataSource);
        }
    }
}

