/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sh.run;

import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationTypeUtil;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.SimpleConfigurationType;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.platform.eel.EelApi;
import com.intellij.platform.eel.EelDescriptor;
import com.intellij.platform.eel.EelExecApi;
import com.intellij.platform.eel.EelPlatform;
import com.intellij.platform.eel.provider.EelProviderUtil;
import com.intellij.platform.eel.provider.LocalEelDescriptor;
import com.intellij.platform.eel.provider.utils.EelPathUtils;
import com.intellij.platform.eel.provider.utils.EelUtilsKt;
import com.intellij.sh.ShBundle;
import com.intellij.sh.ShLanguage;
import com.intellij.sh.run.ShDefaultShellPathProvider;
import com.intellij.sh.run.ShRunConfiguration;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.jetbrains.annotations.NotNull;

public final class ShConfigurationType
extends SimpleConfigurationType {
    ShConfigurationType() {
        super("ShConfigurationType", ShLanguage.INSTANCE.getID(), ShBundle.message("sh.run.configuration.description.0.configuration", ShLanguage.INSTANCE.getID()), NotNullLazyValue.lazy(() -> AllIcons.Nodes.Console));
    }

    @NotNull
    public RunConfiguration createTemplateConfiguration(@NotNull Project project) {
        if (project == null) {
            ShConfigurationType.$$$reportNull$$$0(0);
        }
        ShRunConfiguration configuration = new ShRunConfiguration(project, (ConfigurationFactory)this, ShLanguage.INSTANCE.getID());
        String defaultShell = ShConfigurationType.getDefaultShell(project);
        configuration.setInterpreterPath(defaultShell);
        String projectPath = project.getBasePath();
        if (projectPath != null) {
            configuration.setScriptWorkingDirectory(projectPath);
        }
        ShRunConfiguration shRunConfiguration = configuration;
        if (shRunConfiguration == null) {
            ShConfigurationType.$$$reportNull$$$0(1);
        }
        return shRunConfiguration;
    }

    public static ShConfigurationType getInstance() {
        return (ShConfigurationType)ConfigurationTypeUtil.findConfigurationType(ShConfigurationType.class);
    }

    public boolean isEditableInDumbMode() {
        return true;
    }

    @NotNull
    public static String getDefaultShell(@NotNull Project project) {
        LocalEelDescriptor eelDescriptor;
        if (project == null) {
            ShConfigurationType.$$$reportNull$$$0(2);
        }
        ShDefaultShellPathProvider shellPathProvider = (ShDefaultShellPathProvider)project.getService(ShDefaultShellPathProvider.class);
        Object object = eelDescriptor = project.isDefault() ? LocalEelDescriptor.INSTANCE : EelProviderUtil.getEelDescriptor((Project)project);
        if (shellPathProvider != null && eelDescriptor == LocalEelDescriptor.INSTANCE) {
            String string = shellPathProvider.getDefaultShell();
            if (string == null) {
                ShConfigurationType.$$$reportNull$$$0(3);
            }
            return string;
        }
        return ShConfigurationType.trivialDefaultShellDetection((EelDescriptor)eelDescriptor);
    }

    @NotNull
    private static String trivialDefaultShellDetection(@NotNull EelDescriptor eelDescriptor) {
        Path shellPath;
        EelApi eel;
        String shell;
        if (eelDescriptor == null) {
            ShConfigurationType.$$$reportNull$$$0(4);
        }
        if ((shell = (String)EelUtilsKt.fetchLoginShellEnvVariablesBlocking((EelExecApi)(eel = EelProviderUtil.upgradeBlocking((EelDescriptor)eelDescriptor)).getExec()).get("SHELL")) != null && Files.isExecutable(shellPath = EelPathUtils.getNioPath((String)shell, (EelDescriptor)eelDescriptor))) {
            String string = shellPath.toString();
            if (string == null) {
                ShConfigurationType.$$$reportNull$$$0(5);
            }
            return string;
        }
        if (eel.getPlatform() instanceof EelPlatform.Linux) {
            Path bashPath = EelPathUtils.getNioPath((String)"/bin/bash", (EelDescriptor)eelDescriptor);
            if (Files.exists(bashPath, new LinkOption[0])) {
                String string = bashPath.toString();
                if (string == null) {
                    ShConfigurationType.$$$reportNull$$$0(6);
                }
                return string;
            }
            String string = EelPathUtils.getNioPath((String)"/bin/sh", (EelDescriptor)eelDescriptor).toString();
            if (string == null) {
                ShConfigurationType.$$$reportNull$$$0(7);
            }
            return string;
        }
        return "powershell.exe";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3, 5, 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sh/run/ShConfigurationType";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "eelDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sh/run/ShConfigurationType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createTemplateConfiguration";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultShell";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "trivialDefaultShellDetection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createTemplateConfiguration";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultShell";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "trivialDefaultShellDetection";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3, 5, 6, 7 -> new IllegalStateException(string);
        };
    }
}

