/*
 * Decompiled with CFR 0.152.
 */
package ru.adelf.idea.dotenv.psi;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import ru.adelf.idea.dotenv.psi.DotEnvElementFactory;
import ru.adelf.idea.dotenv.psi.DotEnvProperty;
import ru.adelf.idea.dotenv.psi.DotEnvTypes;

public final class DotEnvPsiUtil {
    private static final TokenSet VALUE_TOKEN_SET = TokenSet.create((IElementType[])new IElementType[]{DotEnvTypes.VALUE_CHARS, DotEnvTypes.NESTED_VARIABLE_KEY, DotEnvTypes.NESTED_VARIABLE_START, DotEnvTypes.NESTED_VARIABLE_END});

    public static String getKeyText(DotEnvProperty element) {
        return element.getKey().getText().replaceAll("\\\\ ", " ");
    }

    public static String getValueText(DotEnvProperty element) {
        ASTNode valueNode = element.getNode().findChildByType(DotEnvTypes.VALUE);
        if (valueNode != null) {
            return Arrays.stream(valueNode.getChildren(VALUE_TOKEN_SET)).map(ASTNode::getText).collect(Collectors.joining(""));
        }
        return "";
    }

    public static String getName(DotEnvProperty element) {
        return DotEnvPsiUtil.getKeyText(element);
    }

    public static PsiElement setName(DotEnvProperty element, @NotNull String newName) {
        ASTNode keyNode;
        if (newName == null) {
            DotEnvPsiUtil.$$$reportNull$$$0(0);
        }
        if ((keyNode = element.getNode().findChildByType(DotEnvTypes.KEY)) != null) {
            DotEnvProperty property = DotEnvElementFactory.createProperty(element.getProject(), newName);
            ASTNode newKeyNode = property.getFirstChild().getNode();
            element.getNode().replaceChild(keyNode, newKeyNode);
        }
        return element;
    }

    public static PsiElement getNameIdentifier(DotEnvProperty element) {
        return element.getKey();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newName", "ru/adelf/idea/dotenv/psi/DotEnvPsiUtil", "setName"));
    }
}

