/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.remoteInterpreter;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.util.Pair;
import com.intellij.python.remoteInterpreter.PySshInterpreterUtil;
import com.intellij.python.remoteInterpreter.PythonRemoteInterpreterBundle;
import com.intellij.remote.RemoteSdkException;
import com.intellij.remote.RemoteSdkProperties;
import com.intellij.ssh.ConnectionBuilder;
import com.intellij.ssh.SshException;
import com.intellij.ssh.SshSession;
import com.jetbrains.python.remote.PyRemoteSocketToLocalHostProvider;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PyRemoteSocketToLocalHostProviderFactory {
    private PyRemoteSocketToLocalHostProviderFactory() {
    }

    @NotNull
    public static PyRemoteSocketToLocalHostProvider ssh(@NotNull ConnectionBuilder connectionBuilder, @NotNull RemoteSdkProperties sdkProperties) throws RemoteSdkException {
        if (connectionBuilder == null) {
            PyRemoteSocketToLocalHostProviderFactory.$$$reportNull$$$0(0);
        }
        if (sdkProperties == null) {
            PyRemoteSocketToLocalHostProviderFactory.$$$reportNull$$$0(1);
        }
        return new MyPyRemoteSocketToLocalHostProvider(connectionBuilder, sdkProperties);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "connectionBuilder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "sdkProperties";
                break;
            }
        }
        objectArray[1] = "com/intellij/python/remoteInterpreter/PyRemoteSocketToLocalHostProviderFactory";
        objectArray[2] = "ssh";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MyPyRemoteSocketToLocalHostProvider
    implements PyRemoteSocketToLocalHostProvider {
        private static final Logger LOG = Logger.getInstance(MyPyRemoteSocketToLocalHostProvider.class);
        private final ConnectionBuilder myConnectionBuilder;
        private final RemoteSdkProperties mySdkProperties;
        private final Set<Integer> myAllocatedPorts = ConcurrentCollectionFactory.createConcurrentSet();
        @Nullable
        private volatile SshSession mySession;
        private volatile boolean isClosed = false;

        private MyPyRemoteSocketToLocalHostProvider(ConnectionBuilder builder, RemoteSdkProperties sdkProperties) {
            this.myConnectionBuilder = builder;
            this.mySdkProperties = sdkProperties;
        }

        @NotNull
        public Pair<String, Integer> getRemoteSocket(final int localPort) throws RemoteSdkException {
            String dialogTitle = PythonRemoteInterpreterBundle.message("ssh.connection.connecting.to.ssh.server", this.myConnectionBuilder.getUserHostPort());
            Pair pair = (Pair)ProgressManager.getInstance().run((Task.WithResult)new Task.WithResult<Pair<String, Integer>, RemoteSdkException>(null, dialogTitle, true){

                protected Pair<String, Integer> compute(@NotNull ProgressIndicator indicator) throws RemoteSdkException {
                    if (indicator == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return this.getRemoteSocketImpl(localPort);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/python/remoteInterpreter/PyRemoteSocketToLocalHostProviderFactory$MyPyRemoteSocketToLocalHostProvider$1", "compute"));
                }
            });
            if (pair == null) {
                MyPyRemoteSocketToLocalHostProvider.$$$reportNull$$$0(0);
            }
            return pair;
        }

        private Pair<String, Integer> getRemoteSocketImpl(int localPort) throws RemoteSdkException {
            Pair<String, Integer> remoteSocket = PySshInterpreterUtil.obtainRemoteSocket(this.myConnectionBuilder, this.mySdkProperties.getInterpreterPath());
            SshSession session = this.mySession;
            if (session == null) {
                this.mySession = session = this.myConnectionBuilder.connect();
            }
            if (!this.isClosed) {
                session.addRemoteTunnel(((Integer)remoteSocket.getSecond()).intValue(), "localhost", localPort);
                this.myAllocatedPorts.add((Integer)remoteSocket.getSecond());
            }
            return remoteSocket;
        }

        public void close() {
            this.isClosed = true;
            SshSession session = this.mySession;
            if (session != null) {
                for (int port : this.myAllocatedPorts) {
                    try {
                        session.removeRemoteTunnel(port);
                    }
                    catch (SshException err) {
                        LOG.info("Failed to close a remote tunnel for port " + port + " in " + String.valueOf(session) + ": " + String.valueOf((Object)err));
                    }
                    catch (Throwable err) {
                        LOG.warn("Failed to close a remote tunnel for port " + port + " in " + String.valueOf(session), err);
                    }
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/python/remoteInterpreter/PyRemoteSocketToLocalHostProviderFactory$MyPyRemoteSocketToLocalHostProvider", "getRemoteSocket"));
        }
    }
}

