/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.profiler;

import com.intellij.python.profiler.CallStatData;
import com.intellij.python.profiler.FuncStat;
import com.intellij.python.profiler.FunctionStat;
import com.intellij.python.profiler.ProfileStatData;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\b\u0012\u0018\u00002\u00020\u00012\u00020\u0002BO\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u0004\u0012\u0006\u0010\u000f\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0010\u0010\u0011B-\b\u0016\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\f\u001a\u00020\r\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u000f\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0010\u0010\u0014J\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0002J\u000e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00020\u001cH\u0016R\u001e\u0010\u0015\u001a\u0012\u0012\u0004\u0012\u00020\u00020\u0016j\b\u0012\u0004\u0012\u00020\u0002`\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/intellij/python/profiler/FunctionStatData;", "Lcom/intellij/python/profiler/CallStatData;", "Lcom/intellij/python/profiler/FunctionStat;", "fileName", "", "funcName", "lineNumber", "", "callCnt", "totalTimes", "", "ownTimes", "profileStatData", "Lcom/intellij/python/profiler/ProfileStatData;", "threadName", "threadId", "<init>", "(Ljava/lang/String;Ljava/lang/String;IIDDLcom/intellij/python/profiler/ProfileStatData;Ljava/lang/String;Ljava/lang/String;)V", "stats", "Lcom/intellij/python/profiler/FuncStat;", "(Lcom/intellij/python/profiler/FuncStat;Lcom/intellij/python/profiler/ProfileStatData;Ljava/lang/String;Ljava/lang/String;)V", "callersList", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "addCaller", "", "func", "getCallers", "", "intellij.python.profiler"})
class FunctionStatData
extends CallStatData
implements FunctionStat {
    @NotNull
    private final ArrayList<FunctionStat> callersList;

    public FunctionStatData(@NotNull String fileName, @NotNull String funcName, int lineNumber, int callCnt, double totalTimes, double ownTimes, @NotNull ProfileStatData profileStatData, @NotNull String threadName, @NotNull String threadId) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)funcName, (String)"funcName");
        Intrinsics.checkNotNullParameter((Object)profileStatData, (String)"profileStatData");
        Intrinsics.checkNotNullParameter((Object)threadName, (String)"threadName");
        Intrinsics.checkNotNullParameter((Object)threadId, (String)"threadId");
        super(fileName, funcName, lineNumber, callCnt, totalTimes, ownTimes, profileStatData, threadName, threadId);
        this.callersList = new ArrayList();
    }

    public FunctionStatData(@NotNull FuncStat stats, @NotNull ProfileStatData profileStatData, @NotNull String threadName, @NotNull String threadId) {
        String string;
        Intrinsics.checkNotNullParameter((Object)stats, (String)"stats");
        Intrinsics.checkNotNullParameter((Object)profileStatData, (String)"profileStatData");
        Intrinsics.checkNotNullParameter((Object)threadName, (String)"threadName");
        Intrinsics.checkNotNullParameter((Object)threadId, (String)"threadId");
        String string2 = stats.file;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"file");
        String string3 = stats.func_name;
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"func_name");
        int n = stats.line;
        int n2 = stats.calls_count;
        double d = stats.total_time;
        double d2 = stats.own_time;
        String string4 = stats.threadName;
        if (string4 == null) {
            string4 = threadName;
        }
        if ((string = stats.threadId) == null) {
            string = threadId;
        }
        this(string2, string3, n, n2, d, d2, profileStatData, string4, string);
    }

    public /* synthetic */ FunctionStatData(FuncStat funcStat, ProfileStatData profileStatData, String string, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            string = "MainThread";
        }
        if ((n & 8) != 0) {
            string2 = "0";
        }
        this(funcStat, profileStatData, string, string2);
    }

    public final void addCaller(@NotNull FunctionStat func) {
        Intrinsics.checkNotNullParameter((Object)func, (String)"func");
        this.callersList.add(func);
    }

    @Override
    @NotNull
    public List<FunctionStat> getCallers() {
        return new CopyOnWriteArrayList(this.callersList);
    }
}

