/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.puppet.ide.navigation.plugins.facts;

import com.intellij.json.JsonFileType;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonValue;
import com.intellij.lang.puppet.ide.navigation.plugins.facts.PuppetFactDataIndexer;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.util.indexing.FileContent;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

final class JsonFactIndexer
implements PuppetFactDataIndexer {
    JsonFactIndexer() {
    }

    @NotNull
    public Map<String, Integer> map(@NotNull FileContent inputData) {
        PsiFile file;
        if (inputData == null) {
            JsonFactIndexer.$$$reportNull$$$0(0);
        }
        if (!((file = inputData.getPsiFile()) instanceof JsonFile)) {
            Map<String, Integer> map = Collections.emptyMap();
            if (map == null) {
                JsonFactIndexer.$$$reportNull$$$0(1);
            }
            return map;
        }
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        JsonValue topLevelValue = ((JsonFile)file).getTopLevelValue();
        if (!(topLevelValue instanceof JsonObject)) {
            HashMap<String, Integer> hashMap = result;
            if (hashMap == null) {
                JsonFactIndexer.$$$reportNull$$$0(2);
            }
            return hashMap;
        }
        for (JsonProperty property : ((JsonObject)topLevelValue).getPropertyList()) {
            String name = property.getName();
            result.put(name, property.getTextOffset());
        }
        HashMap<String, Integer> hashMap = result;
        if (hashMap == null) {
            JsonFactIndexer.$$$reportNull$$$0(3);
        }
        return hashMap;
    }

    @Override
    public boolean acceptsFile(@NotNull String fileName, @NotNull String parentDirName) {
        if (fileName == null) {
            JsonFactIndexer.$$$reportNull$$$0(4);
        }
        if (parentDirName == null) {
            JsonFactIndexer.$$$reportNull$$$0(5);
        }
        return parentDirName.equals("facts.d") && StringUtil.endsWithIgnoreCase((String)fileName, (String)".json");
    }

    @Override
    @NotNull
    public FileType getSuitableFileType() {
        JsonFileType jsonFileType = JsonFileType.INSTANCE;
        if (jsonFileType == null) {
            JsonFactIndexer.$$$reportNull$$$0(6);
        }
        return jsonFileType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputData";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/puppet/ide/navigation/plugins/facts/JsonFactIndexer";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDirName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/puppet/ide/navigation/plugins/facts/JsonFactIndexer";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "map";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuitableFileType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "map";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "acceptsFile";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 6 -> new IllegalStateException(string);
        };
    }
}

