/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.puppet.editing;

import com.intellij.codeInsight.editorActions.SimpleTokenSetQuoteHandler;
import com.intellij.lang.puppet.PuppetTokenTypes;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;

public class PuppetQuoteHandler
extends SimpleTokenSetQuoteHandler {
    public PuppetQuoteHandler() {
        super(new IElementType[]{PuppetTokenTypes.STRING, PuppetTokenTypes.SINGLE_QUOTED_STRING, PuppetTokenTypes.DOUBLE_QUOTED_STRING});
    }

    public boolean isOpeningQuote(HighlighterIterator iterator, int offset) {
        if (this.isInsideLiteral(iterator)) {
            int start = iterator.getStart();
            return offset == start;
        }
        IElementType tokenType = iterator.getTokenType();
        return tokenType == PuppetTokenTypes.DOUBLE_QUOTED_STRING_START;
    }

    public boolean isClosingQuote(HighlighterIterator iterator, int offset) {
        if (this.isInsideLiteral(iterator)) {
            int start = iterator.getStart();
            int end = iterator.getEnd();
            return end - start >= 1 && offset == end - 1;
        }
        return iterator.getTokenType() == PuppetTokenTypes.DOUBLE_QUOTED_STRING_END;
    }

    public boolean hasNonClosedLiteral(@NotNull Editor editor, @NotNull HighlighterIterator iterator, int offset) {
        Document document;
        int lineEndOffset;
        if (editor == null) {
            PuppetQuoteHandler.$$$reportNull$$$0(0);
        }
        if (iterator == null) {
            PuppetQuoteHandler.$$$reportNull$$$0(1);
        }
        if (offset < (lineEndOffset = (document = editor.getDocument()).getLineEndOffset(document.getLineNumber(offset)))) {
            CharSequence charSequence = document.getCharsSequence();
            char openQuote = charSequence.charAt(offset);
            int nextCharOffset = offset + 1;
            if (nextCharOffset < lineEndOffset && charSequence.charAt(nextCharOffset) == openQuote) {
                return true;
            }
            for (int i = nextCharOffset + 1; i < lineEndOffset; ++i) {
                if (charSequence.charAt(i) != openQuote) continue;
                return false;
            }
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "editor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "iterator";
                break;
            }
        }
        objectArray[1] = "com/intellij/lang/puppet/editing/PuppetQuoteHandler";
        objectArray[2] = "hasNonClosedLiteral";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

