/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.inspections;

import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.YAMLBundle;
import org.jetbrains.yaml.inspections.YAMLAddQuoteQuickFixKt;
import org.jetbrains.yaml.psi.YAMLPsiElement;
import org.jetbrains.yaml.psi.YAMLQuotedText;
import org.jetbrains.yaml.psi.YAMLValue;
import org.jetbrains.yaml.psi.YamlPsiUtilKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\r\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\nH\u0016J\r\u0010\u000b\u001a\u00070\t\u00a2\u0006\u0002\b\nH\u0016J3\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0096\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/yaml/inspections/YAMLAddQuotesToSiblingsQuickFix;", "Lcom/intellij/codeInspection/LocalQuickFixAndIntentionActionOnPsiElement;", "baseElement", "Lorg/jetbrains/yaml/psi/YAMLValue;", "singleQuote", "", "<init>", "(Lorg/jetbrains/yaml/psi/YAMLValue;Z)V", "getText", "", "Lorg/jetbrains/annotations/Nls;", "getFamilyName", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "startElement", "Lcom/intellij/psi/PsiElement;", "endElement", "intellij.yaml.backend"})
@SourceDebugExtension(value={"SMAP\nYAMLIncompatibleTypesInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 YAMLIncompatibleTypesInspection.kt\norg/jetbrains/yaml/inspections/YAMLAddQuotesToSiblingsQuickFix\n+ 2 KtUtils.kt\ncom/intellij/util/KotlinUtils\n*L\n1#1,95:1\n19#2:96\n*S KotlinDebug\n*F\n+ 1 YAMLIncompatibleTypesInspection.kt\norg/jetbrains/yaml/inspections/YAMLAddQuotesToSiblingsQuickFix\n*L\n90#1:96\n*E\n"})
final class YAMLAddQuotesToSiblingsQuickFix
extends LocalQuickFixAndIntentionActionOnPsiElement {
    private final boolean singleQuote;

    public YAMLAddQuotesToSiblingsQuickFix(@NotNull YAMLValue baseElement, boolean singleQuote) {
        Intrinsics.checkNotNullParameter((Object)baseElement, (String)"baseElement");
        super((PsiElement)baseElement);
        this.singleQuote = singleQuote;
    }

    public /* synthetic */ YAMLAddQuotesToSiblingsQuickFix(YAMLValue yAMLValue, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        this(yAMLValue, bl);
    }

    @NotNull
    public String getText() {
        String string = YAMLBundle.message((String)"inspections.incompatible.types.quickfix.wrap.all.quotes.message", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)startElement, (String)"startElement");
        Intrinsics.checkNotNullParameter((Object)endElement, (String)"endElement");
        PsiElement $this$asSafely$iv = startElement;
        boolean $i$f$asSafely = false;
        PsiElement psiElement = $this$asSafely$iv;
        if (!(psiElement instanceof YAMLValue)) {
            psiElement = null;
        }
        YAMLValue yAMLValue = (YAMLValue)psiElement;
        if (yAMLValue == null) {
            return;
        }
        YAMLValue baseElement = yAMLValue;
        for (YAMLPsiElement yamlValue : SequencesKt.filterNot(YamlPsiUtilKt.findStructuralSiblings(baseElement), YAMLAddQuotesToSiblingsQuickFix::invoke$lambda$0)) {
            YAMLAddQuoteQuickFixKt.wrapWithQuotes((PsiElement)yamlValue, this.singleQuote);
        }
    }

    private static final boolean invoke$lambda$0(YAMLPsiElement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it instanceof YAMLQuotedText;
    }
}

