/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.util;

public class InlinedProfileBuilder {
    protected final int stateFieldStart;
    protected final int stateFieldLength;
    protected int stateFieldCursor;

    public InlinedProfileBuilder(int offset, int length2) {
        this.stateFieldStart = offset;
        this.stateFieldCursor = offset;
        this.stateFieldLength = length2;
    }

    protected final void maybeAdvanceStateField(int bits) {
        if (this.stateFieldCursor + bits > this.stateFieldStart + this.stateFieldLength) {
            throw new UnsupportedOperationException("Not enough state bits available");
        }
    }

    private int stateFieldOffsetForBits(int bits) {
        this.maybeAdvanceStateField(bits);
        int offset = this.stateFieldCursor;
        this.stateFieldCursor += bits;
        return offset;
    }

    public final int conditionProfile() {
        return this.stateFieldOffsetForBits(2);
    }

    public final int branchProfile() {
        return this.stateFieldOffsetForBits(1);
    }
}

