/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.control;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedCountingConditionProfile;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.cast.JSToBooleanNode;
import com.oracle.truffle.js.nodes.control.AbstractIfNode;
import com.oracle.truffle.js.nodes.control.GeneratorIfNodeGen;
import com.oracle.truffle.js.nodes.control.GeneratorNode;
import com.oracle.truffle.js.nodes.control.YieldException;

abstract class GeneratorIfNode
extends AbstractIfNode
implements GeneratorNode {
    private final int stateSlot;
    @Node.Child
    protected JavaScriptNode condition;
    @Node.Child
    protected JavaScriptNode thenPart;
    @Node.Child
    protected JavaScriptNode elsePart;

    protected GeneratorIfNode(JavaScriptNode condition, JavaScriptNode thenPart, JavaScriptNode elsePart, int stateSlot) {
        this.stateSlot = stateSlot;
        this.condition = condition;
        this.thenPart = thenPart;
        this.elsePart = elsePart;
    }

    @Specialization
    protected Object doDefault(VirtualFrame frame, @Cached(inline=true) JSToBooleanNode toBooleanNode, @Cached InlinedCountingConditionProfile conditionProfile) {
        int index = this.getStateAsIntAndReset(frame, this.stateSlot);
        if (index == 0 && conditionProfile.profile(this, toBooleanNode.executeBoolean(this, this.condition.execute(frame))) || index == 1) {
            try {
                if (this.thenPart != null) {
                    return this.thenPart.execute(frame);
                }
                return EMPTY;
            }
            catch (YieldException e) {
                this.setStateAsInt(frame, this.stateSlot, 1);
                throw e;
            }
        }
        assert (index == 0 || index == 2);
        try {
            if (this.elsePart != null) {
                return this.elsePart.execute(frame);
            }
            return EMPTY;
        }
        catch (YieldException e) {
            this.setStateAsInt(frame, this.stateSlot, 2);
            throw e;
        }
    }

    @Override
    public JavaScriptNode getCondition() {
        return this.condition;
    }

    @Override
    public JavaScriptNode getThenPart() {
        return this.thenPart;
    }

    @Override
    public JavaScriptNode getElsePart() {
        return this.elsePart;
    }

    @Override
    protected AbstractIfNode copyWith(JavaScriptNode newCondition, JavaScriptNode newThenPart, JavaScriptNode newElsePart) {
        return GeneratorIfNodeGen.create(newCondition, newThenPart, newElsePart, this.stateSlot);
    }
}

