/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.access;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.Tag;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.access.PropertyGetNode;
import com.oracle.truffle.js.nodes.cast.JSToBooleanNode;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.Strings;
import java.util.Set;

public class IteratorCompleteUnaryNode
extends JavaScriptNode {
    @Node.Child
    private PropertyGetNode getDoneNode;
    @Node.Child
    private JavaScriptNode iterResultNode;
    @Node.Child
    private JSToBooleanNode toBooleanNode;

    protected IteratorCompleteUnaryNode(JSContext context2, JavaScriptNode iterResultNode) {
        this.iterResultNode = iterResultNode;
        this.getDoneNode = PropertyGetNode.create(Strings.DONE, false, context2);
    }

    public static JavaScriptNode create(JSContext context2, JavaScriptNode iterResultNode) {
        return new IteratorCompleteUnaryNode(context2, iterResultNode);
    }

    @Override
    public Object execute(VirtualFrame frame) {
        return this.executeBoolean(frame);
    }

    @Override
    public boolean executeBoolean(VirtualFrame frame) {
        Object iterResult = this.iterResultNode.execute(frame);
        Object done = this.getDoneNode.getValue(iterResult);
        if (done instanceof Boolean) {
            return (Boolean)done;
        }
        if (this.toBooleanNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.toBooleanNode = this.insert(JSToBooleanNode.create());
        }
        return this.toBooleanNode.executeBoolean(done);
    }

    @Override
    public final boolean isResultAlwaysOfType(Class<?> clazz) {
        return clazz == Boolean.TYPE;
    }

    @Override
    protected JavaScriptNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
        return IteratorCompleteUnaryNode.create(this.getDoneNode.getContext(), IteratorCompleteUnaryNode.cloneUninitialized(this.iterResultNode, materializedTags));
    }
}

