/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.access;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.access.GetSetRecordNodeGen;
import com.oracle.truffle.js.nodes.access.IsObjectNode;
import com.oracle.truffle.js.nodes.access.PropertyGetNode;
import com.oracle.truffle.js.nodes.cast.JSNumberToDoubleNode;
import com.oracle.truffle.js.nodes.cast.JSToIntegerOrInfinityNode;
import com.oracle.truffle.js.nodes.cast.JSToNumberNode;
import com.oracle.truffle.js.nodes.unary.IsCallableNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.Strings;
import com.oracle.truffle.js.runtime.builtins.SetRecord;

@ImportStatic(value={Strings.class})
public abstract class GetSetRecordNode
extends JavaScriptBaseNode {
    protected final JSContext context;

    protected GetSetRecordNode(JSContext context2) {
        this.context = context2;
    }

    @NeverDefault
    public static GetSetRecordNode create(JSContext context2) {
        return GetSetRecordNodeGen.create(context2);
    }

    public abstract SetRecord execute(Object var1);

    @Specialization
    protected SetRecord get(Object obj, @Cached IsObjectNode isObjectNode, @Cached(value="create(SIZE, context)") PropertyGetNode getSizeNode, @Cached(value="create(HAS, context)") PropertyGetNode getHasNode, @Cached(value="create(KEYS, context)") PropertyGetNode getKeysNode, @Cached JSToNumberNode toNumberNode, @Cached JSToIntegerOrInfinityNode toIntegerOrInfinityNode, @Cached JSNumberToDoubleNode numberToDoubleValueNode, @Cached IsCallableNode isCallableNode, @Cached InlinedBranchProfile errorBranch) {
        if (!isObjectNode.executeBoolean(obj)) {
            errorBranch.enter(this);
            throw Errors.createTypeErrorNotAnObject(obj, this);
        }
        Object rawSize = getSizeNode.getValue(obj);
        Object numSize = toNumberNode.execute(rawSize);
        if (JSRuntime.isNaN(numSize)) {
            errorBranch.enter(this);
            throw Errors.createTypeError("The .size property is NaN", (Node)this);
        }
        Object intSize = toIntegerOrInfinityNode.execute(numSize);
        double doubleSize = numberToDoubleValueNode.execute(this, intSize);
        if (doubleSize < 0.0) {
            errorBranch.enter(this);
            throw Errors.createRangeError("The .size property is negative", (Node)this);
        }
        Object has = getHasNode.getValue(obj);
        if (!isCallableNode.executeBoolean(has)) {
            errorBranch.enter(this);
            throw Errors.createTypeErrorCallableExpected();
        }
        Object keys = getKeysNode.getValue(obj);
        if (!isCallableNode.executeBoolean(keys)) {
            errorBranch.enter(this);
            throw Errors.createTypeErrorCallableExpected();
        }
        return new SetRecord(obj, doubleSize, has, keys);
    }
}

