/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins.json;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.api.strings.TruffleStringBuilder;
import com.oracle.truffle.api.strings.TruffleStringBuilderUTF16;
import com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import com.oracle.truffle.js.builtins.json.JSONBuiltinsFactory;
import com.oracle.truffle.js.builtins.json.JSONData;
import com.oracle.truffle.js.builtins.json.JSONParseRecord;
import com.oracle.truffle.js.builtins.json.JSONStringifyStringNode;
import com.oracle.truffle.js.builtins.json.TruffleJSONParser;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.access.CreateDataPropertyNode;
import com.oracle.truffle.js.nodes.access.ReadElementNode;
import com.oracle.truffle.js.nodes.array.JSGetLengthNode;
import com.oracle.truffle.js.nodes.cast.JSToIntegerAsIntNode;
import com.oracle.truffle.js.nodes.cast.JSToNumberNode;
import com.oracle.truffle.js.nodes.cast.JSToStringNode;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.nodes.function.JSBuiltinNode;
import com.oracle.truffle.js.nodes.unary.IsCallableNode;
import com.oracle.truffle.js.nodes.unary.JSIsArrayNode;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.Strings;
import com.oracle.truffle.js.runtime.builtins.BuiltinEnum;
import com.oracle.truffle.js.runtime.builtins.JSArray;
import com.oracle.truffle.js.runtime.builtins.JSNumber;
import com.oracle.truffle.js.runtime.builtins.JSNumberObject;
import com.oracle.truffle.js.runtime.builtins.JSOrdinary;
import com.oracle.truffle.js.runtime.builtins.JSRawJSON;
import com.oracle.truffle.js.runtime.builtins.JSRawJSONObject;
import com.oracle.truffle.js.runtime.builtins.JSString;
import com.oracle.truffle.js.runtime.builtins.JSStringObject;
import com.oracle.truffle.js.runtime.objects.JSAttributes;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.JSObjectUtil;
import com.oracle.truffle.js.runtime.objects.Undefined;
import com.oracle.truffle.js.runtime.util.StringBuilderProfile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;

public final class JSONBuiltins
extends JSBuiltinsContainer.SwitchEnum<JSON> {
    public static final JSBuiltinsContainer BUILTINS = new JSONBuiltins();

    protected JSONBuiltins() {
        super(com.oracle.truffle.js.builtins.json.JSON.CLASS_NAME, JSON.class);
    }

    @Override
    protected Object createNode(JSContext context2, JSBuiltin builtin, boolean construct, boolean newTarget, JSON builtinEnum) {
        switch (builtinEnum.ordinal()) {
            case 2: {
                return JSONBuiltinsFactory.JSONRawJSONNodeGen.create(context2, builtin, JSONBuiltins.args().fixedArgs(1).createArgumentNodes(context2));
            }
            case 3: {
                return JSONBuiltinsFactory.JSONIsRawJSONNodeGen.create(context2, builtin, JSONBuiltins.args().fixedArgs(1).createArgumentNodes(context2));
            }
            case 0: {
                return JSONBuiltinsFactory.JSONParseNodeGen.create(context2, builtin, JSONBuiltins.args().fixedArgs(2).createArgumentNodes(context2));
            }
            case 1: {
                return JSONBuiltinsFactory.JSONStringifyNodeGen.create(context2, builtin, JSONBuiltins.args().fixedArgs(3).createArgumentNodes(context2));
            }
        }
        return null;
    }

    public static enum JSON implements BuiltinEnum<JSON>
    {
        parse(2),
        stringify(3),
        rawJSON(1),
        isRawJSON(1);

        private final int length;

        private JSON(int length2) {
            this.length = length2;
        }

        @Override
        public int getLength() {
            return this.length;
        }

        @Override
        public int getECMAScriptVersion() {
            if (EnumSet.of(rawJSON, isRawJSON).contains(this)) {
                return 15;
            }
            return BuiltinEnum.super.getECMAScriptVersion();
        }
    }

    public static abstract class JSONRawJSONNode
    extends JSBuiltinNode {
        public JSONRawJSONNode(JSContext context2, JSBuiltin builtin) {
            super(context2, builtin);
        }

        @Specialization
        protected Object rawJSON(Object text2, @Cached JSToStringNode toStringNode) {
            TruffleString sourceText = toStringNode.executeString(text2);
            JSRealm realm = this.getRealm();
            JSONParseNode.parseIntl(sourceText, TruffleJSONParser.Mode.RawJSON, realm);
            return JSRawJSON.create(this.getContext(), realm, sourceText);
        }
    }

    public static abstract class JSONIsRawJSONNode
    extends JSBuiltinNode {
        public JSONIsRawJSONNode(JSContext context2, JSBuiltin builtin) {
            super(context2, builtin);
        }

        @Specialization
        protected static Object isRawJSON(Object value2) {
            return value2 instanceof JSRawJSONObject;
        }
    }

    @ImportStatic(value={Strings.class})
    public static abstract class JSONParseNode
    extends JSBuiltinNode {
        public JSONParseNode(JSContext context2, JSBuiltin builtin) {
            super(context2, builtin);
        }

        @Specialization(guards={"isUndefined(reviver)"})
        protected Object parseString(TruffleString text2, Object reviver) {
            return JSONParseNode.parseIntl(text2, TruffleJSONParser.Mode.WithoutReviver, this.getRealm());
        }

        @Specialization(guards={"!isCallable.executeBoolean(reviver)"}, replaces={"parseString"})
        protected Object parseUnfiltered(Object text2, Object reviver, @Cached @Cached.Shared IsCallableNode isCallable, @Cached @Cached.Shared JSToStringNode toStringNode) {
            return JSONParseNode.parseIntl(toStringNode.executeString(text2), TruffleJSONParser.Mode.WithoutReviver, this.getRealm());
        }

        @Specialization(guards={"isCallable.executeBoolean(reviver)"})
        protected Object parse(Object value2, Object reviver, @Cached @Cached.Shared IsCallableNode isCallable, @Cached @Cached.Shared JSToStringNode toStringNode, @Cached(value="create(getContext(), EMPTY_STRING)") CreateDataPropertyNode createWrapperPropertyNode) {
            TruffleString text2 = toStringNode.executeString(value2);
            boolean withSource = this.getContext().getEcmaScriptVersion() >= 15;
            JSRealm realm = this.getRealm();
            Object unfiltered = JSONParseNode.parseIntl(text2, withSource ? TruffleJSONParser.Mode.WithReviverAndSource : TruffleJSONParser.Mode.WithReviver, realm);
            JSObject root = JSOrdinary.create(this.getContext(), realm);
            JSONParseRecord snapshot = null;
            if (withSource) {
                snapshot = (JSONParseRecord)unfiltered;
                unfiltered = snapshot.value();
            }
            createWrapperPropertyNode.executeVoid(root, unfiltered);
            return this.internalizeJSONProperty(root, Strings.EMPTY_STRING, reviver, text2, snapshot, withSource);
        }

        @CompilerDirectives.TruffleBoundary(transferToInterpreterOnException=false)
        private static Object parseIntl(TruffleString jsonString, TruffleJSONParser.Mode mode, JSRealm realm) {
            return new TruffleJSONParser(realm.getContext(), mode).parse(jsonString, realm);
        }

        @CompilerDirectives.TruffleBoundary
        private Object internalizeJSONProperty(JSObject holder, TruffleString property, Object reviverFn, TruffleString input, JSONParseRecord parseRecord, boolean withSource) {
            Object[] objectArray;
            Object value2 = JSObject.get((JSDynamicObject)holder, property);
            assert (!(value2 instanceof JSONParseRecord));
            JSObject contextObject = JSOrdinary.create(this.getContext(), this.getRealm());
            boolean useParseRecord = false;
            if (parseRecord != null && JSRuntime.isSameValue(parseRecord.value(), value2)) {
                useParseRecord = true;
                if (!JSRuntime.isObject(value2)) {
                    JSObjectUtil.putDataProperty(contextObject, Strings.SOURCE, parseRecord.source(), JSAttributes.getDefault());
                }
            }
            if (JSRuntime.isObject(value2)) {
                JSObject object = (JSObject)value2;
                if (JSRuntime.isArray(object)) {
                    int len = (int)JSRuntime.toLength(JSObject.get((JSDynamicObject)object, JSArray.LENGTH));
                    int elementRecordsLen = useParseRecord ? parseRecord.elements().size() : 0;
                    for (int i = 0; i < len; ++i) {
                        JSONParseRecord elementRecord;
                        TruffleString stringIndex = Strings.fromInt(i);
                        Object newElement = this.internalizeJSONProperty(object, stringIndex, reviverFn, input, elementRecord = i < elementRecordsLen ? parseRecord.elements().get(i) : null, withSource);
                        if (newElement == Undefined.instance) {
                            JSObject.delete((JSDynamicObject)object, i);
                            continue;
                        }
                        JSRuntime.createDataProperty(object, stringIndex, newElement);
                    }
                } else {
                    for (TruffleString p : JSObject.enumerableOwnNames(object)) {
                        JSONParseRecord entryRecord;
                        Object newElement = this.internalizeJSONProperty(object, p, reviverFn, input, entryRecord = useParseRecord ? (JSONParseRecord)parseRecord.entries().get(p) : null, withSource);
                        if (newElement == Undefined.instance) {
                            JSObject.delete((JSDynamicObject)object, p);
                            continue;
                        }
                        JSRuntime.createDataProperty(object, p, newElement);
                    }
                }
            }
            if (withSource) {
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = property;
                objectArray2[1] = value2;
                objectArray = objectArray2;
                objectArray2[2] = contextObject;
            } else {
                Object[] objectArray3 = new Object[2];
                objectArray3[0] = property;
                objectArray = objectArray3;
                objectArray3[1] = value2;
            }
            return JSRuntime.call(reviverFn, holder, objectArray);
        }
    }

    public static abstract class JSONStringifyNode
    extends JSBuiltinNode {
        @Node.Child
        private JSONStringifyStringNode jsonStringifyStringNode;
        @Node.Child
        private CreateDataPropertyNode createWrapperPropertyNode = CreateDataPropertyNode.create(this.getContext(), Strings.EMPTY_STRING);

        public JSONStringifyNode(JSContext context2, JSBuiltin builtin) {
            super(context2, builtin);
            this.jsonStringifyStringNode = JSONStringifyStringNode.create(this.getContext());
        }

        @Specialization(guards={"!isString(value)", "isUndefined(replacer)"})
        protected Object stringifyNoReplacer(Object value2, Object replacer, Object space, @Cached @Cached.Shared GetGapNode getGapNode) {
            return this.stringifyIntl(value2, space, null, null, getGapNode);
        }

        @Specialization(guards={"!isUndefined(replacer)"})
        protected Object stringifyWithReplacer(Object value2, Object replacer, Object space, @Bind(value="this") Node node, @Cached @Cached.Shared GetGapNode getGapNode, @Cached IsCallableNode isCallableNode, @Cached(value="createIsArrayLike()") JSIsArrayNode isArrayNode, @Cached ToReplacerListNode toReplacerListNode) {
            Object replacerFn = null;
            List<Object> replacerList = null;
            if (isCallableNode.executeBoolean(replacer)) {
                replacerFn = replacer;
            } else if (isArrayNode.execute(replacer)) {
                replacerList = toReplacerListNode.execute(node, replacer);
            }
            return this.stringifyIntl(value2, space, replacerFn, replacerList, getGapNode);
        }

        @Specialization(guards={"isUndefined(replacer)"})
        protected Object stringifyAStringNoReplacer(TruffleString str, Object replacer, Object space, @Cached(value="createStringBuilderProfile()") StringBuilderProfile stringBuilderProfile, @Cached TruffleStringBuilder.AppendCharUTF16Node appendRawValueNode, @Cached TruffleStringBuilder.AppendStringNode appendStringNode, @Cached TruffleStringBuilder.AppendSubstringByteIndexNode appendSubstringNode, @Cached TruffleStringBuilder.ToStringNode builderToStringNode) {
            TruffleStringBuilderUTF16 builder2 = Strings.builderCreate(Strings.length(str) + 8);
            JSONStringifyStringNode.jsonQuote(stringBuilderProfile, builder2, str, appendRawValueNode, appendStringNode, appendSubstringNode);
            return StringBuilderProfile.toString(builderToStringNode, builder2);
        }

        protected StringBuilderProfile createStringBuilderProfile() {
            return StringBuilderProfile.create(this.getContext().getStringLengthLimit());
        }

        private Object stringifyIntl(Object value2, Object space, Object replacerFnObj, List<Object> replacerList, GetGapNode getGapNode) {
            TruffleString gap = getGapNode.execute(this, space);
            JSObject wrapper = JSOrdinary.create(this.getContext(), this.getRealm());
            this.createWrapperPropertyNode.executeVoid(wrapper, value2);
            return this.jsonStringifyStringNode.execute(new JSONData(gap, replacerFnObj, replacerList), Strings.EMPTY_STRING, wrapper);
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    static abstract class ToReplacerListNode
    extends JavaScriptBaseNode {
        ToReplacerListNode() {
        }

        public abstract List<Object> execute(Node var1, Object var2);

        @Specialization
        static List<Object> makeReplacerList(Object replacerObj, @Cached(value="create(getLanguage().getJSContext())") JSGetLengthNode getLengthNode, @Cached(value="create(getLanguage().getJSContext())") ReadElementNode getElementNode, @Cached JSToStringNode toStringNode) {
            long len = getLengthNode.executeLong(replacerObj);
            ArrayList<Object> replacerList = new ArrayList<Object>();
            for (long k = 0L; k < len; ++k) {
                Object v = getElementNode.executeWithTargetAndIndex(replacerObj, k);
                TruffleString item = null;
                if (v instanceof TruffleString) {
                    TruffleString str;
                    item = str = (TruffleString)v;
                } else if (JSRuntime.isNumber(v) || JSNumber.isJSNumber(v) || JSString.isJSString(v)) {
                    item = toStringNode.executeString(v);
                }
                if (item == null) continue;
                ToReplacerListNode.addToReplacer(replacerList, item);
            }
            return replacerList;
        }

        @CompilerDirectives.TruffleBoundary
        private static void addToReplacer(List<Object> replacerList, TruffleString item) {
            if (!replacerList.contains(item)) {
                replacerList.add(item);
            }
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    static abstract class GetGapNode
    extends JavaScriptBaseNode {
        GetGapNode() {
        }

        public abstract TruffleString execute(Node var1, Object var2);

        @Specialization(guards={"isUndefined(space)"})
        static TruffleString doUndefined(Object space) {
            return Strings.EMPTY_STRING;
        }

        @Specialization
        static TruffleString doNumberObject(JSNumberObject space, @Cached JSToNumberNode toNumberNode, @Cached @Cached.Shared JSToIntegerAsIntNode toIntegerNode, @Cached @Cached.Shared TruffleString.FromByteArrayNode fromByteArrayNode, @Cached @Cached.Shared TruffleString.SwitchEncodingNode switchEncodingNode) {
            return GetGapNode.doNumber(toNumberNode.execute(space), toIntegerNode, fromByteArrayNode, switchEncodingNode);
        }

        @Specialization
        static TruffleString doStringObject(JSStringObject space, @Cached JSToStringNode toStringNode, @Cached @Cached.Shared TruffleString.SubstringByteIndexNode substringNode) {
            return GetGapNode.doString(toStringNode.executeString(space), substringNode);
        }

        @Specialization(guards={"isNumber(space)"})
        static TruffleString doNumber(Object space, @Cached @Cached.Shared JSToIntegerAsIntNode toIntegerNode, @Cached @Cached.Shared TruffleString.FromByteArrayNode fromByteArrayNode, @Cached @Cached.Shared TruffleString.SwitchEncodingNode switchEncodingNode) {
            int newSpace = Math.max(0, Math.min(10, toIntegerNode.executeInt(space)));
            byte[] ar = new byte[newSpace];
            Arrays.fill(ar, (byte)32);
            return switchEncodingNode.execute(fromByteArrayNode.execute(ar, TruffleString.Encoding.ISO_8859_1, false), TruffleString.Encoding.UTF_16);
        }

        @Specialization
        static TruffleString doString(TruffleString space, @Cached @Cached.Shared TruffleString.SubstringByteIndexNode substringNode) {
            if (Strings.length(space) <= 10) {
                return space;
            }
            return Strings.lazySubstring(substringNode, space, 0, 10);
        }

        @Fallback
        static TruffleString doOther(Object space) {
            return Strings.EMPTY_STRING;
        }
    }
}

