/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins;

import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.js.builtins.IteratorFunctionBuiltinsFactory;
import com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import com.oracle.truffle.js.nodes.access.GetIteratorFlattenableNode;
import com.oracle.truffle.js.nodes.binary.InstanceofNode;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.nodes.function.JSBuiltinNode;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.builtins.BuiltinEnum;
import com.oracle.truffle.js.runtime.builtins.JSIterator;
import com.oracle.truffle.js.runtime.builtins.JSWrapForValidIterator;
import com.oracle.truffle.js.runtime.objects.IteratorRecord;

public final class IteratorFunctionBuiltins
extends JSBuiltinsContainer.SwitchEnum<IteratorFunction> {
    public static final JSBuiltinsContainer BUILTINS = new IteratorFunctionBuiltins();

    IteratorFunctionBuiltins() {
        super(JSIterator.CLASS_NAME, IteratorFunction.class);
    }

    @Override
    protected Object createNode(JSContext context2, JSBuiltin builtin, boolean construct, boolean newTarget, IteratorFunction builtinEnum) {
        switch (builtinEnum.ordinal()) {
            case 0: {
                return IteratorFunctionBuiltinsFactory.JSIteratorFromNodeGen.create(context2, builtin, IteratorFunctionBuiltins.args().fixedArgs(1).createArgumentNodes(context2));
            }
        }
        return null;
    }

    public static enum IteratorFunction implements BuiltinEnum<IteratorFunction>
    {
        from(1);

        private final int length;

        private IteratorFunction(int length2) {
            this.length = length2;
        }

        @Override
        public int getLength() {
            return this.length;
        }
    }

    public static abstract class JSIteratorFromNode
    extends JSBuiltinNode {
        @Node.Child
        private GetIteratorFlattenableNode getIteratorFlattenableNode;
        @Node.Child
        private InstanceofNode.OrdinaryHasInstanceNode ordinaryHasInstanceNode;

        public JSIteratorFromNode(JSContext context2, JSBuiltin builtin) {
            super(context2, builtin);
            this.getIteratorFlattenableNode = GetIteratorFlattenableNode.create(false, false, context2);
            this.ordinaryHasInstanceNode = InstanceofNode.OrdinaryHasInstanceNode.create(context2);
        }

        @Specialization
        protected Object iteratorFrom(Object arg) {
            IteratorRecord iteratorRecord = this.getIteratorFlattenableNode.execute(arg);
            JSRealm realm = this.getRealm();
            boolean hasInstance = this.ordinaryHasInstanceNode.executeBoolean(iteratorRecord.getIterator(), realm.getIteratorConstructor());
            if (hasInstance) {
                return iteratorRecord.getIterator();
            }
            return JSWrapForValidIterator.create(this.getContext(), realm, iteratorRecord);
        }
    }
}

