/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.jsonpath.internal.path;

import com.jayway.jsonpath.InvalidPathException;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.PathNotFoundException;
import com.jayway.jsonpath.internal.PathRef;
import com.jayway.jsonpath.internal.Utils;
import com.jayway.jsonpath.internal.path.EvaluationContextImpl;
import com.jayway.jsonpath.internal.path.PathToken;
import java.util.ArrayList;
import java.util.List;

public class PropertyPathToken
extends PathToken {
    private final List<String> properties;
    private final String stringDelimiter;

    public PropertyPathToken(List<String> properties2, char stringDelimiter) {
        if (properties2.isEmpty()) {
            throw new InvalidPathException("Empty properties");
        }
        this.properties = properties2;
        this.stringDelimiter = Character.toString(stringDelimiter);
    }

    public List<String> getProperties() {
        return this.properties;
    }

    public boolean singlePropertyCase() {
        return this.properties.size() == 1;
    }

    public boolean multiPropertyMergeCase() {
        return this.isLeaf() && this.properties.size() > 1;
    }

    public boolean multiPropertyIterationCase() {
        return !this.isLeaf() && this.properties.size() > 1;
    }

    @Override
    public void evaluate(String currentPath, PathRef parent, Object model, EvaluationContextImpl ctx) {
        assert (Utils.onlyOneIsTrueNonThrow(this.singlePropertyCase(), this.multiPropertyMergeCase(), this.multiPropertyIterationCase()));
        if (!ctx.jsonProvider().isMap(model)) {
            if (!this.isUpstreamDefinite() || ctx.options().contains((Object)Option.SUPPRESS_EXCEPTIONS)) {
                return;
            }
            String m = model == null ? "null" : model.getClass().getName();
            throw new PathNotFoundException(String.format("Expected to find an object with property %s in path %s but found '%s'. This is not a json object according to the JsonProvider: '%s'.", this.getPathFragment(), currentPath, m, ctx.configuration().jsonProvider().getClass().getName()));
        }
        if (this.singlePropertyCase() || this.multiPropertyMergeCase()) {
            this.handleObjectProperty(currentPath, model, ctx, this.properties);
            return;
        }
        assert (this.multiPropertyIterationCase());
        ArrayList<String> currentlyHandledProperty = new ArrayList<String>(1);
        currentlyHandledProperty.add(null);
        for (String property : this.properties) {
            currentlyHandledProperty.set(0, property);
            this.handleObjectProperty(currentPath, model, ctx, currentlyHandledProperty);
        }
    }

    @Override
    public boolean isTokenDefinite() {
        return this.singlePropertyCase() || this.multiPropertyMergeCase();
    }

    @Override
    public String getPathFragment() {
        return "[" + Utils.join(",", this.stringDelimiter, this.properties) + "]";
    }
}

