/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.http.request.run.js.graalvm.dom;

import com.intellij.httpClient.http.request.run.js.graalvm.dom.xml.XmlDomDocument;
import java.io.ByteArrayInputStream;
import java.nio.charset.Charset;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.graalvm.polyglot.proxy.ProxyObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007\u00a8\u0006\t"}, d2={"Lcom/intellij/httpClient/http/request/run/js/graalvm/dom/DOMParser;", "", "<init>", "()V", "parseFromString", "Lorg/graalvm/polyglot/proxy/ProxyObject;", "xmlString", "", "mimeType", "intellij.httpClient.executor"})
public final class DOMParser {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public final ProxyObject parseFromString(@NotNull String xmlString, @NotNull String mimeType) {
        Intrinsics.checkNotNullParameter((Object)xmlString, (String)"xmlString");
        Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
        switch (mimeType) {
            case "application/xml": 
            case "text/xml": {
                Object object;
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder2 = factory.newDocumentBuilder();
                try {
                    object = xmlString;
                    Charset charset = Charsets.UTF_8;
                    byte[] byArray = ((String)object).getBytes(charset);
                    Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
                    object = builder2.parse(new ByteArrayInputStream(byArray));
                }
                catch (Exception e) {
                    object = builder2.newDocument();
                }
                Object document = object;
                Intrinsics.checkNotNull((Object)document);
                return new XmlDomDocument((Document)document);
            }
            case "text/html": {
                throw new IllegalStateException("Unsupported type".toString());
            }
            case "application/xhtml+xml": {
                throw new IllegalStateException("Unsupported type".toString());
            }
            case "image/svg+xml": {
                throw new IllegalStateException("Unsupported type".toString());
            }
        }
        throw new IllegalStateException(("invalid mime type: " + mimeType).toString());
    }
}

