/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.execution.ssl;

import com.intellij.httpClient.execution.HttpClientExecutorBundle;
import java.security.Provider;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMDecryptorProvider;
import org.bouncycastle.openssl.PEMEncryptedKeyPair;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.bc.BcPEMDecryptorProvider;
import org.bouncycastle.operator.InputDecryptorProvider;
import org.bouncycastle.pkcs.PKCS8EncryptedPrivateKeyInfo;
import org.bouncycastle.pkcs.jcajce.JcePKCSPBEInputDecryptorProviderBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0019\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0001J\u001a\u0010\u0007\u001a\u00020\b2\b\u0010\u0006\u001a\u0004\u0018\u00010\u00012\b\u0010\t\u001a\u0004\u0018\u00010\nJ\u000e\u0010\u000b\u001a\u00020\f*\u0004\u0018\u00010\nH\u0002\u00a8\u0006\r"}, d2={"Lcom/intellij/httpClient/execution/ssl/PemHelper;", "", "<init>", "()V", "isKey", "", "pemObject", "readKey", "Lorg/bouncycastle/asn1/pkcs/PrivateKeyInfo;", "passphrase", "", "asValid", "", "intellij.httpClient.executor"})
@SourceDebugExtension(value={"SMAP\nPemHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PemHelper.kt\ncom/intellij/httpClient/execution/ssl/PemHelper\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,39:1\n1#2:40\n*E\n"})
public final class PemHelper {
    @NotNull
    public static final PemHelper INSTANCE = new PemHelper();

    private PemHelper() {
    }

    public final boolean isKey(@Nullable Object pemObject) {
        Object object = pemObject;
        return object instanceof PEMKeyPair || object instanceof PEMEncryptedKeyPair || object instanceof PrivateKeyInfo || object instanceof PKCS8EncryptedPrivateKeyInfo;
    }

    @NotNull
    public final PrivateKeyInfo readKey(@Nullable Object pemObject, @Nullable String passphrase) {
        PrivateKeyInfo privateKeyInfo;
        boolean bl = this.isKey(pemObject);
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        Object object = pemObject;
        if (object instanceof PrivateKeyInfo) {
            privateKeyInfo = (PrivateKeyInfo)pemObject;
        } else if (object instanceof PEMKeyPair) {
            PrivateKeyInfo privateKeyInfo2 = ((PEMKeyPair)pemObject).getPrivateKeyInfo();
            privateKeyInfo = privateKeyInfo2;
            Intrinsics.checkNotNullExpressionValue((Object)privateKeyInfo2, (String)"getPrivateKeyInfo(...)");
        } else if (object instanceof PEMEncryptedKeyPair) {
            PrivateKeyInfo privateKeyInfo3 = ((PEMEncryptedKeyPair)pemObject).decryptKeyPair((PEMDecryptorProvider)new BcPEMDecryptorProvider(this.asValid(passphrase))).getPrivateKeyInfo();
            privateKeyInfo = privateKeyInfo3;
            Intrinsics.checkNotNullExpressionValue((Object)privateKeyInfo3, (String)"getPrivateKeyInfo(...)");
        } else if (object instanceof PKCS8EncryptedPrivateKeyInfo) {
            InputDecryptorProvider provider = new JcePKCSPBEInputDecryptorProviderBuilder().setProvider((Provider)new BouncyCastleProvider()).build(this.asValid(passphrase));
            PrivateKeyInfo privateKeyInfo4 = ((PKCS8EncryptedPrivateKeyInfo)pemObject).decryptPrivateKeyInfo(provider);
            Intrinsics.checkNotNull((Object)privateKeyInfo4);
            privateKeyInfo = privateKeyInfo4;
        } else {
            throw new AssertionError((Object)"Cannot be here");
        }
        return privateKeyInfo;
    }

    private final char[] asValid(String $this$asValid) {
        if (!($this$asValid != null)) {
            boolean bl = false;
            String string = HttpClientExecutorBundle.message("http.request.ssl.encrypted.key.without.passphrase.error", new Object[0]);
            throw new IllegalStateException(string.toString());
        }
        char[] cArray = $this$asValid.toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
        return cArray;
    }
}

