/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.lsp;

import com.intellij.lang.typescript.compiler.languageService.TypeScriptLanguageServiceUtil;
import com.intellij.lang.typescript.library.TypeScriptLibraryProvider;
import com.intellij.lang.typescript.lsp.LspServerActivationRule;
import com.intellij.lang.typescript.lsp.LspServerLoader;
import com.intellij.lang.typescript.lsp.TSPluginLoader;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b'\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0018\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0004R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0011"}, d2={"Lcom/intellij/lang/typescript/lsp/JSServiceSetActivationRule;", "Lcom/intellij/lang/typescript/lsp/LspServerActivationRule;", "lspServerLoader", "Lcom/intellij/lang/typescript/lsp/LspServerLoader;", "tsPluginLoader", "Lcom/intellij/lang/typescript/lsp/TSPluginLoader;", "<init>", "(Lcom/intellij/lang/typescript/lsp/LspServerLoader;Lcom/intellij/lang/typescript/lsp/TSPluginLoader;)V", "getTsPluginLoader", "()Lcom/intellij/lang/typescript/lsp/TSPluginLoader;", "isTSPluginEnabledAndAvailable", "", "project", "Lcom/intellij/openapi/project/Project;", "context", "Lcom/intellij/openapi/vfs/VirtualFile;", "isEnabledByEnvironment", "intellij.javascript.impl"})
@ApiStatus.Experimental
public abstract class JSServiceSetActivationRule
extends LspServerActivationRule {
    @Nullable
    private final TSPluginLoader tsPluginLoader;

    public JSServiceSetActivationRule(@NotNull LspServerLoader lspServerLoader, @Nullable TSPluginLoader tsPluginLoader) {
        Intrinsics.checkNotNullParameter((Object)lspServerLoader, (String)"lspServerLoader");
        super(lspServerLoader);
        this.tsPluginLoader = tsPluginLoader;
    }

    @Nullable
    public final TSPluginLoader getTsPluginLoader() {
        return this.tsPluginLoader;
    }

    public final boolean isTSPluginEnabledAndAvailable(@NotNull Project project, @NotNull VirtualFile context2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (this.tsPluginLoader == null) {
            throw new NotImplementedError(this.getClass().getSimpleName() + " doesn't support TS Plugin");
        }
        return this.isEnabledByContextAndSettings(project, context2) && this.tsPluginLoader.getAbsolutePathOrRefresh(project) != null;
    }

    @Override
    protected final boolean isEnabledByEnvironment(@NotNull Project project, @NotNull VirtualFile context2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        return TypeScriptLanguageServiceUtil.isServiceEnabled(project) && !TypeScriptLibraryProvider.isLibraryOrBundledLibraryFile(project, context2);
    }
}

