/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler.languageService;

import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.javascript.flow.LogicalNavigationLinkHandler;
import com.intellij.lang.javascript.service.JSLanguageServiceAnnotationResult;
import com.intellij.lang.javascript.service.protocol.LocalFilePath;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerSettings;
import com.intellij.lang.typescript.compiler.languageService.DiagnosticMessageItem;
import com.intellij.lang.typescript.compiler.languageService.DiagnosticMessageParser;
import com.intellij.lang.typescript.compiler.languageService.DiagnosticMessageWithConcatenatedItemsParser;
import com.intellij.lang.typescript.compiler.languageService.Fragment;
import com.intellij.lang.typescript.compiler.languageService.LanguageServiceInfo;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.response.TypeScriptDiagnosticsResponse;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.response.TypeScriptResponseCommon;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.StringUtil;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.io.File;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptLanguageServiceAnnotationResult
extends JSLanguageServiceAnnotationResult {
    private final int myErrorCode;
    @Nullable
    private final String mySource;

    @NotNull
    public static TypeScriptLanguageServiceAnnotationResult buildAnnotation(@NotNull Project project, @Nullable String fileName, @NotNull TypeScriptDiagnosticsResponse.DiagnosticsResponseDiagnostics diagnostic, @Nullable LanguageServiceInfo languageServiceInfo) {
        String category;
        if (project == null) {
            TypeScriptLanguageServiceAnnotationResult.$$$reportNull$$$0(0);
        }
        if (diagnostic == null) {
            TypeScriptLanguageServiceAnnotationResult.$$$reportNull$$$0(1);
        }
        if (StringUtil.isEmpty((String)(category = diagnostic.category))) {
            category = "error";
        }
        if (!TypeScriptCompilerSettings.getSettings(project).isShowSuggestions() && "suggestion".equals(category)) {
            category = "info";
        }
        TypeScriptDiagnosticsResponse.DiagnosticsResponseDiagnosticsLineInfo start = diagnostic.start;
        TypeScriptDiagnosticsResponse.DiagnosticsResponseDiagnosticsLineInfo end = diagnostic.end;
        String simpleErrorText = StringUtil.notNullize((String)diagnostic.text, (String)"error").trim();
        List<DiagnosticMessageItem> messageItems = DiagnosticMessageWithConcatenatedItemsParser.INSTANCE.parse(simpleErrorText, diagnostic.code, project, languageServiceInfo);
        String relatedErrors = TypeScriptLanguageServiceAnnotationResult.parseRelatedErrors(diagnostic.relatedInformation, project, languageServiceInfo);
        String prefix = TypeScriptLanguageServiceAnnotationResult.getSourceOrTsCodePrefix(diagnostic);
        String tooltip = DiagnosticMessageWithConcatenatedItemsParser.INSTANCE.messageItemsToHtml(messageItems, prefix, project) + relatedErrors;
        return new TypeScriptLanguageServiceAnnotationResult(prefix + simpleErrorText, fileName, category, diagnostic.source, tooltip, diagnostic.code, start == null ? 0 : start.line, start == null ? 0 : start.offset, end == null ? 0 : end.line, end == null ? 0 : end.offset);
    }

    private static String getSourceOrTsCodePrefix(TypeScriptDiagnosticsResponse.DiagnosticsResponseDiagnostics diagnostic) {
        String source = diagnostic.source;
        if (source != null && !source.isBlank()) {
            return source + ": ";
        }
        if (!StringUtil.notNullize((String)diagnostic.text).startsWith("TS") && diagnostic.code > 0) {
            return "TS" + diagnostic.code + ": ";
        }
        return "";
    }

    @NotNull
    private static String parseRelatedErrors(TypeScriptDiagnosticsResponse.DiagnosticRelatedInformation[] relatedInformation, Project project, LanguageServiceInfo languageServiceInfo) {
        if (relatedInformation == null || relatedInformation.length == 0) {
            return "";
        }
        StringBuilder result2 = new StringBuilder();
        for (TypeScriptDiagnosticsResponse.DiagnosticRelatedInformation information : relatedInformation) {
            String message = information.message;
            if (StringUtil.isEmpty((String)message)) continue;
            result2.append("<div style=\"margin-top: ").append(4).append("px\">");
            TypeScriptResponseCommon.FileSpan fileSpan = information.span;
            if (fileSpan != null && fileSpan.file != null) {
                result2.append(TypeScriptLanguageServiceAnnotationResult.buildLink(fileSpan));
            }
            List<Fragment> fragments = DiagnosticMessageParser.INSTANCE.parse(message, information.code, project, languageServiceInfo);
            result2.append(DiagnosticMessageParser.INSTANCE.fragmentsToHtml(fragments, project)).append("</div>");
        }
        String string = result2.toString();
        if (string == null) {
            TypeScriptLanguageServiceAnnotationResult.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    private static String buildLink(TypeScriptResponseCommon.FileSpan span) {
        LocalFilePath file = span.file;
        String path2 = file.getPath();
        if (!StringUtil.isEmpty((String)path2) && span.start != null) {
            String fileName = new File(path2).getName();
            String uri = LogicalNavigationLinkHandler.buildUri(path2, span.start.line, span.start.offset);
            String text = fileName + "(" + span.start.line + ", " + span.start.offset + ")";
            String string = new HtmlBuilder().appendLink(uri, text).append(": ").toString();
            if (string == null) {
                TypeScriptLanguageServiceAnnotationResult.$$$reportNull$$$0(3);
            }
            return string;
        }
        return "";
    }

    public TypeScriptLanguageServiceAnnotationResult(@NotNull String infoText, @Nullable String fileAbsolutePath) {
        if (infoText == null) {
            TypeScriptLanguageServiceAnnotationResult.$$$reportNull$$$0(4);
        }
        this(infoText, fileAbsolutePath, "info", null, null, -1, 0, 0, 0, 0);
    }

    public TypeScriptLanguageServiceAnnotationResult(@NotNull String errorText, @Nullable String fileAbsolutePath, @Nullable String category, @Nullable String source, @Nullable String tooltipText, int errorCode, int line, int column, int lineEnd, int columnEnd) {
        if (errorText == null) {
            TypeScriptLanguageServiceAnnotationResult.$$$reportNull$$$0(5);
        }
        super(errorText, tooltipText, fileAbsolutePath, category, line, column, lineEnd, columnEnd);
        this.myErrorCode = errorCode == -1 ? TypeScriptLanguageServiceAnnotationResult.getErrorCodeImpl(errorText) : errorCode;
        this.mySource = source;
    }

    public int getErrorCode() {
        return this.myErrorCode;
    }

    @Nullable
    public String getSource() {
        return this.mySource;
    }

    private static int getErrorCodeImpl(String myErrorText) {
        String prefix = "TS";
        if (myErrorText.startsWith(prefix)) {
            int endCode = myErrorText.indexOf(":");
            if (endCode == -1) {
                return -1;
            }
            String code = myErrorText.substring(prefix.length(), endCode);
            try {
                return Integer.parseInt(code.trim());
            }
            catch (Exception e) {
                return -1;
            }
        }
        return -1;
    }

    @Override
    public ProblemHighlightType getHighlightType() {
        int code = this.getErrorCode();
        return TypeScriptLanguageServiceAnnotationResult.getHighlightingTypeByCode(this.getDescription(), code, this.getCategory());
    }

    @Nullable
    public static ProblemHighlightType getHighlightingTypeByCode(String description, int code, @Nullable String category) {
        if (code != -1) {
            if (Objects.equals(category, "suggestion")) {
                if (Codes.UNUSED_SYMBOL.contains(code)) {
                    if (description.contains("'h'") || description.contains("'React'")) {
                        return ProblemHighlightType.INFORMATION;
                    }
                    return ProblemHighlightType.LIKE_UNUSED_SYMBOL;
                }
                return null;
            }
            if (Codes.UNKNOWN_SYMBOL.contains(code)) {
                return ProblemHighlightType.LIKE_UNKNOWN_SYMBOL;
            }
        }
        return null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TypeScriptLanguageServiceAnnotationResult result2 = (TypeScriptLanguageServiceAnnotationResult)o;
        return this.myErrorCode == result2.myErrorCode && Objects.equals(this.mySource, result2.mySource);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.myErrorCode, this.mySource);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "diagnostic";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/compiler/languageService/TypeScriptLanguageServiceAnnotationResult";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "infoText";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/compiler/languageService/TypeScriptLanguageServiceAnnotationResult";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "parseRelatedErrors";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildLink";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildAnnotation";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3 -> new IllegalStateException(string);
        };
    }

    private static class Codes {
        private static final IntSet UNKNOWN_SYMBOL = IntOpenHashSet.of((int[])new int[]{2304, 2339, 2305, 2551, 2552, 2580, 2582, 2583, 2584, 2663, 2693, 2694, 2749, 4025, 4081, 18004});
        private static final IntSet UNUSED_SYMBOL = IntOpenHashSet.of((int)6133, (int)6138, (int)6196);

        private Codes() {
        }
    }
}

