/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.util;

import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSRecursiveWalkingElementVisitor;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;

public final class RecursionVisitor
extends JSRecursiveWalkingElementVisitor {
    private boolean recursive;
    private final JSFunction function;
    private final String functionName;
    private final boolean accessMethod;

    public RecursionVisitor(@NotNull JSFunction function) {
        if (function == null) {
            RecursionVisitor.$$$reportNull$$$0(0);
        }
        this.recursive = false;
        this.function = function;
        this.functionName = function.getName();
        this.accessMethod = JSPsiImplUtils.isGetterOrSetter(function);
    }

    @Override
    public void visitElement(@NotNull PsiElement element) {
        if (element == null) {
            RecursionVisitor.$$$reportNull$$$0(1);
        }
        if (!this.recursive) {
            super.visitElement(element);
        }
    }

    @Override
    public void visitJSCallExpression(@NotNull JSCallExpression call) {
        if (call == null) {
            RecursionVisitor.$$$reportNull$$$0(2);
        }
        if (this.recursive) {
            return;
        }
        super.visitJSCallExpression(call);
        JSExpression methodExpression = call.getMethodExpression();
        if (!(methodExpression instanceof JSReferenceExpression)) {
            return;
        }
        this.processRefExpr((JSReferenceExpression)methodExpression);
    }

    private void processRefExpr(JSReferenceExpression functionExpression) {
        String calledFunctionName = functionExpression.getReferencedName();
        if (calledFunctionName == null) {
            return;
        }
        if (!calledFunctionName.equals(this.functionName)) {
            return;
        }
        PsiElement referent = functionExpression.resolve();
        if (!this.function.equals(referent)) {
            return;
        }
        JSExpression qualifier = functionExpression.getQualifier();
        if (qualifier == null || qualifier instanceof JSThisExpression) {
            this.recursive = true;
        }
    }

    @Override
    public void visitJSReferenceExpression(@NotNull JSReferenceExpression node) {
        if (node == null) {
            RecursionVisitor.$$$reportNull$$$0(3);
        }
        if (this.recursive || !this.accessMethod) {
            return;
        }
        PsiElement parent = node.getParent();
        if (parent instanceof JSCallExpression || parent instanceof JSReferenceExpression) {
            return;
        }
        super.visitJSReferenceExpression(node);
        this.processRefExpr(node);
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/psi/util/RecursionVisitor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "visitElement";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "visitJSCallExpression";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "visitJSReferenceExpression";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

