/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.jsx;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.htmlInspections.XmlAttributeRenameFix;
import com.intellij.codeInspection.htmlInspections.XmlUnknownAttributeQuickFixProvider;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.typescript.compiler.TypeScriptServiceHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class JSXXmlAttributeRenameProvider
implements XmlUnknownAttributeQuickFixProvider {
    @NotNull
    public @NotNull Collection<@NotNull LocalQuickFix> getOrRegisterAttributeFixes(@NotNull XmlTag tag, @NotNull String name, ProblemsHolder holder, boolean isFixRequired) {
        if (tag == null) {
            JSXXmlAttributeRenameProvider.$$$reportNull$$$0(0);
        }
        if (name == null) {
            JSXXmlAttributeRenameProvider.$$$reportNull$$$0(1);
        }
        if (!isFixRequired) {
            List<LocalQuickFix> list = Collections.emptyList();
            if (list == null) {
                JSXXmlAttributeRenameProvider.$$$reportNull$$$0(2);
            }
            return list;
        }
        XmlElementDescriptor descriptor = tag.getDescriptor();
        if (descriptor == null) {
            List<LocalQuickFix> list = Collections.emptyList();
            if (list == null) {
                JSXXmlAttributeRenameProvider.$$$reportNull$$$0(3);
            }
            return list;
        }
        XmlAttributeDescriptor[] attrDescriptors = descriptor.getAttributesDescriptors(tag);
        ArrayList<LocalQuickFix> attributeFixes = new ArrayList<LocalQuickFix>();
        JSXXmlAttributeRenameProvider.addFixIfApplicable(name, attrDescriptors, "class", "className", attributeFixes);
        JSXXmlAttributeRenameProvider.addFixIfApplicable(name, attrDescriptors, "for", "htmlFor", attributeFixes);
        JSXXmlAttributeRenameProvider.addFixIfApplicable(name, attrDescriptors, "innerHTML", "dangerouslySetInnerHTML", attributeFixes);
        ArrayList<LocalQuickFix> arrayList = attributeFixes;
        if (arrayList == null) {
            JSXXmlAttributeRenameProvider.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    private static void addFixIfApplicable(@NotNull String attrName, XmlAttributeDescriptor[] attrDescriptors, @NotNull String attrNameToFix, @NotNull String attrNameFix, Collection<LocalQuickFix> attributeFixes) {
        if (attrName == null) {
            JSXXmlAttributeRenameProvider.$$$reportNull$$$0(5);
        }
        if (attrNameToFix == null) {
            JSXXmlAttributeRenameProvider.$$$reportNull$$$0(6);
        }
        if (attrNameFix == null) {
            JSXXmlAttributeRenameProvider.$$$reportNull$$$0(7);
        }
        if (!attrName.equals(attrNameToFix)) {
            return;
        }
        XmlAttributeDescriptor attributeFix = (XmlAttributeDescriptor)ContainerUtil.find((Object[])attrDescriptors, attrDescriptor -> attrDescriptor.getName().equals(attrNameFix));
        if (attributeFix != null) {
            attributeFixes.add((LocalQuickFix)new XmlAttributeRenameFix(attributeFix));
        }
    }

    @NotNull
    public ProblemHighlightType getProblemHighlightType(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            JSXXmlAttributeRenameProvider.$$$reportNull$$$0(8);
        }
        if (DialectDetector.isTypeScript(psiElement) && TypeScriptServiceHolder.getForElement(psiElement, null) != null) {
            ProblemHighlightType problemHighlightType = ProblemHighlightType.INFORMATION;
            if (problemHighlightType == null) {
                JSXXmlAttributeRenameProvider.$$$reportNull$$$0(9);
            }
            return problemHighlightType;
        }
        ProblemHighlightType problemHighlightType = ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
        if (problemHighlightType == null) {
            JSXXmlAttributeRenameProvider.$$$reportNull$$$0(10);
        }
        return problemHighlightType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 9, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/frameworks/jsx/JSXXmlAttributeRenameProvider";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attrName";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attrNameToFix";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attrNameFix";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/frameworks/jsx/JSXXmlAttributeRenameProvider";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrRegisterAttributeFixes";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getProblemHighlightType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getOrRegisterAttributeFixes";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 9: 
            case 10: {
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addFixIfApplicable";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getProblemHighlightType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 9, 10 -> new IllegalStateException(string);
        };
    }
}

