/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.jsx;

import com.intellij.codeInsight.editorActions.CopyPastePreProcessor;
import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.editor.ES6CopyPasteProcessorBase;
import com.intellij.lang.ecmascript6.editor.JSCopyPasteProcessorBase;
import com.intellij.lang.ecmascript6.psi.impl.JSimportUtilKt;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.editor.JSCopyPasteService;
import com.intellij.lang.javascript.editor.JSEditorOptions;
import com.intellij.lang.javascript.frameworks.jsx.JSXAttributeCustomMappingKt;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSXmlLiteralExpression;
import com.intellij.lang.javascript.psi.ecma6.impl.JSXXmlLiteralExpressionImpl;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RawText;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.util.CollapseTagIntention;
import com.intellij.xml.util.HtmlUtil;
import com.intellij.xml.util.XmlTagUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001)B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J*\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\u0005H\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J8\u0010\u000e\u001a\u00020\u00052\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u000b\u001a\u00020\u00052\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016J>\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aH\u0002J$\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u001e\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010 \u001a\u00020!H\u0002J\u0016\u0010\"\u001a\b\u0012\u0004\u0012\u00020#0\u001d2\u0006\u0010$\u001a\u00020\u001eH\u0002J$\u0010%\u001a\b\u0012\u0004\u0012\u00020&0\u001d2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010'\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\u0005H\u0002J\u0018\u0010(\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a8\u0006*"}, d2={"Lcom/intellij/lang/javascript/frameworks/jsx/JSXCopyPasteTagProcessor;", "Lcom/intellij/codeInsight/editorActions/CopyPastePreProcessor;", "<init>", "()V", "preprocessOnCopy", "", "file", "Lcom/intellij/psi/PsiFile;", "startOffsets", "", "endOffsets", "text", "isFileAcceptable", "", "preprocessOnPaste", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "rawText", "Lcom/intellij/openapi/editor/RawText;", "processAsync", "", "offset", "", "parentPointer", "Lcom/intellij/psi/SmartPsiElementPointer;", "Lcom/intellij/psi/PsiElement;", "collectSelfClosingTags", "", "Lcom/intellij/psi/xml/XmlTag;", "findAllXmlTagsInRange", "range", "Lcom/intellij/openapi/util/TextRange;", "collectAttributes", "Lcom/intellij/lang/javascript/frameworks/jsx/JSXCopyPasteTagProcessor$AttributeToReplace;", "tag", "collectExpressions", "Lcom/intellij/lang/javascript/psi/JSXmlLiteralExpression;", "isPossibleContentWithTag", "requiresAllDocumentsToBeCommitted", "AttributeToReplace", "intellij.javascript.impl"})
@SourceDebugExtension(value={"SMAP\nJSXCopyPasteTagProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JSXCopyPasteTagProcessor.kt\ncom/intellij/lang/javascript/frameworks/jsx/JSXCopyPasteTagProcessor\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 6 KtUtils.kt\ncom/intellij/util/KotlinUtils\n*L\n1#1,204:1\n31#2,2:205\n774#3:207\n865#3,2:208\n774#3:210\n865#3,2:211\n1863#3:213\n1864#3:220\n1611#3,9:221\n1863#3:230\n1864#3:232\n1620#3:233\n1454#3,2:236\n1456#3,3:251\n1598#3,4:254\n1863#3,2:258\n8634#4,2:214\n8894#4,4:216\n11476#4,9:238\n13402#4:247\n13403#4:249\n11485#4:250\n1#5:231\n1#5:234\n1#5:248\n19#6:235\n*S KotlinDebug\n*F\n+ 1 JSXCopyPasteTagProcessor.kt\ncom/intellij/lang/javascript/frameworks/jsx/JSXCopyPasteTagProcessor\n*L\n81#1:205,2\n138#1:207\n138#1:208,2\n148#1:210\n148#1:211,2\n161#1:213\n161#1:220\n189#1:221,9\n189#1:230\n189#1:232\n189#1:233\n109#1:236,2\n109#1:251,3\n118#1:254,4\n126#1:258,2\n165#1:214,2\n165#1:216,4\n110#1:238,9\n110#1:247\n110#1:249\n110#1:250\n189#1:231\n110#1:248\n92#1:235\n*E\n"})
public final class JSXCopyPasteTagProcessor
implements CopyPastePreProcessor {
    @Nullable
    public String preprocessOnCopy(@NotNull PsiFile file, @NotNull int[] startOffsets, @NotNull int[] endOffsets, @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)startOffsets, (String)"startOffsets");
        Intrinsics.checkNotNullParameter((Object)endOffsets, (String)"endOffsets");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return null;
    }

    private final boolean isFileAcceptable(PsiFile file) {
        return file instanceof JSFile || file instanceof XmlFile;
    }

    @NotNull
    public String preprocessOnPaste(@Nullable Project project, @Nullable PsiFile file, @Nullable Editor editor, @NotNull String text, @Nullable RawText rawText) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        if (project == null || file == null || !this.isFileAcceptable(file) || !JSEditorOptions.getInstance().CLOSE_HTML_SINGLE_TAGS && !JSEditorOptions.getInstance().CONVERT_HTML_TO_REACT || editor == null) {
            return text;
        }
        int offset = editor.getCaretModel().getOffset();
        PsiElement context2 = JSCopyPasteProcessorBase.Companion.getContextElementOrFile(file, offset);
        if (!DialectDetector.isJSX(context2) || ES6CopyPasteProcessorBase.Companion.isInvalidImportPasteContext(context2) || !this.isPossibleContentWithTag(text)) {
            return text;
        }
        SmartPsiElementPointer smartPsiElementPointer = SmartPointerManager.getInstance((Project)project).createSmartPsiElementPointer(context2.getParent(), file);
        Intrinsics.checkNotNullExpressionValue((Object)smartPsiElementPointer, (String)"createSmartPsiElementPointer(...)");
        SmartPsiElementPointer parentPointer = smartPsiElementPointer;
        this.processAsync(project, editor, text, file, offset, (SmartPsiElementPointer<PsiElement>)parentPointer);
        return text;
    }

    private final void processAsync(Project project, Editor editor, String text, PsiFile file, int offset, SmartPsiElementPointer<PsiElement> parentPointer) {
        JSEditorOptions jsEditorOptions = JSEditorOptions.getInstance();
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean $i$f$service = false;
        Class<JSCopyPasteService> serviceClass$iv = JSCopyPasteService.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        JSCopyPasteService jSCopyPasteService = (JSCopyPasteService)object;
        String string = JavaScriptBundle.message("jsx.convert.html.to.jsx.progress", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String string2 = JavaScriptBundle.message("jsx.convert.html.to.jsx.command.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        jSCopyPasteService.scheduleOnPasteProcessing(file, string, string2, () -> JSXCopyPasteTagProcessor.processAsync$lambda$9(project, file, offset, text, jsEditorOptions, this, parentPointer, editor), arg_0 -> JSXCopyPasteTagProcessor.processAsync$lambda$12(parentPointer, project, editor, file, text, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private final List<XmlTag> collectSelfClosingTags(SmartPsiElementPointer<PsiElement> parentPointer, PsiFile file) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        PsiElement psiElement = parentPointer.getElement();
        if (psiElement == null) {
            return CollectionsKt.emptyList();
        }
        PsiElement element = psiElement;
        TextRange textRange = element.getTextRange();
        if (textRange == null) {
            return CollectionsKt.emptyList();
        }
        TextRange textRange2 = textRange;
        Iterable iterable = this.findAllXmlTagsInRange(file, textRange2);
        boolean $i$f$filter = false;
        void var7_7 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            XmlTag it = (XmlTag)element$iv$iv;
            boolean bl = false;
            if (!(HtmlUtil.isSingleHtmlTag((XmlTag)it, (boolean)true) && !CollapseTagIntention.isAvailable((XmlTag)it) && XmlChildRole.EMPTY_TAG_END_FINDER.findChild(it.getNode()) == null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<XmlTag> findAllXmlTagsInRange(PsiFile file, TextRange range) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        PsiElement psiElement = JSimportUtilKt.getParentOfLine(file, range);
        if (psiElement == null) {
            return CollectionsKt.emptyList();
        }
        PsiElement parent = psiElement;
        Class[] classArray = new Class[]{XmlTag.class};
        Collection collection = PsiTreeUtil.findChildrenOfAnyType((PsiElement)parent, (boolean)false, (Class[])classArray);
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"findChildrenOfAnyType(...)");
        Iterable iterable = collection;
        boolean $i$f$filter = false;
        void var6_7 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            XmlTag it = (XmlTag)element$iv$iv;
            boolean bl = false;
            if (!range.intersects(it.getTextRange())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<AttributeToReplace> collectAttributes(XmlTag tag) {
        List list = SyntaxTraverser.psiTraverser((PsiElement)((PsiElement)tag)).traverse().filter(XmlTag.class).filter(arg_0 -> JSXCopyPasteTagProcessor.collectAttributes$lambda$16(JSXCopyPasteTagProcessor::collectAttributes$lambda$15, arg_0)).sort(new Comparator(){

            public final int compare(T a, T b) {
                XmlTag it = (XmlTag)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getTextOffset());
                it = (XmlTag)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getTextOffset()));
            }
        }).toList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"toList(...)");
        List tagList = list;
        if (tagList.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        List result2 = new ArrayList();
        Iterable $this$forEach$iv = tagList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$associateByTo$iv$iv;
            XmlElementDescriptor tagDescriptor;
            XmlTag nestedTag = (XmlTag)element$iv;
            boolean bl = false;
            if (nestedTag.getDescriptor() == null) continue;
            XmlAttributeDescriptor[] attributesDescriptors = tagDescriptor.getAttributesDescriptors(nestedTag);
            Intrinsics.checkNotNull((Object)attributesDescriptors);
            XmlAttributeDescriptor[] $this$associateBy$iv = attributesDescriptors;
            boolean $i$f$associateBy = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)$this$associateBy$iv.length), (int)16);
            XmlAttributeDescriptor[] xmlAttributeDescriptorArray = $this$associateBy$iv;
            Map map2 = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateByTo = false;
            int n = ((void)$this$associateByTo$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                String string;
                void it;
                void element$iv$iv;
                void var21_26 = element$iv$iv = $this$associateByTo$iv$iv[i];
                Map map3 = map2;
                boolean bl2 = false;
                Intrinsics.checkNotNullExpressionValue((Object)it.getName(), (String)"getName(...)");
                Locale locale = Locale.ENGLISH;
                Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ENGLISH");
                String string2 = string.toLowerCase(locale);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
                map3.put(string2, element$iv$iv);
            }
            Map namesFromTag = map2;
            for (XmlAttribute xmlAttribute : nestedTag.getAttributes()) {
                String string;
                Intrinsics.checkNotNull((Object)xmlAttribute);
                XmlAttribute attribute = xmlAttribute;
                Intrinsics.checkNotNullExpressionValue((Object)attribute.getName(), (String)"getName(...)");
                String string3 = string;
                Locale locale = Locale.ENGLISH;
                Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ENGLISH");
                String string4 = string3.toLowerCase(locale);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
                XmlAttributeDescriptor descriptor = (XmlAttributeDescriptor)namesFromTag.get(string4);
                if (descriptor == null) {
                    String mappedName = JSXAttributeCustomMappingKt.getMappedAttribute(string);
                    if (mappedName == null) continue;
                    result2.add(new AttributeToReplace(attribute, mappedName));
                    continue;
                }
                if (Intrinsics.areEqual((Object)descriptor.getName(), (Object)string)) continue;
                String string5 = descriptor.getName();
                String string6 = descriptor.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"getName(...)");
                string3 = string6;
                Locale locale2 = Locale.ENGLISH;
                Intrinsics.checkNotNullExpressionValue((Object)locale2, (String)"ENGLISH");
                String string7 = string3.toLowerCase(locale2);
                Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"toLowerCase(...)");
                if (Intrinsics.areEqual((Object)string5, (Object)string7)) continue;
                String string8 = descriptor.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"getName(...)");
                result2.add(new AttributeToReplace(attribute, string8));
            }
        }
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    private final List<JSXmlLiteralExpression> collectExpressions(SmartPsiElementPointer<PsiElement> parentPointer, PsiFile file) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        PsiElement psiElement = parentPointer.getElement();
        if (psiElement == null) {
            return CollectionsKt.emptyList();
        }
        PsiElement element = psiElement;
        TextRange textRange = element.getTextRange();
        if (textRange == null) {
            return CollectionsKt.emptyList();
        }
        TextRange textRange2 = textRange;
        Iterable iterable = JSimportUtilKt.findAllExpressionsInRange(file, textRange2);
        boolean $i$f$mapNotNull = false;
        void var7_7 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            JSXXmlLiteralExpressionImpl it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            JSExpression it = (JSExpression)element$iv$iv;
            boolean bl2 = false;
            if ((it instanceof JSXXmlLiteralExpressionImpl ? (JSXXmlLiteralExpressionImpl)it : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final boolean isPossibleContentWithTag(String text) {
        String trimmedText = ((Object)StringsKt.trim((CharSequence)text)).toString();
        if (!StringsKt.startsWith$default((String)trimmedText, (String)"<", (boolean)false, (int)2, null) || !StringsKt.endsWith$default((String)trimmedText, (String)">", (boolean)false, (int)2, null)) {
            return false;
        }
        char firstLetter = trimmedText.charAt(1);
        return Character.isLetter(firstLetter) && Character.isLowerCase(firstLetter);
    }

    public boolean requiresAllDocumentsToBeCommitted(@NotNull Editor editor, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return false;
    }

    private static final Unit processAsync$lambda$9$lambda$4$lambda$3$lambda$2$lambda$1(XmlAttribute $attribute, AttributeToReplace $it) {
        $attribute.setName($it.getNewName());
        return Unit.INSTANCE;
    }

    private static final Unit processAsync$lambda$9$lambda$5(Project $project, Editor $editor) {
        PsiDocumentManager.getInstance((Project)$project).doPostponedOperationsAndUnblockDocument($editor.getDocument());
        return Unit.INSTANCE;
    }

    private static final Unit processAsync$lambda$9$lambda$8$lambda$7(XmlTag $element, Editor $editor, int $index) {
        block0: {
            TextRange textRange = XmlTagUtil.getStartTagRange((XmlTag)$element);
            if (textRange == null) break block0;
            TextRange it = textRange;
            boolean bl = false;
            $editor.getDocument().replaceString(it.getEndOffset() - 1 + $index, it.getEndOffset() + $index, (CharSequence)"/>");
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final List processAsync$lambda$9(Project $project, PsiFile $file, int $offset, String $text, JSEditorOptions $jsEditorOptions, JSXCopyPasteTagProcessor this$0, SmartPsiElementPointer $parentPointer, Editor $editor) {
        int $i$f$mapNotNull;
        XmlTag $this$mapNotNull$iv;
        if ($project.isDisposed()) {
            return CollectionsKt.emptyList();
        }
        PsiElement newContext = JSCopyPasteProcessorBase.Companion.getContextElementOrFile($file, $offset);
        ASTNode aSTNode = JSChangeUtil.createStatementFromTextWithContext("<>" + $text + "</>", newContext);
        if (aSTNode == null || (aSTNode = aSTNode.getPsi()) == null) {
            return CollectionsKt.emptyList();
        }
        ASTNode parentStatement = aSTNode;
        PsiElement $this$asSafely$iv = parentStatement.getFirstChild();
        boolean $i$f$asSafely = false;
        PsiElement psiElement = $this$asSafely$iv;
        if (!(psiElement instanceof JSXmlLiteralExpression)) {
            psiElement = null;
        }
        JSXmlLiteralExpression jSXmlLiteralExpression = (JSXmlLiteralExpression)psiElement;
        if (jSXmlLiteralExpression == null) {
            return CollectionsKt.emptyList();
        }
        JSXmlLiteralExpression fragmentCandidate = jSXmlLiteralExpression;
        if (PsiTreeUtil.getChildOfType((PsiElement)((PsiElement)fragmentCandidate), PsiErrorElement.class) != null) {
            return CollectionsKt.emptyList();
        }
        Pair pair = $jsEditorOptions.CONVERT_HTML_TO_REACT ? new Pair(this$0.collectAttributes((XmlTag)fragmentCandidate), this$0.collectExpressions((SmartPsiElementPointer<PsiElement>)$parentPointer, $file)) : new Pair((Object)CollectionsKt.emptyList(), (Object)CollectionsKt.emptyList());
        List attributesToReplace = (List)pair.component1();
        List expressions = (List)pair.component2();
        List<XmlTag> selfClosingTags = $jsEditorOptions.CLOSE_HTML_SINGLE_TAGS ? this$0.collectSelfClosingTags((SmartPsiElementPointer<PsiElement>)$parentPointer, $file) : CollectionsKt.emptyList();
        List actions = new ArrayList();
        Iterable $this$flatMapTo$iv = expressions;
        boolean $i$f$flatMapTo = false;
        for (Object element$iv : $this$flatMapTo$iv) {
            void $this$mapNotNullTo$iv$iv;
            JSXmlLiteralExpression expression = (JSXmlLiteralExpression)element$iv;
            boolean bl = false;
            XmlAttribute[] xmlAttributeArray = expression.getAttributes();
            Intrinsics.checkNotNullExpressionValue((Object)xmlAttributeArray, (String)"getAttributes(...)");
            $this$mapNotNull$iv = (XmlTag)xmlAttributeArray;
            $i$f$mapNotNull = 0;
            XmlTag xmlTag = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            int n = ((void)$this$forEach$iv$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                Function0 function0;
                Object v4;
                XmlAttribute attribute;
                block13: {
                    void element$iv$iv$iv;
                    void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
                    boolean bl2 = false;
                    attribute = (XmlAttribute)element$iv$iv;
                    boolean bl3 = false;
                    Iterable iterable = attributesToReplace;
                    for (Object t : iterable) {
                        AttributeToReplace it = (AttributeToReplace)t;
                        boolean bl4 = false;
                        if (!(Intrinsics.areEqual((Object)it.getOldName(), (Object)attribute.getName()) && Intrinsics.areEqual((Object)it.getTagName(), (Object)attribute.getParent().getName()))) continue;
                        v4 = t;
                        break block13;
                    }
                    v4 = null;
                }
                AttributeToReplace attributeToReplace = v4;
                if (attributeToReplace != null) {
                    AttributeToReplace it = attributeToReplace;
                    boolean bl5 = false;
                    function0 = () -> JSXCopyPasteTagProcessor.processAsync$lambda$9$lambda$4$lambda$3$lambda$2$lambda$1(attribute, it);
                } else {
                    function0 = null;
                }
                if (function0 == null) continue;
                Function0 it$iv$iv = function0;
                boolean bl6 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            Iterable list$iv = (List)destination$iv$iv;
            CollectionsKt.addAll((Collection)actions, (Iterable)list$iv);
        }
        if (!((Collection)actions).isEmpty()) {
            actions.add(() -> JSXCopyPasteTagProcessor.processAsync$lambda$9$lambda$5($project, $editor));
        }
        Iterable $this$mapIndexedTo$iv = selfClosingTags;
        boolean $i$f$mapIndexedTo = false;
        int index$iv = 0;
        for (Object item$iv : $this$mapIndexedTo$iv) {
            void index;
            void element;
            int n;
            Collection collection = actions;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            $this$mapNotNull$iv = (XmlTag)item$iv;
            $i$f$mapNotNull = n;
            Collection collection2 = collection;
            boolean bl = false;
            collection2.add(() -> JSXCopyPasteTagProcessor.processAsync$lambda$9$lambda$8$lambda$7((XmlTag)element, $editor, (int)index));
        }
        return actions;
    }

    private static final Unit processAsync$lambda$12(SmartPsiElementPointer $parentPointer, Project $project, Editor $editor, PsiFile $file, String $text, List actions) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)actions, (String)"actions");
            Iterable $this$forEach$iv = actions;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Function0 it = (Function0)element$iv;
                boolean bl = false;
                it.invoke();
            }
            PsiElement psiElement = $parentPointer.getElement();
            if (psiElement == null || (psiElement = psiElement.getTextRange()) == null) break block1;
            PsiElement it = psiElement;
            boolean bl = false;
            PsiDocumentManager.getInstance((Project)$project).commitDocument($editor.getDocument());
            CodeStyleManager.getInstance((Project)$project).reformatText($file, it.getStartOffset(), it.getEndOffset() + $text.length());
        }
        return Unit.INSTANCE;
    }

    private static final boolean collectAttributes$lambda$15(XmlTag it) {
        String string = it.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return !(((CharSequence)string).length() == 0) && Character.isLowerCase(it.getName().charAt(0));
    }

    private static final boolean collectAttributes$lambda$16(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001b\u0010\n\u001a\f0\u0005\u00a2\u0006\u0002\b\u000b\u00a2\u0006\u0002\b\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\tR\u001b\u0010\u000e\u001a\f0\u0005\u00a2\u0006\u0002\b\f\u00a2\u0006\u0002\b\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\t\u00a8\u0006\u0010"}, d2={"Lcom/intellij/lang/javascript/frameworks/jsx/JSXCopyPasteTagProcessor$AttributeToReplace;", "", "attribute", "Lcom/intellij/psi/xml/XmlAttribute;", "newName", "", "<init>", "(Lcom/intellij/psi/xml/XmlAttribute;Ljava/lang/String;)V", "getNewName", "()Ljava/lang/String;", "oldName", "Lcom/intellij/openapi/util/NlsSafe;", "Lorg/jetbrains/annotations/NotNull;", "getOldName", "tagName", "getTagName", "intellij.javascript.impl"})
    public static final class AttributeToReplace {
        @NotNull
        private final String newName;
        @NotNull
        private final String oldName;
        @NotNull
        private final String tagName;

        public AttributeToReplace(@NotNull XmlAttribute attribute, @NotNull String newName) {
            Intrinsics.checkNotNullParameter((Object)attribute, (String)"attribute");
            Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
            this.newName = newName;
            String string = attribute.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            this.oldName = string;
            String string2 = attribute.getParent().getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
            this.tagName = string2;
        }

        @NotNull
        public final String getNewName() {
            return this.newName;
        }

        @NotNull
        public final String getOldName() {
            return this.oldName;
        }

        @NotNull
        public final String getTagName() {
            return this.tagName;
        }
    }
}

