/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.dialects;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.dialects.JSLanguageLevel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/lang/javascript/dialects/JSLanguageLevelDetector;", "", "<init>", "()V", "languageLevelOfElement", "Lcom/intellij/lang/javascript/dialects/JSLanguageLevel;", "element", "Lcom/intellij/psi/PsiElement;", "intellij.javascript.psi.impl"})
public final class JSLanguageLevelDetector {
    @NotNull
    public static final JSLanguageLevelDetector INSTANCE = new JSLanguageLevelDetector();

    private JSLanguageLevelDetector() {
    }

    @JvmStatic
    @Nullable
    public static final JSLanguageLevel languageLevelOfElement(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        JSLanguageDialect dialect = DialectDetector.languageDialectOfElement(element);
        if (dialect == null || !dialect.getOptionHolder().isJavaScript()) {
            return null;
        }
        PsiFile psiFile = element.getContainingFile();
        Project project = element.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        JSLanguageLevel level = DialectDetector.getConfiguredJSLevel(psiFile, project);
        if (level.getDialect().isAtLeast(dialect)) {
            return level;
        }
        return JSLanguageLevel.Companion.ofDialect(dialect);
    }
}

