/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.testing;

import com.intellij.javascript.nodejs.execution.NodeTargetRun;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.wsl.WslNodeInterpreter;
import com.intellij.javascript.testFramework.coverage.CoverageSerializationUtils;
import com.intellij.javascript.testFramework.coverage.LcovCoverageReport;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.OSAgnosticPathUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.rt.coverage.data.ClassData;
import com.intellij.rt.coverage.data.LineData;
import com.intellij.rt.coverage.data.ProjectData;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CoverageProjectDataLoader {
    private static final Logger LOG = Logger.getInstance(CoverageProjectDataLoader.class);

    @NotNull
    public static ProjectData readProjectData(@NotNull Path lcovFile, @NotNull Path localBaseDir, @Nullable NodeTargetRun targetRun) throws IOException {
        if (lcovFile == null) {
            CoverageProjectDataLoader.$$$reportNull$$$0(0);
        }
        if (localBaseDir == null) {
            CoverageProjectDataLoader.$$$reportNull$$$0(1);
        }
        ProjectData projectData = new ProjectData();
        LcovCoverageReport report = CoverageSerializationUtils.readLCOV(lcovFile, localBaseDir, path2 -> {
            NodeJsInterpreter resultInterpreter;
            String localPath = path2;
            if (targetRun != null) {
                try {
                    localPath = targetRun.convertTargetPathToLocalPath((String)path2);
                }
                catch (IllegalArgumentException e) {
                    LOG.info((Throwable)e);
                }
            }
            NodeJsInterpreter nodeJsInterpreter = resultInterpreter = targetRun != null ? targetRun.getInterpreter() : null;
            if (resultInterpreter instanceof WslNodeInterpreter) {
                localPath = CoverageProjectDataLoader.driveLetterToUpperCase(localPath);
            }
            return localPath;
        });
        String targetBaseDir = CoverageProjectDataLoader.dereferenceBasePath(localBaseDir);
        for (Map.Entry<String, List<LcovCoverageReport.LineHits>> entry : report.getInfo().entrySet()) {
            String filePath = entry.getKey();
            ClassData classData = projectData.getOrCreateClassData(CoverageProjectDataLoader.getQualifiedName(filePath));
            int max = 0;
            List<LcovCoverageReport.LineHits> lineHitsList = entry.getValue();
            if (!lineHitsList.isEmpty()) {
                LcovCoverageReport.LineHits lastLineHits = lineHitsList.get(lineHitsList.size() - 1);
                max = lastLineHits.getLineNumber();
            }
            LineData[] lines = new LineData[max + 1];
            for (LcovCoverageReport.LineHits lineHits : lineHitsList) {
                LineData lineData = new LineData(lineHits.getLineNumber(), null);
                lineData.setHits(lineHits.getHits());
                lines[lineHits.getLineNumber()] = lineData;
            }
            classData.setLines(lines);
            if (targetBaseDir == null || !filePath.startsWith(targetBaseDir)) continue;
            Path fileInsideBasePath = localBaseDir.resolve(filePath.substring(targetBaseDir.length()));
            ClassData classData2 = projectData.getOrCreateClassData(fileInsideBasePath.toString());
            classData2.setLines(lines);
        }
        ProjectData projectData2 = projectData;
        if (projectData2 == null) {
            CoverageProjectDataLoader.$$$reportNull$$$0(2);
        }
        return projectData2;
    }

    @Nullable
    private static String dereferenceBasePath(@NotNull Path file) {
        if (file == null) {
            CoverageProjectDataLoader.$$$reportNull$$$0(3);
        }
        String path2 = FileUtil.toSystemIndependentName((String)file.toString());
        try {
            Path canonicalFile = file.toRealPath(new LinkOption[0]);
            String canonicalPath = FileUtil.toSystemIndependentName((String)canonicalFile.toString());
            if (!canonicalPath.equals(path2)) {
                return StringUtil.trimEnd((String)canonicalPath, (char)'/') + "/";
            }
        }
        catch (IOException e) {
            LOG.warn("Failed to dereference " + path2, (Throwable)e);
        }
        return null;
    }

    @NotNull
    private static String getQualifiedName(@NotNull String filePath) {
        if (filePath == null) {
            CoverageProjectDataLoader.$$$reportNull$$$0(4);
        }
        String string = FileUtil.toSystemIndependentName((String)filePath);
        if (string == null) {
            CoverageProjectDataLoader.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    private static String driveLetterToUpperCase(@NotNull String path2) {
        if (path2 == null) {
            CoverageProjectDataLoader.$$$reportNull$$$0(6);
        }
        if (SystemInfo.isWindows && OSAgnosticPathUtil.isAbsoluteDosPath((String)path2)) {
            String string = Character.toUpperCase(path2.charAt(0)) + path2.substring(1);
            if (string == null) {
                CoverageProjectDataLoader.$$$reportNull$$$0(7);
            }
            return string;
        }
        String string = path2;
        if (string == null) {
            CoverageProjectDataLoader.$$$reportNull$$$0(8);
        }
        return string;
    }

    @Nullable
    public static Path guessBaseDir(@NotNull Path lcovFile, @Nullable Project project) {
        LcovCoverageReport report;
        if (lcovFile == null) {
            CoverageProjectDataLoader.$$$reportNull$$$0(9);
        }
        if (project == null) {
            LOG.warn("Cannot guess baseDir for null project=");
            return null;
        }
        try {
            report = CoverageSerializationUtils.readLCOV(lcovFile, null, Function.identity());
        }
        catch (IOException e) {
            LOG.warn("Cannot guess baseDir", (Throwable)e);
            return null;
        }
        List<String> relativePaths = report.getInfo().keySet().stream().filter(path2 -> !FileUtil.isAbsolute((String)path2)).toList();
        if (relativePaths.isEmpty()) {
            VirtualFile projectRoot = (VirtualFile)ReadAction.compute(() -> ProjectUtil.guessProjectDir((Project)project));
            return projectRoot != null ? projectRoot.toNioPath() : null;
        }
        List contentRoots = (List)ReadAction.compute(() -> List.of(ProjectRootManager.getInstance((Project)project).getContentRoots()));
        VirtualFile contentRoot = (VirtualFile)ContainerUtil.find((Iterable)contentRoots, root -> ContainerUtil.and((Iterable)relativePaths, relativePath -> root.findFileByRelativePath(relativePath) != null));
        return contentRoot != null ? contentRoot.toNioPath() : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 5, 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lcovFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localBaseDir";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/testing/CoverageProjectDataLoader";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/testing/CoverageProjectDataLoader";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "readProjectData";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifiedName";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "driveLetterToUpperCase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "readProjectData";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 8: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "dereferenceBasePath";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getQualifiedName";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "driveLetterToUpperCase";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "guessBaseDir";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 5, 7, 8 -> new IllegalStateException(string);
        };
    }
}

