/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.settings;

import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterField;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterRef;
import com.intellij.javascript.nodejs.npm.NpmUtil;
import com.intellij.javascript.nodejs.settings.NodeCoreSourcesView;
import com.intellij.javascript.nodejs.settings.NodeVersionListener;
import com.intellij.javascript.nodejs.util.NodePackageField;
import com.intellij.javascript.nodejs.util.NodePackageRef;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.NullableConsumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.SemVer;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.Component;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodeSettingsView {
    private final NodeJsInterpreterField myNodeInterpreterField;
    private final NodePackageField myPmPackageField;
    private final JComponent myComponent;
    private final List<NodeVersionListener> myVersionListeners;

    public NodeSettingsView(@NotNull Project project, @Nullable VirtualFile requestor) {
        if (project == null) {
            NodeSettingsView.$$$reportNull$$$0(0);
        }
        this.myVersionListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myNodeInterpreterField = new NodeJsInterpreterField(project){

            @Override
            public boolean isDefaultProjectInterpreterField() {
                return true;
            }
        };
        this.myPmPackageField = NpmUtil.createPackageManagerPackageField(this.myNodeInterpreterField, true);
        FormBuilder formBuilder = FormBuilder.createFormBuilder().setAlignLabelOnRight(false);
        formBuilder.addLabeledComponent(NodeJsInterpreterField.getLabelTextForComponent(), (JComponent)((Object)this.myNodeInterpreterField));
        NodeCoreSourcesView nodeCoreSourcesView = new NodeCoreSourcesView(project, requestor);
        formBuilder.addComponent(nodeCoreSourcesView.getComponent(), 4);
        formBuilder.addLabeledComponent(NpmUtil.getPackageManagerPackageFieldLabelText(), (JComponent)((Object)this.myPmPackageField), 8);
        this.myVersionListeners.add(nodeCoreSourcesView);
        JPanel bottomComponent = new JPanel();
        formBuilder.addComponentFillVertically((JComponent)bottomComponent, 4);
        this.myComponent = formBuilder.getPanel();
        this.listenForNodeInterpreterPathUpdate();
    }

    private void listenForNodeInterpreterPathUpdate() {
        this.myNodeInterpreterField.addChangeListener(this::handleNodeInterpreterChange);
    }

    private void handleNodeInterpreterChange(@Nullable NodeJsInterpreter newInterpreter) {
        if (newInterpreter == null) {
            this.fireVersionUpdated(null, null);
            return;
        }
        Ref<SemVer> versionRef = newInterpreter.getCachedVersion();
        if (versionRef != null) {
            this.fireVersionUpdated(newInterpreter, (SemVer)versionRef.get());
            return;
        }
        UiNotifyConnector.doWhenFirstShown((JComponent)this.myComponent, () -> {
            this.fireUpdateStarted();
            ModalityState modalityState = ModalityState.stateForComponent((Component)this.myComponent);
            newInterpreter.fetchVersion((NullableConsumer<? super SemVer>)((NullableConsumer)version2 -> ApplicationManager.getApplication().invokeLater(() -> {
                if (this.myComponent.isShowing()) {
                    this.fireVersionUpdated(newInterpreter, (SemVer)version2);
                }
            }, modalityState, this.myNodeInterpreterField.getProject().getDisposed())));
        });
    }

    private void fireUpdateStarted() {
        for (NodeVersionListener listener2 : this.myVersionListeners) {
            listener2.versionUpdateStarted();
        }
    }

    private void fireVersionUpdated(@Nullable NodeJsInterpreter interpreter2, @Nullable SemVer version2) {
        for (NodeVersionListener listener2 : this.myVersionListeners) {
            listener2.versionUpdated(interpreter2, version2);
        }
    }

    public void setInterpreterRef(@NotNull NodeJsInterpreterRef interpreterRef) {
        if (interpreterRef == null) {
            NodeSettingsView.$$$reportNull$$$0(1);
        }
        this.myNodeInterpreterField.setInterpreterRef(interpreterRef);
    }

    public void setPackageManagerPackageRef(@NotNull NodePackageRef packageRef) {
        if (packageRef == null) {
            NodeSettingsView.$$$reportNull$$$0(2);
        }
        this.myPmPackageField.setSelectedRef(packageRef);
    }

    @NotNull
    public NodeJsInterpreterRef getInterpreterRef() {
        NodeJsInterpreterRef nodeJsInterpreterRef = this.myNodeInterpreterField.getInterpreterRef();
        if (nodeJsInterpreterRef == null) {
            NodeSettingsView.$$$reportNull$$$0(3);
        }
        return nodeJsInterpreterRef;
    }

    @NotNull
    public NodePackageRef getPackageManagerPackageRef() {
        NodePackageRef nodePackageRef = this.myPmPackageField.getSelectedRef();
        if (nodePackageRef == null) {
            NodeSettingsView.$$$reportNull$$$0(4);
        }
        return nodePackageRef;
    }

    @NotNull
    public JComponent getComponent() {
        JComponent jComponent = this.myComponent;
        if (jComponent == null) {
            NodeSettingsView.$$$reportNull$$$0(5);
        }
        return jComponent;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreterRef";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageRef";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/settings/NodeSettingsView";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/settings/NodeSettingsView";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getInterpreterRef";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackageManagerPackageRef";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setInterpreterRef";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setPackageManagerPackageRef";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5 -> new IllegalStateException(string);
        };
    }
}

