/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.sshAgentProxy;

import com.intellij.community.wintools.ErrorToolsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.codeWithMe.model.SshRequesterProcessInfo;
import com.jetbrains.rdserver.actions.ActionTimestamp;
import com.jetbrains.rdserver.portForwarding.utils.ProcessInfoUtil;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpc;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpcService;
import com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.win32.W32APIOptions;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 '2\u00020\u0001:\u0005&'()*B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0012H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0006\u0010\u0019\u001a\u00020\u001aJ\u0010\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u001dH\u0014J\b\u0010#\u001a\u00020\u0012H\u0002J\b\u0010$\u001a\u00020\u0012H\u0016J\b\u0010%\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0016R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\u00020\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u0006+"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc;", "pipePath", "", "WindowsNamedPipeAgentIpc", "(Ljava/lang/String;)V", "key", "getKey", "()Ljava/lang/String;", "hPipe", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lock", "", "connectionThread", "Ljava/lang/Thread;", "state", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "assertConnectionThread", "", "open", "isOpen", "", "()Z", "accept", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc$Streams;", "getRequesterPid", "", "isSshProcess", "process", "Lcom/jetbrains/rdserver/portForwarding/utils/ProcessInfoUtil$ProcessInfo;", "requestorProcessValue", "Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "requesterProcessInfo", "getRequesterProcessInfo", "()Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "disconnect", "close", "cleanup", "NamedPipeState", "Companion", "Kernel32Ex", "PipeReadableByteChannel", "PipeWritableByteChannel", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n1#2:392\n25#3:393\n25#3:394\n25#3:395\n25#3:396\n25#3:397\n25#3:398\n25#3:399\n25#3:400\n25#3:401\n25#3:402\n25#3:403\n25#3:404\n25#3:405\n25#3:406\n25#3:407\n25#3:408\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n*L\n131#1:393\n142#1:394\n151#1:395\n161#1:396\n179#1:397\n203#1:398\n208#1:399\n228#1:400\n236#1:401\n238#1:402\n249#1:403\n264#1:404\n274#1:405\n284#1:406\n288#1:407\n290#1:408\n*E\n"})
public final class WindowsNamedPipeAgentIpc
extends SshAgentIpc {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final String pipePath;
    @NotNull
    private final String key;
    @NotNull
    private WinNT.HANDLE hPipe;
    @NotNull
    private final Object lock;
    @Nullable
    private Thread connectionThread;
    @NotNull
    private NamedPipeState state;
    @NotNull
    private SshRequesterProcessInfo requestorProcessValue;
    private static final String[] c;
    private static final String[] d;

    public WindowsNamedPipeAgentIpc(@NotNull String pipePath) {
        long l2 = 75457102523624L;
        Intrinsics.checkNotNullParameter((Object)pipePath, (String)WindowsNamedPipeAgentIpc.b(-1177926090 - -26012, 1177926090 - (char)-27196, (int)l2));
        this.key = this.pipePath = pipePath;
        WinNT.HANDLE hANDLE = WinNT.INVALID_HANDLE_VALUE;
        Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(-1177926090 - -26013, 1177926090 - 31912, (int)l2));
        this.hPipe = hANDLE;
        this.lock = new Object();
        this.state = NamedPipeState.Initial;
        this.requestorProcessValue = SshAgentIpc.Companion.getMissingProcessInfo();
    }

    @Override
    @NotNull
    public String getKey() {
        return this.key;
    }

    private final void assertConnectionThread() {
        block3: {
            boolean bl;
            Thread thread;
            long l2;
            block2: {
                l2 = 16084675445457L;
                thread = Thread.currentThread();
                ActionTimestamp[] actionTimestampArray = SshAgentIpcService.m();
                try {
                    bl = Intrinsics.areEqual((Object)thread, (Object)this.connectionThread);
                    if (actionTimestampArray != null) break block2;
                    if (bl) break block3;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                bl = false;
            }
            boolean bl2 = bl;
            Thread thread2 = thread;
            Thread thread3 = this.connectionThread;
            String string = this.pipePath;
            String string2 = WindowsNamedPipeAgentIpc.b(22937250 - 14521, -22937250 - -5059, (int)l2) + string + WindowsNamedPipeAgentIpc.b(22937250 - 14522, 22937250 - 11592, (int)l2) + thread3 + WindowsNamedPipeAgentIpc.b(22937250 - 14515, -22937250 - -22879, (int)l2) + thread2;
            throw new IllegalArgumentException(string2.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() {
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
        long l2;
        block14: {
            block15: {
                ActionTimestamp[] actionTimestampArray;
                l2 = 91645627325517L;
                Object object = this.lock;
                synchronized (object) {
                    boolean bl;
                    actionTimestampArray = SshAgentIpcService.m();
                    boolean bl2 = false;
                    try {
                        bl = this.connectionThread == null;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl3 = false;
                        String string = WindowsNamedPipeAgentIpc.b(-384821520 + -15230, 384821520 + 21279, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-384821520 + -15231, -384821520 + -7938, (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.connectionThread = Thread.currentThread();
                    Unit unit = Unit.INSTANCE;
                }
                try {
                    try {
                        this.hPipe = Kernel32.INSTANCE.CreateNamedPipe(this.pipePath, 3, 0, 1, 16384, 16384, 0, null);
                        windowsNamedPipeAgentIpc = this;
                        if (actionTimestampArray != null) break block14;
                        if (Intrinsics.areEqual((Object)windowsNamedPipeAgentIpc.hPipe, (Object)WinNT.INVALID_HANDLE_VALUE)) {
                        }
                        break block15;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    throw new RuntimeException(WindowsNamedPipeAgentIpc.b(-384821520 + -15232, -384821520 + -7917, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-384821520 + -15217, 384821520 + (char)-32369, (int)l2) + ErrorToolsKt.kernel32LastError());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
            }
            this.state = NamedPipeState.Open;
            windowsNamedPipeAgentIpc = this;
        }
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = windowsNamedPipeAgentIpc;
        boolean bl = false;
        try {
            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-384821520 + -15218, -384821520 + -28676, (int)l2));
            logger.info(WindowsNamedPipeAgentIpc.b(-384821520 + -15232, -384821520 + -7917, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-384821520 + -15219, 384821520 + 13465, (int)l2));
            if (ActionTimestamp.m() == null) {
                SshAgentIpcService.m(new ActionTimestamp[1]);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
        }
    }

    @Override
    public boolean isOpen() {
        int n2;
        block8: {
            block7: {
                ActionTimestamp[] actionTimestampArray;
                block6: {
                    long l2 = 82316748628616L;
                    actionTimestampArray = SshAgentIpcService.m();
                    try {
                        try {
                            n2 = this.state.compareTo((Enum)NamedPipeState.Open);
                            if (actionTimestampArray != null) break block6;
                            if (n2 < 0) break block7;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n2 = this.state.compareTo((Enum)NamedPipeState.Disconnecting);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                try {
                    if (actionTimestampArray != null) break block8;
                    if (n2 > 0) break block7;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                n2 = 1;
                break block8;
            }
            n2 = 0;
        }
        return n2 != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    @NotNull
    public SshAgentIpc.Streams accept() {
        SshAgentIpc.Streams streams;
        Object object;
        Object object2;
        ActionTimestamp[] actionTimestampArray;
        long l2;
        block27: {
            block28: {
                l2 = 13357406278079L;
                this.assertConnectionThread();
                Object object3 = this.lock;
                synchronized (object3) {
                    boolean bl;
                    NamedPipeState namedPipeState;
                    NamedPipeState namedPipeState2;
                    block25: {
                        block26: {
                            actionTimestampArray = SshAgentIpcService.m();
                            boolean bl2 = false;
                            try {
                                namedPipeState2 = this.state;
                                namedPipeState = NamedPipeState.Closing;
                                if (actionTimestampArray != null) break block25;
                                if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block26;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                            boolean bl3 = false;
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(57932940 + (char)-9726, 57932940 + (char)-8698, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(57932940 + (char)-9738, 57932940 + (char)-1691, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(57932940 + (char)-9731, -57932940 + -((char)-29458), (int)l2) + this.state);
                            throw new ClosedChannelException();
                        }
                        namedPipeState2 = this.state;
                        namedPipeState = NamedPipeState.Open;
                    }
                    try {
                        bl = namedPipeState2 == namedPipeState;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl4 = false;
                        String string = WindowsNamedPipeAgentIpc.b(57932940 + (char)-9738, 57932940 + (char)-1691, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(57932940 + (char)-9732, -57932940 + -((char)-25232), (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.state = NamedPipeState.Connecting;
                    Unit unit = Unit.INSTANCE;
                }
                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                boolean bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(57932940 + (char)-9726, 57932940 + (char)-8698, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(57932940 + (char)-9738, 57932940 + (char)-1691, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(57932940 + (char)-9729, -57932940 + -((char)-15691), (int)l2));
                    object2 = Kernel32.INSTANCE;
                    if (actionTimestampArray != null) break block27;
                    if (object2.ConnectNamedPipe(this.hPipe, null)) break block28;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                int n2 = Kernel32.INSTANCE.GetLastError();
                if (n2 == 535) {
                    WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                    boolean bl5 = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(57932940 + (char)-9726, 57932940 + (char)-8698, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(57932940 + (char)-9738, 57932940 + (char)-1691, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(57932940 + (char)-9730, 57932940 + (char)-27189, (int)l2));
                } else {
                    throw new IllegalStateException((WindowsNamedPipeAgentIpc.b(57932940 + (char)-9738, 57932940 + (char)-1691, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(57932940 + (char)-9719, -57932940 + -((char)-25814), (int)l2) + ErrorToolsKt.prettyHRESULT(n2)).toString());
                }
            }
            object2 = this.lock;
        }
        Kernel32 kernel32 = object2;
        synchronized (kernel32) {
            boolean bl;
            NamedPipeState namedPipeState;
            NamedPipeState namedPipeState3;
            block29: {
                block30: {
                    boolean bl6 = false;
                    namedPipeState3 = this.state;
                    namedPipeState = NamedPipeState.Closing;
                    if (actionTimestampArray != null) break block29;
                    try {
                        block31: {
                            if (namedPipeState3.compareTo((Enum)namedPipeState) < 0) break block30;
                            break block31;
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        throw new ClosedChannelException();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                namedPipeState3 = this.state;
                namedPipeState = NamedPipeState.Connecting;
            }
            try {
                bl = namedPipeState3 == namedPipeState;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
            }
            if (!bl) {
                boolean bl7 = false;
                String string = WindowsNamedPipeAgentIpc.b(57932940 + (char)-9738, 57932940 + (char)-1691, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(57932940 + (char)-9732, -57932940 + -((char)-25232), (int)l2) + this.state;
                throw new IllegalArgumentException(string.toString());
            }
            this.state = NamedPipeState.Connected;
            object = Unit.INSTANCE;
        }
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
        boolean bl = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(57932940 + (char)-9726, 57932940 + (char)-8698, (int)l2));
        logger.info(WindowsNamedPipeAgentIpc.b(57932940 + (char)-9738, 57932940 + (char)-1691, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(57932940 + (char)-9720, -57932940 + -((char)-14747), (int)l2));
        long l3 = this.getRequesterPid();
        this.requestorProcessValue = this.calcRequesterProcessInfo(l3);
        object = new PipeReadableByteChannel(this);
        PipeWritableByteChannel pipeWritableByteChannel = new PipeWritableByteChannel(this);
        try {
            streams = new SshAgentIpc.Streams((PipeReadableByteChannel)object, pipeWritableByteChannel, this){
                final /* synthetic */ PipeReadableByteChannel $read;
                final /* synthetic */ PipeWritableByteChannel $write;
                final /* synthetic */ WindowsNamedPipeAgentIpc this$0;
                private static final String[] a;
                private static final String[] b;
                {
                    this.$read = $read;
                    this.$write = $write;
                    this.this$0 = $receiver;
                }

                public InputStream getInputStream() {
                    long l2 = 119366875156774L;
                    InputStream inputStream = Channels.newInputStream(this.$read);
                    Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)accept.3.a(-1144110030 - -((char)-28000), -1144110030 - -32137, (int)l2));
                    return inputStream;
                }

                public OutputStream getOutputStream() {
                    long l2 = 70953046085207L;
                    OutputStream outputStream = Channels.newOutputStream(this.$write);
                    Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)accept.3.a(-186381540 - -16006, -186381540 - -8503, (int)l2));
                    return outputStream;
                }

                public void close() {
                    WindowsNamedPipeAgentIpc.access$disconnect(this.this$0);
                }

                /*
                 * Unable to fully structure code
                 */
                static {
                    block13: {
                        var5 = new String[2];
                        var3_1 = 0;
                        var2_2 = "\u0002\u001fh\u00d7\u009d\u00de\u00e6\u00e8\u0084oo\u0015\u0084\u0085\u00cc\u008ef\u00a0i\u0014\u00fa\u00d0w(e\u00e3\u0084\u00caJ-s\u0089\u00c5\u00ef%H\u00b6\u00bet!";
                        var4_3 = "\u0002\u001fh\u00d7\u009d\u00de\u00e6\u00e8\u0084oo\u0015\u0084\u0085\u00cc\u008ef\u00a0i\u0014\u00fa\u00d0w(e\u00e3\u0084\u00caJ-s\u0089\u00c5\u00ef%H\u00b6\u00bet!".length();
                        var1_4 = 19;
                        var0_5 = -1;
lbl7:
                        // 2 sources

                        while (true) {
                            continue;
                            break;
                        }
lbl9:
                        // 1 sources

                        while (true) {
                            var5[var3_1++] = new String(v0).intern();
                            if ((var0_5 += var1_4) < var4_3) {
                                var1_4 = var2_2.charAt(var0_5);
                                ** continue;
                            }
                            break block13;
                            break;
                        }
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                        v3 = v2.length;
                        var6_6 = 0;
                        v4 = 7;
                        v5 = v2;
                        v6 = v3;
                        if (v3 > 1) ** GOTO lbl67
                        do {
                            v7 = v4;
                            v5 = v5;
                            v8 = v5;
                            v9 = v4;
                            v10 = var6_6;
                            while (true) {
                                switch (var6_6 % 7) {
                                    case 0: {
                                        v11 = 112;
                                        break;
                                    }
                                    case 1: {
                                        v11 = 51;
                                        break;
                                    }
                                    case 2: {
                                        v11 = 21;
                                        break;
                                    }
                                    case 3: {
                                        v11 = 53;
                                        break;
                                    }
                                    case 4: {
                                        v11 = 34;
                                        break;
                                    }
                                    case 5: {
                                        v11 = 117;
                                        break;
                                    }
                                    default: {
                                        v11 = 32;
                                    }
                                }
                                v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                                ++var6_6;
                                v4 = v7;
                                if (v7 != 0) break;
                                v7 = v4;
                                v5 = v5;
                                v10 = v4;
                                v8 = v5;
                                v9 = v4;
                            }
lbl67:
                            // 2 sources

                            v0 = v5;
                            v6 = v6;
                        } while (v6 > var6_6);
                        ** while (true)
                    }
                    accept.3.a = var5;
                    accept.3.b = new String[2];
                }

                private static String a(int n2, int n3, int n4) {
                    int n5 = (n2 ^ n4 ^ 0xFFFFC7F4) & 0xFFFF;
                    if (b[n5] == null) {
                        int n6;
                        char[] cArray = a[n5].toCharArray();
                        int n7 = switch (cArray[0] & 0xFF) {
                            case 0 -> 49;
                            case 1 -> 123;
                            case 2 -> 224;
                            case 3 -> 237;
                            case 4 -> 114;
                            case 5 -> 79;
                            case 6 -> 148;
                            case 7 -> 183;
                            case 8 -> 196;
                            case 9 -> 39;
                            case 10 -> 65;
                            case 11 -> 86;
                            case 12 -> 216;
                            case 13 -> 89;
                            case 14 -> 163;
                            case 15 -> 95;
                            case 16 -> 207;
                            case 17 -> 171;
                            case 18 -> 21;
                            case 19 -> 103;
                            case 20 -> 111;
                            case 21 -> 6;
                            case 22 -> 25;
                            case 23 -> 229;
                            case 24 -> 51;
                            case 25 -> 28;
                            case 26 -> 142;
                            case 27 -> 55;
                            case 28 -> 23;
                            case 29 -> 188;
                            case 30 -> 174;
                            case 31 -> 185;
                            case 32 -> 127;
                            case 33 -> 206;
                            case 34 -> 253;
                            case 35 -> 128;
                            case 36 -> 129;
                            case 37 -> 12;
                            case 38 -> 17;
                            case 39 -> 1;
                            case 40 -> 226;
                            case 41 -> 110;
                            case 42 -> 115;
                            case 43 -> 113;
                            case 44 -> 203;
                            case 45 -> 84;
                            case 46 -> 102;
                            case 47 -> 195;
                            case 48 -> 8;
                            case 49 -> 179;
                            case 50 -> 20;
                            case 51 -> 146;
                            case 52 -> 72;
                            case 53 -> 189;
                            case 54 -> 126;
                            case 55 -> 202;
                            case 56 -> 107;
                            case 57 -> 93;
                            case 58 -> 64;
                            case 59 -> 225;
                            case 60 -> 176;
                            case 61 -> 251;
                            case 62 -> 192;
                            case 63 -> 57;
                            case 64 -> 240;
                            case 65 -> 62;
                            case 66 -> 139;
                            case 67 -> 116;
                            case 68 -> 47;
                            case 69 -> 4;
                            case 70 -> 198;
                            case 71 -> 246;
                            case 72 -> 75;
                            case 73 -> 234;
                            case 74 -> 170;
                            case 75 -> 134;
                            case 76 -> 13;
                            case 77 -> 112;
                            case 78 -> 100;
                            case 79 -> 29;
                            case 80 -> 35;
                            case 81 -> 145;
                            case 82 -> 184;
                            case 83 -> 205;
                            case 84 -> 5;
                            case 85 -> 218;
                            case 86 -> 26;
                            case 87 -> 14;
                            case 88 -> 194;
                            case 89 -> 248;
                            case 90 -> 63;
                            case 91 -> 45;
                            case 92 -> 136;
                            case 93 -> 40;
                            case 94 -> 204;
                            case 95 -> 180;
                            case 96 -> 77;
                            case 97 -> 109;
                            case 98 -> 245;
                            case 99 -> 165;
                            case 100 -> 96;
                            case 101 -> 66;
                            case 102 -> 219;
                            case 103 -> 59;
                            case 104 -> 104;
                            case 105 -> 106;
                            case 106 -> 54;
                            case 107 -> 221;
                            case 108 -> 193;
                            case 109 -> 44;
                            case 110 -> 30;
                            case 111 -> 43;
                            case 112 -> 153;
                            case 113 -> 0;
                            case 114 -> 247;
                            case 115 -> 81;
                            case 116 -> 140;
                            case 117 -> 130;
                            case 118 -> 238;
                            case 119 -> 92;
                            case 120 -> 132;
                            case 121 -> 31;
                            case 122 -> 56;
                            case 123 -> 186;
                            case 124 -> 191;
                            case 125 -> 173;
                            case 126 -> 122;
                            case 127 -> 217;
                            case 128 -> 16;
                            case 129 -> 152;
                            case 130 -> 120;
                            case 131 -> 105;
                            case 132 -> 236;
                            case 133 -> 223;
                            case 134 -> 187;
                            case 135 -> 117;
                            case 136 -> 232;
                            case 137 -> 76;
                            case 138 -> 181;
                            case 139 -> 151;
                            case 140 -> 61;
                            case 141 -> 33;
                            case 142 -> 52;
                            case 143 -> 222;
                            case 144 -> 214;
                            case 145 -> 48;
                            case 146 -> 154;
                            case 147 -> 250;
                            case 148 -> 213;
                            case 149 -> 210;
                            case 150 -> 91;
                            case 151 -> 168;
                            case 152 -> 230;
                            case 153 -> 161;
                            case 154 -> 233;
                            case 155 -> 125;
                            case 156 -> 24;
                            case 157 -> 94;
                            case 158 -> 150;
                            case 159 -> 11;
                            case 160 -> 135;
                            case 161 -> 73;
                            case 162 -> 38;
                            case 163 -> 227;
                            case 164 -> 118;
                            case 165 -> 244;
                            case 166 -> 15;
                            case 167 -> 200;
                            case 168 -> 50;
                            case 169 -> 60;
                            case 170 -> 157;
                            case 171 -> 2;
                            case 172 -> 34;
                            case 173 -> 172;
                            case 174 -> 143;
                            case 175 -> 160;
                            case 176 -> 36;
                            case 177 -> 70;
                            case 178 -> 220;
                            case 179 -> 252;
                            case 180 -> 255;
                            case 181 -> 235;
                            case 182 -> 228;
                            case 183 -> 201;
                            case 184 -> 178;
                            case 185 -> 164;
                            case 186 -> 67;
                            case 187 -> 199;
                            case 188 -> 167;
                            case 189 -> 71;
                            case 190 -> 212;
                            case 191 -> 166;
                            case 192 -> 131;
                            case 193 -> 90;
                            case 194 -> 74;
                            case 195 -> 97;
                            case 196 -> 254;
                            case 197 -> 124;
                            case 198 -> 7;
                            case 199 -> 208;
                            case 200 -> 119;
                            case 201 -> 46;
                            case 202 -> 137;
                            case 203 -> 215;
                            case 204 -> 22;
                            case 205 -> 239;
                            case 206 -> 162;
                            case 207 -> 211;
                            case 208 -> 242;
                            case 209 -> 78;
                            case 210 -> 42;
                            case 211 -> 159;
                            case 212 -> 209;
                            case 213 -> 101;
                            case 214 -> 190;
                            case 215 -> 177;
                            case 216 -> 85;
                            case 217 -> 37;
                            case 218 -> 82;
                            case 219 -> 98;
                            case 220 -> 156;
                            case 221 -> 175;
                            case 222 -> 99;
                            case 223 -> 144;
                            case 224 -> 80;
                            case 225 -> 83;
                            case 226 -> 58;
                            case 227 -> 182;
                            case 228 -> 32;
                            case 229 -> 69;
                            case 230 -> 10;
                            case 231 -> 243;
                            case 232 -> 158;
                            case 233 -> 87;
                            case 234 -> 41;
                            case 235 -> 141;
                            case 236 -> 249;
                            case 237 -> 3;
                            case 238 -> 149;
                            case 239 -> 27;
                            case 240 -> 138;
                            case 241 -> 231;
                            case 242 -> 147;
                            case 243 -> 133;
                            case 244 -> 155;
                            case 245 -> 68;
                            case 246 -> 18;
                            case 247 -> 241;
                            case 248 -> 169;
                            case 249 -> 197;
                            case 250 -> 121;
                            case 251 -> 108;
                            case 252 -> 9;
                            case 253 -> 88;
                            case 254 -> 19;
                            default -> 53;
                        };
                        int n8 = ((n3 ^= n4) & 0xFF) - n7;
                        if (n8 < 0) {
                            n8 += 256;
                        }
                        if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                            n6 += 256;
                        }
                        int n9 = 0;
                        while (n9 < cArray.length) {
                            int n10 = n9 % 2;
                            int n11 = n9;
                            char[] cArray2 = cArray;
                            char c2 = cArray[n11];
                            if (n10 == 0) {
                                cArray2[n11] = (char)(c2 ^ n8);
                                n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                            } else {
                                cArray2[n11] = (char)(c2 ^ n6);
                                n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                            }
                            ++n9;
                        }
                        accept.3.b[n5] = new String(cArray).intern();
                    }
                    return b[n5];
                }
            };
            if (actionTimestampArray != null) {
                ActionTimestamp.m(new ActionTimestamp[4]);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
        }
        return streams;
    }

    public final long getRequesterPid() {
        long l2;
        block4: {
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            int n2;
            long l3;
            block2: {
                block3: {
                    l3 = 131168908890415L;
                    WinDef.ULONGByReference uLONGByReference = new WinDef.ULONGByReference();
                    ActionTimestamp[] actionTimestampArray = SshAgentIpcService.m();
                    try {
                        n2 = Kernel32.INSTANCE.GetNamedPipeClientProcessId(this.hPipe, uLONGByReference);
                        if (actionTimestampArray != null) break block2;
                        if (n2 == 0) break block3;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    WinDef.ULONG uLONG = uLONGByReference.getValue();
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(607640520 + 31318, 607640520 + 32314, (int)l3));
                    logger.info(WindowsNamedPipeAgentIpc.b(607640520 + 31306, 607640520 + (char)-26215, (int)l3) + this.pipePath + WindowsNamedPipeAgentIpc.b(607640520 + 31295, -607640520 + -((char)-29788), (int)l3) + uLONG);
                    l2 = uLONGByReference.getValue().longValue();
                    break block4;
                }
                n2 = Kernel32.INSTANCE.GetLastError();
            }
            int n3 = n2;
            windowsNamedPipeAgentIpc = this;
            bl = false;
            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(607640520 + 31318, 607640520 + 32314, (int)l3));
            logger.warn(WindowsNamedPipeAgentIpc.b(607640520 + 31306, 607640520 + (char)-26215, (int)l3) + this.pipePath + WindowsNamedPipeAgentIpc.b(607640520 + 31294, -607640520 + -15340, (int)l3) + ErrorToolsKt.prettyHRESULT(n3));
            l2 = -1L;
        }
        long l4 = l2;
        return l4;
    }

    @Override
    protected boolean isSshProcess(@NotNull ProcessInfoUtil.ProcessInfo process2) {
        boolean bl;
        block14: {
            block12: {
                block15: {
                    String string;
                    Object object;
                    ActionTimestamp[] actionTimestampArray;
                    block13: {
                        long l2 = 46738781492134L;
                        ActionTimestamp[] actionTimestampArray2 = SshAgentIpcService.m();
                        Intrinsics.checkNotNullParameter((Object)process2, (String)WindowsNamedPipeAgentIpc.b(947373960 + 3328, 947373960 - 7536, (int)l2));
                        actionTimestampArray = actionTimestampArray2;
                        try {
                            try {
                                try {
                                    try {
                                        if (actionTimestampArray != null || (object = process2.getExecutable()) == null) break block12;
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                    if ((object = object.getFileName()) == null) break block12;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                String string2 = object.toString();
                                string = string2;
                                object = string2;
                                if (actionTimestampArray != null) break block13;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            if (string == null) break block12;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        string = WindowsNamedPipeAgentIpc.b(947373960 + 3329, -947373960 - -4797, (int)l2);
                    }
                    try {
                        try {
                            bl = StringsKt.equals((String)object, (String)string, (boolean)true);
                            if (actionTimestampArray != null) break block14;
                            if (!bl) break block15;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        bl = true;
                        break block14;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                bl = false;
                break block14;
            }
            bl = false;
        }
        return bl;
    }

    @Override
    @NotNull
    public SshRequesterProcessInfo getRequesterProcessInfo() {
        return this.requestorProcessValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private final void disconnect() {
        Object object;
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
        ActionTimestamp[] actionTimestampArray;
        long l2;
        block25: {
            block26: {
                l2 = 40924487641103L;
                this.assertConnectionThread();
                Object object2 = this.lock;
                synchronized (object2) {
                    boolean bl;
                    NamedPipeState namedPipeState;
                    NamedPipeState namedPipeState2;
                    block23: {
                        block24: {
                            block21: {
                                block22: {
                                    actionTimestampArray = SshAgentIpcService.m();
                                    boolean bl2 = false;
                                    namedPipeState2 = this.state;
                                    namedPipeState = NamedPipeState.Closing;
                                    if (actionTimestampArray != null) break block21;
                                    try {
                                        block29: {
                                            if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block22;
                                            break block29;
                                            catch (IllegalArgumentException illegalArgumentException) {
                                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                            }
                                        }
                                        throw new ClosedChannelException();
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                }
                                namedPipeState2 = this.state;
                                namedPipeState = NamedPipeState.Open;
                            }
                            try {
                                if (actionTimestampArray != null) break block23;
                                if (namedPipeState2 != namedPipeState) break block24;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                            boolean bl3 = false;
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(2039187060 + (char)-5942, 2039187060 + (char)-9042, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(2039187060 + (char)-5954, 2039187060 + (char)-14899, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(2039187060 + (char)-5969, -2039187060 + -((char)-29221), (int)l2));
                            return;
                        }
                        namedPipeState2 = this.state;
                        namedPipeState = NamedPipeState.Connected;
                    }
                    try {
                        bl = namedPipeState2 == namedPipeState;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl4 = false;
                        String string = WindowsNamedPipeAgentIpc.b(2039187060 + (char)-5954, 2039187060 + (char)-14899, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(2039187060 + (char)-5948, -2039187060 + -((char)-26152), (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.state = NamedPipeState.Disconnecting;
                    Unit unit = Unit.INSTANCE;
                }
                windowsNamedPipeAgentIpc = this;
                boolean bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(2039187060 + (char)-5942, 2039187060 + (char)-9042, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(2039187060 + (char)-5954, 2039187060 + (char)-14899, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(2039187060 + (char)-5970, 2039187060 + (char)-12406, (int)l2));
                    object = Kernel32.INSTANCE;
                    if (actionTimestampArray != null) break block25;
                    if (object.DisconnectNamedPipe(this.hPipe)) break block26;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                windowsNamedPipeAgentIpc = this;
                bl = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(2039187060 + (char)-5942, 2039187060 + (char)-9042, (int)l2));
                logger.warn(WindowsNamedPipeAgentIpc.b(2039187060 + (char)-5954, 2039187060 + (char)-14899, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(2039187060 + (char)-5959, -2039187060 + -((char)-12571), (int)l2) + ErrorToolsKt.kernel32LastError());
                return;
            }
            object = this.lock;
        }
        Kernel32 kernel32 = object;
        synchronized (kernel32) {
            block27: {
                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3;
                block28: {
                    boolean bl = false;
                    windowsNamedPipeAgentIpc3 = this;
                    if (actionTimestampArray != null) break block27;
                    try {
                        block30: {
                            if (windowsNamedPipeAgentIpc3.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block28;
                            break block30;
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        throw new ClosedChannelException();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                windowsNamedPipeAgentIpc3 = this;
            }
            windowsNamedPipeAgentIpc3.state = NamedPipeState.Open;
            Unit unit = Unit.INSTANCE;
        }
        windowsNamedPipeAgentIpc = this;
        boolean bl = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(2039187060 + (char)-5942, 2039187060 + (char)-9042, (int)l2));
        logger.info(WindowsNamedPipeAgentIpc.b(2039187060 + (char)-5954, 2039187060 + (char)-14899, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(2039187060 + (char)-5960, 2039187060 + (char)-8300, (int)l2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        block17: {
            int n2;
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            long l2;
            block15: {
                ActionTimestamp[] actionTimestampArray;
                block16: {
                    l2 = 123366369296520L;
                    Object object = this.lock;
                    actionTimestampArray = SshAgentIpcService.m();
                    synchronized (object) {
                        block13: {
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2;
                            block14: {
                                boolean bl2 = false;
                                try {
                                    windowsNamedPipeAgentIpc2 = this;
                                    if (actionTimestampArray != null) break block13;
                                    if (windowsNamedPipeAgentIpc2.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block14;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3 = this;
                                boolean bl3 = false;
                                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(2023720800 - (char)-89, 2023720800 - (char)-1093, (int)l2));
                                logger.info(WindowsNamedPipeAgentIpc.b(2023720800 - (char)-85, 2023720800 - (char)-7526, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(2023720800 - (char)-72, 2023720800 - (char)-25872, (int)l2) + this.state + WindowsNamedPipeAgentIpc.b(2023720800 - (char)-73, -2023720800 - -((char)-19403), (int)l2));
                                return;
                            }
                            windowsNamedPipeAgentIpc2 = this;
                        }
                        windowsNamedPipeAgentIpc2.state = NamedPipeState.Closing;
                        Unit unit = Unit.INSTANCE;
                    }
                    WindowsNamedPipeAgentIpc.Companion.connectToPipe(this.pipePath);
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    try {
                        try {
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(2023720800 - (char)-89, 2023720800 - (char)-1093, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(2023720800 - (char)-85, 2023720800 - (char)-7526, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(2023720800 - (char)-78, 2023720800 - (char)-6002, (int)l2));
                            n2 = Kernel32Ex.Companion.getINSTANCE().CancelIoEx(this.hPipe, null);
                            if (actionTimestampArray != null) break block15;
                            if (n2 != 0) break block16;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n2 = Kernel32.INSTANCE.GetLastError();
                        if (actionTimestampArray != null) break block15;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    int n3 = n2;
                    if (n3 != 1168) {
                        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc4 = this;
                        boolean bl4 = false;
                        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(2023720800 - (char)-89, 2023720800 - (char)-1093, (int)l2));
                        logger.info(WindowsNamedPipeAgentIpc.b(2023720800 - (char)-85, 2023720800 - (char)-7526, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(2023720800 - (char)-79, -2023720800 - -((char)-7624), (int)l2) + ErrorToolsKt.prettyHRESULT(n3));
                    }
                }
                windowsNamedPipeAgentIpc = this;
                bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(2023720800 - (char)-89, 2023720800 - (char)-1093, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(2023720800 - (char)-85, 2023720800 - (char)-7526, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(2023720800 - (char)-76, 2023720800 - (char)-14877, (int)l2));
                    if (actionTimestampArray != null) break block17;
                    n2 = Kernel32.INSTANCE.CloseHandle(this.hPipe) ? 1 : 0;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
            }
            if (n2 == 0) {
                windowsNamedPipeAgentIpc = this;
                bl = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(2023720800 - (char)-89, 2023720800 - (char)-1093, (int)l2));
                logger.warn(WindowsNamedPipeAgentIpc.b(2023720800 - (char)-85, 2023720800 - (char)-7526, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(2023720800 - (char)-77, 2023720800 - (char)-15682, (int)l2) + ErrorToolsKt.kernel32LastError());
            }
            this.hPipe = WinNT.INVALID_HANDLE_VALUE;
            this.state = NamedPipeState.Closed;
        }
    }

    @Override
    public void cleanup() {
    }

    public static final /* synthetic */ String access$getPipePath$p(WindowsNamedPipeAgentIpc $this) {
        return $this.pipePath;
    }

    /*
     * Unable to fully structure code
     */
    static {
        block20: {
            block19: {
                var5 = new String[32];
                var3_1 = 0;
                var2_2 = "\u001d\u0094\u0001A2iA\u00c1\u0014\u00f71d\u0012`\u008b\u00a4\u0087w\u00a9\u0013$@$[X2)FL\u0006\u0011{\u0080\u00bch\u0097\u0018\u00f9,\u00c5\u0081\u00d6<p\u00b1%\u0012V#\u008e;\u00d09\u00ealsy\u00fa\u008c\u00a6\u00c9\tx\u00a2k\u00e1h\u00af\u00bf\u008b\u00e0\u00054\u00a9$\u00e6\u00e6\b\u00a2:\u00f6\u00e5\u009e\u00db\u00d2u\u0005\u000ffC\u001f\n\u001e\u00ec\u00d8*\u00ac\u00ba]_\u00e7e\u00cc\u0015\u007f\u00aa\u0090\u00f6(\u00cf\u00df\u0005\u00fb\u0098\u00f3\u00e6\u00ebv\u00c9\u00b8C\u0090\u00b0\u0010\u00ef>\u00ae\u00b5}LQ<\u00d9\u0005\u000f\u00bb\u00ef]\u00f1\u000e\t\u00b5\u0086\u0004t\u00d6:N\u00a60\u0010U\u00bf\u00f9\u0085\u0097J\f\u00fcr\u001dz\u00b8A=$\u0002?\u00b2\u0014\u00e95\u00cfgt\u00ccqx\u00d2\u0012\u00ed\u00cb#z\u00b0\u00f0\u0097\u00dbD\u00a5\u0006Gz\u00b44X6\u0085\u00ed\u0014#4\u0005/U\u00a2+K\u0003\u00ebc_\u00a1:\u00c4y\u0013}B-\u00d0\u00e6N\u00a5\u00daK\u00a7\u00e7F=&\b5\u0019\u0004\u0081\u00c0W\u0019\u00e4\fg\u0004^9\u0096\"=M}c\u00c9sF\u00e8_\u00afR\u00a8O\u00fa\u00e0\u0085\u00da\u00dc\u0080\u00ba\u0091\u00d6\u0017\u00f2:\u00df-_)f\u00e4@\u00eb\u0080\u00b8\u001f\u00b0\u00f2\u008e\u00fc\u00d1<\u00b2\u00a8\\?P\u0012\u009d\u00cajJ\u0019\u00ed`\u00d1\u00a6|\u00fc\u00f8J]+'\u00ee\u008e\u00efPU\u00b8\u0089X9`\u009a\u00cf[\u001f\u00cd\u0099\u000e\u0084>X\u00cfGw\u00d8W\u00fd\u00e2\u00dd\u00f40\u00f44\u001fL\u0010\u0085 \u008e\u00cf\u00b5\u0098\u0000\u0089)\"\u000b\u00eb?\u00cf^\u00a4\u00ce{\u00d0\u00b5\u00dc\u00da\u001557\u0014\\\u00d8\u00e6\u0018\u00a8\u00e73XK\u00bd\u00a7\u0002)\u00d1\u0083f\u00c3\t)m\u00d7\u001aM\u00bca\u009f`}<\u0016a\u00ceD\u00ef\u0006\u00c8zC\"k0\u0089 \u0095)\u0004\u00eb5\u00a07\u00b2\u00ba\u00f3\u0092{cx\u00cd}\u00ef\u0007d\u00a71Y\u00fd\u00be,\u0007\u00a0Q\u00cd\u00eb\u0085\u00075( \u00be\u00ffA\u00b0\u008a\u00e8:\u00e3\u00a0\u00ef\u00c4\u00d2q.#\u00f7s\n@#B\u00ef\u00a5\u00c9%9\u0011\u00a5\u009f\u00feLxGT@\u0001b\u0012\u00cd\u000f\u00da\u001e\u00ee|zA\u0014\u0080\tz\u0013\u00ce\u00eddW\"]c\u001c\u00db|\u00b3\u0087:~wv\b\u00c1ej\u00ec\u0093\u000e\u00a2\u00ee\u00bd\u00a9\u00f3CI\u0011R2\u00db\u00a9H\u0094{\u00c4\u000e\r$\u0014;%\u00a9\u00ff\u009dt\u00d9\u00bc\u00ba\u0014\u00e0\u001bd\u00e0>\u00a6\u009b\u00af\u00bd\u0001k\u00cd\u00d29\u0089\u00a6E\u0082\u00dei\u00b6\u009e\u0004\u0093\u00b7\u00a2\u008a@\u007f\n\u0010Yt\u0096\u00c6M\u00c5w\u00cfa\u0018\u00beje\u00fa\u00f1\u0098\u00d1\u00b9\u00f8\u0013b}&}L\u00d8\u0088#\u00ab\u00ae\u00df\u00de\u0097X)\u00a4:#\u00f0\u009b\u00d6{\u0096\u00e1\u00e2\u0085\u00ba\u00b86\u00be3\u009c\u00a9\u0016\u009d\u00fb\u00d7\u00d2\u00d0\u008b\u00a5Z\u0096\u00adS\u009f]\u008a\u00d0A\u008b\u00c7BY:}";
                var4_3 = "\u001d\u0094\u0001A2iA\u00c1\u0014\u00f71d\u0012`\u008b\u00a4\u0087w\u00a9\u0013$@$[X2)FL\u0006\u0011{\u0080\u00bch\u0097\u0018\u00f9,\u00c5\u0081\u00d6<p\u00b1%\u0012V#\u008e;\u00d09\u00ealsy\u00fa\u008c\u00a6\u00c9\tx\u00a2k\u00e1h\u00af\u00bf\u008b\u00e0\u00054\u00a9$\u00e6\u00e6\b\u00a2:\u00f6\u00e5\u009e\u00db\u00d2u\u0005\u000ffC\u001f\n\u001e\u00ec\u00d8*\u00ac\u00ba]_\u00e7e\u00cc\u0015\u007f\u00aa\u0090\u00f6(\u00cf\u00df\u0005\u00fb\u0098\u00f3\u00e6\u00ebv\u00c9\u00b8C\u0090\u00b0\u0010\u00ef>\u00ae\u00b5}LQ<\u00d9\u0005\u000f\u00bb\u00ef]\u00f1\u000e\t\u00b5\u0086\u0004t\u00d6:N\u00a60\u0010U\u00bf\u00f9\u0085\u0097J\f\u00fcr\u001dz\u00b8A=$\u0002?\u00b2\u0014\u00e95\u00cfgt\u00ccqx\u00d2\u0012\u00ed\u00cb#z\u00b0\u00f0\u0097\u00dbD\u00a5\u0006Gz\u00b44X6\u0085\u00ed\u0014#4\u0005/U\u00a2+K\u0003\u00ebc_\u00a1:\u00c4y\u0013}B-\u00d0\u00e6N\u00a5\u00daK\u00a7\u00e7F=&\b5\u0019\u0004\u0081\u00c0W\u0019\u00e4\fg\u0004^9\u0096\"=M}c\u00c9sF\u00e8_\u00afR\u00a8O\u00fa\u00e0\u0085\u00da\u00dc\u0080\u00ba\u0091\u00d6\u0017\u00f2:\u00df-_)f\u00e4@\u00eb\u0080\u00b8\u001f\u00b0\u00f2\u008e\u00fc\u00d1<\u00b2\u00a8\\?P\u0012\u009d\u00cajJ\u0019\u00ed`\u00d1\u00a6|\u00fc\u00f8J]+'\u00ee\u008e\u00efPU\u00b8\u0089X9`\u009a\u00cf[\u001f\u00cd\u0099\u000e\u0084>X\u00cfGw\u00d8W\u00fd\u00e2\u00dd\u00f40\u00f44\u001fL\u0010\u0085 \u008e\u00cf\u00b5\u0098\u0000\u0089)\"\u000b\u00eb?\u00cf^\u00a4\u00ce{\u00d0\u00b5\u00dc\u00da\u001557\u0014\\\u00d8\u00e6\u0018\u00a8\u00e73XK\u00bd\u00a7\u0002)\u00d1\u0083f\u00c3\t)m\u00d7\u001aM\u00bca\u009f`}<\u0016a\u00ceD\u00ef\u0006\u00c8zC\"k0\u0089 \u0095)\u0004\u00eb5\u00a07\u00b2\u00ba\u00f3\u0092{cx\u00cd}\u00ef\u0007d\u00a71Y\u00fd\u00be,\u0007\u00a0Q\u00cd\u00eb\u0085\u00075( \u00be\u00ffA\u00b0\u008a\u00e8:\u00e3\u00a0\u00ef\u00c4\u00d2q.#\u00f7s\n@#B\u00ef\u00a5\u00c9%9\u0011\u00a5\u009f\u00feLxGT@\u0001b\u0012\u00cd\u000f\u00da\u001e\u00ee|zA\u0014\u0080\tz\u0013\u00ce\u00eddW\"]c\u001c\u00db|\u00b3\u0087:~wv\b\u00c1ej\u00ec\u0093\u000e\u00a2\u00ee\u00bd\u00a9\u00f3CI\u0011R2\u00db\u00a9H\u0094{\u00c4\u000e\r$\u0014;%\u00a9\u00ff\u009dt\u00d9\u00bc\u00ba\u0014\u00e0\u001bd\u00e0>\u00a6\u009b\u00af\u00bd\u0001k\u00cd\u00d29\u0089\u00a6E\u0082\u00dei\u00b6\u009e\u0004\u0093\u00b7\u00a2\u008a@\u007f\n\u0010Yt\u0096\u00c6M\u00c5w\u00cfa\u0018\u00beje\u00fa\u00f1\u0098\u00d1\u00b9\u00f8\u0013b}&}L\u00d8\u0088#\u00ab\u00ae\u00df\u00de\u0097X)\u00a4:#\u00f0\u009b\u00d6{\u0096\u00e1\u00e2\u0085\u00ba\u00b86\u00be3\u009c\u00a9\u0016\u009d\u00fb\u00d7\u00d2\u00d0\u008b\u00a5Z\u0096\u00adS\u009f]\u008a\u00d0A\u008b\u00c7BY:}".length();
                var1_4 = 8;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    v0 = 82;
                    v1 = ++var0_5;
                    v2 = var2_2.substring(v1, v1 + var1_4);
                    v3 = -1;
                    break block19;
                    break;
                }
lbl13:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    var2_2 = "\u0093\u007fU\u00c0c\u00f6;\u00f1\u00b6\u001d|\u0016\u00ad\u00e0\u00dfAf\u00f1\u00d7\u009b\u00d6\u0000G\u00f4\u00d4\u00feD\u0089\u00c8\u0088\u00e0\u00df\u00d7\u009a\u0015e\u008d^R";
                    var4_3 = "\u0093\u007fU\u00c0c\u00f6;\u00f1\u00b6\u001d|\u0016\u00ad\u00e0\u00dfAf\u00f1\u00d7\u009b\u00d6\u0000G\u00f4\u00d4\u00feD\u0089\u00c8\u0088\u00e0\u00df\u00d7\u009a\u0015e\u008d^R".length();
                    var1_4 = 9;
                    var0_5 = -1;
lbl22:
                    // 2 sources

                    while (true) {
                        v0 = 12;
                        v5 = ++var0_5;
                        v2 = var2_2.substring(v5, v5 + var1_4);
                        v3 = 0;
                        break block19;
                        break;
                    }
                    break;
                }
lbl28:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block20;
                    break;
                }
            }
            v6 = v2.toCharArray();
            v7 = v6.length;
            var6_6 = 0;
            v8 = v0;
            v9 = v6;
            v10 = v7;
            if (v7 > 1) ** GOTO lbl85
            do {
                v11 = v8;
                v9 = v9;
                v12 = v9;
                v13 = v8;
                v14 = var6_6;
                while (true) {
                    switch (var6_6 % 7) {
                        case 0: {
                            v15 = 126;
                            break;
                        }
                        case 1: {
                            v15 = 116;
                            break;
                        }
                        case 2: {
                            v15 = 123;
                            break;
                        }
                        case 3: {
                            v15 = 100;
                            break;
                        }
                        case 4: {
                            v15 = 75;
                            break;
                        }
                        case 5: {
                            v15 = 125;
                            break;
                        }
                        default: {
                            v15 = 88;
                        }
                    }
                    v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                    ++var6_6;
                    v8 = v11;
                    if (v11 != 0) break;
                    v11 = v8;
                    v9 = v9;
                    v14 = v8;
                    v12 = v9;
                    v13 = v8;
                }
lbl85:
                // 2 sources

                v16 = v9;
                v10 = v10;
            } while (v10 > var6_6);
            v4 = new String(v16);
            switch (v3) {
                default: {
                    ** continue;
                }
                ** case 0:
lbl95:
                // 1 sources

                ** continue;
            }
        }
        WindowsNamedPipeAgentIpc.c = var5;
        WindowsNamedPipeAgentIpc.d = new String[32];
        WindowsNamedPipeAgentIpc.Companion = new Companion(null);
    }

    private static IllegalArgumentException a(IllegalArgumentException illegalArgumentException) {
        return illegalArgumentException;
    }

    private static String b(int n2, int n3, int n4) {
        int n5 = (n2 ^ n4 ^ 0x73A) & 0xFFFF;
        if (d[n5] == null) {
            int n6;
            char[] cArray = c[n5].toCharArray();
            int n7 = switch (cArray[0] & 0xFF) {
                case 0 -> 218;
                case 1 -> 82;
                case 2 -> 31;
                case 3 -> 97;
                case 4 -> 121;
                case 5 -> 254;
                case 6 -> 203;
                case 7 -> 154;
                case 8 -> 44;
                case 9 -> 139;
                case 10 -> 49;
                case 11 -> 2;
                case 12 -> 146;
                case 13 -> 241;
                case 14 -> 246;
                case 15 -> 202;
                case 16 -> 208;
                case 17 -> 195;
                case 18 -> 38;
                case 19 -> 64;
                case 20 -> 230;
                case 21 -> 185;
                case 22 -> 194;
                case 23 -> 1;
                case 24 -> 250;
                case 25 -> 152;
                case 26 -> 54;
                case 27 -> 90;
                case 28 -> 223;
                case 29 -> 83;
                case 30 -> 249;
                case 31 -> 100;
                case 32 -> 207;
                case 33 -> 236;
                case 34 -> 23;
                case 35 -> 251;
                case 36 -> 191;
                case 37 -> 16;
                case 38 -> 168;
                case 39 -> 136;
                case 40 -> 209;
                case 41 -> 119;
                case 42 -> 60;
                case 43 -> 103;
                case 44 -> 127;
                case 45 -> 6;
                case 46 -> 42;
                case 47 -> 140;
                case 48 -> 36;
                case 49 -> 173;
                case 50 -> 62;
                case 51 -> 222;
                case 52 -> 32;
                case 53 -> 114;
                case 54 -> 205;
                case 55 -> 66;
                case 56 -> 110;
                case 57 -> 201;
                case 58 -> 252;
                case 59 -> 51;
                case 60 -> 77;
                case 61 -> 163;
                case 62 -> 48;
                case 63 -> 20;
                case 64 -> 73;
                case 65 -> 232;
                case 66 -> 3;
                case 67 -> 9;
                case 68 -> 7;
                case 69 -> 39;
                case 70 -> 72;
                case 71 -> 172;
                case 72 -> 134;
                case 73 -> 248;
                case 74 -> 104;
                case 75 -> 143;
                case 76 -> 22;
                case 77 -> 186;
                case 78 -> 81;
                case 79 -> 184;
                case 80 -> 181;
                case 81 -> 169;
                case 82 -> 4;
                case 83 -> 8;
                case 84 -> 244;
                case 85 -> 0;
                case 86 -> 27;
                case 87 -> 46;
                case 88 -> 19;
                case 89 -> 129;
                case 90 -> 71;
                case 91 -> 242;
                case 92 -> 198;
                case 93 -> 137;
                case 94 -> 88;
                case 95 -> 214;
                case 96 -> 33;
                case 97 -> 221;
                case 98 -> 206;
                case 99 -> 99;
                case 100 -> 34;
                case 101 -> 115;
                case 102 -> 29;
                case 103 -> 166;
                case 104 -> 196;
                case 105 -> 255;
                case 106 -> 35;
                case 107 -> 21;
                case 108 -> 78;
                case 109 -> 138;
                case 110 -> 215;
                case 111 -> 153;
                case 112 -> 128;
                case 113 -> 93;
                case 114 -> 43;
                case 115 -> 237;
                case 116 -> 76;
                case 117 -> 96;
                case 118 -> 55;
                case 119 -> 69;
                case 120 -> 228;
                case 121 -> 15;
                case 122 -> 164;
                case 123 -> 85;
                case 124 -> 165;
                case 125 -> 52;
                case 126 -> 226;
                case 127 -> 118;
                case 128 -> 189;
                case 129 -> 238;
                case 130 -> 188;
                case 131 -> 41;
                case 132 -> 24;
                case 133 -> 227;
                case 134 -> 170;
                case 135 -> 63;
                case 136 -> 158;
                case 137 -> 111;
                case 138 -> 107;
                case 139 -> 132;
                case 140 -> 148;
                case 141 -> 190;
                case 142 -> 239;
                case 143 -> 156;
                case 144 -> 126;
                case 145 -> 204;
                case 146 -> 178;
                case 147 -> 144;
                case 148 -> 28;
                case 149 -> 109;
                case 150 -> 84;
                case 151 -> 101;
                case 152 -> 125;
                case 153 -> 65;
                case 154 -> 210;
                case 155 -> 57;
                case 156 -> 231;
                case 157 -> 247;
                case 158 -> 149;
                case 159 -> 79;
                case 160 -> 235;
                case 161 -> 212;
                case 162 -> 233;
                case 163 -> 182;
                case 164 -> 13;
                case 165 -> 14;
                case 166 -> 45;
                case 167 -> 180;
                case 168 -> 219;
                case 169 -> 162;
                case 170 -> 86;
                case 171 -> 120;
                case 172 -> 30;
                case 173 -> 175;
                case 174 -> 18;
                case 175 -> 177;
                case 176 -> 243;
                case 177 -> 92;
                case 178 -> 12;
                case 179 -> 145;
                case 180 -> 80;
                case 181 -> 151;
                case 182 -> 200;
                case 183 -> 10;
                case 184 -> 174;
                case 185 -> 171;
                case 186 -> 245;
                case 187 -> 112;
                case 188 -> 225;
                case 189 -> 217;
                case 190 -> 142;
                case 191 -> 91;
                case 192 -> 216;
                case 193 -> 193;
                case 194 -> 130;
                case 195 -> 253;
                case 196 -> 234;
                case 197 -> 155;
                case 198 -> 133;
                case 199 -> 179;
                case 200 -> 89;
                case 201 -> 213;
                case 202 -> 95;
                case 203 -> 161;
                case 204 -> 135;
                case 205 -> 192;
                case 206 -> 116;
                case 207 -> 176;
                case 208 -> 220;
                case 209 -> 67;
                case 210 -> 98;
                case 211 -> 197;
                case 212 -> 187;
                case 213 -> 150;
                case 214 -> 106;
                case 215 -> 87;
                case 216 -> 47;
                case 217 -> 240;
                case 218 -> 50;
                case 219 -> 56;
                case 220 -> 141;
                case 221 -> 113;
                case 222 -> 229;
                case 223 -> 58;
                case 224 -> 108;
                case 225 -> 26;
                case 226 -> 75;
                case 227 -> 68;
                case 228 -> 224;
                case 229 -> 131;
                case 230 -> 183;
                case 231 -> 53;
                case 232 -> 59;
                case 233 -> 124;
                case 234 -> 123;
                case 235 -> 25;
                case 236 -> 11;
                case 237 -> 159;
                case 238 -> 70;
                case 239 -> 61;
                case 240 -> 74;
                case 241 -> 147;
                case 242 -> 199;
                case 243 -> 160;
                case 244 -> 117;
                case 245 -> 5;
                case 246 -> 37;
                case 247 -> 105;
                case 248 -> 157;
                case 249 -> 17;
                case 250 -> 40;
                case 251 -> 211;
                case 252 -> 167;
                case 253 -> 122;
                case 254 -> 94;
                default -> 102;
            };
            int n8 = ((n3 ^= n4) & 0xFF) - n7;
            if (n8 < 0) {
                n8 += 256;
            }
            if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                n6 += 256;
            }
            int n9 = 0;
            while (n9 < cArray.length) {
                int n10 = n9 % 2;
                int n11 = n9;
                char[] cArray2 = cArray;
                char c2 = cArray[n11];
                if (n10 == 0) {
                    cArray2[n11] = (char)(c2 ^ n8);
                    n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                } else {
                    cArray2[n11] = (char)(c2 ^ n6);
                    n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                }
                ++n9;
            }
            WindowsNamedPipeAgentIpc.d[n5] = new String(cArray).intern();
        }
        return d[n5];
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion;", "", "WindowsNamedPipeAgentIpc$Companion", "()V", "connectToPipeTest", "", "pipePath", "", "connectToPipe", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n25#2:392\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n*L\n84#1:392\n*E\n"})
    public static final class Companion {
        private static final String[] a;
        private static final String[] b;

        private Companion() {
        }

        @TestOnly
        public final void connectToPipeTest(@NotNull String pipePath) {
            long l2 = 29897971258277L;
            Intrinsics.checkNotNullParameter((Object)pipePath, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-703976970 - -((char)-2393), 703976970 - (char)-5231, (int)l2));
            this.connectToPipe(pipePath);
        }

        private final void connectToPipe(String pipePath) {
            block6: {
                boolean bl;
                WinNT.HANDLE hANDLE;
                block7: {
                    long l2;
                    block5: {
                        WinNT.HANDLE hANDLE2;
                        ActionTimestamp[] actionTimestampArray;
                        block4: {
                            l2 = 101832082140033L;
                            hANDLE = Kernel32.INSTANCE.CreateFile(pipePath, -1073741824, 0, null, 3, 0, null);
                            actionTimestampArray = SshAgentIpcService.m();
                            try {
                                hANDLE2 = hANDLE;
                                if (actionTimestampArray != null) break block4;
                                if (hANDLE2 == null) break block5;
                            }
                            catch (RuntimeException runtimeException) {
                                throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                            }
                            hANDLE2 = WinNT.INVALID_HANDLE_VALUE;
                        }
                        try {
                            bl = Intrinsics.areEqual((Object)hANDLE2, (Object)hANDLE);
                            if (actionTimestampArray != null) break block6;
                            if (!bl) break block7;
                        }
                        catch (RuntimeException runtimeException) {
                            throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                        }
                    }
                    Companion companion = this;
                    boolean bl2 = false;
                    Logger logger = Logger.getInstance(Companion.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(1592500500 - (char)-14244, 1592500500 - (char)-1227, (int)l2));
                    logger.info(com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(1592500500 - (char)-14247, -1592500500 - -((char)-9814), (int)l2) + pipePath + com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(1592500500 - (char)-14246, -1592500500 - -((char)-9791), (int)l2));
                }
                bl = Kernel32.INSTANCE.CloseHandle(hANDLE);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[4];
                    var3_1 = 0;
                    var2_2 = "\u00b13B\u00d8\u0084\u0085o?\u0010\u00b2$\u00d3\u009b\fV\u0087\u001c\u008e\u00d7\u0088?\u00c05w\u008e";
                    var4_3 = "\u00b13B\u00d8\u0084\u0085o?\u0010\u00b2$\u00d3\u009b\fV\u0087\u001c\u008e\u00d7\u0088?\u00c05w\u008e".length();
                    var1_4 = 8;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 125;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "\u0007&#\u00cdo5\u00e1\u0084\u00e8\u00f5\u00c4\u00151h\u0098Uo\u0018|\u008cR\u0084\u00e1<C\u00bb\u008d\u00f8\u00a9\u00d94\u00a1\u008a\u009f\u00a5w/\u00d7\u00ee\u0098\u00f7/\u00f4\u00e9\u0081 \u008e\u00e6\u0091,\u00cbe\u0012h2}Oi\u00ee";
                        var4_3 = "\u0007&#\u00cdo5\u00e1\u0084\u00e8\u00f5\u00c4\u00151h\u0098Uo\u0018|\u008cR\u0084\u00e1<C\u00bb\u008d\u00f8\u00a9\u00d94\u00a1\u008a\u009f\u00a5w/\u00d7\u00ee\u0098\u00f7/\u00f4\u00e9\u0081 \u008e\u00e6\u0091,\u00cbe\u0012h2}Oi\u00ee".length();
                        var1_4 = 5;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 104;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 93;
                                break;
                            }
                            case 1: {
                                v15 = 25;
                                break;
                            }
                            case 2: {
                                v15 = 3;
                                break;
                            }
                            case 3: {
                                v15 = 110;
                                break;
                            }
                            case 4: {
                                v15 = 80;
                                break;
                            }
                            case 5: {
                                v15 = 41;
                                break;
                            }
                            default: {
                                v15 = 9;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a = var5;
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b = new String[4];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0xFFFFF338) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 57;
                    case 1 -> 147;
                    case 2 -> 85;
                    case 3 -> 61;
                    case 4 -> 188;
                    case 5 -> 86;
                    case 6 -> 168;
                    case 7 -> 153;
                    case 8 -> 179;
                    case 9 -> 155;
                    case 10 -> 136;
                    case 11 -> 43;
                    case 12 -> 201;
                    case 13 -> 91;
                    case 14 -> 160;
                    case 15 -> 222;
                    case 16 -> 180;
                    case 17 -> 208;
                    case 18 -> 95;
                    case 19 -> 246;
                    case 20 -> 199;
                    case 21 -> 9;
                    case 22 -> 171;
                    case 23 -> 104;
                    case 24 -> 94;
                    case 25 -> 121;
                    case 26 -> 120;
                    case 27 -> 145;
                    case 28 -> 189;
                    case 29 -> 74;
                    case 30 -> 17;
                    case 31 -> 194;
                    case 32 -> 214;
                    case 33 -> 250;
                    case 34 -> 59;
                    case 35 -> 141;
                    case 36 -> 6;
                    case 37 -> 207;
                    case 38 -> 46;
                    case 39 -> 50;
                    case 40 -> 26;
                    case 41 -> 117;
                    case 42 -> 47;
                    case 43 -> 241;
                    case 44 -> 131;
                    case 45 -> 204;
                    case 46 -> 184;
                    case 47 -> 101;
                    case 48 -> 174;
                    case 49 -> 66;
                    case 50 -> 213;
                    case 51 -> 236;
                    case 52 -> 54;
                    case 53 -> 51;
                    case 54 -> 72;
                    case 55 -> 116;
                    case 56 -> 209;
                    case 57 -> 217;
                    case 58 -> 21;
                    case 59 -> 173;
                    case 60 -> 12;
                    case 61 -> 138;
                    case 62 -> 84;
                    case 63 -> 103;
                    case 64 -> 38;
                    case 65 -> 248;
                    case 66 -> 49;
                    case 67 -> 73;
                    case 68 -> 159;
                    case 69 -> 114;
                    case 70 -> 83;
                    case 71 -> 172;
                    case 72 -> 140;
                    case 73 -> 182;
                    case 74 -> 99;
                    case 75 -> 163;
                    case 76 -> 193;
                    case 77 -> 125;
                    case 78 -> 79;
                    case 79 -> 3;
                    case 80 -> 122;
                    case 81 -> 35;
                    case 82 -> 7;
                    case 83 -> 15;
                    case 84 -> 225;
                    case 85 -> 156;
                    case 86 -> 32;
                    case 87 -> 96;
                    case 88 -> 56;
                    case 89 -> 67;
                    case 90 -> 70;
                    case 91 -> 25;
                    case 92 -> 239;
                    case 93 -> 13;
                    case 94 -> 244;
                    case 95 -> 177;
                    case 96 -> 45;
                    case 97 -> 93;
                    case 98 -> 142;
                    case 99 -> 76;
                    case 100 -> 10;
                    case 101 -> 252;
                    case 102 -> 234;
                    case 103 -> 42;
                    case 104 -> 212;
                    case 105 -> 185;
                    case 106 -> 205;
                    case 107 -> 44;
                    case 108 -> 192;
                    case 109 -> 238;
                    case 110 -> 235;
                    case 111 -> 167;
                    case 112 -> 48;
                    case 113 -> 124;
                    case 114 -> 28;
                    case 115 -> 232;
                    case 116 -> 219;
                    case 117 -> 135;
                    case 118 -> 77;
                    case 119 -> 203;
                    case 120 -> 226;
                    case 121 -> 18;
                    case 122 -> 92;
                    case 123 -> 197;
                    case 124 -> 5;
                    case 125 -> 210;
                    case 126 -> 52;
                    case 127 -> 27;
                    case 128 -> 150;
                    case 129 -> 90;
                    case 130 -> 221;
                    case 131 -> 149;
                    case 132 -> 63;
                    case 133 -> 102;
                    case 134 -> 191;
                    case 135 -> 40;
                    case 136 -> 249;
                    case 137 -> 253;
                    case 138 -> 30;
                    case 139 -> 108;
                    case 140 -> 64;
                    case 141 -> 216;
                    case 142 -> 240;
                    case 143 -> 148;
                    case 144 -> 176;
                    case 145 -> 251;
                    case 146 -> 105;
                    case 147 -> 143;
                    case 148 -> 11;
                    case 149 -> 41;
                    case 150 -> 230;
                    case 151 -> 20;
                    case 152 -> 127;
                    case 153 -> 175;
                    case 154 -> 82;
                    case 155 -> 161;
                    case 156 -> 89;
                    case 157 -> 220;
                    case 158 -> 146;
                    case 159 -> 34;
                    case 160 -> 16;
                    case 161 -> 247;
                    case 162 -> 190;
                    case 163 -> 206;
                    case 164 -> 228;
                    case 165 -> 126;
                    case 166 -> 31;
                    case 167 -> 223;
                    case 168 -> 69;
                    case 169 -> 128;
                    case 170 -> 4;
                    case 171 -> 115;
                    case 172 -> 33;
                    case 173 -> 58;
                    case 174 -> 224;
                    case 175 -> 144;
                    case 176 -> 178;
                    case 177 -> 137;
                    case 178 -> 242;
                    case 179 -> 112;
                    case 180 -> 8;
                    case 181 -> 154;
                    case 182 -> 200;
                    case 183 -> 195;
                    case 184 -> 158;
                    case 185 -> 119;
                    case 186 -> 139;
                    case 187 -> 98;
                    case 188 -> 19;
                    case 189 -> 80;
                    case 190 -> 100;
                    case 191 -> 186;
                    case 192 -> 198;
                    case 193 -> 237;
                    case 194 -> 87;
                    case 195 -> 202;
                    case 196 -> 36;
                    case 197 -> 227;
                    case 198 -> 169;
                    case 199 -> 255;
                    case 200 -> 111;
                    case 201 -> 165;
                    case 202 -> 113;
                    case 203 -> 166;
                    case 204 -> 39;
                    case 205 -> 78;
                    case 206 -> 254;
                    case 207 -> 53;
                    case 208 -> 68;
                    case 209 -> 22;
                    case 210 -> 24;
                    case 211 -> 123;
                    case 212 -> 62;
                    case 213 -> 233;
                    case 214 -> 97;
                    case 215 -> 218;
                    case 216 -> 75;
                    case 217 -> 81;
                    case 218 -> 65;
                    case 219 -> 132;
                    case 220 -> 107;
                    case 221 -> 55;
                    case 222 -> 170;
                    case 223 -> 152;
                    case 224 -> 88;
                    case 225 -> 29;
                    case 226 -> 243;
                    case 227 -> 162;
                    case 228 -> 37;
                    case 229 -> 2;
                    case 230 -> 71;
                    case 231 -> 187;
                    case 232 -> 196;
                    case 233 -> 211;
                    case 234 -> 215;
                    case 235 -> 151;
                    case 236 -> 110;
                    case 237 -> 134;
                    case 238 -> 106;
                    case 239 -> 231;
                    case 240 -> 14;
                    case 241 -> 0;
                    case 242 -> 157;
                    case 243 -> 60;
                    case 244 -> 118;
                    case 245 -> 164;
                    case 246 -> 245;
                    case 247 -> 1;
                    case 248 -> 133;
                    case 249 -> 229;
                    case 250 -> 109;
                    case 251 -> 183;
                    case 252 -> 23;
                    case 253 -> 130;
                    case 254 -> 129;
                    default -> 181;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u0000 \b2\u00020\u0001:\u0001\bJ\u001c\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\t\u00c0\u0006\u0001"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "Lcom/sun/jna/platform/win32/Kernel32;", "CancelIoEx", "", "hFile", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lpOverlapped", "Lcom/sun/jna/Pointer;", "Companion", "intellij.platform.backend.split"})
    public static interface Kernel32Ex
    extends Kernel32 {
        @NotNull
        public static final Companion Companion = Companion.$$INSTANCE;

        public boolean CancelIoEx(@Nullable WinNT.HANDLE var1, @Nullable Pointer var2);

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex$Companion;", "", "WindowsNamedPipeAgentIpc$Kernel32Ex$Companion", "()V", "INSTANCE", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "getINSTANCE", "()Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "intellij.platform.backend.split"})
        public static final class Companion {
            static final /* synthetic */ Companion $$INSTANCE;
            @NotNull
            private static final Kernel32Ex INSTANCE;

            private Companion() {
            }

            @NotNull
            public final Kernel32Ex getINSTANCE() {
                return INSTANCE;
            }

            /*
             * Unable to fully structure code
             */
            static {
                block13: {
                    var7 = 102980891986970L;
                    var0_1 = new String[2];
                    var4_2 = 0;
                    var3_3 = "A\u000bG^B&-\u0018\tF\u0001TT\u000fd0\u0004G";
                    var5_4 = "A\u000bG^B&-\u0018\tF\u0001TT\u000fd0\u0004G".length();
                    var2_5 = 8;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        continue;
                        break;
                    }
lbl10:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = new String(v0).intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block13;
                        break;
                    }
                    v1 = ++var1_6;
                    v2 = var3_3.substring(v1, v1 + var2_5).toCharArray();
                    v3 = v2.length;
                    var6_7 = 0;
                    v4 = 93;
                    v5 = v2;
                    v6 = v3;
                    if (v3 > 1) ** GOTO lbl68
                    do {
                        v7 = v4;
                        v5 = v5;
                        v8 = v5;
                        v9 = v4;
                        v10 = var6_7;
                        while (true) {
                            switch (var6_7 % 7) {
                                case 0: {
                                    v11 = 119;
                                    break;
                                }
                                case 1: {
                                    v11 = 51;
                                    break;
                                }
                                case 2: {
                                    v11 = 104;
                                    break;
                                }
                                case 3: {
                                    v11 = 109;
                                    break;
                                }
                                case 4: {
                                    v11 = 122;
                                    break;
                                }
                                case 5: {
                                    v11 = 23;
                                    break;
                                }
                                default: {
                                    v11 = 67;
                                }
                            }
                            v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                            ++var6_7;
                            v4 = v7;
                            if (v7 != 0) break;
                            v7 = v4;
                            v5 = v5;
                            v10 = v4;
                            v8 = v5;
                            v9 = v4;
                        }
lbl68:
                        // 2 sources

                        v0 = v5;
                        v6 = v6;
                    } while (v6 > var6_7);
                    ** while (true)
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.$$INSTANCE = new Companion();
                v12 = Native.load((String)var0_1[0], Kernel32Ex.class, (Map)W32APIOptions.DEFAULT_OPTIONS);
                Intrinsics.checkNotNullExpressionValue((Object)v12, (String)var0_1[1]);
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.INSTANCE = (Kernel32Ex)v12;
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\n\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "", "WindowsNamedPipeAgentIpc$NamedPipeState", "(Ljava/lang/String;I)V", "Initial", "Open", "Connecting", "Connected", "Disconnecting", "Closing", "Closed", "intellij.platform.backend.split"})
    public static final class NamedPipeState
    extends Enum<NamedPipeState> {
        public static final /* enum */ NamedPipeState Initial;
        public static final /* enum */ NamedPipeState Open;
        public static final /* enum */ NamedPipeState Connecting;
        public static final /* enum */ NamedPipeState Connected;
        public static final /* enum */ NamedPipeState Disconnecting;
        public static final /* enum */ NamedPipeState Closing;
        public static final /* enum */ NamedPipeState Closed;
        private static final /* synthetic */ NamedPipeState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static NamedPipeState[] values() {
            return (NamedPipeState[])$VALUES.clone();
        }

        public static NamedPipeState valueOf(String value) {
            return Enum.valueOf(NamedPipeState.class, value);
        }

        @NotNull
        public static EnumEntries<NamedPipeState> getEntries() {
            return $ENTRIES;
        }

        private static final /* synthetic */ NamedPipeState[] $values() {
            NamedPipeState[] namedPipeStateArray = new NamedPipeState[]{Initial, Open, Connecting, Connected, Disconnecting, Closing, Closed};
            return namedPipeStateArray;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var7 = 117487173590946L;
                    var0_1 = new String[7];
                    var4_2 = 0;
                    var3_3 = "\u001d?IG`w\u000e\u0004\u001b!E]\n\u0017>N]lu\u0016=?G\t\u0017>N]lu\u001615\r\u00108SPfx\f12TZgq";
                    var5_4 = "\u001d?IG`w\u000e\u0004\u001b!E]\n\u0017>N]lu\u0016=?G\t\u0017>N]lu\u001615\r\u00108SPfx\f12TZgq".length();
                    var2_5 = 7;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        v0 = 34;
                        v1 = ++var1_6;
                        v2 = var3_3.substring(v1, v1 + var2_5);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl14:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        var3_3 = "3\u0019kdD\\!\u00063\u0019kdHV";
                        var5_4 = "3\u0019kdD\\!\u00063\u0019kdHV".length();
                        var2_5 = 7;
                        var1_6 = -1;
lbl23:
                        // 2 sources

                        while (true) {
                            v0 = 6;
                            v5 = ++var1_6;
                            v2 = var3_3.substring(v5, v5 + var2_5);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl29:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_7 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl86
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_7;
                    while (true) {
                        switch (var6_7 % 7) {
                            case 0: {
                                v15 = 118;
                                break;
                            }
                            case 1: {
                                v15 = 115;
                                break;
                            }
                            case 2: {
                                v15 = 2;
                                break;
                            }
                            case 3: {
                                v15 = 17;
                                break;
                            }
                            case 4: {
                                v15 = 43;
                                break;
                            }
                            case 5: {
                                v15 = 52;
                                break;
                            }
                            default: {
                                v15 = 64;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_7;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl86:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_7);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl96:
                    // 1 sources

                    ** continue;
                }
            }
            NamedPipeState.Initial = new NamedPipeState();
            NamedPipeState.Open = new NamedPipeState();
            NamedPipeState.Connecting = new NamedPipeState();
            NamedPipeState.Connected = new NamedPipeState();
            NamedPipeState.Disconnecting = new NamedPipeState();
            NamedPipeState.Closing = new NamedPipeState();
            NamedPipeState.Closed = new NamedPipeState();
            NamedPipeState.$VALUES = NamedPipeState.$values();
            NamedPipeState.$ENTRIES = EnumEntriesKt.enumEntries((Enum[])NamedPipeState.$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel;", "Ljava/nio/channels/ReadableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeReadableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "read", "", "dst", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n25#2:392\n25#2:393\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n*L\n315#1:392\n320#1:393\n*E\n"})
    private static final class PipeReadableByteChannel
    implements ReadableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeReadableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l2 = 22453470956443L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeReadableByteChannel.a(617995050 + (char)-2216, 617995050 + (char)-16385, (int)l2));
            this.agent = agent;
        }

        /*
         * Exception decompiling
         */
        @Override
        public int read(@NotNull ByteBuffer dst) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 5[SWITCH]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l2 = 99740573130224L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeReadableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[9];
                    var3_1 = 0;
                    var2_2 = "Gq\u00a5M\u00d4\u00031\u000e\u00df\u0005Q\u001fAD\u00ab\r0\u0003[\u008d\u001d\u00f9\u00a8@\u008b\u00c7\u00d2O\u0095\u0010w\u001dt\u00a5\u00c7i\u00d8oL\u00a6\u00c9.\u00101\u00f9'\u0005\u00ab4\u001e!@3\u00ba\u0087- 9\u009d7\u00e5\u00cc\nR\u0092\u00a5\u00f7c\u00e0_\u0005k\u00d3\u00be\u00d07\u00fc\u0082\u0012\u00fa.6k\u00ca\u00a7\u001b\u007f8\u009bi\u0095,-\u00e9\u008cO\u00cd\u00c9\u0085\u00b4\u0011\u00feA\u00b8";
                    var4_3 = "Gq\u00a5M\u00d4\u00031\u000e\u00df\u0005Q\u001fAD\u00ab\r0\u0003[\u008d\u001d\u00f9\u00a8@\u008b\u00c7\u00d2O\u0095\u0010w\u001dt\u00a5\u00c7i\u00d8oL\u00a6\u00c9.\u00101\u00f9'\u0005\u00ab4\u001e!@3\u00ba\u0087- 9\u009d7\u00e5\u00cc\nR\u0092\u00a5\u00f7c\u00e0_\u0005k\u00d3\u00be\u00d07\u00fc\u0082\u0012\u00fa.6k\u00ca\u00a7\u001b\u007f8\u009bi\u0095,-\u00e9\u008cO\u00cd\u00c9\u0085\u00b4\u0011\u00feA\u00b8".length();
                    var1_4 = 5;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 109;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "\u00ec\u00a9\u0092\u00a6\u008e\u009cdDNV\u001c\u00a5?\u00d5\u0089.L\u00e7\u00cf\u0004\u00a0v\u0094\u0015+\u00e9(D\u00d3:\u0095\u00ba_\u00f4\u00b6t\u00c6\u00a0\u0083K\u00a1\u00bb\u00c7m\u00c7\u00ab\u008a\u0003a\u00a7\u00dcKf\u00a0a\u00ba@\u0098I;\u009d\u00c7\u00c4+\u0094jPWe\u00bcB\u008e\u0088\u00a4\u000b\u00fb7\u008d\u00ed\u00bc\u0089\u009ce\u00e3\u0004\u00a4\u0094?\u00af\u00ab\u0097\u0092u";
                        var4_3 = "\u00ec\u00a9\u0092\u00a6\u008e\u009cdDNV\u001c\u00a5?\u00d5\u0089.L\u00e7\u00cf\u0004\u00a0v\u0094\u0015+\u00e9(D\u00d3:\u0095\u00ba_\u00f4\u00b6t\u00c6\u00a0\u0083K\u00a1\u00bb\u00c7m\u00c7\u00ab\u008a\u0003a\u00a7\u00dcKf\u00a0a\u00ba@\u0098I;\u009d\u00c7\u00c4+\u0094jPWe\u00bcB\u008e\u0088\u00a4\u000b\u00fb7\u008d\u00ed\u00bc\u0089\u009ce\u00e3\u0004\u00a4\u0094?\u00af\u00ab\u0097\u0092u".length();
                        var1_4 = 16;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 51;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 54;
                                break;
                            }
                            case 1: {
                                v15 = 32;
                                break;
                            }
                            case 2: {
                                v15 = 99;
                                break;
                            }
                            case 3: {
                                v15 = 66;
                                break;
                            }
                            case 4: {
                                v15 = 113;
                                break;
                            }
                            case 5: {
                                v15 = 70;
                                break;
                            }
                            default: {
                                v15 = 25;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            PipeReadableByteChannel.a = var5;
            PipeReadableByteChannel.b = new String[9];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0xFFFFD919) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 159;
                    case 1 -> 26;
                    case 2 -> 216;
                    case 3 -> 210;
                    case 4 -> 59;
                    case 5 -> 66;
                    case 6 -> 200;
                    case 7 -> 49;
                    case 8 -> 206;
                    case 9 -> 2;
                    case 10 -> 90;
                    case 11 -> 225;
                    case 12 -> 153;
                    case 13 -> 18;
                    case 14 -> 142;
                    case 15 -> 27;
                    case 16 -> 74;
                    case 17 -> 189;
                    case 18 -> 34;
                    case 19 -> 22;
                    case 20 -> 1;
                    case 21 -> 227;
                    case 22 -> 94;
                    case 23 -> 217;
                    case 24 -> 76;
                    case 25 -> 250;
                    case 26 -> 93;
                    case 27 -> 203;
                    case 28 -> 53;
                    case 29 -> 24;
                    case 30 -> 167;
                    case 31 -> 16;
                    case 32 -> 125;
                    case 33 -> 193;
                    case 34 -> 38;
                    case 35 -> 166;
                    case 36 -> 143;
                    case 37 -> 174;
                    case 38 -> 169;
                    case 39 -> 122;
                    case 40 -> 80;
                    case 41 -> 198;
                    case 42 -> 112;
                    case 43 -> 127;
                    case 44 -> 71;
                    case 45 -> 187;
                    case 46 -> 201;
                    case 47 -> 92;
                    case 48 -> 226;
                    case 49 -> 91;
                    case 50 -> 60;
                    case 51 -> 160;
                    case 52 -> 224;
                    case 53 -> 214;
                    case 54 -> 182;
                    case 55 -> 243;
                    case 56 -> 177;
                    case 57 -> 208;
                    case 58 -> 78;
                    case 59 -> 40;
                    case 60 -> 188;
                    case 61 -> 23;
                    case 62 -> 164;
                    case 63 -> 84;
                    case 64 -> 39;
                    case 65 -> 155;
                    case 66 -> 190;
                    case 67 -> 105;
                    case 68 -> 62;
                    case 69 -> 221;
                    case 70 -> 10;
                    case 71 -> 233;
                    case 72 -> 133;
                    case 73 -> 48;
                    case 74 -> 139;
                    case 75 -> 131;
                    case 76 -> 158;
                    case 77 -> 29;
                    case 78 -> 251;
                    case 79 -> 41;
                    case 80 -> 50;
                    case 81 -> 212;
                    case 82 -> 145;
                    case 83 -> 61;
                    case 84 -> 73;
                    case 85 -> 129;
                    case 86 -> 70;
                    case 87 -> 106;
                    case 88 -> 204;
                    case 89 -> 202;
                    case 90 -> 151;
                    case 91 -> 51;
                    case 92 -> 19;
                    case 93 -> 31;
                    case 94 -> 146;
                    case 95 -> 185;
                    case 96 -> 228;
                    case 97 -> 168;
                    case 98 -> 47;
                    case 99 -> 235;
                    case 100 -> 100;
                    case 101 -> 65;
                    case 102 -> 157;
                    case 103 -> 20;
                    case 104 -> 58;
                    case 105 -> 183;
                    case 106 -> 245;
                    case 107 -> 215;
                    case 108 -> 154;
                    case 109 -> 242;
                    case 110 -> 179;
                    case 111 -> 184;
                    case 112 -> 196;
                    case 113 -> 173;
                    case 114 -> 42;
                    case 115 -> 194;
                    case 116 -> 52;
                    case 117 -> 149;
                    case 118 -> 5;
                    case 119 -> 95;
                    case 120 -> 57;
                    case 121 -> 237;
                    case 122 -> 211;
                    case 123 -> 163;
                    case 124 -> 255;
                    case 125 -> 171;
                    case 126 -> 13;
                    case 127 -> 35;
                    case 128 -> 186;
                    case 129 -> 46;
                    case 130 -> 218;
                    case 131 -> 64;
                    case 132 -> 81;
                    case 133 -> 199;
                    case 134 -> 88;
                    case 135 -> 134;
                    case 136 -> 87;
                    case 137 -> 45;
                    case 138 -> 98;
                    case 139 -> 113;
                    case 140 -> 82;
                    case 141 -> 234;
                    case 142 -> 120;
                    case 143 -> 108;
                    case 144 -> 249;
                    case 145 -> 77;
                    case 146 -> 89;
                    case 147 -> 25;
                    case 148 -> 0;
                    case 149 -> 239;
                    case 150 -> 17;
                    case 151 -> 138;
                    case 152 -> 28;
                    case 153 -> 180;
                    case 154 -> 240;
                    case 155 -> 104;
                    case 156 -> 83;
                    case 157 -> 128;
                    case 158 -> 161;
                    case 159 -> 136;
                    case 160 -> 181;
                    case 161 -> 99;
                    case 162 -> 4;
                    case 163 -> 207;
                    case 164 -> 162;
                    case 165 -> 252;
                    case 166 -> 110;
                    case 167 -> 191;
                    case 168 -> 223;
                    case 169 -> 178;
                    case 170 -> 72;
                    case 171 -> 54;
                    case 172 -> 32;
                    case 173 -> 246;
                    case 174 -> 192;
                    case 175 -> 144;
                    case 176 -> 55;
                    case 177 -> 222;
                    case 178 -> 132;
                    case 179 -> 148;
                    case 180 -> 137;
                    case 181 -> 195;
                    case 182 -> 7;
                    case 183 -> 117;
                    case 184 -> 220;
                    case 185 -> 109;
                    case 186 -> 126;
                    case 187 -> 69;
                    case 188 -> 111;
                    case 189 -> 33;
                    case 190 -> 232;
                    case 191 -> 67;
                    case 192 -> 56;
                    case 193 -> 244;
                    case 194 -> 241;
                    case 195 -> 219;
                    case 196 -> 12;
                    case 197 -> 176;
                    case 198 -> 135;
                    case 199 -> 229;
                    case 200 -> 253;
                    case 201 -> 197;
                    case 202 -> 156;
                    case 203 -> 3;
                    case 204 -> 36;
                    case 205 -> 102;
                    case 206 -> 44;
                    case 207 -> 165;
                    case 208 -> 116;
                    case 209 -> 152;
                    case 210 -> 123;
                    case 211 -> 14;
                    case 212 -> 101;
                    case 213 -> 79;
                    case 214 -> 96;
                    case 215 -> 68;
                    case 216 -> 205;
                    case 217 -> 103;
                    case 218 -> 150;
                    case 219 -> 247;
                    case 220 -> 121;
                    case 221 -> 118;
                    case 222 -> 43;
                    case 223 -> 231;
                    case 224 -> 115;
                    case 225 -> 209;
                    case 226 -> 213;
                    case 227 -> 11;
                    case 228 -> 248;
                    case 229 -> 63;
                    case 230 -> 238;
                    case 231 -> 86;
                    case 232 -> 124;
                    case 233 -> 75;
                    case 234 -> 15;
                    case 235 -> 140;
                    case 236 -> 254;
                    case 237 -> 30;
                    case 238 -> 97;
                    case 239 -> 8;
                    case 240 -> 230;
                    case 241 -> 37;
                    case 242 -> 9;
                    case 243 -> 107;
                    case 244 -> 147;
                    case 245 -> 130;
                    case 246 -> 236;
                    case 247 -> 141;
                    case 248 -> 172;
                    case 249 -> 170;
                    case 250 -> 85;
                    case 251 -> 119;
                    case 252 -> 175;
                    case 253 -> 21;
                    case 254 -> 6;
                    default -> 114;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                PipeReadableByteChannel.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeWritableByteChannel;", "Ljava/nio/channels/WritableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeWritableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "write", "", "src", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    private static final class PipeWritableByteChannel
    implements WritableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeWritableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l2 = 23128223440549L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeWritableByteChannel.a(175502730 - (char)-12546, 175502730 - (char)-24408, (int)l2));
            this.agent = agent;
        }

        @Override
        public int write(@NotNull ByteBuffer src) {
            int n2;
            block7: {
                IntByReference intByReference;
                block8: {
                    long l2 = 102290342542132L;
                    ActionTimestamp[] actionTimestampArray = SshAgentIpcService.m();
                    Intrinsics.checkNotNullParameter((Object)src, (String)PipeWritableByteChannel.a(-1401400440 + -20588, -1401400440 + -16635, (int)l2));
                    ActionTimestamp[] actionTimestampArray2 = actionTimestampArray;
                    try {
                        if (!this.agent.isOpen()) {
                            throw new ClosedChannelException();
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                    intByReference = new IntByReference();
                    byte[] byArray = new byte[src.remaining()];
                    try {
                        try {
                            src.get(byArray);
                            n2 = Kernel32.INSTANCE.WriteFile(this.agent.hPipe, byArray, byArray.length, intByReference, null);
                            if (actionTimestampArray2 != null) break block7;
                            if (n2 != 0) break block8;
                        }
                        catch (RuntimeException runtimeException) {
                            throw PipeWritableByteChannel.a(runtimeException);
                        }
                        return -1;
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                }
                n2 = intByReference.getValue();
            }
            return n2;
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l2 = 124964755683395L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeWritableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block13: {
                var5 = new String[2];
                var3_1 = 0;
                var2_2 = "\u00ddQ\u00df(B\u0003\u00f5s\u008c";
                var4_3 = "\u00ddQ\u00df(B\u0003\u00f5s\u008c".length();
                var1_4 = 5;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    continue;
                    break;
                }
lbl9:
                // 1 sources

                while (true) {
                    var5[var3_1++] = new String(v0).intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block13;
                    break;
                }
                v1 = ++var0_5;
                v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                v3 = v2.length;
                var6_6 = 0;
                v4 = 13;
                v5 = v2;
                v6 = v3;
                if (v3 > 1) ** GOTO lbl67
                do {
                    v7 = v4;
                    v5 = v5;
                    v8 = v5;
                    v9 = v4;
                    v10 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v11 = 108;
                                break;
                            }
                            case 1: {
                                v11 = 27;
                                break;
                            }
                            case 2: {
                                v11 = 109;
                                break;
                            }
                            case 3: {
                                v11 = 40;
                                break;
                            }
                            case 4: {
                                v11 = 5;
                                break;
                            }
                            case 5: {
                                v11 = 114;
                                break;
                            }
                            default: {
                                v11 = 44;
                            }
                        }
                        v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                        ++var6_6;
                        v4 = v7;
                        if (v7 != 0) break;
                        v7 = v4;
                        v5 = v5;
                        v10 = v4;
                        v8 = v5;
                        v9 = v4;
                    }
lbl67:
                    // 2 sources

                    v0 = v5;
                    v6 = v6;
                } while (v6 > var6_6);
                ** while (true)
            }
            PipeWritableByteChannel.a = var5;
            PipeWritableByteChannel.b = new String[2];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0xFFFFF829) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 85;
                    case 1 -> 162;
                    case 2 -> 77;
                    case 3 -> 171;
                    case 4 -> 245;
                    case 5 -> 180;
                    case 6 -> 196;
                    case 7 -> 61;
                    case 8 -> 252;
                    case 9 -> 122;
                    case 10 -> 181;
                    case 11 -> 66;
                    case 12 -> 250;
                    case 13 -> 96;
                    case 14 -> 59;
                    case 15 -> 46;
                    case 16 -> 202;
                    case 17 -> 237;
                    case 18 -> 175;
                    case 19 -> 152;
                    case 20 -> 174;
                    case 21 -> 224;
                    case 22 -> 30;
                    case 23 -> 148;
                    case 24 -> 105;
                    case 25 -> 195;
                    case 26 -> 156;
                    case 27 -> 29;
                    case 28 -> 129;
                    case 29 -> 133;
                    case 30 -> 103;
                    case 31 -> 63;
                    case 32 -> 220;
                    case 33 -> 164;
                    case 34 -> 240;
                    case 35 -> 229;
                    case 36 -> 205;
                    case 37 -> 139;
                    case 38 -> 94;
                    case 39 -> 113;
                    case 40 -> 131;
                    case 41 -> 227;
                    case 42 -> 170;
                    case 43 -> 218;
                    case 44 -> 155;
                    case 45 -> 138;
                    case 46 -> 215;
                    case 47 -> 242;
                    case 48 -> 178;
                    case 49 -> 188;
                    case 50 -> 87;
                    case 51 -> 110;
                    case 52 -> 26;
                    case 53 -> 134;
                    case 54 -> 47;
                    case 55 -> 2;
                    case 56 -> 217;
                    case 57 -> 34;
                    case 58 -> 125;
                    case 59 -> 225;
                    case 60 -> 235;
                    case 61 -> 1;
                    case 62 -> 151;
                    case 63 -> 3;
                    case 64 -> 36;
                    case 65 -> 158;
                    case 66 -> 41;
                    case 67 -> 117;
                    case 68 -> 33;
                    case 69 -> 120;
                    case 70 -> 73;
                    case 71 -> 17;
                    case 72 -> 75;
                    case 73 -> 97;
                    case 74 -> 239;
                    case 75 -> 20;
                    case 76 -> 226;
                    case 77 -> 208;
                    case 78 -> 118;
                    case 79 -> 38;
                    case 80 -> 222;
                    case 81 -> 168;
                    case 82 -> 223;
                    case 83 -> 145;
                    case 84 -> 153;
                    case 85 -> 14;
                    case 86 -> 244;
                    case 87 -> 62;
                    case 88 -> 90;
                    case 89 -> 214;
                    case 90 -> 50;
                    case 91 -> 93;
                    case 92 -> 71;
                    case 93 -> 236;
                    case 94 -> 72;
                    case 95 -> 70;
                    case 96 -> 102;
                    case 97 -> 142;
                    case 98 -> 146;
                    case 99 -> 100;
                    case 100 -> 52;
                    case 101 -> 197;
                    case 102 -> 22;
                    case 103 -> 234;
                    case 104 -> 68;
                    case 105 -> 10;
                    case 106 -> 119;
                    case 107 -> 65;
                    case 108 -> 12;
                    case 109 -> 11;
                    case 110 -> 86;
                    case 111 -> 207;
                    case 112 -> 137;
                    case 113 -> 247;
                    case 114 -> 64;
                    case 115 -> 253;
                    case 116 -> 116;
                    case 117 -> 161;
                    case 118 -> 81;
                    case 119 -> 204;
                    case 120 -> 95;
                    case 121 -> 42;
                    case 122 -> 57;
                    case 123 -> 114;
                    case 124 -> 216;
                    case 125 -> 184;
                    case 126 -> 23;
                    case 127 -> 123;
                    case 128 -> 209;
                    case 129 -> 27;
                    case 130 -> 104;
                    case 131 -> 15;
                    case 132 -> 54;
                    case 133 -> 163;
                    case 134 -> 43;
                    case 135 -> 233;
                    case 136 -> 69;
                    case 137 -> 248;
                    case 138 -> 35;
                    case 139 -> 199;
                    case 140 -> 91;
                    case 141 -> 37;
                    case 142 -> 25;
                    case 143 -> 150;
                    case 144 -> 187;
                    case 145 -> 166;
                    case 146 -> 84;
                    case 147 -> 159;
                    case 148 -> 210;
                    case 149 -> 169;
                    case 150 -> 149;
                    case 151 -> 243;
                    case 152 -> 83;
                    case 153 -> 193;
                    case 154 -> 140;
                    case 155 -> 249;
                    case 156 -> 130;
                    case 157 -> 7;
                    case 158 -> 124;
                    case 159 -> 128;
                    case 160 -> 231;
                    case 161 -> 241;
                    case 162 -> 0;
                    case 163 -> 203;
                    case 164 -> 167;
                    case 165 -> 191;
                    case 166 -> 55;
                    case 167 -> 67;
                    case 168 -> 80;
                    case 169 -> 121;
                    case 170 -> 49;
                    case 171 -> 109;
                    case 172 -> 200;
                    case 173 -> 176;
                    case 174 -> 19;
                    case 175 -> 44;
                    case 176 -> 31;
                    case 177 -> 16;
                    case 178 -> 238;
                    case 179 -> 13;
                    case 180 -> 228;
                    case 181 -> 76;
                    case 182 -> 79;
                    case 183 -> 173;
                    case 184 -> 160;
                    case 185 -> 165;
                    case 186 -> 51;
                    case 187 -> 251;
                    case 188 -> 106;
                    case 189 -> 157;
                    case 190 -> 53;
                    case 191 -> 6;
                    case 192 -> 101;
                    case 193 -> 4;
                    case 194 -> 88;
                    case 195 -> 132;
                    case 196 -> 179;
                    case 197 -> 92;
                    case 198 -> 24;
                    case 199 -> 143;
                    case 200 -> 60;
                    case 201 -> 40;
                    case 202 -> 194;
                    case 203 -> 136;
                    case 204 -> 107;
                    case 205 -> 141;
                    case 206 -> 147;
                    case 207 -> 185;
                    case 208 -> 221;
                    case 209 -> 246;
                    case 210 -> 232;
                    case 211 -> 99;
                    case 212 -> 28;
                    case 213 -> 255;
                    case 214 -> 74;
                    case 215 -> 18;
                    case 216 -> 230;
                    case 217 -> 45;
                    case 218 -> 186;
                    case 219 -> 9;
                    case 220 -> 115;
                    case 221 -> 192;
                    case 222 -> 39;
                    case 223 -> 78;
                    case 224 -> 219;
                    case 225 -> 201;
                    case 226 -> 48;
                    case 227 -> 154;
                    case 228 -> 5;
                    case 229 -> 127;
                    case 230 -> 254;
                    case 231 -> 183;
                    case 232 -> 21;
                    case 233 -> 8;
                    case 234 -> 198;
                    case 235 -> 56;
                    case 236 -> 108;
                    case 237 -> 98;
                    case 238 -> 182;
                    case 239 -> 206;
                    case 240 -> 177;
                    case 241 -> 212;
                    case 242 -> 172;
                    case 243 -> 189;
                    case 244 -> 135;
                    case 245 -> 213;
                    case 246 -> 58;
                    case 247 -> 144;
                    case 248 -> 211;
                    case 249 -> 190;
                    case 250 -> 82;
                    case 251 -> 111;
                    case 252 -> 112;
                    case 253 -> 126;
                    case 254 -> 89;
                    default -> 32;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                PipeWritableByteChannel.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }
}

