// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go_gapic. DO NOT EDIT.

package stitcher

import (
	"context"
	"fmt"
	"math"
	"net/url"
	"time"

	"cloud.google.com/go/longrunning"
	lroauto "cloud.google.com/go/longrunning/autogen"
	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	stitcherpb "cloud.google.com/go/video/stitcher/apiv1/stitcherpb"
	gax "github.com/googleapis/gax-go/v2"
	"google.golang.org/api/iterator"
	"google.golang.org/api/option"
	"google.golang.org/api/option/internaloption"
	gtransport "google.golang.org/api/transport/grpc"
	"google.golang.org/grpc"
	"google.golang.org/protobuf/proto"
)

var newVideoStitcherClientHook clientHook

// VideoStitcherCallOptions contains the retry settings for each method of VideoStitcherClient.
type VideoStitcherCallOptions struct {
	CreateCdnKey         []gax.CallOption
	ListCdnKeys          []gax.CallOption
	GetCdnKey            []gax.CallOption
	DeleteCdnKey         []gax.CallOption
	UpdateCdnKey         []gax.CallOption
	CreateVodSession     []gax.CallOption
	GetVodSession        []gax.CallOption
	ListVodStitchDetails []gax.CallOption
	GetVodStitchDetail   []gax.CallOption
	ListVodAdTagDetails  []gax.CallOption
	GetVodAdTagDetail    []gax.CallOption
	ListLiveAdTagDetails []gax.CallOption
	GetLiveAdTagDetail   []gax.CallOption
	CreateSlate          []gax.CallOption
	ListSlates           []gax.CallOption
	GetSlate             []gax.CallOption
	UpdateSlate          []gax.CallOption
	DeleteSlate          []gax.CallOption
	CreateLiveSession    []gax.CallOption
	GetLiveSession       []gax.CallOption
	CreateLiveConfig     []gax.CallOption
	ListLiveConfigs      []gax.CallOption
	GetLiveConfig        []gax.CallOption
	DeleteLiveConfig     []gax.CallOption
	CancelOperation      []gax.CallOption
	DeleteOperation      []gax.CallOption
	GetOperation         []gax.CallOption
	ListOperations       []gax.CallOption
}

func defaultVideoStitcherGRPCClientOptions() []option.ClientOption {
	return []option.ClientOption{
		internaloption.WithDefaultEndpoint("videostitcher.googleapis.com:443"),
		internaloption.WithDefaultEndpointTemplate("videostitcher.UNIVERSE_DOMAIN:443"),
		internaloption.WithDefaultMTLSEndpoint("videostitcher.mtls.googleapis.com:443"),
		internaloption.WithDefaultUniverseDomain("googleapis.com"),
		internaloption.WithDefaultAudience("https://videostitcher.googleapis.com/"),
		internaloption.WithDefaultScopes(DefaultAuthScopes()...),
		internaloption.EnableJwtWithScope(),
		option.WithGRPCDialOption(grpc.WithDefaultCallOptions(
			grpc.MaxCallRecvMsgSize(math.MaxInt32))),
	}
}

func defaultVideoStitcherCallOptions() *VideoStitcherCallOptions {
	return &VideoStitcherCallOptions{
		CreateCdnKey: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		ListCdnKeys: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		GetCdnKey: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		DeleteCdnKey: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		UpdateCdnKey: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		CreateVodSession: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		GetVodSession: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		ListVodStitchDetails: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		GetVodStitchDetail: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		ListVodAdTagDetails: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		GetVodAdTagDetail: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		ListLiveAdTagDetails: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		GetLiveAdTagDetail: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		CreateSlate: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		ListSlates: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		GetSlate: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		UpdateSlate: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		DeleteSlate: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		CreateLiveSession: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		GetLiveSession: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		CreateLiveConfig: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		ListLiveConfigs: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		GetLiveConfig: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		DeleteLiveConfig: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		CancelOperation: []gax.CallOption{},
		DeleteOperation: []gax.CallOption{},
		GetOperation:    []gax.CallOption{},
		ListOperations:  []gax.CallOption{},
	}
}

// internalVideoStitcherClient is an interface that defines the methods available from Video Stitcher API.
type internalVideoStitcherClient interface {
	Close() error
	setGoogleClientInfo(...string)
	Connection() *grpc.ClientConn
	CreateCdnKey(context.Context, *stitcherpb.CreateCdnKeyRequest, ...gax.CallOption) (*CreateCdnKeyOperation, error)
	CreateCdnKeyOperation(name string) *CreateCdnKeyOperation
	ListCdnKeys(context.Context, *stitcherpb.ListCdnKeysRequest, ...gax.CallOption) *CdnKeyIterator
	GetCdnKey(context.Context, *stitcherpb.GetCdnKeyRequest, ...gax.CallOption) (*stitcherpb.CdnKey, error)
	DeleteCdnKey(context.Context, *stitcherpb.DeleteCdnKeyRequest, ...gax.CallOption) (*DeleteCdnKeyOperation, error)
	DeleteCdnKeyOperation(name string) *DeleteCdnKeyOperation
	UpdateCdnKey(context.Context, *stitcherpb.UpdateCdnKeyRequest, ...gax.CallOption) (*UpdateCdnKeyOperation, error)
	UpdateCdnKeyOperation(name string) *UpdateCdnKeyOperation
	CreateVodSession(context.Context, *stitcherpb.CreateVodSessionRequest, ...gax.CallOption) (*stitcherpb.VodSession, error)
	GetVodSession(context.Context, *stitcherpb.GetVodSessionRequest, ...gax.CallOption) (*stitcherpb.VodSession, error)
	ListVodStitchDetails(context.Context, *stitcherpb.ListVodStitchDetailsRequest, ...gax.CallOption) *VodStitchDetailIterator
	GetVodStitchDetail(context.Context, *stitcherpb.GetVodStitchDetailRequest, ...gax.CallOption) (*stitcherpb.VodStitchDetail, error)
	ListVodAdTagDetails(context.Context, *stitcherpb.ListVodAdTagDetailsRequest, ...gax.CallOption) *VodAdTagDetailIterator
	GetVodAdTagDetail(context.Context, *stitcherpb.GetVodAdTagDetailRequest, ...gax.CallOption) (*stitcherpb.VodAdTagDetail, error)
	ListLiveAdTagDetails(context.Context, *stitcherpb.ListLiveAdTagDetailsRequest, ...gax.CallOption) *LiveAdTagDetailIterator
	GetLiveAdTagDetail(context.Context, *stitcherpb.GetLiveAdTagDetailRequest, ...gax.CallOption) (*stitcherpb.LiveAdTagDetail, error)
	CreateSlate(context.Context, *stitcherpb.CreateSlateRequest, ...gax.CallOption) (*CreateSlateOperation, error)
	CreateSlateOperation(name string) *CreateSlateOperation
	ListSlates(context.Context, *stitcherpb.ListSlatesRequest, ...gax.CallOption) *SlateIterator
	GetSlate(context.Context, *stitcherpb.GetSlateRequest, ...gax.CallOption) (*stitcherpb.Slate, error)
	UpdateSlate(context.Context, *stitcherpb.UpdateSlateRequest, ...gax.CallOption) (*UpdateSlateOperation, error)
	UpdateSlateOperation(name string) *UpdateSlateOperation
	DeleteSlate(context.Context, *stitcherpb.DeleteSlateRequest, ...gax.CallOption) (*DeleteSlateOperation, error)
	DeleteSlateOperation(name string) *DeleteSlateOperation
	CreateLiveSession(context.Context, *stitcherpb.CreateLiveSessionRequest, ...gax.CallOption) (*stitcherpb.LiveSession, error)
	GetLiveSession(context.Context, *stitcherpb.GetLiveSessionRequest, ...gax.CallOption) (*stitcherpb.LiveSession, error)
	CreateLiveConfig(context.Context, *stitcherpb.CreateLiveConfigRequest, ...gax.CallOption) (*CreateLiveConfigOperation, error)
	CreateLiveConfigOperation(name string) *CreateLiveConfigOperation
	ListLiveConfigs(context.Context, *stitcherpb.ListLiveConfigsRequest, ...gax.CallOption) *LiveConfigIterator
	GetLiveConfig(context.Context, *stitcherpb.GetLiveConfigRequest, ...gax.CallOption) (*stitcherpb.LiveConfig, error)
	DeleteLiveConfig(context.Context, *stitcherpb.DeleteLiveConfigRequest, ...gax.CallOption) (*DeleteLiveConfigOperation, error)
	DeleteLiveConfigOperation(name string) *DeleteLiveConfigOperation
	CancelOperation(context.Context, *longrunningpb.CancelOperationRequest, ...gax.CallOption) error
	DeleteOperation(context.Context, *longrunningpb.DeleteOperationRequest, ...gax.CallOption) error
	GetOperation(context.Context, *longrunningpb.GetOperationRequest, ...gax.CallOption) (*longrunningpb.Operation, error)
	ListOperations(context.Context, *longrunningpb.ListOperationsRequest, ...gax.CallOption) *OperationIterator
}

// VideoStitcherClient is a client for interacting with Video Stitcher API.
// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
//
// Video-On-Demand content stitching API allows you to insert ads
// into (VoD) video on demand files. You will be able to render custom
// scrubber bars with highlighted ads, enforce ad policies, allow
// seamless playback and tracking on native players and monetize
// content with any standard VMAP compliant ad server.
type VideoStitcherClient struct {
	// The internal transport-dependent client.
	internalClient internalVideoStitcherClient

	// The call options for this service.
	CallOptions *VideoStitcherCallOptions

	// LROClient is used internally to handle long-running operations.
	// It is exposed so that its CallOptions can be modified if required.
	// Users should not Close this client.
	LROClient *lroauto.OperationsClient
}

// Wrapper methods routed to the internal client.

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *VideoStitcherClient) Close() error {
	return c.internalClient.Close()
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *VideoStitcherClient) setGoogleClientInfo(keyval ...string) {
	c.internalClient.setGoogleClientInfo(keyval...)
}

// Connection returns a connection to the API service.
//
// Deprecated: Connections are now pooled so this method does not always
// return the same resource.
func (c *VideoStitcherClient) Connection() *grpc.ClientConn {
	return c.internalClient.Connection()
}

// CreateCdnKey creates a new CDN key.
func (c *VideoStitcherClient) CreateCdnKey(ctx context.Context, req *stitcherpb.CreateCdnKeyRequest, opts ...gax.CallOption) (*CreateCdnKeyOperation, error) {
	return c.internalClient.CreateCdnKey(ctx, req, opts...)
}

// CreateCdnKeyOperation returns a new CreateCdnKeyOperation from a given name.
// The name must be that of a previously created CreateCdnKeyOperation, possibly from a different process.
func (c *VideoStitcherClient) CreateCdnKeyOperation(name string) *CreateCdnKeyOperation {
	return c.internalClient.CreateCdnKeyOperation(name)
}

// ListCdnKeys lists all CDN keys in the specified project and location.
func (c *VideoStitcherClient) ListCdnKeys(ctx context.Context, req *stitcherpb.ListCdnKeysRequest, opts ...gax.CallOption) *CdnKeyIterator {
	return c.internalClient.ListCdnKeys(ctx, req, opts...)
}

// GetCdnKey returns the specified CDN key.
func (c *VideoStitcherClient) GetCdnKey(ctx context.Context, req *stitcherpb.GetCdnKeyRequest, opts ...gax.CallOption) (*stitcherpb.CdnKey, error) {
	return c.internalClient.GetCdnKey(ctx, req, opts...)
}

// DeleteCdnKey deletes the specified CDN key.
func (c *VideoStitcherClient) DeleteCdnKey(ctx context.Context, req *stitcherpb.DeleteCdnKeyRequest, opts ...gax.CallOption) (*DeleteCdnKeyOperation, error) {
	return c.internalClient.DeleteCdnKey(ctx, req, opts...)
}

// DeleteCdnKeyOperation returns a new DeleteCdnKeyOperation from a given name.
// The name must be that of a previously created DeleteCdnKeyOperation, possibly from a different process.
func (c *VideoStitcherClient) DeleteCdnKeyOperation(name string) *DeleteCdnKeyOperation {
	return c.internalClient.DeleteCdnKeyOperation(name)
}

// UpdateCdnKey updates the specified CDN key. Only update fields specified
// in the call method body.
func (c *VideoStitcherClient) UpdateCdnKey(ctx context.Context, req *stitcherpb.UpdateCdnKeyRequest, opts ...gax.CallOption) (*UpdateCdnKeyOperation, error) {
	return c.internalClient.UpdateCdnKey(ctx, req, opts...)
}

// UpdateCdnKeyOperation returns a new UpdateCdnKeyOperation from a given name.
// The name must be that of a previously created UpdateCdnKeyOperation, possibly from a different process.
func (c *VideoStitcherClient) UpdateCdnKeyOperation(name string) *UpdateCdnKeyOperation {
	return c.internalClient.UpdateCdnKeyOperation(name)
}

// CreateVodSession creates a client side playback VOD session and returns the full
// tracking and playback metadata of the session.
func (c *VideoStitcherClient) CreateVodSession(ctx context.Context, req *stitcherpb.CreateVodSessionRequest, opts ...gax.CallOption) (*stitcherpb.VodSession, error) {
	return c.internalClient.CreateVodSession(ctx, req, opts...)
}

// GetVodSession returns the full tracking, playback metadata, and relevant ad-ops
// logs for the specified VOD session.
func (c *VideoStitcherClient) GetVodSession(ctx context.Context, req *stitcherpb.GetVodSessionRequest, opts ...gax.CallOption) (*stitcherpb.VodSession, error) {
	return c.internalClient.GetVodSession(ctx, req, opts...)
}

// ListVodStitchDetails returns a list of detailed stitching information of the specified VOD
// session.
func (c *VideoStitcherClient) ListVodStitchDetails(ctx context.Context, req *stitcherpb.ListVodStitchDetailsRequest, opts ...gax.CallOption) *VodStitchDetailIterator {
	return c.internalClient.ListVodStitchDetails(ctx, req, opts...)
}

// GetVodStitchDetail returns the specified stitching information for the specified VOD session.
func (c *VideoStitcherClient) GetVodStitchDetail(ctx context.Context, req *stitcherpb.GetVodStitchDetailRequest, opts ...gax.CallOption) (*stitcherpb.VodStitchDetail, error) {
	return c.internalClient.GetVodStitchDetail(ctx, req, opts...)
}

// ListVodAdTagDetails return the list of ad tag details for the specified VOD session.
func (c *VideoStitcherClient) ListVodAdTagDetails(ctx context.Context, req *stitcherpb.ListVodAdTagDetailsRequest, opts ...gax.CallOption) *VodAdTagDetailIterator {
	return c.internalClient.ListVodAdTagDetails(ctx, req, opts...)
}

// GetVodAdTagDetail returns the specified ad tag detail for the specified VOD session.
func (c *VideoStitcherClient) GetVodAdTagDetail(ctx context.Context, req *stitcherpb.GetVodAdTagDetailRequest, opts ...gax.CallOption) (*stitcherpb.VodAdTagDetail, error) {
	return c.internalClient.GetVodAdTagDetail(ctx, req, opts...)
}

// ListLiveAdTagDetails return the list of ad tag details for the specified live session.
func (c *VideoStitcherClient) ListLiveAdTagDetails(ctx context.Context, req *stitcherpb.ListLiveAdTagDetailsRequest, opts ...gax.CallOption) *LiveAdTagDetailIterator {
	return c.internalClient.ListLiveAdTagDetails(ctx, req, opts...)
}

// GetLiveAdTagDetail returns the specified ad tag detail for the specified live session.
func (c *VideoStitcherClient) GetLiveAdTagDetail(ctx context.Context, req *stitcherpb.GetLiveAdTagDetailRequest, opts ...gax.CallOption) (*stitcherpb.LiveAdTagDetail, error) {
	return c.internalClient.GetLiveAdTagDetail(ctx, req, opts...)
}

// CreateSlate creates a slate.
func (c *VideoStitcherClient) CreateSlate(ctx context.Context, req *stitcherpb.CreateSlateRequest, opts ...gax.CallOption) (*CreateSlateOperation, error) {
	return c.internalClient.CreateSlate(ctx, req, opts...)
}

// CreateSlateOperation returns a new CreateSlateOperation from a given name.
// The name must be that of a previously created CreateSlateOperation, possibly from a different process.
func (c *VideoStitcherClient) CreateSlateOperation(name string) *CreateSlateOperation {
	return c.internalClient.CreateSlateOperation(name)
}

// ListSlates lists all slates in the specified project and location.
func (c *VideoStitcherClient) ListSlates(ctx context.Context, req *stitcherpb.ListSlatesRequest, opts ...gax.CallOption) *SlateIterator {
	return c.internalClient.ListSlates(ctx, req, opts...)
}

// GetSlate returns the specified slate.
func (c *VideoStitcherClient) GetSlate(ctx context.Context, req *stitcherpb.GetSlateRequest, opts ...gax.CallOption) (*stitcherpb.Slate, error) {
	return c.internalClient.GetSlate(ctx, req, opts...)
}

// UpdateSlate updates the specified slate.
func (c *VideoStitcherClient) UpdateSlate(ctx context.Context, req *stitcherpb.UpdateSlateRequest, opts ...gax.CallOption) (*UpdateSlateOperation, error) {
	return c.internalClient.UpdateSlate(ctx, req, opts...)
}

// UpdateSlateOperation returns a new UpdateSlateOperation from a given name.
// The name must be that of a previously created UpdateSlateOperation, possibly from a different process.
func (c *VideoStitcherClient) UpdateSlateOperation(name string) *UpdateSlateOperation {
	return c.internalClient.UpdateSlateOperation(name)
}

// DeleteSlate deletes the specified slate.
func (c *VideoStitcherClient) DeleteSlate(ctx context.Context, req *stitcherpb.DeleteSlateRequest, opts ...gax.CallOption) (*DeleteSlateOperation, error) {
	return c.internalClient.DeleteSlate(ctx, req, opts...)
}

// DeleteSlateOperation returns a new DeleteSlateOperation from a given name.
// The name must be that of a previously created DeleteSlateOperation, possibly from a different process.
func (c *VideoStitcherClient) DeleteSlateOperation(name string) *DeleteSlateOperation {
	return c.internalClient.DeleteSlateOperation(name)
}

// CreateLiveSession creates a new live session.
func (c *VideoStitcherClient) CreateLiveSession(ctx context.Context, req *stitcherpb.CreateLiveSessionRequest, opts ...gax.CallOption) (*stitcherpb.LiveSession, error) {
	return c.internalClient.CreateLiveSession(ctx, req, opts...)
}

// GetLiveSession returns the details for the specified live session.
func (c *VideoStitcherClient) GetLiveSession(ctx context.Context, req *stitcherpb.GetLiveSessionRequest, opts ...gax.CallOption) (*stitcherpb.LiveSession, error) {
	return c.internalClient.GetLiveSession(ctx, req, opts...)
}

// CreateLiveConfig registers the live config with the provided unique ID in
// the specified region.
func (c *VideoStitcherClient) CreateLiveConfig(ctx context.Context, req *stitcherpb.CreateLiveConfigRequest, opts ...gax.CallOption) (*CreateLiveConfigOperation, error) {
	return c.internalClient.CreateLiveConfig(ctx, req, opts...)
}

// CreateLiveConfigOperation returns a new CreateLiveConfigOperation from a given name.
// The name must be that of a previously created CreateLiveConfigOperation, possibly from a different process.
func (c *VideoStitcherClient) CreateLiveConfigOperation(name string) *CreateLiveConfigOperation {
	return c.internalClient.CreateLiveConfigOperation(name)
}

// ListLiveConfigs lists all live configs managed by the Video Stitcher that
// belong to the specified project and region.
func (c *VideoStitcherClient) ListLiveConfigs(ctx context.Context, req *stitcherpb.ListLiveConfigsRequest, opts ...gax.CallOption) *LiveConfigIterator {
	return c.internalClient.ListLiveConfigs(ctx, req, opts...)
}

// GetLiveConfig returns the specified live config managed by the Video
// Stitcher service.
func (c *VideoStitcherClient) GetLiveConfig(ctx context.Context, req *stitcherpb.GetLiveConfigRequest, opts ...gax.CallOption) (*stitcherpb.LiveConfig, error) {
	return c.internalClient.GetLiveConfig(ctx, req, opts...)
}

// DeleteLiveConfig deletes the specified live config.
func (c *VideoStitcherClient) DeleteLiveConfig(ctx context.Context, req *stitcherpb.DeleteLiveConfigRequest, opts ...gax.CallOption) (*DeleteLiveConfigOperation, error) {
	return c.internalClient.DeleteLiveConfig(ctx, req, opts...)
}

// DeleteLiveConfigOperation returns a new DeleteLiveConfigOperation from a given name.
// The name must be that of a previously created DeleteLiveConfigOperation, possibly from a different process.
func (c *VideoStitcherClient) DeleteLiveConfigOperation(name string) *DeleteLiveConfigOperation {
	return c.internalClient.DeleteLiveConfigOperation(name)
}

// CancelOperation is a utility method from google.longrunning.Operations.
func (c *VideoStitcherClient) CancelOperation(ctx context.Context, req *longrunningpb.CancelOperationRequest, opts ...gax.CallOption) error {
	return c.internalClient.CancelOperation(ctx, req, opts...)
}

// DeleteOperation is a utility method from google.longrunning.Operations.
func (c *VideoStitcherClient) DeleteOperation(ctx context.Context, req *longrunningpb.DeleteOperationRequest, opts ...gax.CallOption) error {
	return c.internalClient.DeleteOperation(ctx, req, opts...)
}

// GetOperation is a utility method from google.longrunning.Operations.
func (c *VideoStitcherClient) GetOperation(ctx context.Context, req *longrunningpb.GetOperationRequest, opts ...gax.CallOption) (*longrunningpb.Operation, error) {
	return c.internalClient.GetOperation(ctx, req, opts...)
}

// ListOperations is a utility method from google.longrunning.Operations.
func (c *VideoStitcherClient) ListOperations(ctx context.Context, req *longrunningpb.ListOperationsRequest, opts ...gax.CallOption) *OperationIterator {
	return c.internalClient.ListOperations(ctx, req, opts...)
}

// videoStitcherGRPCClient is a client for interacting with Video Stitcher API over gRPC transport.
//
// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
type videoStitcherGRPCClient struct {
	// Connection pool of gRPC connections to the service.
	connPool gtransport.ConnPool

	// Points back to the CallOptions field of the containing VideoStitcherClient
	CallOptions **VideoStitcherCallOptions

	// The gRPC API client.
	videoStitcherClient stitcherpb.VideoStitcherServiceClient

	// LROClient is used internally to handle long-running operations.
	// It is exposed so that its CallOptions can be modified if required.
	// Users should not Close this client.
	LROClient **lroauto.OperationsClient

	operationsClient longrunningpb.OperationsClient

	// The x-goog-* metadata to be sent with each request.
	xGoogHeaders []string
}

// NewVideoStitcherClient creates a new video stitcher service client based on gRPC.
// The returned client must be Closed when it is done being used to clean up its underlying connections.
//
// Video-On-Demand content stitching API allows you to insert ads
// into (VoD) video on demand files. You will be able to render custom
// scrubber bars with highlighted ads, enforce ad policies, allow
// seamless playback and tracking on native players and monetize
// content with any standard VMAP compliant ad server.
func NewVideoStitcherClient(ctx context.Context, opts ...option.ClientOption) (*VideoStitcherClient, error) {
	clientOpts := defaultVideoStitcherGRPCClientOptions()
	if newVideoStitcherClientHook != nil {
		hookOpts, err := newVideoStitcherClientHook(ctx, clientHookParams{})
		if err != nil {
			return nil, err
		}
		clientOpts = append(clientOpts, hookOpts...)
	}

	connPool, err := gtransport.DialPool(ctx, append(clientOpts, opts...)...)
	if err != nil {
		return nil, err
	}
	client := VideoStitcherClient{CallOptions: defaultVideoStitcherCallOptions()}

	c := &videoStitcherGRPCClient{
		connPool:            connPool,
		videoStitcherClient: stitcherpb.NewVideoStitcherServiceClient(connPool),
		CallOptions:         &client.CallOptions,
		operationsClient:    longrunningpb.NewOperationsClient(connPool),
	}
	c.setGoogleClientInfo()

	client.internalClient = c

	client.LROClient, err = lroauto.NewOperationsClient(ctx, gtransport.WithConnPool(connPool))
	if err != nil {
		// This error "should not happen", since we are just reusing old connection pool
		// and never actually need to dial.
		// If this does happen, we could leak connp. However, we cannot close conn:
		// If the user invoked the constructor with option.WithGRPCConn,
		// we would close a connection that's still in use.
		// TODO: investigate error conditions.
		return nil, err
	}
	c.LROClient = &client.LROClient
	return &client, nil
}

// Connection returns a connection to the API service.
//
// Deprecated: Connections are now pooled so this method does not always
// return the same resource.
func (c *videoStitcherGRPCClient) Connection() *grpc.ClientConn {
	return c.connPool.Conn()
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *videoStitcherGRPCClient) setGoogleClientInfo(keyval ...string) {
	kv := append([]string{"gl-go", gax.GoVersion}, keyval...)
	kv = append(kv, "gapic", getVersionClient(), "gax", gax.Version, "grpc", grpc.Version)
	c.xGoogHeaders = []string{"x-goog-api-client", gax.XGoogHeader(kv...)}
}

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *videoStitcherGRPCClient) Close() error {
	return c.connPool.Close()
}

func (c *videoStitcherGRPCClient) CreateCdnKey(ctx context.Context, req *stitcherpb.CreateCdnKeyRequest, opts ...gax.CallOption) (*CreateCdnKeyOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).CreateCdnKey[0:len((*c.CallOptions).CreateCdnKey):len((*c.CallOptions).CreateCdnKey)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.videoStitcherClient.CreateCdnKey(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &CreateCdnKeyOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *videoStitcherGRPCClient) ListCdnKeys(ctx context.Context, req *stitcherpb.ListCdnKeysRequest, opts ...gax.CallOption) *CdnKeyIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListCdnKeys[0:len((*c.CallOptions).ListCdnKeys):len((*c.CallOptions).ListCdnKeys)], opts...)
	it := &CdnKeyIterator{}
	req = proto.Clone(req).(*stitcherpb.ListCdnKeysRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*stitcherpb.CdnKey, string, error) {
		resp := &stitcherpb.ListCdnKeysResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = c.videoStitcherClient.ListCdnKeys(ctx, req, settings.GRPC...)
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetCdnKeys(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *videoStitcherGRPCClient) GetCdnKey(ctx context.Context, req *stitcherpb.GetCdnKeyRequest, opts ...gax.CallOption) (*stitcherpb.CdnKey, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetCdnKey[0:len((*c.CallOptions).GetCdnKey):len((*c.CallOptions).GetCdnKey)], opts...)
	var resp *stitcherpb.CdnKey
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.videoStitcherClient.GetCdnKey(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *videoStitcherGRPCClient) DeleteCdnKey(ctx context.Context, req *stitcherpb.DeleteCdnKeyRequest, opts ...gax.CallOption) (*DeleteCdnKeyOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).DeleteCdnKey[0:len((*c.CallOptions).DeleteCdnKey):len((*c.CallOptions).DeleteCdnKey)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.videoStitcherClient.DeleteCdnKey(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &DeleteCdnKeyOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *videoStitcherGRPCClient) UpdateCdnKey(ctx context.Context, req *stitcherpb.UpdateCdnKeyRequest, opts ...gax.CallOption) (*UpdateCdnKeyOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "cdn_key.name", url.QueryEscape(req.GetCdnKey().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).UpdateCdnKey[0:len((*c.CallOptions).UpdateCdnKey):len((*c.CallOptions).UpdateCdnKey)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.videoStitcherClient.UpdateCdnKey(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &UpdateCdnKeyOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *videoStitcherGRPCClient) CreateVodSession(ctx context.Context, req *stitcherpb.CreateVodSessionRequest, opts ...gax.CallOption) (*stitcherpb.VodSession, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).CreateVodSession[0:len((*c.CallOptions).CreateVodSession):len((*c.CallOptions).CreateVodSession)], opts...)
	var resp *stitcherpb.VodSession
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.videoStitcherClient.CreateVodSession(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *videoStitcherGRPCClient) GetVodSession(ctx context.Context, req *stitcherpb.GetVodSessionRequest, opts ...gax.CallOption) (*stitcherpb.VodSession, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetVodSession[0:len((*c.CallOptions).GetVodSession):len((*c.CallOptions).GetVodSession)], opts...)
	var resp *stitcherpb.VodSession
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.videoStitcherClient.GetVodSession(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *videoStitcherGRPCClient) ListVodStitchDetails(ctx context.Context, req *stitcherpb.ListVodStitchDetailsRequest, opts ...gax.CallOption) *VodStitchDetailIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListVodStitchDetails[0:len((*c.CallOptions).ListVodStitchDetails):len((*c.CallOptions).ListVodStitchDetails)], opts...)
	it := &VodStitchDetailIterator{}
	req = proto.Clone(req).(*stitcherpb.ListVodStitchDetailsRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*stitcherpb.VodStitchDetail, string, error) {
		resp := &stitcherpb.ListVodStitchDetailsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = c.videoStitcherClient.ListVodStitchDetails(ctx, req, settings.GRPC...)
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetVodStitchDetails(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *videoStitcherGRPCClient) GetVodStitchDetail(ctx context.Context, req *stitcherpb.GetVodStitchDetailRequest, opts ...gax.CallOption) (*stitcherpb.VodStitchDetail, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetVodStitchDetail[0:len((*c.CallOptions).GetVodStitchDetail):len((*c.CallOptions).GetVodStitchDetail)], opts...)
	var resp *stitcherpb.VodStitchDetail
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.videoStitcherClient.GetVodStitchDetail(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *videoStitcherGRPCClient) ListVodAdTagDetails(ctx context.Context, req *stitcherpb.ListVodAdTagDetailsRequest, opts ...gax.CallOption) *VodAdTagDetailIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListVodAdTagDetails[0:len((*c.CallOptions).ListVodAdTagDetails):len((*c.CallOptions).ListVodAdTagDetails)], opts...)
	it := &VodAdTagDetailIterator{}
	req = proto.Clone(req).(*stitcherpb.ListVodAdTagDetailsRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*stitcherpb.VodAdTagDetail, string, error) {
		resp := &stitcherpb.ListVodAdTagDetailsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = c.videoStitcherClient.ListVodAdTagDetails(ctx, req, settings.GRPC...)
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetVodAdTagDetails(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *videoStitcherGRPCClient) GetVodAdTagDetail(ctx context.Context, req *stitcherpb.GetVodAdTagDetailRequest, opts ...gax.CallOption) (*stitcherpb.VodAdTagDetail, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetVodAdTagDetail[0:len((*c.CallOptions).GetVodAdTagDetail):len((*c.CallOptions).GetVodAdTagDetail)], opts...)
	var resp *stitcherpb.VodAdTagDetail
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.videoStitcherClient.GetVodAdTagDetail(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *videoStitcherGRPCClient) ListLiveAdTagDetails(ctx context.Context, req *stitcherpb.ListLiveAdTagDetailsRequest, opts ...gax.CallOption) *LiveAdTagDetailIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListLiveAdTagDetails[0:len((*c.CallOptions).ListLiveAdTagDetails):len((*c.CallOptions).ListLiveAdTagDetails)], opts...)
	it := &LiveAdTagDetailIterator{}
	req = proto.Clone(req).(*stitcherpb.ListLiveAdTagDetailsRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*stitcherpb.LiveAdTagDetail, string, error) {
		resp := &stitcherpb.ListLiveAdTagDetailsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = c.videoStitcherClient.ListLiveAdTagDetails(ctx, req, settings.GRPC...)
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetLiveAdTagDetails(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *videoStitcherGRPCClient) GetLiveAdTagDetail(ctx context.Context, req *stitcherpb.GetLiveAdTagDetailRequest, opts ...gax.CallOption) (*stitcherpb.LiveAdTagDetail, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetLiveAdTagDetail[0:len((*c.CallOptions).GetLiveAdTagDetail):len((*c.CallOptions).GetLiveAdTagDetail)], opts...)
	var resp *stitcherpb.LiveAdTagDetail
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.videoStitcherClient.GetLiveAdTagDetail(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *videoStitcherGRPCClient) CreateSlate(ctx context.Context, req *stitcherpb.CreateSlateRequest, opts ...gax.CallOption) (*CreateSlateOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).CreateSlate[0:len((*c.CallOptions).CreateSlate):len((*c.CallOptions).CreateSlate)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.videoStitcherClient.CreateSlate(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &CreateSlateOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *videoStitcherGRPCClient) ListSlates(ctx context.Context, req *stitcherpb.ListSlatesRequest, opts ...gax.CallOption) *SlateIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListSlates[0:len((*c.CallOptions).ListSlates):len((*c.CallOptions).ListSlates)], opts...)
	it := &SlateIterator{}
	req = proto.Clone(req).(*stitcherpb.ListSlatesRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*stitcherpb.Slate, string, error) {
		resp := &stitcherpb.ListSlatesResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = c.videoStitcherClient.ListSlates(ctx, req, settings.GRPC...)
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetSlates(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *videoStitcherGRPCClient) GetSlate(ctx context.Context, req *stitcherpb.GetSlateRequest, opts ...gax.CallOption) (*stitcherpb.Slate, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetSlate[0:len((*c.CallOptions).GetSlate):len((*c.CallOptions).GetSlate)], opts...)
	var resp *stitcherpb.Slate
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.videoStitcherClient.GetSlate(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *videoStitcherGRPCClient) UpdateSlate(ctx context.Context, req *stitcherpb.UpdateSlateRequest, opts ...gax.CallOption) (*UpdateSlateOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "slate.name", url.QueryEscape(req.GetSlate().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).UpdateSlate[0:len((*c.CallOptions).UpdateSlate):len((*c.CallOptions).UpdateSlate)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.videoStitcherClient.UpdateSlate(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &UpdateSlateOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *videoStitcherGRPCClient) DeleteSlate(ctx context.Context, req *stitcherpb.DeleteSlateRequest, opts ...gax.CallOption) (*DeleteSlateOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).DeleteSlate[0:len((*c.CallOptions).DeleteSlate):len((*c.CallOptions).DeleteSlate)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.videoStitcherClient.DeleteSlate(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &DeleteSlateOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *videoStitcherGRPCClient) CreateLiveSession(ctx context.Context, req *stitcherpb.CreateLiveSessionRequest, opts ...gax.CallOption) (*stitcherpb.LiveSession, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).CreateLiveSession[0:len((*c.CallOptions).CreateLiveSession):len((*c.CallOptions).CreateLiveSession)], opts...)
	var resp *stitcherpb.LiveSession
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.videoStitcherClient.CreateLiveSession(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *videoStitcherGRPCClient) GetLiveSession(ctx context.Context, req *stitcherpb.GetLiveSessionRequest, opts ...gax.CallOption) (*stitcherpb.LiveSession, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetLiveSession[0:len((*c.CallOptions).GetLiveSession):len((*c.CallOptions).GetLiveSession)], opts...)
	var resp *stitcherpb.LiveSession
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.videoStitcherClient.GetLiveSession(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *videoStitcherGRPCClient) CreateLiveConfig(ctx context.Context, req *stitcherpb.CreateLiveConfigRequest, opts ...gax.CallOption) (*CreateLiveConfigOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).CreateLiveConfig[0:len((*c.CallOptions).CreateLiveConfig):len((*c.CallOptions).CreateLiveConfig)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.videoStitcherClient.CreateLiveConfig(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &CreateLiveConfigOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *videoStitcherGRPCClient) ListLiveConfigs(ctx context.Context, req *stitcherpb.ListLiveConfigsRequest, opts ...gax.CallOption) *LiveConfigIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListLiveConfigs[0:len((*c.CallOptions).ListLiveConfigs):len((*c.CallOptions).ListLiveConfigs)], opts...)
	it := &LiveConfigIterator{}
	req = proto.Clone(req).(*stitcherpb.ListLiveConfigsRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*stitcherpb.LiveConfig, string, error) {
		resp := &stitcherpb.ListLiveConfigsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = c.videoStitcherClient.ListLiveConfigs(ctx, req, settings.GRPC...)
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetLiveConfigs(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *videoStitcherGRPCClient) GetLiveConfig(ctx context.Context, req *stitcherpb.GetLiveConfigRequest, opts ...gax.CallOption) (*stitcherpb.LiveConfig, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetLiveConfig[0:len((*c.CallOptions).GetLiveConfig):len((*c.CallOptions).GetLiveConfig)], opts...)
	var resp *stitcherpb.LiveConfig
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.videoStitcherClient.GetLiveConfig(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *videoStitcherGRPCClient) DeleteLiveConfig(ctx context.Context, req *stitcherpb.DeleteLiveConfigRequest, opts ...gax.CallOption) (*DeleteLiveConfigOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).DeleteLiveConfig[0:len((*c.CallOptions).DeleteLiveConfig):len((*c.CallOptions).DeleteLiveConfig)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.videoStitcherClient.DeleteLiveConfig(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &DeleteLiveConfigOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *videoStitcherGRPCClient) CancelOperation(ctx context.Context, req *longrunningpb.CancelOperationRequest, opts ...gax.CallOption) error {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).CancelOperation[0:len((*c.CallOptions).CancelOperation):len((*c.CallOptions).CancelOperation)], opts...)
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		_, err = c.operationsClient.CancelOperation(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	return err
}

func (c *videoStitcherGRPCClient) DeleteOperation(ctx context.Context, req *longrunningpb.DeleteOperationRequest, opts ...gax.CallOption) error {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).DeleteOperation[0:len((*c.CallOptions).DeleteOperation):len((*c.CallOptions).DeleteOperation)], opts...)
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		_, err = c.operationsClient.DeleteOperation(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	return err
}

func (c *videoStitcherGRPCClient) GetOperation(ctx context.Context, req *longrunningpb.GetOperationRequest, opts ...gax.CallOption) (*longrunningpb.Operation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetOperation[0:len((*c.CallOptions).GetOperation):len((*c.CallOptions).GetOperation)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.operationsClient.GetOperation(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *videoStitcherGRPCClient) ListOperations(ctx context.Context, req *longrunningpb.ListOperationsRequest, opts ...gax.CallOption) *OperationIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListOperations[0:len((*c.CallOptions).ListOperations):len((*c.CallOptions).ListOperations)], opts...)
	it := &OperationIterator{}
	req = proto.Clone(req).(*longrunningpb.ListOperationsRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*longrunningpb.Operation, string, error) {
		resp := &longrunningpb.ListOperationsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = c.operationsClient.ListOperations(ctx, req, settings.GRPC...)
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetOperations(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// CreateCdnKeyOperation returns a new CreateCdnKeyOperation from a given name.
// The name must be that of a previously created CreateCdnKeyOperation, possibly from a different process.
func (c *videoStitcherGRPCClient) CreateCdnKeyOperation(name string) *CreateCdnKeyOperation {
	return &CreateCdnKeyOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// CreateLiveConfigOperation returns a new CreateLiveConfigOperation from a given name.
// The name must be that of a previously created CreateLiveConfigOperation, possibly from a different process.
func (c *videoStitcherGRPCClient) CreateLiveConfigOperation(name string) *CreateLiveConfigOperation {
	return &CreateLiveConfigOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// CreateSlateOperation returns a new CreateSlateOperation from a given name.
// The name must be that of a previously created CreateSlateOperation, possibly from a different process.
func (c *videoStitcherGRPCClient) CreateSlateOperation(name string) *CreateSlateOperation {
	return &CreateSlateOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// DeleteCdnKeyOperation returns a new DeleteCdnKeyOperation from a given name.
// The name must be that of a previously created DeleteCdnKeyOperation, possibly from a different process.
func (c *videoStitcherGRPCClient) DeleteCdnKeyOperation(name string) *DeleteCdnKeyOperation {
	return &DeleteCdnKeyOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// DeleteLiveConfigOperation returns a new DeleteLiveConfigOperation from a given name.
// The name must be that of a previously created DeleteLiveConfigOperation, possibly from a different process.
func (c *videoStitcherGRPCClient) DeleteLiveConfigOperation(name string) *DeleteLiveConfigOperation {
	return &DeleteLiveConfigOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// DeleteSlateOperation returns a new DeleteSlateOperation from a given name.
// The name must be that of a previously created DeleteSlateOperation, possibly from a different process.
func (c *videoStitcherGRPCClient) DeleteSlateOperation(name string) *DeleteSlateOperation {
	return &DeleteSlateOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// UpdateCdnKeyOperation returns a new UpdateCdnKeyOperation from a given name.
// The name must be that of a previously created UpdateCdnKeyOperation, possibly from a different process.
func (c *videoStitcherGRPCClient) UpdateCdnKeyOperation(name string) *UpdateCdnKeyOperation {
	return &UpdateCdnKeyOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// UpdateSlateOperation returns a new UpdateSlateOperation from a given name.
// The name must be that of a previously created UpdateSlateOperation, possibly from a different process.
func (c *videoStitcherGRPCClient) UpdateSlateOperation(name string) *UpdateSlateOperation {
	return &UpdateSlateOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}
