// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.31.0
// 	protoc        v4.23.2
// source: google/firestore/v1/query.proto

package firestorepb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	wrapperspb "google.golang.org/protobuf/types/known/wrapperspb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// A sort direction.
type StructuredQuery_Direction int32

const (
	// Unspecified.
	StructuredQuery_DIRECTION_UNSPECIFIED StructuredQuery_Direction = 0
	// Ascending.
	StructuredQuery_ASCENDING StructuredQuery_Direction = 1
	// Descending.
	StructuredQuery_DESCENDING StructuredQuery_Direction = 2
)

// Enum value maps for StructuredQuery_Direction.
var (
	StructuredQuery_Direction_name = map[int32]string{
		0: "DIRECTION_UNSPECIFIED",
		1: "ASCENDING",
		2: "DESCENDING",
	}
	StructuredQuery_Direction_value = map[string]int32{
		"DIRECTION_UNSPECIFIED": 0,
		"ASCENDING":             1,
		"DESCENDING":            2,
	}
)

func (x StructuredQuery_Direction) Enum() *StructuredQuery_Direction {
	p := new(StructuredQuery_Direction)
	*p = x
	return p
}

func (x StructuredQuery_Direction) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (StructuredQuery_Direction) Descriptor() protoreflect.EnumDescriptor {
	return file_google_firestore_v1_query_proto_enumTypes[0].Descriptor()
}

func (StructuredQuery_Direction) Type() protoreflect.EnumType {
	return &file_google_firestore_v1_query_proto_enumTypes[0]
}

func (x StructuredQuery_Direction) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use StructuredQuery_Direction.Descriptor instead.
func (StructuredQuery_Direction) EnumDescriptor() ([]byte, []int) {
	return file_google_firestore_v1_query_proto_rawDescGZIP(), []int{0, 0}
}

// A composite filter operator.
type StructuredQuery_CompositeFilter_Operator int32

const (
	// Unspecified. This value must not be used.
	StructuredQuery_CompositeFilter_OPERATOR_UNSPECIFIED StructuredQuery_CompositeFilter_Operator = 0
	// Documents are required to satisfy all of the combined filters.
	StructuredQuery_CompositeFilter_AND StructuredQuery_CompositeFilter_Operator = 1
	// Documents are required to satisfy at least one of the combined filters.
	StructuredQuery_CompositeFilter_OR StructuredQuery_CompositeFilter_Operator = 2
)

// Enum value maps for StructuredQuery_CompositeFilter_Operator.
var (
	StructuredQuery_CompositeFilter_Operator_name = map[int32]string{
		0: "OPERATOR_UNSPECIFIED",
		1: "AND",
		2: "OR",
	}
	StructuredQuery_CompositeFilter_Operator_value = map[string]int32{
		"OPERATOR_UNSPECIFIED": 0,
		"AND":                  1,
		"OR":                   2,
	}
)

func (x StructuredQuery_CompositeFilter_Operator) Enum() *StructuredQuery_CompositeFilter_Operator {
	p := new(StructuredQuery_CompositeFilter_Operator)
	*p = x
	return p
}

func (x StructuredQuery_CompositeFilter_Operator) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (StructuredQuery_CompositeFilter_Operator) Descriptor() protoreflect.EnumDescriptor {
	return file_google_firestore_v1_query_proto_enumTypes[1].Descriptor()
}

func (StructuredQuery_CompositeFilter_Operator) Type() protoreflect.EnumType {
	return &file_google_firestore_v1_query_proto_enumTypes[1]
}

func (x StructuredQuery_CompositeFilter_Operator) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use StructuredQuery_CompositeFilter_Operator.Descriptor instead.
func (StructuredQuery_CompositeFilter_Operator) EnumDescriptor() ([]byte, []int) {
	return file_google_firestore_v1_query_proto_rawDescGZIP(), []int{0, 2, 0}
}

// A field filter operator.
type StructuredQuery_FieldFilter_Operator int32

const (
	// Unspecified. This value must not be used.
	StructuredQuery_FieldFilter_OPERATOR_UNSPECIFIED StructuredQuery_FieldFilter_Operator = 0
	// The given `field` is less than the given `value`.
	//
	// Requires:
	//
	// * That `field` come first in `order_by`.
	StructuredQuery_FieldFilter_LESS_THAN StructuredQuery_FieldFilter_Operator = 1
	// The given `field` is less than or equal to the given `value`.
	//
	// Requires:
	//
	// * That `field` come first in `order_by`.
	StructuredQuery_FieldFilter_LESS_THAN_OR_EQUAL StructuredQuery_FieldFilter_Operator = 2
	// The given `field` is greater than the given `value`.
	//
	// Requires:
	//
	// * That `field` come first in `order_by`.
	StructuredQuery_FieldFilter_GREATER_THAN StructuredQuery_FieldFilter_Operator = 3
	// The given `field` is greater than or equal to the given `value`.
	//
	// Requires:
	//
	// * That `field` come first in `order_by`.
	StructuredQuery_FieldFilter_GREATER_THAN_OR_EQUAL StructuredQuery_FieldFilter_Operator = 4
	// The given `field` is equal to the given `value`.
	StructuredQuery_FieldFilter_EQUAL StructuredQuery_FieldFilter_Operator = 5
	// The given `field` is not equal to the given `value`.
	//
	// Requires:
	//
	// * No other `NOT_EQUAL`, `NOT_IN`, `IS_NOT_NULL`, or `IS_NOT_NAN`.
	// * That `field` comes first in the `order_by`.
	StructuredQuery_FieldFilter_NOT_EQUAL StructuredQuery_FieldFilter_Operator = 6
	// The given `field` is an array that contains the given `value`.
	StructuredQuery_FieldFilter_ARRAY_CONTAINS StructuredQuery_FieldFilter_Operator = 7
	// The given `field` is equal to at least one value in the given array.
	//
	// Requires:
	//
	// * That `value` is a non-empty `ArrayValue`, subject to disjunction
	//   limits.
	// * No `NOT_IN` filters in the same query.
	StructuredQuery_FieldFilter_IN StructuredQuery_FieldFilter_Operator = 8
	// The given `field` is an array that contains any of the values in the
	// given array.
	//
	// Requires:
	//
	// * That `value` is a non-empty `ArrayValue`, subject to disjunction
	//   limits.
	// * No other `ARRAY_CONTAINS_ANY` filters within the same disjunction.
	// * No `NOT_IN` filters in the same query.
	StructuredQuery_FieldFilter_ARRAY_CONTAINS_ANY StructuredQuery_FieldFilter_Operator = 9
	// The value of the `field` is not in the given array.
	//
	// Requires:
	//
	// * That `value` is a non-empty `ArrayValue` with at most 10 values.
	// * No other `OR`, `IN`, `ARRAY_CONTAINS_ANY`, `NOT_IN`, `NOT_EQUAL`,
	//   `IS_NOT_NULL`, or `IS_NOT_NAN`.
	// * That `field` comes first in the `order_by`.
	StructuredQuery_FieldFilter_NOT_IN StructuredQuery_FieldFilter_Operator = 10
)

// Enum value maps for StructuredQuery_FieldFilter_Operator.
var (
	StructuredQuery_FieldFilter_Operator_name = map[int32]string{
		0:  "OPERATOR_UNSPECIFIED",
		1:  "LESS_THAN",
		2:  "LESS_THAN_OR_EQUAL",
		3:  "GREATER_THAN",
		4:  "GREATER_THAN_OR_EQUAL",
		5:  "EQUAL",
		6:  "NOT_EQUAL",
		7:  "ARRAY_CONTAINS",
		8:  "IN",
		9:  "ARRAY_CONTAINS_ANY",
		10: "NOT_IN",
	}
	StructuredQuery_FieldFilter_Operator_value = map[string]int32{
		"OPERATOR_UNSPECIFIED":  0,
		"LESS_THAN":             1,
		"LESS_THAN_OR_EQUAL":    2,
		"GREATER_THAN":          3,
		"GREATER_THAN_OR_EQUAL": 4,
		"EQUAL":                 5,
		"NOT_EQUAL":             6,
		"ARRAY_CONTAINS":        7,
		"IN":                    8,
		"ARRAY_CONTAINS_ANY":    9,
		"NOT_IN":                10,
	}
)

func (x StructuredQuery_FieldFilter_Operator) Enum() *StructuredQuery_FieldFilter_Operator {
	p := new(StructuredQuery_FieldFilter_Operator)
	*p = x
	return p
}

func (x StructuredQuery_FieldFilter_Operator) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (StructuredQuery_FieldFilter_Operator) Descriptor() protoreflect.EnumDescriptor {
	return file_google_firestore_v1_query_proto_enumTypes[2].Descriptor()
}

func (StructuredQuery_FieldFilter_Operator) Type() protoreflect.EnumType {
	return &file_google_firestore_v1_query_proto_enumTypes[2]
}

func (x StructuredQuery_FieldFilter_Operator) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use StructuredQuery_FieldFilter_Operator.Descriptor instead.
func (StructuredQuery_FieldFilter_Operator) EnumDescriptor() ([]byte, []int) {
	return file_google_firestore_v1_query_proto_rawDescGZIP(), []int{0, 3, 0}
}

// A unary operator.
type StructuredQuery_UnaryFilter_Operator int32

const (
	// Unspecified. This value must not be used.
	StructuredQuery_UnaryFilter_OPERATOR_UNSPECIFIED StructuredQuery_UnaryFilter_Operator = 0
	// The given `field` is equal to `NaN`.
	StructuredQuery_UnaryFilter_IS_NAN StructuredQuery_UnaryFilter_Operator = 2
	// The given `field` is equal to `NULL`.
	StructuredQuery_UnaryFilter_IS_NULL StructuredQuery_UnaryFilter_Operator = 3
	// The given `field` is not equal to `NaN`.
	//
	// Requires:
	//
	// * No other `NOT_EQUAL`, `NOT_IN`, `IS_NOT_NULL`, or `IS_NOT_NAN`.
	// * That `field` comes first in the `order_by`.
	StructuredQuery_UnaryFilter_IS_NOT_NAN StructuredQuery_UnaryFilter_Operator = 4
	// The given `field` is not equal to `NULL`.
	//
	// Requires:
	//
	// * A single `NOT_EQUAL`, `NOT_IN`, `IS_NOT_NULL`, or `IS_NOT_NAN`.
	// * That `field` comes first in the `order_by`.
	StructuredQuery_UnaryFilter_IS_NOT_NULL StructuredQuery_UnaryFilter_Operator = 5
)

// Enum value maps for StructuredQuery_UnaryFilter_Operator.
var (
	StructuredQuery_UnaryFilter_Operator_name = map[int32]string{
		0: "OPERATOR_UNSPECIFIED",
		2: "IS_NAN",
		3: "IS_NULL",
		4: "IS_NOT_NAN",
		5: "IS_NOT_NULL",
	}
	StructuredQuery_UnaryFilter_Operator_value = map[string]int32{
		"OPERATOR_UNSPECIFIED": 0,
		"IS_NAN":               2,
		"IS_NULL":              3,
		"IS_NOT_NAN":           4,
		"IS_NOT_NULL":          5,
	}
)

func (x StructuredQuery_UnaryFilter_Operator) Enum() *StructuredQuery_UnaryFilter_Operator {
	p := new(StructuredQuery_UnaryFilter_Operator)
	*p = x
	return p
}

func (x StructuredQuery_UnaryFilter_Operator) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (StructuredQuery_UnaryFilter_Operator) Descriptor() protoreflect.EnumDescriptor {
	return file_google_firestore_v1_query_proto_enumTypes[3].Descriptor()
}

func (StructuredQuery_UnaryFilter_Operator) Type() protoreflect.EnumType {
	return &file_google_firestore_v1_query_proto_enumTypes[3]
}

func (x StructuredQuery_UnaryFilter_Operator) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use StructuredQuery_UnaryFilter_Operator.Descriptor instead.
func (StructuredQuery_UnaryFilter_Operator) EnumDescriptor() ([]byte, []int) {
	return file_google_firestore_v1_query_proto_rawDescGZIP(), []int{0, 4, 0}
}

// A Firestore query.
type StructuredQuery struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional sub-set of the fields to return.
	//
	// This acts as a [DocumentMask][google.firestore.v1.DocumentMask] over the
	// documents returned from a query. When not set, assumes that the caller
	// wants all fields returned.
	Select *StructuredQuery_Projection `protobuf:"bytes,1,opt,name=select,proto3" json:"select,omitempty"`
	// The collections to query.
	From []*StructuredQuery_CollectionSelector `protobuf:"bytes,2,rep,name=from,proto3" json:"from,omitempty"`
	// The filter to apply.
	Where *StructuredQuery_Filter `protobuf:"bytes,3,opt,name=where,proto3" json:"where,omitempty"`
	// The order to apply to the query results.
	//
	// Firestore allows callers to provide a full ordering, a partial ordering, or
	// no ordering at all. In all cases, Firestore guarantees a stable ordering
	// through the following rules:
	//
	//  * The `order_by` is required to reference all fields used with an
	//    inequality filter.
	//  * All fields that are required to be in the `order_by` but are not already
	//    present are appended in lexicographical ordering of the field name.
	//  * If an order on `__name__` is not specified, it is appended by default.
	//
	// Fields are appended with the same sort direction as the last order
	// specified, or 'ASCENDING' if no order was specified. For example:
	//
	//  * `ORDER BY a` becomes `ORDER BY a ASC, __name__ ASC`
	//  * `ORDER BY a DESC` becomes `ORDER BY a DESC, __name__ DESC`
	//  * `WHERE a > 1` becomes `WHERE a > 1 ORDER BY a ASC, __name__ ASC`
	//  * `WHERE __name__ > ... AND a > 1` becomes
	//     `WHERE __name__ > ... AND a > 1 ORDER BY a ASC, __name__ ASC`
	OrderBy []*StructuredQuery_Order `protobuf:"bytes,4,rep,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
	// A potential prefix of a position in the result set to start the query at.
	//
	// The ordering of the result set is based on the `ORDER BY` clause of the
	// original query.
	//
	// ```
	// SELECT * FROM k WHERE a = 1 AND b > 2 ORDER BY b ASC, __name__ ASC;
	// ```
	//
	// This query's results are ordered by `(b ASC, __name__ ASC)`.
	//
	// Cursors can reference either the full ordering or a prefix of the location,
	// though it cannot reference more fields than what are in the provided
	// `ORDER BY`.
	//
	// Continuing off the example above, attaching the following start cursors
	// will have varying impact:
	//
	// - `START BEFORE (2, /k/123)`: start the query right before `a = 1 AND
	//    b > 2 AND __name__ > /k/123`.
	// - `START AFTER (10)`: start the query right after `a = 1 AND b > 10`.
	//
	// Unlike `OFFSET` which requires scanning over the first N results to skip,
	// a start cursor allows the query to begin at a logical position. This
	// position is not required to match an actual result, it will scan forward
	// from this position to find the next document.
	//
	// Requires:
	//
	// * The number of values cannot be greater than the number of fields
	//   specified in the `ORDER BY` clause.
	StartAt *Cursor `protobuf:"bytes,7,opt,name=start_at,json=startAt,proto3" json:"start_at,omitempty"`
	// A potential prefix of a position in the result set to end the query at.
	//
	// This is similar to `START_AT` but with it controlling the end position
	// rather than the start position.
	//
	// Requires:
	//
	// * The number of values cannot be greater than the number of fields
	//   specified in the `ORDER BY` clause.
	EndAt *Cursor `protobuf:"bytes,8,opt,name=end_at,json=endAt,proto3" json:"end_at,omitempty"`
	// The number of documents to skip before returning the first result.
	//
	// This applies after the constraints specified by the `WHERE`, `START AT`, &
	// `END AT` but before the `LIMIT` clause.
	//
	// Requires:
	//
	// * The value must be greater than or equal to zero if specified.
	Offset int32 `protobuf:"varint,6,opt,name=offset,proto3" json:"offset,omitempty"`
	// The maximum number of results to return.
	//
	// Applies after all other constraints.
	//
	// Requires:
	//
	// * The value must be greater than or equal to zero if specified.
	Limit *wrapperspb.Int32Value `protobuf:"bytes,5,opt,name=limit,proto3" json:"limit,omitempty"`
}

func (x *StructuredQuery) Reset() {
	*x = StructuredQuery{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_firestore_v1_query_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StructuredQuery) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StructuredQuery) ProtoMessage() {}

func (x *StructuredQuery) ProtoReflect() protoreflect.Message {
	mi := &file_google_firestore_v1_query_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StructuredQuery.ProtoReflect.Descriptor instead.
func (*StructuredQuery) Descriptor() ([]byte, []int) {
	return file_google_firestore_v1_query_proto_rawDescGZIP(), []int{0}
}

func (x *StructuredQuery) GetSelect() *StructuredQuery_Projection {
	if x != nil {
		return x.Select
	}
	return nil
}

func (x *StructuredQuery) GetFrom() []*StructuredQuery_CollectionSelector {
	if x != nil {
		return x.From
	}
	return nil
}

func (x *StructuredQuery) GetWhere() *StructuredQuery_Filter {
	if x != nil {
		return x.Where
	}
	return nil
}

func (x *StructuredQuery) GetOrderBy() []*StructuredQuery_Order {
	if x != nil {
		return x.OrderBy
	}
	return nil
}

func (x *StructuredQuery) GetStartAt() *Cursor {
	if x != nil {
		return x.StartAt
	}
	return nil
}

func (x *StructuredQuery) GetEndAt() *Cursor {
	if x != nil {
		return x.EndAt
	}
	return nil
}

func (x *StructuredQuery) GetOffset() int32 {
	if x != nil {
		return x.Offset
	}
	return 0
}

func (x *StructuredQuery) GetLimit() *wrapperspb.Int32Value {
	if x != nil {
		return x.Limit
	}
	return nil
}

// Firestore query for running an aggregation over a
// [StructuredQuery][google.firestore.v1.StructuredQuery].
type StructuredAggregationQuery struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The base query to aggregate over.
	//
	// Types that are assignable to QueryType:
	//	*StructuredAggregationQuery_StructuredQuery
	QueryType isStructuredAggregationQuery_QueryType `protobuf_oneof:"query_type"`
	// Optional. Series of aggregations to apply over the results of the
	// `structured_query`.
	//
	// Requires:
	//
	// * A minimum of one and maximum of five aggregations per query.
	Aggregations []*StructuredAggregationQuery_Aggregation `protobuf:"bytes,3,rep,name=aggregations,proto3" json:"aggregations,omitempty"`
}

func (x *StructuredAggregationQuery) Reset() {
	*x = StructuredAggregationQuery{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_firestore_v1_query_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StructuredAggregationQuery) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StructuredAggregationQuery) ProtoMessage() {}

func (x *StructuredAggregationQuery) ProtoReflect() protoreflect.Message {
	mi := &file_google_firestore_v1_query_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StructuredAggregationQuery.ProtoReflect.Descriptor instead.
func (*StructuredAggregationQuery) Descriptor() ([]byte, []int) {
	return file_google_firestore_v1_query_proto_rawDescGZIP(), []int{1}
}

func (m *StructuredAggregationQuery) GetQueryType() isStructuredAggregationQuery_QueryType {
	if m != nil {
		return m.QueryType
	}
	return nil
}

func (x *StructuredAggregationQuery) GetStructuredQuery() *StructuredQuery {
	if x, ok := x.GetQueryType().(*StructuredAggregationQuery_StructuredQuery); ok {
		return x.StructuredQuery
	}
	return nil
}

func (x *StructuredAggregationQuery) GetAggregations() []*StructuredAggregationQuery_Aggregation {
	if x != nil {
		return x.Aggregations
	}
	return nil
}

type isStructuredAggregationQuery_QueryType interface {
	isStructuredAggregationQuery_QueryType()
}

type StructuredAggregationQuery_StructuredQuery struct {
	// Nested structured query.
	StructuredQuery *StructuredQuery `protobuf:"bytes,1,opt,name=structured_query,json=structuredQuery,proto3,oneof"`
}

func (*StructuredAggregationQuery_StructuredQuery) isStructuredAggregationQuery_QueryType() {}

// A position in a query result set.
type Cursor struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The values that represent a position, in the order they appear in
	// the order by clause of a query.
	//
	// Can contain fewer values than specified in the order by clause.
	Values []*Value `protobuf:"bytes,1,rep,name=values,proto3" json:"values,omitempty"`
	// If the position is just before or just after the given values, relative
	// to the sort order defined by the query.
	Before bool `protobuf:"varint,2,opt,name=before,proto3" json:"before,omitempty"`
}

func (x *Cursor) Reset() {
	*x = Cursor{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_firestore_v1_query_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Cursor) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Cursor) ProtoMessage() {}

func (x *Cursor) ProtoReflect() protoreflect.Message {
	mi := &file_google_firestore_v1_query_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Cursor.ProtoReflect.Descriptor instead.
func (*Cursor) Descriptor() ([]byte, []int) {
	return file_google_firestore_v1_query_proto_rawDescGZIP(), []int{2}
}

func (x *Cursor) GetValues() []*Value {
	if x != nil {
		return x.Values
	}
	return nil
}

func (x *Cursor) GetBefore() bool {
	if x != nil {
		return x.Before
	}
	return false
}

// A selection of a collection, such as `messages as m1`.
type StructuredQuery_CollectionSelector struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The collection ID.
	// When set, selects only collections with this ID.
	CollectionId string `protobuf:"bytes,2,opt,name=collection_id,json=collectionId,proto3" json:"collection_id,omitempty"`
	// When false, selects only collections that are immediate children of
	// the `parent` specified in the containing `RunQueryRequest`.
	// When true, selects all descendant collections.
	AllDescendants bool `protobuf:"varint,3,opt,name=all_descendants,json=allDescendants,proto3" json:"all_descendants,omitempty"`
}

func (x *StructuredQuery_CollectionSelector) Reset() {
	*x = StructuredQuery_CollectionSelector{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_firestore_v1_query_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StructuredQuery_CollectionSelector) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StructuredQuery_CollectionSelector) ProtoMessage() {}

func (x *StructuredQuery_CollectionSelector) ProtoReflect() protoreflect.Message {
	mi := &file_google_firestore_v1_query_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StructuredQuery_CollectionSelector.ProtoReflect.Descriptor instead.
func (*StructuredQuery_CollectionSelector) Descriptor() ([]byte, []int) {
	return file_google_firestore_v1_query_proto_rawDescGZIP(), []int{0, 0}
}

func (x *StructuredQuery_CollectionSelector) GetCollectionId() string {
	if x != nil {
		return x.CollectionId
	}
	return ""
}

func (x *StructuredQuery_CollectionSelector) GetAllDescendants() bool {
	if x != nil {
		return x.AllDescendants
	}
	return false
}

// A filter.
type StructuredQuery_Filter struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The type of filter.
	//
	// Types that are assignable to FilterType:
	//	*StructuredQuery_Filter_CompositeFilter
	//	*StructuredQuery_Filter_FieldFilter
	//	*StructuredQuery_Filter_UnaryFilter
	FilterType isStructuredQuery_Filter_FilterType `protobuf_oneof:"filter_type"`
}

func (x *StructuredQuery_Filter) Reset() {
	*x = StructuredQuery_Filter{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_firestore_v1_query_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StructuredQuery_Filter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StructuredQuery_Filter) ProtoMessage() {}

func (x *StructuredQuery_Filter) ProtoReflect() protoreflect.Message {
	mi := &file_google_firestore_v1_query_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StructuredQuery_Filter.ProtoReflect.Descriptor instead.
func (*StructuredQuery_Filter) Descriptor() ([]byte, []int) {
	return file_google_firestore_v1_query_proto_rawDescGZIP(), []int{0, 1}
}

func (m *StructuredQuery_Filter) GetFilterType() isStructuredQuery_Filter_FilterType {
	if m != nil {
		return m.FilterType
	}
	return nil
}

func (x *StructuredQuery_Filter) GetCompositeFilter() *StructuredQuery_CompositeFilter {
	if x, ok := x.GetFilterType().(*StructuredQuery_Filter_CompositeFilter); ok {
		return x.CompositeFilter
	}
	return nil
}

func (x *StructuredQuery_Filter) GetFieldFilter() *StructuredQuery_FieldFilter {
	if x, ok := x.GetFilterType().(*StructuredQuery_Filter_FieldFilter); ok {
		return x.FieldFilter
	}
	return nil
}

func (x *StructuredQuery_Filter) GetUnaryFilter() *StructuredQuery_UnaryFilter {
	if x, ok := x.GetFilterType().(*StructuredQuery_Filter_UnaryFilter); ok {
		return x.UnaryFilter
	}
	return nil
}

type isStructuredQuery_Filter_FilterType interface {
	isStructuredQuery_Filter_FilterType()
}

type StructuredQuery_Filter_CompositeFilter struct {
	// A composite filter.
	CompositeFilter *StructuredQuery_CompositeFilter `protobuf:"bytes,1,opt,name=composite_filter,json=compositeFilter,proto3,oneof"`
}

type StructuredQuery_Filter_FieldFilter struct {
	// A filter on a document field.
	FieldFilter *StructuredQuery_FieldFilter `protobuf:"bytes,2,opt,name=field_filter,json=fieldFilter,proto3,oneof"`
}

type StructuredQuery_Filter_UnaryFilter struct {
	// A filter that takes exactly one argument.
	UnaryFilter *StructuredQuery_UnaryFilter `protobuf:"bytes,3,opt,name=unary_filter,json=unaryFilter,proto3,oneof"`
}

func (*StructuredQuery_Filter_CompositeFilter) isStructuredQuery_Filter_FilterType() {}

func (*StructuredQuery_Filter_FieldFilter) isStructuredQuery_Filter_FilterType() {}

func (*StructuredQuery_Filter_UnaryFilter) isStructuredQuery_Filter_FilterType() {}

// A filter that merges multiple other filters using the given operator.
type StructuredQuery_CompositeFilter struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The operator for combining multiple filters.
	Op StructuredQuery_CompositeFilter_Operator `protobuf:"varint,1,opt,name=op,proto3,enum=google.firestore.v1.StructuredQuery_CompositeFilter_Operator" json:"op,omitempty"`
	// The list of filters to combine.
	//
	// Requires:
	//
	// * At least one filter is present.
	Filters []*StructuredQuery_Filter `protobuf:"bytes,2,rep,name=filters,proto3" json:"filters,omitempty"`
}

func (x *StructuredQuery_CompositeFilter) Reset() {
	*x = StructuredQuery_CompositeFilter{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_firestore_v1_query_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StructuredQuery_CompositeFilter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StructuredQuery_CompositeFilter) ProtoMessage() {}

func (x *StructuredQuery_CompositeFilter) ProtoReflect() protoreflect.Message {
	mi := &file_google_firestore_v1_query_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StructuredQuery_CompositeFilter.ProtoReflect.Descriptor instead.
func (*StructuredQuery_CompositeFilter) Descriptor() ([]byte, []int) {
	return file_google_firestore_v1_query_proto_rawDescGZIP(), []int{0, 2}
}

func (x *StructuredQuery_CompositeFilter) GetOp() StructuredQuery_CompositeFilter_Operator {
	if x != nil {
		return x.Op
	}
	return StructuredQuery_CompositeFilter_OPERATOR_UNSPECIFIED
}

func (x *StructuredQuery_CompositeFilter) GetFilters() []*StructuredQuery_Filter {
	if x != nil {
		return x.Filters
	}
	return nil
}

// A filter on a specific field.
type StructuredQuery_FieldFilter struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The field to filter by.
	Field *StructuredQuery_FieldReference `protobuf:"bytes,1,opt,name=field,proto3" json:"field,omitempty"`
	// The operator to filter by.
	Op StructuredQuery_FieldFilter_Operator `protobuf:"varint,2,opt,name=op,proto3,enum=google.firestore.v1.StructuredQuery_FieldFilter_Operator" json:"op,omitempty"`
	// The value to compare to.
	Value *Value `protobuf:"bytes,3,opt,name=value,proto3" json:"value,omitempty"`
}

func (x *StructuredQuery_FieldFilter) Reset() {
	*x = StructuredQuery_FieldFilter{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_firestore_v1_query_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StructuredQuery_FieldFilter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StructuredQuery_FieldFilter) ProtoMessage() {}

func (x *StructuredQuery_FieldFilter) ProtoReflect() protoreflect.Message {
	mi := &file_google_firestore_v1_query_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StructuredQuery_FieldFilter.ProtoReflect.Descriptor instead.
func (*StructuredQuery_FieldFilter) Descriptor() ([]byte, []int) {
	return file_google_firestore_v1_query_proto_rawDescGZIP(), []int{0, 3}
}

func (x *StructuredQuery_FieldFilter) GetField() *StructuredQuery_FieldReference {
	if x != nil {
		return x.Field
	}
	return nil
}

func (x *StructuredQuery_FieldFilter) GetOp() StructuredQuery_FieldFilter_Operator {
	if x != nil {
		return x.Op
	}
	return StructuredQuery_FieldFilter_OPERATOR_UNSPECIFIED
}

func (x *StructuredQuery_FieldFilter) GetValue() *Value {
	if x != nil {
		return x.Value
	}
	return nil
}

// A filter with a single operand.
type StructuredQuery_UnaryFilter struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The unary operator to apply.
	Op StructuredQuery_UnaryFilter_Operator `protobuf:"varint,1,opt,name=op,proto3,enum=google.firestore.v1.StructuredQuery_UnaryFilter_Operator" json:"op,omitempty"`
	// The argument to the filter.
	//
	// Types that are assignable to OperandType:
	//	*StructuredQuery_UnaryFilter_Field
	OperandType isStructuredQuery_UnaryFilter_OperandType `protobuf_oneof:"operand_type"`
}

func (x *StructuredQuery_UnaryFilter) Reset() {
	*x = StructuredQuery_UnaryFilter{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_firestore_v1_query_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StructuredQuery_UnaryFilter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StructuredQuery_UnaryFilter) ProtoMessage() {}

func (x *StructuredQuery_UnaryFilter) ProtoReflect() protoreflect.Message {
	mi := &file_google_firestore_v1_query_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StructuredQuery_UnaryFilter.ProtoReflect.Descriptor instead.
func (*StructuredQuery_UnaryFilter) Descriptor() ([]byte, []int) {
	return file_google_firestore_v1_query_proto_rawDescGZIP(), []int{0, 4}
}

func (x *StructuredQuery_UnaryFilter) GetOp() StructuredQuery_UnaryFilter_Operator {
	if x != nil {
		return x.Op
	}
	return StructuredQuery_UnaryFilter_OPERATOR_UNSPECIFIED
}

func (m *StructuredQuery_UnaryFilter) GetOperandType() isStructuredQuery_UnaryFilter_OperandType {
	if m != nil {
		return m.OperandType
	}
	return nil
}

func (x *StructuredQuery_UnaryFilter) GetField() *StructuredQuery_FieldReference {
	if x, ok := x.GetOperandType().(*StructuredQuery_UnaryFilter_Field); ok {
		return x.Field
	}
	return nil
}

type isStructuredQuery_UnaryFilter_OperandType interface {
	isStructuredQuery_UnaryFilter_OperandType()
}

type StructuredQuery_UnaryFilter_Field struct {
	// The field to which to apply the operator.
	Field *StructuredQuery_FieldReference `protobuf:"bytes,2,opt,name=field,proto3,oneof"`
}

func (*StructuredQuery_UnaryFilter_Field) isStructuredQuery_UnaryFilter_OperandType() {}

// An order on a field.
type StructuredQuery_Order struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The field to order by.
	Field *StructuredQuery_FieldReference `protobuf:"bytes,1,opt,name=field,proto3" json:"field,omitempty"`
	// The direction to order by. Defaults to `ASCENDING`.
	Direction StructuredQuery_Direction `protobuf:"varint,2,opt,name=direction,proto3,enum=google.firestore.v1.StructuredQuery_Direction" json:"direction,omitempty"`
}

func (x *StructuredQuery_Order) Reset() {
	*x = StructuredQuery_Order{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_firestore_v1_query_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StructuredQuery_Order) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StructuredQuery_Order) ProtoMessage() {}

func (x *StructuredQuery_Order) ProtoReflect() protoreflect.Message {
	mi := &file_google_firestore_v1_query_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StructuredQuery_Order.ProtoReflect.Descriptor instead.
func (*StructuredQuery_Order) Descriptor() ([]byte, []int) {
	return file_google_firestore_v1_query_proto_rawDescGZIP(), []int{0, 5}
}

func (x *StructuredQuery_Order) GetField() *StructuredQuery_FieldReference {
	if x != nil {
		return x.Field
	}
	return nil
}

func (x *StructuredQuery_Order) GetDirection() StructuredQuery_Direction {
	if x != nil {
		return x.Direction
	}
	return StructuredQuery_DIRECTION_UNSPECIFIED
}

// A reference to a field in a document, ex: `stats.operations`.
type StructuredQuery_FieldReference struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A reference to a field in a document.
	//
	// Requires:
	//
	// * MUST be a dot-delimited (`.`) string of segments, where each segment
	// conforms to [document field name][google.firestore.v1.Document.fields]
	// limitations.
	FieldPath string `protobuf:"bytes,2,opt,name=field_path,json=fieldPath,proto3" json:"field_path,omitempty"`
}

func (x *StructuredQuery_FieldReference) Reset() {
	*x = StructuredQuery_FieldReference{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_firestore_v1_query_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StructuredQuery_FieldReference) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StructuredQuery_FieldReference) ProtoMessage() {}

func (x *StructuredQuery_FieldReference) ProtoReflect() protoreflect.Message {
	mi := &file_google_firestore_v1_query_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StructuredQuery_FieldReference.ProtoReflect.Descriptor instead.
func (*StructuredQuery_FieldReference) Descriptor() ([]byte, []int) {
	return file_google_firestore_v1_query_proto_rawDescGZIP(), []int{0, 6}
}

func (x *StructuredQuery_FieldReference) GetFieldPath() string {
	if x != nil {
		return x.FieldPath
	}
	return ""
}

// The projection of document's fields to return.
type StructuredQuery_Projection struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The fields to return.
	//
	// If empty, all fields are returned. To only return the name
	// of the document, use `['__name__']`.
	Fields []*StructuredQuery_FieldReference `protobuf:"bytes,2,rep,name=fields,proto3" json:"fields,omitempty"`
}

func (x *StructuredQuery_Projection) Reset() {
	*x = StructuredQuery_Projection{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_firestore_v1_query_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StructuredQuery_Projection) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StructuredQuery_Projection) ProtoMessage() {}

func (x *StructuredQuery_Projection) ProtoReflect() protoreflect.Message {
	mi := &file_google_firestore_v1_query_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StructuredQuery_Projection.ProtoReflect.Descriptor instead.
func (*StructuredQuery_Projection) Descriptor() ([]byte, []int) {
	return file_google_firestore_v1_query_proto_rawDescGZIP(), []int{0, 7}
}

func (x *StructuredQuery_Projection) GetFields() []*StructuredQuery_FieldReference {
	if x != nil {
		return x.Fields
	}
	return nil
}

// Defines an aggregation that produces a single result.
type StructuredAggregationQuery_Aggregation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The type of aggregation to perform, required.
	//
	// Types that are assignable to Operator:
	//	*StructuredAggregationQuery_Aggregation_Count_
	//	*StructuredAggregationQuery_Aggregation_Sum_
	//	*StructuredAggregationQuery_Aggregation_Avg_
	Operator isStructuredAggregationQuery_Aggregation_Operator `protobuf_oneof:"operator"`
	// Optional. Optional name of the field to store the result of the
	// aggregation into.
	//
	// If not provided, Firestore will pick a default name following the format
	// `field_<incremental_id++>`. For example:
	//
	// ```
	// AGGREGATE
	//   COUNT_UP_TO(1) AS count_up_to_1,
	//   COUNT_UP_TO(2),
	//   COUNT_UP_TO(3) AS count_up_to_3,
	//   COUNT(*)
	// OVER (
	//   ...
	// );
	// ```
	//
	// becomes:
	//
	// ```
	// AGGREGATE
	//   COUNT_UP_TO(1) AS count_up_to_1,
	//   COUNT_UP_TO(2) AS field_1,
	//   COUNT_UP_TO(3) AS count_up_to_3,
	//   COUNT(*) AS field_2
	// OVER (
	//   ...
	// );
	// ```
	//
	// Requires:
	//
	// * Must be unique across all aggregation aliases.
	// * Conform to [document field name][google.firestore.v1.Document.fields]
	// limitations.
	Alias string `protobuf:"bytes,7,opt,name=alias,proto3" json:"alias,omitempty"`
}

func (x *StructuredAggregationQuery_Aggregation) Reset() {
	*x = StructuredAggregationQuery_Aggregation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_firestore_v1_query_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StructuredAggregationQuery_Aggregation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StructuredAggregationQuery_Aggregation) ProtoMessage() {}

func (x *StructuredAggregationQuery_Aggregation) ProtoReflect() protoreflect.Message {
	mi := &file_google_firestore_v1_query_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StructuredAggregationQuery_Aggregation.ProtoReflect.Descriptor instead.
func (*StructuredAggregationQuery_Aggregation) Descriptor() ([]byte, []int) {
	return file_google_firestore_v1_query_proto_rawDescGZIP(), []int{1, 0}
}

func (m *StructuredAggregationQuery_Aggregation) GetOperator() isStructuredAggregationQuery_Aggregation_Operator {
	if m != nil {
		return m.Operator
	}
	return nil
}

func (x *StructuredAggregationQuery_Aggregation) GetCount() *StructuredAggregationQuery_Aggregation_Count {
	if x, ok := x.GetOperator().(*StructuredAggregationQuery_Aggregation_Count_); ok {
		return x.Count
	}
	return nil
}

func (x *StructuredAggregationQuery_Aggregation) GetSum() *StructuredAggregationQuery_Aggregation_Sum {
	if x, ok := x.GetOperator().(*StructuredAggregationQuery_Aggregation_Sum_); ok {
		return x.Sum
	}
	return nil
}

func (x *StructuredAggregationQuery_Aggregation) GetAvg() *StructuredAggregationQuery_Aggregation_Avg {
	if x, ok := x.GetOperator().(*StructuredAggregationQuery_Aggregation_Avg_); ok {
		return x.Avg
	}
	return nil
}

func (x *StructuredAggregationQuery_Aggregation) GetAlias() string {
	if x != nil {
		return x.Alias
	}
	return ""
}

type isStructuredAggregationQuery_Aggregation_Operator interface {
	isStructuredAggregationQuery_Aggregation_Operator()
}

type StructuredAggregationQuery_Aggregation_Count_ struct {
	// Count aggregator.
	Count *StructuredAggregationQuery_Aggregation_Count `protobuf:"bytes,1,opt,name=count,proto3,oneof"`
}

type StructuredAggregationQuery_Aggregation_Sum_ struct {
	// Sum aggregator.
	Sum *StructuredAggregationQuery_Aggregation_Sum `protobuf:"bytes,2,opt,name=sum,proto3,oneof"`
}

type StructuredAggregationQuery_Aggregation_Avg_ struct {
	// Average aggregator.
	Avg *StructuredAggregationQuery_Aggregation_Avg `protobuf:"bytes,3,opt,name=avg,proto3,oneof"`
}

func (*StructuredAggregationQuery_Aggregation_Count_) isStructuredAggregationQuery_Aggregation_Operator() {
}

func (*StructuredAggregationQuery_Aggregation_Sum_) isStructuredAggregationQuery_Aggregation_Operator() {
}

func (*StructuredAggregationQuery_Aggregation_Avg_) isStructuredAggregationQuery_Aggregation_Operator() {
}

// Count of documents that match the query.
//
// The `COUNT(*)` aggregation function operates on the entire document
// so it does not require a field reference.
type StructuredAggregationQuery_Aggregation_Count struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Optional constraint on the maximum number of documents to
	// count.
	//
	// This provides a way to set an upper bound on the number of documents
	// to scan, limiting latency, and cost.
	//
	// Unspecified is interpreted as no bound.
	//
	// High-Level Example:
	//
	// ```
	// AGGREGATE COUNT_UP_TO(1000) OVER ( SELECT * FROM k );
	// ```
	//
	// Requires:
	//
	// * Must be greater than zero when present.
	UpTo *wrapperspb.Int64Value `protobuf:"bytes,1,opt,name=up_to,json=upTo,proto3" json:"up_to,omitempty"`
}

func (x *StructuredAggregationQuery_Aggregation_Count) Reset() {
	*x = StructuredAggregationQuery_Aggregation_Count{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_firestore_v1_query_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StructuredAggregationQuery_Aggregation_Count) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StructuredAggregationQuery_Aggregation_Count) ProtoMessage() {}

func (x *StructuredAggregationQuery_Aggregation_Count) ProtoReflect() protoreflect.Message {
	mi := &file_google_firestore_v1_query_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StructuredAggregationQuery_Aggregation_Count.ProtoReflect.Descriptor instead.
func (*StructuredAggregationQuery_Aggregation_Count) Descriptor() ([]byte, []int) {
	return file_google_firestore_v1_query_proto_rawDescGZIP(), []int{1, 0, 0}
}

func (x *StructuredAggregationQuery_Aggregation_Count) GetUpTo() *wrapperspb.Int64Value {
	if x != nil {
		return x.UpTo
	}
	return nil
}

// Sum of the values of the requested field.
//
// * Only numeric values will be aggregated. All non-numeric values
// including `NULL` are skipped.
//
// * If the aggregated values contain `NaN`, returns `NaN`. Infinity math
// follows IEEE-754 standards.
//
// * If the aggregated value set is empty, returns 0.
//
// * Returns a 64-bit integer if all aggregated numbers are integers and the
// sum result does not overflow. Otherwise, the result is returned as a
// double. Note that even if all the aggregated values are integers, the
// result is returned as a double if it cannot fit within a 64-bit signed
// integer. When this occurs, the returned value will lose precision.
//
// * When underflow occurs, floating-point aggregation is non-deterministic.
// This means that running the same query repeatedly without any changes to
// the underlying values could produce slightly different results each
// time. In those cases, values should be stored as integers over
// floating-point numbers.
type StructuredAggregationQuery_Aggregation_Sum struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The field to aggregate on.
	Field *StructuredQuery_FieldReference `protobuf:"bytes,1,opt,name=field,proto3" json:"field,omitempty"`
}

func (x *StructuredAggregationQuery_Aggregation_Sum) Reset() {
	*x = StructuredAggregationQuery_Aggregation_Sum{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_firestore_v1_query_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StructuredAggregationQuery_Aggregation_Sum) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StructuredAggregationQuery_Aggregation_Sum) ProtoMessage() {}

func (x *StructuredAggregationQuery_Aggregation_Sum) ProtoReflect() protoreflect.Message {
	mi := &file_google_firestore_v1_query_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StructuredAggregationQuery_Aggregation_Sum.ProtoReflect.Descriptor instead.
func (*StructuredAggregationQuery_Aggregation_Sum) Descriptor() ([]byte, []int) {
	return file_google_firestore_v1_query_proto_rawDescGZIP(), []int{1, 0, 1}
}

func (x *StructuredAggregationQuery_Aggregation_Sum) GetField() *StructuredQuery_FieldReference {
	if x != nil {
		return x.Field
	}
	return nil
}

// Average of the values of the requested field.
//
// * Only numeric values will be aggregated. All non-numeric values
// including `NULL` are skipped.
//
// * If the aggregated values contain `NaN`, returns `NaN`. Infinity math
// follows IEEE-754 standards.
//
// * If the aggregated value set is empty, returns `NULL`.
//
// * Always returns the result as a double.
type StructuredAggregationQuery_Aggregation_Avg struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The field to aggregate on.
	Field *StructuredQuery_FieldReference `protobuf:"bytes,1,opt,name=field,proto3" json:"field,omitempty"`
}

func (x *StructuredAggregationQuery_Aggregation_Avg) Reset() {
	*x = StructuredAggregationQuery_Aggregation_Avg{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_firestore_v1_query_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StructuredAggregationQuery_Aggregation_Avg) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StructuredAggregationQuery_Aggregation_Avg) ProtoMessage() {}

func (x *StructuredAggregationQuery_Aggregation_Avg) ProtoReflect() protoreflect.Message {
	mi := &file_google_firestore_v1_query_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StructuredAggregationQuery_Aggregation_Avg.ProtoReflect.Descriptor instead.
func (*StructuredAggregationQuery_Aggregation_Avg) Descriptor() ([]byte, []int) {
	return file_google_firestore_v1_query_proto_rawDescGZIP(), []int{1, 0, 2}
}

func (x *StructuredAggregationQuery_Aggregation_Avg) GetField() *StructuredQuery_FieldReference {
	if x != nil {
		return x.Field
	}
	return nil
}

var File_google_firestore_v1_query_proto protoreflect.FileDescriptor

var file_google_firestore_v1_query_proto_rawDesc = []byte{
	0x0a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x66, 0x69, 0x72, 0x65, 0x73, 0x74, 0x6f,
	0x72, 0x65, 0x2f, 0x76, 0x31, 0x2f, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x12, 0x13, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x66, 0x69, 0x72, 0x65, 0x73, 0x74,
	0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61,
	0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f,
	0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x22, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x66, 0x69, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2f, 0x76, 0x31, 0x2f, 0x64, 0x6f, 0x63,
	0x75, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x77, 0x72, 0x61,
	0x70, 0x70, 0x65, 0x72, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x93, 0x11, 0x0a, 0x0f,
	0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x64, 0x51, 0x75, 0x65, 0x72, 0x79, 0x12,
	0x47, 0x0a, 0x06, 0x73, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x66, 0x69, 0x72, 0x65, 0x73, 0x74, 0x6f,
	0x72, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x64,
	0x51, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x06, 0x73, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x12, 0x4b, 0x0a, 0x04, 0x66, 0x72, 0x6f, 0x6d,
	0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x66, 0x69, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x72,
	0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x64, 0x51, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x43, 0x6f, 0x6c,
	0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x52,
	0x04, 0x66, 0x72, 0x6f, 0x6d, 0x12, 0x41, 0x0a, 0x05, 0x77, 0x68, 0x65, 0x72, 0x65, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x66, 0x69,
	0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63,
	0x74, 0x75, 0x72, 0x65, 0x64, 0x51, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x46, 0x69, 0x6c, 0x74, 0x65,
	0x72, 0x52, 0x05, 0x77, 0x68, 0x65, 0x72, 0x65, 0x12, 0x45, 0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65,
	0x72, 0x5f, 0x62, 0x79, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x66, 0x69, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31,
	0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x64, 0x51, 0x75, 0x65, 0x72, 0x79,
	0x2e, 0x4f, 0x72, 0x64, 0x65, 0x72, 0x52, 0x07, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x12,
	0x36, 0x0a, 0x08, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x61, 0x74, 0x18, 0x07, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x66, 0x69, 0x72, 0x65, 0x73,
	0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x75, 0x72, 0x73, 0x6f, 0x72, 0x52, 0x07,
	0x73, 0x74, 0x61, 0x72, 0x74, 0x41, 0x74, 0x12, 0x32, 0x0a, 0x06, 0x65, 0x6e, 0x64, 0x5f, 0x61,
	0x74, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x66, 0x69, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x75,
	0x72, 0x73, 0x6f, 0x72, 0x52, 0x05, 0x65, 0x6e, 0x64, 0x41, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x6f,
	0x66, 0x66, 0x73, 0x65, 0x74, 0x18, 0x06, 0x20, 0x01, 0x28, 0x05, 0x52, 0x06, 0x6f, 0x66, 0x66,
	0x73, 0x65, 0x74, 0x12, 0x31, 0x0a, 0x05, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x33, 0x32, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52,
	0x05, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x1a, 0x62, 0x0a, 0x12, 0x43, 0x6f, 0x6c, 0x6c, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x12, 0x23, 0x0a, 0x0d,
	0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0c, 0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x49,
	0x64, 0x12, 0x27, 0x0a, 0x0f, 0x61, 0x6c, 0x6c, 0x5f, 0x64, 0x65, 0x73, 0x63, 0x65, 0x6e, 0x64,
	0x61, 0x6e, 0x74, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0e, 0x61, 0x6c, 0x6c, 0x44,
	0x65, 0x73, 0x63, 0x65, 0x6e, 0x64, 0x61, 0x6e, 0x74, 0x73, 0x1a, 0xa8, 0x02, 0x0a, 0x06, 0x46,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x61, 0x0a, 0x10, 0x63, 0x6f, 0x6d, 0x70, 0x6f, 0x73, 0x69,
	0x74, 0x65, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x66, 0x69, 0x72, 0x65, 0x73, 0x74, 0x6f,
	0x72, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x64,
	0x51, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x65, 0x46,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x48, 0x00, 0x52, 0x0f, 0x63, 0x6f, 0x6d, 0x70, 0x6f, 0x73, 0x69,
	0x74, 0x65, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x55, 0x0a, 0x0c, 0x66, 0x69, 0x65, 0x6c,
	0x64, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x66, 0x69, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72,
	0x65, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x64, 0x51,
	0x75, 0x65, 0x72, 0x79, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72,
	0x48, 0x00, 0x52, 0x0b, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12,
	0x55, 0x0a, 0x0c, 0x75, 0x6e, 0x61, 0x72, 0x79, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x66,
	0x69, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x72, 0x75,
	0x63, 0x74, 0x75, 0x72, 0x65, 0x64, 0x51, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x55, 0x6e, 0x61, 0x72,
	0x79, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x48, 0x00, 0x52, 0x0b, 0x75, 0x6e, 0x61, 0x72, 0x79,
	0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x42, 0x0d, 0x0a, 0x0b, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72,
	0x5f, 0x74, 0x79, 0x70, 0x65, 0x1a, 0xde, 0x01, 0x0a, 0x0f, 0x43, 0x6f, 0x6d, 0x70, 0x6f, 0x73,
	0x69, 0x74, 0x65, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x4d, 0x0a, 0x02, 0x6f, 0x70, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x66,
	0x69, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x72, 0x75,
	0x63, 0x74, 0x75, 0x72, 0x65, 0x64, 0x51, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x43, 0x6f, 0x6d, 0x70,
	0x6f, 0x73, 0x69, 0x74, 0x65, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x2e, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x6f, 0x72, 0x52, 0x02, 0x6f, 0x70, 0x12, 0x45, 0x0a, 0x07, 0x66, 0x69, 0x6c, 0x74,
	0x65, 0x72, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x66, 0x69, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x2e,
	0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x64, 0x51, 0x75, 0x65, 0x72, 0x79, 0x2e,
	0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x52, 0x07, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x22,
	0x35, 0x0a, 0x08, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x12, 0x18, 0x0a, 0x14, 0x4f,
	0x50, 0x45, 0x52, 0x41, 0x54, 0x4f, 0x52, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46,
	0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x07, 0x0a, 0x03, 0x41, 0x4e, 0x44, 0x10, 0x01, 0x12, 0x06,
	0x0a, 0x02, 0x4f, 0x52, 0x10, 0x02, 0x1a, 0xaa, 0x03, 0x0a, 0x0b, 0x46, 0x69, 0x65, 0x6c, 0x64,
	0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x49, 0x0a, 0x05, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x66,
	0x69, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x72, 0x75,
	0x63, 0x74, 0x75, 0x72, 0x65, 0x64, 0x51, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x46, 0x69, 0x65, 0x6c,
	0x64, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x52, 0x05, 0x66, 0x69, 0x65, 0x6c,
	0x64, 0x12, 0x49, 0x0a, 0x02, 0x6f, 0x70, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x39, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x66, 0x69, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65,
	0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x64, 0x51, 0x75,
	0x65, 0x72, 0x79, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x2e,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x52, 0x02, 0x6f, 0x70, 0x12, 0x30, 0x0a, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x66, 0x69, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76,
	0x31, 0x2e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x22, 0xd2,
	0x01, 0x0a, 0x08, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x12, 0x18, 0x0a, 0x14, 0x4f,
	0x50, 0x45, 0x52, 0x41, 0x54, 0x4f, 0x52, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46,
	0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0d, 0x0a, 0x09, 0x4c, 0x45, 0x53, 0x53, 0x5f, 0x54, 0x48,
	0x41, 0x4e, 0x10, 0x01, 0x12, 0x16, 0x0a, 0x12, 0x4c, 0x45, 0x53, 0x53, 0x5f, 0x54, 0x48, 0x41,
	0x4e, 0x5f, 0x4f, 0x52, 0x5f, 0x45, 0x51, 0x55, 0x41, 0x4c, 0x10, 0x02, 0x12, 0x10, 0x0a, 0x0c,
	0x47, 0x52, 0x45, 0x41, 0x54, 0x45, 0x52, 0x5f, 0x54, 0x48, 0x41, 0x4e, 0x10, 0x03, 0x12, 0x19,
	0x0a, 0x15, 0x47, 0x52, 0x45, 0x41, 0x54, 0x45, 0x52, 0x5f, 0x54, 0x48, 0x41, 0x4e, 0x5f, 0x4f,
	0x52, 0x5f, 0x45, 0x51, 0x55, 0x41, 0x4c, 0x10, 0x04, 0x12, 0x09, 0x0a, 0x05, 0x45, 0x51, 0x55,
	0x41, 0x4c, 0x10, 0x05, 0x12, 0x0d, 0x0a, 0x09, 0x4e, 0x4f, 0x54, 0x5f, 0x45, 0x51, 0x55, 0x41,
	0x4c, 0x10, 0x06, 0x12, 0x12, 0x0a, 0x0e, 0x41, 0x52, 0x52, 0x41, 0x59, 0x5f, 0x43, 0x4f, 0x4e,
	0x54, 0x41, 0x49, 0x4e, 0x53, 0x10, 0x07, 0x12, 0x06, 0x0a, 0x02, 0x49, 0x4e, 0x10, 0x08, 0x12,
	0x16, 0x0a, 0x12, 0x41, 0x52, 0x52, 0x41, 0x59, 0x5f, 0x43, 0x4f, 0x4e, 0x54, 0x41, 0x49, 0x4e,
	0x53, 0x5f, 0x41, 0x4e, 0x59, 0x10, 0x09, 0x12, 0x0a, 0x0a, 0x06, 0x4e, 0x4f, 0x54, 0x5f, 0x49,
	0x4e, 0x10, 0x0a, 0x1a, 0x95, 0x02, 0x0a, 0x0b, 0x55, 0x6e, 0x61, 0x72, 0x79, 0x46, 0x69, 0x6c,
	0x74, 0x65, 0x72, 0x12, 0x49, 0x0a, 0x02, 0x6f, 0x70, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x66, 0x69, 0x72, 0x65, 0x73, 0x74, 0x6f,
	0x72, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x64,
	0x51, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x55, 0x6e, 0x61, 0x72, 0x79, 0x46, 0x69, 0x6c, 0x74, 0x65,
	0x72, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x52, 0x02, 0x6f, 0x70, 0x12, 0x4b,
	0x0a, 0x05, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x66, 0x69, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65,
	0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x64, 0x51, 0x75,
	0x65, 0x72, 0x79, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e,
	0x63, 0x65, 0x48, 0x00, 0x52, 0x05, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x22, 0x5e, 0x0a, 0x08, 0x4f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x12, 0x18, 0x0a, 0x14, 0x4f, 0x50, 0x45, 0x52, 0x41,
	0x54, 0x4f, 0x52, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10,
	0x00, 0x12, 0x0a, 0x0a, 0x06, 0x49, 0x53, 0x5f, 0x4e, 0x41, 0x4e, 0x10, 0x02, 0x12, 0x0b, 0x0a,
	0x07, 0x49, 0x53, 0x5f, 0x4e, 0x55, 0x4c, 0x4c, 0x10, 0x03, 0x12, 0x0e, 0x0a, 0x0a, 0x49, 0x53,
	0x5f, 0x4e, 0x4f, 0x54, 0x5f, 0x4e, 0x41, 0x4e, 0x10, 0x04, 0x12, 0x0f, 0x0a, 0x0b, 0x49, 0x53,
	0x5f, 0x4e, 0x4f, 0x54, 0x5f, 0x4e, 0x55, 0x4c, 0x4c, 0x10, 0x05, 0x42, 0x0e, 0x0a, 0x0c, 0x6f,
	0x70, 0x65, 0x72, 0x61, 0x6e, 0x64, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x1a, 0xa0, 0x01, 0x0a, 0x05,
	0x4f, 0x72, 0x64, 0x65, 0x72, 0x12, 0x49, 0x0a, 0x05, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x66, 0x69,
	0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63,
	0x74, 0x75, 0x72, 0x65, 0x64, 0x51, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64,
	0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x52, 0x05, 0x66, 0x69, 0x65, 0x6c, 0x64,
	0x12, 0x4c, 0x0a, 0x09, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x66, 0x69, 0x72,
	0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74,
	0x75, 0x72, 0x65, 0x64, 0x51, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x09, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x1a, 0x2f,
	0x0a, 0x0e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65,
	0x12, 0x1d, 0x0a, 0x0a, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x50, 0x61, 0x74, 0x68, 0x1a,
	0x59, 0x0a, 0x0a, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x4b, 0x0a,
	0x06, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x33, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x66, 0x69, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65,
	0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x64, 0x51, 0x75,
	0x65, 0x72, 0x79, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e,
	0x63, 0x65, 0x52, 0x06, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x73, 0x22, 0x45, 0x0a, 0x09, 0x44, 0x69,
	0x72, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x19, 0x0a, 0x15, 0x44, 0x49, 0x52, 0x45, 0x43,
	0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x0d, 0x0a, 0x09, 0x41, 0x53, 0x43, 0x45, 0x4e, 0x44, 0x49, 0x4e, 0x47, 0x10,
	0x01, 0x12, 0x0e, 0x0a, 0x0a, 0x44, 0x45, 0x53, 0x43, 0x45, 0x4e, 0x44, 0x49, 0x4e, 0x47, 0x10,
	0x02, 0x22, 0x83, 0x06, 0x0a, 0x1a, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x64,
	0x41, 0x67, 0x67, 0x72, 0x65, 0x67, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x51, 0x75, 0x65, 0x72, 0x79,
	0x12, 0x51, 0x0a, 0x10, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x64, 0x5f, 0x71,
	0x75, 0x65, 0x72, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x66, 0x69, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31,
	0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x64, 0x51, 0x75, 0x65, 0x72, 0x79,
	0x48, 0x00, 0x52, 0x0f, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x64, 0x51, 0x75,
	0x65, 0x72, 0x79, 0x12, 0x64, 0x0a, 0x0c, 0x61, 0x67, 0x67, 0x72, 0x65, 0x67, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x66, 0x69, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x2e,
	0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x64, 0x41, 0x67, 0x67, 0x72, 0x65, 0x67,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x51, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x41, 0x67, 0x67, 0x72, 0x65,
	0x67, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x61, 0x67, 0x67,
	0x72, 0x65, 0x67, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x1a, 0x9d, 0x04, 0x0a, 0x0b, 0x41, 0x67,
	0x67, 0x72, 0x65, 0x67, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x59, 0x0a, 0x05, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x66, 0x69, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x53,
	0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x64, 0x41, 0x67, 0x67, 0x72, 0x65, 0x67, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x51, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x41, 0x67, 0x67, 0x72, 0x65, 0x67,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x48, 0x00, 0x52, 0x05, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x12, 0x53, 0x0a, 0x03, 0x73, 0x75, 0x6d, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x66, 0x69, 0x72, 0x65, 0x73,
	0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72,
	0x65, 0x64, 0x41, 0x67, 0x67, 0x72, 0x65, 0x67, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x51, 0x75, 0x65,
	0x72, 0x79, 0x2e, 0x41, 0x67, 0x67, 0x72, 0x65, 0x67, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x53,
	0x75, 0x6d, 0x48, 0x00, 0x52, 0x03, 0x73, 0x75, 0x6d, 0x12, 0x53, 0x0a, 0x03, 0x61, 0x76, 0x67,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x66, 0x69, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x72,
	0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x64, 0x41, 0x67, 0x67, 0x72, 0x65, 0x67, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x51, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x41, 0x67, 0x67, 0x72, 0x65, 0x67, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x41, 0x76, 0x67, 0x48, 0x00, 0x52, 0x03, 0x61, 0x76, 0x67, 0x12, 0x19,
	0x0a, 0x05, 0x61, 0x6c, 0x69, 0x61, 0x73, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x05, 0x61, 0x6c, 0x69, 0x61, 0x73, 0x1a, 0x3e, 0x0a, 0x05, 0x43, 0x6f, 0x75,
	0x6e, 0x74, 0x12, 0x35, 0x0a, 0x05, 0x75, 0x70, 0x5f, 0x74, 0x6f, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x04, 0x75, 0x70, 0x54, 0x6f, 0x1a, 0x50, 0x0a, 0x03, 0x53, 0x75, 0x6d,
	0x12, 0x49, 0x0a, 0x05, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x66, 0x69, 0x72, 0x65, 0x73, 0x74, 0x6f,
	0x72, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x64,
	0x51, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x52, 0x65, 0x66, 0x65, 0x72,
	0x65, 0x6e, 0x63, 0x65, 0x52, 0x05, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x1a, 0x50, 0x0a, 0x03, 0x41,
	0x76, 0x67, 0x12, 0x49, 0x0a, 0x05, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x66, 0x69, 0x72, 0x65, 0x73,
	0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72,
	0x65, 0x64, 0x51, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x52, 0x65, 0x66,
	0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x52, 0x05, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x42, 0x0a, 0x0a,
	0x08, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x42, 0x0c, 0x0a, 0x0a, 0x71, 0x75, 0x65,
	0x72, 0x79, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x22, 0x54, 0x0a, 0x06, 0x43, 0x75, 0x72, 0x73, 0x6f,
	0x72, 0x12, 0x32, 0x0a, 0x06, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x66, 0x69, 0x72, 0x65, 0x73,
	0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x06, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x73, 0x12, 0x16, 0x0a, 0x06, 0x62, 0x65, 0x66, 0x6f, 0x72, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x06, 0x62, 0x65, 0x66, 0x6f, 0x72, 0x65, 0x42, 0xc2, 0x01,
	0x0a, 0x17, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x66, 0x69, 0x72,
	0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x42, 0x0a, 0x51, 0x75, 0x65, 0x72, 0x79,
	0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x3b, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x66, 0x69, 0x72,
	0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x2f, 0x66, 0x69, 0x72,
	0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x70, 0x62, 0x3b, 0x66, 0x69, 0x72, 0x65, 0x73, 0x74, 0x6f,
	0x72, 0x65, 0x70, 0x62, 0xa2, 0x02, 0x04, 0x47, 0x43, 0x46, 0x53, 0xaa, 0x02, 0x19, 0x47, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x46, 0x69, 0x72, 0x65, 0x73,
	0x74, 0x6f, 0x72, 0x65, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x19, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x46, 0x69, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65,
	0x5c, 0x56, 0x31, 0xea, 0x02, 0x1c, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c,
	0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x46, 0x69, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x3a, 0x3a,
	0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_firestore_v1_query_proto_rawDescOnce sync.Once
	file_google_firestore_v1_query_proto_rawDescData = file_google_firestore_v1_query_proto_rawDesc
)

func file_google_firestore_v1_query_proto_rawDescGZIP() []byte {
	file_google_firestore_v1_query_proto_rawDescOnce.Do(func() {
		file_google_firestore_v1_query_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_firestore_v1_query_proto_rawDescData)
	})
	return file_google_firestore_v1_query_proto_rawDescData
}

var file_google_firestore_v1_query_proto_enumTypes = make([]protoimpl.EnumInfo, 4)
var file_google_firestore_v1_query_proto_msgTypes = make([]protoimpl.MessageInfo, 15)
var file_google_firestore_v1_query_proto_goTypes = []interface{}{
	(StructuredQuery_Direction)(0),                       // 0: google.firestore.v1.StructuredQuery.Direction
	(StructuredQuery_CompositeFilter_Operator)(0),        // 1: google.firestore.v1.StructuredQuery.CompositeFilter.Operator
	(StructuredQuery_FieldFilter_Operator)(0),            // 2: google.firestore.v1.StructuredQuery.FieldFilter.Operator
	(StructuredQuery_UnaryFilter_Operator)(0),            // 3: google.firestore.v1.StructuredQuery.UnaryFilter.Operator
	(*StructuredQuery)(nil),                              // 4: google.firestore.v1.StructuredQuery
	(*StructuredAggregationQuery)(nil),                   // 5: google.firestore.v1.StructuredAggregationQuery
	(*Cursor)(nil),                                       // 6: google.firestore.v1.Cursor
	(*StructuredQuery_CollectionSelector)(nil),           // 7: google.firestore.v1.StructuredQuery.CollectionSelector
	(*StructuredQuery_Filter)(nil),                       // 8: google.firestore.v1.StructuredQuery.Filter
	(*StructuredQuery_CompositeFilter)(nil),              // 9: google.firestore.v1.StructuredQuery.CompositeFilter
	(*StructuredQuery_FieldFilter)(nil),                  // 10: google.firestore.v1.StructuredQuery.FieldFilter
	(*StructuredQuery_UnaryFilter)(nil),                  // 11: google.firestore.v1.StructuredQuery.UnaryFilter
	(*StructuredQuery_Order)(nil),                        // 12: google.firestore.v1.StructuredQuery.Order
	(*StructuredQuery_FieldReference)(nil),               // 13: google.firestore.v1.StructuredQuery.FieldReference
	(*StructuredQuery_Projection)(nil),                   // 14: google.firestore.v1.StructuredQuery.Projection
	(*StructuredAggregationQuery_Aggregation)(nil),       // 15: google.firestore.v1.StructuredAggregationQuery.Aggregation
	(*StructuredAggregationQuery_Aggregation_Count)(nil), // 16: google.firestore.v1.StructuredAggregationQuery.Aggregation.Count
	(*StructuredAggregationQuery_Aggregation_Sum)(nil),   // 17: google.firestore.v1.StructuredAggregationQuery.Aggregation.Sum
	(*StructuredAggregationQuery_Aggregation_Avg)(nil),   // 18: google.firestore.v1.StructuredAggregationQuery.Aggregation.Avg
	(*wrapperspb.Int32Value)(nil),                        // 19: google.protobuf.Int32Value
	(*Value)(nil),                                        // 20: google.firestore.v1.Value
	(*wrapperspb.Int64Value)(nil),                        // 21: google.protobuf.Int64Value
}
var file_google_firestore_v1_query_proto_depIdxs = []int32{
	14, // 0: google.firestore.v1.StructuredQuery.select:type_name -> google.firestore.v1.StructuredQuery.Projection
	7,  // 1: google.firestore.v1.StructuredQuery.from:type_name -> google.firestore.v1.StructuredQuery.CollectionSelector
	8,  // 2: google.firestore.v1.StructuredQuery.where:type_name -> google.firestore.v1.StructuredQuery.Filter
	12, // 3: google.firestore.v1.StructuredQuery.order_by:type_name -> google.firestore.v1.StructuredQuery.Order
	6,  // 4: google.firestore.v1.StructuredQuery.start_at:type_name -> google.firestore.v1.Cursor
	6,  // 5: google.firestore.v1.StructuredQuery.end_at:type_name -> google.firestore.v1.Cursor
	19, // 6: google.firestore.v1.StructuredQuery.limit:type_name -> google.protobuf.Int32Value
	4,  // 7: google.firestore.v1.StructuredAggregationQuery.structured_query:type_name -> google.firestore.v1.StructuredQuery
	15, // 8: google.firestore.v1.StructuredAggregationQuery.aggregations:type_name -> google.firestore.v1.StructuredAggregationQuery.Aggregation
	20, // 9: google.firestore.v1.Cursor.values:type_name -> google.firestore.v1.Value
	9,  // 10: google.firestore.v1.StructuredQuery.Filter.composite_filter:type_name -> google.firestore.v1.StructuredQuery.CompositeFilter
	10, // 11: google.firestore.v1.StructuredQuery.Filter.field_filter:type_name -> google.firestore.v1.StructuredQuery.FieldFilter
	11, // 12: google.firestore.v1.StructuredQuery.Filter.unary_filter:type_name -> google.firestore.v1.StructuredQuery.UnaryFilter
	1,  // 13: google.firestore.v1.StructuredQuery.CompositeFilter.op:type_name -> google.firestore.v1.StructuredQuery.CompositeFilter.Operator
	8,  // 14: google.firestore.v1.StructuredQuery.CompositeFilter.filters:type_name -> google.firestore.v1.StructuredQuery.Filter
	13, // 15: google.firestore.v1.StructuredQuery.FieldFilter.field:type_name -> google.firestore.v1.StructuredQuery.FieldReference
	2,  // 16: google.firestore.v1.StructuredQuery.FieldFilter.op:type_name -> google.firestore.v1.StructuredQuery.FieldFilter.Operator
	20, // 17: google.firestore.v1.StructuredQuery.FieldFilter.value:type_name -> google.firestore.v1.Value
	3,  // 18: google.firestore.v1.StructuredQuery.UnaryFilter.op:type_name -> google.firestore.v1.StructuredQuery.UnaryFilter.Operator
	13, // 19: google.firestore.v1.StructuredQuery.UnaryFilter.field:type_name -> google.firestore.v1.StructuredQuery.FieldReference
	13, // 20: google.firestore.v1.StructuredQuery.Order.field:type_name -> google.firestore.v1.StructuredQuery.FieldReference
	0,  // 21: google.firestore.v1.StructuredQuery.Order.direction:type_name -> google.firestore.v1.StructuredQuery.Direction
	13, // 22: google.firestore.v1.StructuredQuery.Projection.fields:type_name -> google.firestore.v1.StructuredQuery.FieldReference
	16, // 23: google.firestore.v1.StructuredAggregationQuery.Aggregation.count:type_name -> google.firestore.v1.StructuredAggregationQuery.Aggregation.Count
	17, // 24: google.firestore.v1.StructuredAggregationQuery.Aggregation.sum:type_name -> google.firestore.v1.StructuredAggregationQuery.Aggregation.Sum
	18, // 25: google.firestore.v1.StructuredAggregationQuery.Aggregation.avg:type_name -> google.firestore.v1.StructuredAggregationQuery.Aggregation.Avg
	21, // 26: google.firestore.v1.StructuredAggregationQuery.Aggregation.Count.up_to:type_name -> google.protobuf.Int64Value
	13, // 27: google.firestore.v1.StructuredAggregationQuery.Aggregation.Sum.field:type_name -> google.firestore.v1.StructuredQuery.FieldReference
	13, // 28: google.firestore.v1.StructuredAggregationQuery.Aggregation.Avg.field:type_name -> google.firestore.v1.StructuredQuery.FieldReference
	29, // [29:29] is the sub-list for method output_type
	29, // [29:29] is the sub-list for method input_type
	29, // [29:29] is the sub-list for extension type_name
	29, // [29:29] is the sub-list for extension extendee
	0,  // [0:29] is the sub-list for field type_name
}

func init() { file_google_firestore_v1_query_proto_init() }
func file_google_firestore_v1_query_proto_init() {
	if File_google_firestore_v1_query_proto != nil {
		return
	}
	file_google_firestore_v1_document_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_firestore_v1_query_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StructuredQuery); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_firestore_v1_query_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StructuredAggregationQuery); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_firestore_v1_query_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Cursor); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_firestore_v1_query_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StructuredQuery_CollectionSelector); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_firestore_v1_query_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StructuredQuery_Filter); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_firestore_v1_query_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StructuredQuery_CompositeFilter); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_firestore_v1_query_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StructuredQuery_FieldFilter); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_firestore_v1_query_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StructuredQuery_UnaryFilter); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_firestore_v1_query_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StructuredQuery_Order); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_firestore_v1_query_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StructuredQuery_FieldReference); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_firestore_v1_query_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StructuredQuery_Projection); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_firestore_v1_query_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StructuredAggregationQuery_Aggregation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_firestore_v1_query_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StructuredAggregationQuery_Aggregation_Count); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_firestore_v1_query_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StructuredAggregationQuery_Aggregation_Sum); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_firestore_v1_query_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StructuredAggregationQuery_Aggregation_Avg); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_firestore_v1_query_proto_msgTypes[1].OneofWrappers = []interface{}{
		(*StructuredAggregationQuery_StructuredQuery)(nil),
	}
	file_google_firestore_v1_query_proto_msgTypes[4].OneofWrappers = []interface{}{
		(*StructuredQuery_Filter_CompositeFilter)(nil),
		(*StructuredQuery_Filter_FieldFilter)(nil),
		(*StructuredQuery_Filter_UnaryFilter)(nil),
	}
	file_google_firestore_v1_query_proto_msgTypes[7].OneofWrappers = []interface{}{
		(*StructuredQuery_UnaryFilter_Field)(nil),
	}
	file_google_firestore_v1_query_proto_msgTypes[11].OneofWrappers = []interface{}{
		(*StructuredAggregationQuery_Aggregation_Count_)(nil),
		(*StructuredAggregationQuery_Aggregation_Sum_)(nil),
		(*StructuredAggregationQuery_Aggregation_Avg_)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_firestore_v1_query_proto_rawDesc,
			NumEnums:      4,
			NumMessages:   15,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_firestore_v1_query_proto_goTypes,
		DependencyIndexes: file_google_firestore_v1_query_proto_depIdxs,
		EnumInfos:         file_google_firestore_v1_query_proto_enumTypes,
		MessageInfos:      file_google_firestore_v1_query_proto_msgTypes,
	}.Build()
	File_google_firestore_v1_query_proto = out.File
	file_google_firestore_v1_query_proto_rawDesc = nil
	file_google_firestore_v1_query_proto_goTypes = nil
	file_google_firestore_v1_query_proto_depIdxs = nil
}
