// Copyright 2021 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.32.0
// 	protoc        v4.23.2
// source: google/cloud/binaryauthorization/v1/resources.proto

package binaryauthorizationpb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type Policy_GlobalPolicyEvaluationMode int32

const (
	// Not specified: DISABLE is assumed.
	Policy_GLOBAL_POLICY_EVALUATION_MODE_UNSPECIFIED Policy_GlobalPolicyEvaluationMode = 0
	// Enables system policy evaluation.
	Policy_ENABLE Policy_GlobalPolicyEvaluationMode = 1
	// Disables system policy evaluation.
	Policy_DISABLE Policy_GlobalPolicyEvaluationMode = 2
)

// Enum value maps for Policy_GlobalPolicyEvaluationMode.
var (
	Policy_GlobalPolicyEvaluationMode_name = map[int32]string{
		0: "GLOBAL_POLICY_EVALUATION_MODE_UNSPECIFIED",
		1: "ENABLE",
		2: "DISABLE",
	}
	Policy_GlobalPolicyEvaluationMode_value = map[string]int32{
		"GLOBAL_POLICY_EVALUATION_MODE_UNSPECIFIED": 0,
		"ENABLE":  1,
		"DISABLE": 2,
	}
)

func (x Policy_GlobalPolicyEvaluationMode) Enum() *Policy_GlobalPolicyEvaluationMode {
	p := new(Policy_GlobalPolicyEvaluationMode)
	*p = x
	return p
}

func (x Policy_GlobalPolicyEvaluationMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Policy_GlobalPolicyEvaluationMode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_binaryauthorization_v1_resources_proto_enumTypes[0].Descriptor()
}

func (Policy_GlobalPolicyEvaluationMode) Type() protoreflect.EnumType {
	return &file_google_cloud_binaryauthorization_v1_resources_proto_enumTypes[0]
}

func (x Policy_GlobalPolicyEvaluationMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Policy_GlobalPolicyEvaluationMode.Descriptor instead.
func (Policy_GlobalPolicyEvaluationMode) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_binaryauthorization_v1_resources_proto_rawDescGZIP(), []int{0, 0}
}

type AdmissionRule_EvaluationMode int32

const (
	// Do not use.
	AdmissionRule_EVALUATION_MODE_UNSPECIFIED AdmissionRule_EvaluationMode = 0
	// This rule allows all all pod creations.
	AdmissionRule_ALWAYS_ALLOW AdmissionRule_EvaluationMode = 1
	// This rule allows a pod creation if all the attestors listed in
	// 'require_attestations_by' have valid attestations for all of the
	// images in the pod spec.
	AdmissionRule_REQUIRE_ATTESTATION AdmissionRule_EvaluationMode = 2
	// This rule denies all pod creations.
	AdmissionRule_ALWAYS_DENY AdmissionRule_EvaluationMode = 3
)

// Enum value maps for AdmissionRule_EvaluationMode.
var (
	AdmissionRule_EvaluationMode_name = map[int32]string{
		0: "EVALUATION_MODE_UNSPECIFIED",
		1: "ALWAYS_ALLOW",
		2: "REQUIRE_ATTESTATION",
		3: "ALWAYS_DENY",
	}
	AdmissionRule_EvaluationMode_value = map[string]int32{
		"EVALUATION_MODE_UNSPECIFIED": 0,
		"ALWAYS_ALLOW":                1,
		"REQUIRE_ATTESTATION":         2,
		"ALWAYS_DENY":                 3,
	}
)

func (x AdmissionRule_EvaluationMode) Enum() *AdmissionRule_EvaluationMode {
	p := new(AdmissionRule_EvaluationMode)
	*p = x
	return p
}

func (x AdmissionRule_EvaluationMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AdmissionRule_EvaluationMode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_binaryauthorization_v1_resources_proto_enumTypes[1].Descriptor()
}

func (AdmissionRule_EvaluationMode) Type() protoreflect.EnumType {
	return &file_google_cloud_binaryauthorization_v1_resources_proto_enumTypes[1]
}

func (x AdmissionRule_EvaluationMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AdmissionRule_EvaluationMode.Descriptor instead.
func (AdmissionRule_EvaluationMode) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_binaryauthorization_v1_resources_proto_rawDescGZIP(), []int{2, 0}
}

// Defines the possible actions when a pod creation is denied by an admission
// rule.
type AdmissionRule_EnforcementMode int32

const (
	// Do not use.
	AdmissionRule_ENFORCEMENT_MODE_UNSPECIFIED AdmissionRule_EnforcementMode = 0
	// Enforce the admission rule by blocking the pod creation.
	AdmissionRule_ENFORCED_BLOCK_AND_AUDIT_LOG AdmissionRule_EnforcementMode = 1
	// Dryrun mode: Audit logging only.  This will allow the pod creation as if
	// the admission request had specified break-glass.
	AdmissionRule_DRYRUN_AUDIT_LOG_ONLY AdmissionRule_EnforcementMode = 2
)

// Enum value maps for AdmissionRule_EnforcementMode.
var (
	AdmissionRule_EnforcementMode_name = map[int32]string{
		0: "ENFORCEMENT_MODE_UNSPECIFIED",
		1: "ENFORCED_BLOCK_AND_AUDIT_LOG",
		2: "DRYRUN_AUDIT_LOG_ONLY",
	}
	AdmissionRule_EnforcementMode_value = map[string]int32{
		"ENFORCEMENT_MODE_UNSPECIFIED": 0,
		"ENFORCED_BLOCK_AND_AUDIT_LOG": 1,
		"DRYRUN_AUDIT_LOG_ONLY":        2,
	}
)

func (x AdmissionRule_EnforcementMode) Enum() *AdmissionRule_EnforcementMode {
	p := new(AdmissionRule_EnforcementMode)
	*p = x
	return p
}

func (x AdmissionRule_EnforcementMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AdmissionRule_EnforcementMode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_binaryauthorization_v1_resources_proto_enumTypes[2].Descriptor()
}

func (AdmissionRule_EnforcementMode) Type() protoreflect.EnumType {
	return &file_google_cloud_binaryauthorization_v1_resources_proto_enumTypes[2]
}

func (x AdmissionRule_EnforcementMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AdmissionRule_EnforcementMode.Descriptor instead.
func (AdmissionRule_EnforcementMode) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_binaryauthorization_v1_resources_proto_rawDescGZIP(), []int{2, 1}
}

// Represents a signature algorithm and other information necessary to verify
// signatures with a given public key.
// This is based primarily on the public key types supported by Tink's
// PemKeyType, which is in turn based on KMS's supported signing algorithms.
// See https://cloud.google.com/kms/docs/algorithms. In the future, BinAuthz
// might support additional public key types independently of Tink and/or KMS.
type PkixPublicKey_SignatureAlgorithm int32

const (
	// Not specified.
	PkixPublicKey_SIGNATURE_ALGORITHM_UNSPECIFIED PkixPublicKey_SignatureAlgorithm = 0
	// RSASSA-PSS 2048 bit key with a SHA256 digest.
	PkixPublicKey_RSA_PSS_2048_SHA256 PkixPublicKey_SignatureAlgorithm = 1
	// RSASSA-PSS 3072 bit key with a SHA256 digest.
	PkixPublicKey_RSA_PSS_3072_SHA256 PkixPublicKey_SignatureAlgorithm = 2
	// RSASSA-PSS 4096 bit key with a SHA256 digest.
	PkixPublicKey_RSA_PSS_4096_SHA256 PkixPublicKey_SignatureAlgorithm = 3
	// RSASSA-PSS 4096 bit key with a SHA512 digest.
	PkixPublicKey_RSA_PSS_4096_SHA512 PkixPublicKey_SignatureAlgorithm = 4
	// RSASSA-PKCS1-v1_5 with a 2048 bit key and a SHA256 digest.
	PkixPublicKey_RSA_SIGN_PKCS1_2048_SHA256 PkixPublicKey_SignatureAlgorithm = 5
	// RSASSA-PKCS1-v1_5 with a 3072 bit key and a SHA256 digest.
	PkixPublicKey_RSA_SIGN_PKCS1_3072_SHA256 PkixPublicKey_SignatureAlgorithm = 6
	// RSASSA-PKCS1-v1_5 with a 4096 bit key and a SHA256 digest.
	PkixPublicKey_RSA_SIGN_PKCS1_4096_SHA256 PkixPublicKey_SignatureAlgorithm = 7
	// RSASSA-PKCS1-v1_5 with a 4096 bit key and a SHA512 digest.
	PkixPublicKey_RSA_SIGN_PKCS1_4096_SHA512 PkixPublicKey_SignatureAlgorithm = 8
	// ECDSA on the NIST P-256 curve with a SHA256 digest.
	PkixPublicKey_ECDSA_P256_SHA256 PkixPublicKey_SignatureAlgorithm = 9
	// ECDSA on the NIST P-256 curve with a SHA256 digest.
	PkixPublicKey_EC_SIGN_P256_SHA256 PkixPublicKey_SignatureAlgorithm = 9
	// ECDSA on the NIST P-384 curve with a SHA384 digest.
	PkixPublicKey_ECDSA_P384_SHA384 PkixPublicKey_SignatureAlgorithm = 10
	// ECDSA on the NIST P-384 curve with a SHA384 digest.
	PkixPublicKey_EC_SIGN_P384_SHA384 PkixPublicKey_SignatureAlgorithm = 10
	// ECDSA on the NIST P-521 curve with a SHA512 digest.
	PkixPublicKey_ECDSA_P521_SHA512 PkixPublicKey_SignatureAlgorithm = 11
	// ECDSA on the NIST P-521 curve with a SHA512 digest.
	PkixPublicKey_EC_SIGN_P521_SHA512 PkixPublicKey_SignatureAlgorithm = 11
)

// Enum value maps for PkixPublicKey_SignatureAlgorithm.
var (
	PkixPublicKey_SignatureAlgorithm_name = map[int32]string{
		0: "SIGNATURE_ALGORITHM_UNSPECIFIED",
		1: "RSA_PSS_2048_SHA256",
		2: "RSA_PSS_3072_SHA256",
		3: "RSA_PSS_4096_SHA256",
		4: "RSA_PSS_4096_SHA512",
		5: "RSA_SIGN_PKCS1_2048_SHA256",
		6: "RSA_SIGN_PKCS1_3072_SHA256",
		7: "RSA_SIGN_PKCS1_4096_SHA256",
		8: "RSA_SIGN_PKCS1_4096_SHA512",
		9: "ECDSA_P256_SHA256",
		// Duplicate value: 9: "EC_SIGN_P256_SHA256",
		10: "ECDSA_P384_SHA384",
		// Duplicate value: 10: "EC_SIGN_P384_SHA384",
		11: "ECDSA_P521_SHA512",
		// Duplicate value: 11: "EC_SIGN_P521_SHA512",
	}
	PkixPublicKey_SignatureAlgorithm_value = map[string]int32{
		"SIGNATURE_ALGORITHM_UNSPECIFIED": 0,
		"RSA_PSS_2048_SHA256":             1,
		"RSA_PSS_3072_SHA256":             2,
		"RSA_PSS_4096_SHA256":             3,
		"RSA_PSS_4096_SHA512":             4,
		"RSA_SIGN_PKCS1_2048_SHA256":      5,
		"RSA_SIGN_PKCS1_3072_SHA256":      6,
		"RSA_SIGN_PKCS1_4096_SHA256":      7,
		"RSA_SIGN_PKCS1_4096_SHA512":      8,
		"ECDSA_P256_SHA256":               9,
		"EC_SIGN_P256_SHA256":             9,
		"ECDSA_P384_SHA384":               10,
		"EC_SIGN_P384_SHA384":             10,
		"ECDSA_P521_SHA512":               11,
		"EC_SIGN_P521_SHA512":             11,
	}
)

func (x PkixPublicKey_SignatureAlgorithm) Enum() *PkixPublicKey_SignatureAlgorithm {
	p := new(PkixPublicKey_SignatureAlgorithm)
	*p = x
	return p
}

func (x PkixPublicKey_SignatureAlgorithm) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PkixPublicKey_SignatureAlgorithm) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_binaryauthorization_v1_resources_proto_enumTypes[3].Descriptor()
}

func (PkixPublicKey_SignatureAlgorithm) Type() protoreflect.EnumType {
	return &file_google_cloud_binaryauthorization_v1_resources_proto_enumTypes[3]
}

func (x PkixPublicKey_SignatureAlgorithm) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PkixPublicKey_SignatureAlgorithm.Descriptor instead.
func (PkixPublicKey_SignatureAlgorithm) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_binaryauthorization_v1_resources_proto_rawDescGZIP(), []int{5, 0}
}

// A [policy][google.cloud.binaryauthorization.v1.Policy] for container image binary authorization.
type Policy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The resource name, in the format `projects/*/policy`. There is
	// at most one policy per project.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. A descriptive comment.
	Description string `protobuf:"bytes,6,opt,name=description,proto3" json:"description,omitempty"`
	// Optional. Controls the evaluation of a Google-maintained global admission
	// policy for common system-level images. Images not covered by the global
	// policy will be subject to the project admission policy. This setting
	// has no effect when specified inside a global admission policy.
	GlobalPolicyEvaluationMode Policy_GlobalPolicyEvaluationMode `protobuf:"varint,7,opt,name=global_policy_evaluation_mode,json=globalPolicyEvaluationMode,proto3,enum=google.cloud.binaryauthorization.v1.Policy_GlobalPolicyEvaluationMode" json:"global_policy_evaluation_mode,omitempty"`
	// Optional. Admission policy allowlisting. A matching admission request will
	// always be permitted. This feature is typically used to exclude Google or
	// third-party infrastructure images from Binary Authorization policies.
	AdmissionWhitelistPatterns []*AdmissionWhitelistPattern `protobuf:"bytes,2,rep,name=admission_whitelist_patterns,json=admissionWhitelistPatterns,proto3" json:"admission_whitelist_patterns,omitempty"`
	// Optional. Per-cluster admission rules. Cluster spec format:
	// `location.clusterId`. There can be at most one admission rule per cluster
	// spec.
	// A `location` is either a compute zone (e.g. us-central1-a) or a region
	// (e.g. us-central1).
	// For `clusterId` syntax restrictions see
	// https://cloud.google.com/container-engine/reference/rest/v1/projects.zones.clusters.
	ClusterAdmissionRules map[string]*AdmissionRule `protobuf:"bytes,3,rep,name=cluster_admission_rules,json=clusterAdmissionRules,proto3" json:"cluster_admission_rules,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Optional. Per-kubernetes-namespace admission rules. K8s namespace spec format:
	// [a-z.-]+, e.g. 'some-namespace'
	KubernetesNamespaceAdmissionRules map[string]*AdmissionRule `protobuf:"bytes,10,rep,name=kubernetes_namespace_admission_rules,json=kubernetesNamespaceAdmissionRules,proto3" json:"kubernetes_namespace_admission_rules,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Optional. Per-kubernetes-service-account admission rules. Service account
	// spec format: `namespace:serviceaccount`. e.g. 'test-ns:default'
	KubernetesServiceAccountAdmissionRules map[string]*AdmissionRule `protobuf:"bytes,8,rep,name=kubernetes_service_account_admission_rules,json=kubernetesServiceAccountAdmissionRules,proto3" json:"kubernetes_service_account_admission_rules,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Optional. Per-istio-service-identity admission rules. Istio service
	// identity spec format:
	// spiffe://<domain>/ns/<namespace>/sa/<serviceaccount> or
	// <domain>/ns/<namespace>/sa/<serviceaccount>
	// e.g. spiffe://example.com/ns/test-ns/sa/default
	IstioServiceIdentityAdmissionRules map[string]*AdmissionRule `protobuf:"bytes,9,rep,name=istio_service_identity_admission_rules,json=istioServiceIdentityAdmissionRules,proto3" json:"istio_service_identity_admission_rules,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Required. Default admission rule for a cluster without a per-cluster, per-
	// kubernetes-service-account, or per-istio-service-identity admission rule.
	DefaultAdmissionRule *AdmissionRule `protobuf:"bytes,4,opt,name=default_admission_rule,json=defaultAdmissionRule,proto3" json:"default_admission_rule,omitempty"`
	// Output only. Time when the policy was last updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
}

func (x *Policy) Reset() {
	*x = Policy{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_binaryauthorization_v1_resources_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Policy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Policy) ProtoMessage() {}

func (x *Policy) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_binaryauthorization_v1_resources_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Policy.ProtoReflect.Descriptor instead.
func (*Policy) Descriptor() ([]byte, []int) {
	return file_google_cloud_binaryauthorization_v1_resources_proto_rawDescGZIP(), []int{0}
}

func (x *Policy) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Policy) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Policy) GetGlobalPolicyEvaluationMode() Policy_GlobalPolicyEvaluationMode {
	if x != nil {
		return x.GlobalPolicyEvaluationMode
	}
	return Policy_GLOBAL_POLICY_EVALUATION_MODE_UNSPECIFIED
}

func (x *Policy) GetAdmissionWhitelistPatterns() []*AdmissionWhitelistPattern {
	if x != nil {
		return x.AdmissionWhitelistPatterns
	}
	return nil
}

func (x *Policy) GetClusterAdmissionRules() map[string]*AdmissionRule {
	if x != nil {
		return x.ClusterAdmissionRules
	}
	return nil
}

func (x *Policy) GetKubernetesNamespaceAdmissionRules() map[string]*AdmissionRule {
	if x != nil {
		return x.KubernetesNamespaceAdmissionRules
	}
	return nil
}

func (x *Policy) GetKubernetesServiceAccountAdmissionRules() map[string]*AdmissionRule {
	if x != nil {
		return x.KubernetesServiceAccountAdmissionRules
	}
	return nil
}

func (x *Policy) GetIstioServiceIdentityAdmissionRules() map[string]*AdmissionRule {
	if x != nil {
		return x.IstioServiceIdentityAdmissionRules
	}
	return nil
}

func (x *Policy) GetDefaultAdmissionRule() *AdmissionRule {
	if x != nil {
		return x.DefaultAdmissionRule
	}
	return nil
}

func (x *Policy) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

// An [admission allowlist pattern][google.cloud.binaryauthorization.v1.AdmissionWhitelistPattern] exempts images
// from checks by [admission rules][google.cloud.binaryauthorization.v1.AdmissionRule].
type AdmissionWhitelistPattern struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// An image name pattern to allowlist, in the form `registry/path/to/image`.
	// This supports a trailing `*` wildcard, but this is allowed only in
	// text after the `registry/` part. This also supports a trailing `**`
	// wildcard which matches subdirectories of a given entry.
	NamePattern string `protobuf:"bytes,1,opt,name=name_pattern,json=namePattern,proto3" json:"name_pattern,omitempty"`
}

func (x *AdmissionWhitelistPattern) Reset() {
	*x = AdmissionWhitelistPattern{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_binaryauthorization_v1_resources_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AdmissionWhitelistPattern) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AdmissionWhitelistPattern) ProtoMessage() {}

func (x *AdmissionWhitelistPattern) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_binaryauthorization_v1_resources_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AdmissionWhitelistPattern.ProtoReflect.Descriptor instead.
func (*AdmissionWhitelistPattern) Descriptor() ([]byte, []int) {
	return file_google_cloud_binaryauthorization_v1_resources_proto_rawDescGZIP(), []int{1}
}

func (x *AdmissionWhitelistPattern) GetNamePattern() string {
	if x != nil {
		return x.NamePattern
	}
	return ""
}

// An [admission rule][google.cloud.binaryauthorization.v1.AdmissionRule] specifies either that all container images
// used in a pod creation request must be attested to by one or more
// [attestors][google.cloud.binaryauthorization.v1.Attestor], that all pod creations will be allowed, or that all
// pod creations will be denied.
//
// Images matching an [admission allowlist pattern][google.cloud.binaryauthorization.v1.AdmissionWhitelistPattern]
// are exempted from admission rules and will never block a pod creation.
type AdmissionRule struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. How this admission rule will be evaluated.
	EvaluationMode AdmissionRule_EvaluationMode `protobuf:"varint,1,opt,name=evaluation_mode,json=evaluationMode,proto3,enum=google.cloud.binaryauthorization.v1.AdmissionRule_EvaluationMode" json:"evaluation_mode,omitempty"`
	// Optional. The resource names of the attestors that must attest to
	// a container image, in the format `projects/*/attestors/*`. Each
	// attestor must exist before a policy can reference it.  To add an attestor
	// to a policy the principal issuing the policy change request must be able
	// to read the attestor resource.
	//
	// Note: this field must be non-empty when the evaluation_mode field specifies
	// REQUIRE_ATTESTATION, otherwise it must be empty.
	RequireAttestationsBy []string `protobuf:"bytes,2,rep,name=require_attestations_by,json=requireAttestationsBy,proto3" json:"require_attestations_by,omitempty"`
	// Required. The action when a pod creation is denied by the admission rule.
	EnforcementMode AdmissionRule_EnforcementMode `protobuf:"varint,3,opt,name=enforcement_mode,json=enforcementMode,proto3,enum=google.cloud.binaryauthorization.v1.AdmissionRule_EnforcementMode" json:"enforcement_mode,omitempty"`
}

func (x *AdmissionRule) Reset() {
	*x = AdmissionRule{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_binaryauthorization_v1_resources_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AdmissionRule) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AdmissionRule) ProtoMessage() {}

func (x *AdmissionRule) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_binaryauthorization_v1_resources_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AdmissionRule.ProtoReflect.Descriptor instead.
func (*AdmissionRule) Descriptor() ([]byte, []int) {
	return file_google_cloud_binaryauthorization_v1_resources_proto_rawDescGZIP(), []int{2}
}

func (x *AdmissionRule) GetEvaluationMode() AdmissionRule_EvaluationMode {
	if x != nil {
		return x.EvaluationMode
	}
	return AdmissionRule_EVALUATION_MODE_UNSPECIFIED
}

func (x *AdmissionRule) GetRequireAttestationsBy() []string {
	if x != nil {
		return x.RequireAttestationsBy
	}
	return nil
}

func (x *AdmissionRule) GetEnforcementMode() AdmissionRule_EnforcementMode {
	if x != nil {
		return x.EnforcementMode
	}
	return AdmissionRule_ENFORCEMENT_MODE_UNSPECIFIED
}

// An [attestor][google.cloud.binaryauthorization.v1.Attestor] that attests to container image
// artifacts. An existing attestor cannot be modified except where
// indicated.
type Attestor struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name, in the format:
	// `projects/*/attestors/*`. This field may not be updated.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. A descriptive comment.  This field may be updated.
	// The field may be displayed in chooser dialogs.
	Description string `protobuf:"bytes,6,opt,name=description,proto3" json:"description,omitempty"`
	// Types that are assignable to AttestorType:
	//
	//	*Attestor_UserOwnedGrafeasNote
	AttestorType isAttestor_AttestorType `protobuf_oneof:"attestor_type"`
	// Output only. Time when the attestor was last updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
}

func (x *Attestor) Reset() {
	*x = Attestor{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_binaryauthorization_v1_resources_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Attestor) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Attestor) ProtoMessage() {}

func (x *Attestor) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_binaryauthorization_v1_resources_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Attestor.ProtoReflect.Descriptor instead.
func (*Attestor) Descriptor() ([]byte, []int) {
	return file_google_cloud_binaryauthorization_v1_resources_proto_rawDescGZIP(), []int{3}
}

func (x *Attestor) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Attestor) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (m *Attestor) GetAttestorType() isAttestor_AttestorType {
	if m != nil {
		return m.AttestorType
	}
	return nil
}

func (x *Attestor) GetUserOwnedGrafeasNote() *UserOwnedGrafeasNote {
	if x, ok := x.GetAttestorType().(*Attestor_UserOwnedGrafeasNote); ok {
		return x.UserOwnedGrafeasNote
	}
	return nil
}

func (x *Attestor) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

type isAttestor_AttestorType interface {
	isAttestor_AttestorType()
}

type Attestor_UserOwnedGrafeasNote struct {
	// This specifies how an attestation will be read, and how it will be used
	// during policy enforcement.
	UserOwnedGrafeasNote *UserOwnedGrafeasNote `protobuf:"bytes,3,opt,name=user_owned_grafeas_note,json=userOwnedGrafeasNote,proto3,oneof"`
}

func (*Attestor_UserOwnedGrafeasNote) isAttestor_AttestorType() {}

// An [user owned Grafeas note][google.cloud.binaryauthorization.v1.UserOwnedGrafeasNote] references a Grafeas
// Attestation.Authority Note created by the user.
type UserOwnedGrafeasNote struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The Grafeas resource name of a Attestation.Authority Note,
	// created by the user, in the format: `projects/*/notes/*`. This field may
	// not be updated.
	//
	// An attestation by this attestor is stored as a Grafeas
	// Attestation.Authority Occurrence that names a container image and that
	// links to this Note. Grafeas is an external dependency.
	NoteReference string `protobuf:"bytes,1,opt,name=note_reference,json=noteReference,proto3" json:"note_reference,omitempty"`
	// Optional. Public keys that verify attestations signed by this
	// attestor.  This field may be updated.
	//
	// If this field is non-empty, one of the specified public keys must
	// verify that an attestation was signed by this attestor for the
	// image specified in the admission request.
	//
	// If this field is empty, this attestor always returns that no
	// valid attestations exist.
	PublicKeys []*AttestorPublicKey `protobuf:"bytes,2,rep,name=public_keys,json=publicKeys,proto3" json:"public_keys,omitempty"`
	// Output only. This field will contain the service account email address
	// that this Attestor will use as the principal when querying Container
	// Analysis. Attestor administrators must grant this service account the
	// IAM role needed to read attestations from the [note_reference][Note] in
	// Container Analysis (`containeranalysis.notes.occurrences.viewer`).
	//
	// This email address is fixed for the lifetime of the Attestor, but callers
	// should not make any other assumptions about the service account email;
	// future versions may use an email based on a different naming pattern.
	DelegationServiceAccountEmail string `protobuf:"bytes,3,opt,name=delegation_service_account_email,json=delegationServiceAccountEmail,proto3" json:"delegation_service_account_email,omitempty"`
}

func (x *UserOwnedGrafeasNote) Reset() {
	*x = UserOwnedGrafeasNote{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_binaryauthorization_v1_resources_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UserOwnedGrafeasNote) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UserOwnedGrafeasNote) ProtoMessage() {}

func (x *UserOwnedGrafeasNote) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_binaryauthorization_v1_resources_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UserOwnedGrafeasNote.ProtoReflect.Descriptor instead.
func (*UserOwnedGrafeasNote) Descriptor() ([]byte, []int) {
	return file_google_cloud_binaryauthorization_v1_resources_proto_rawDescGZIP(), []int{4}
}

func (x *UserOwnedGrafeasNote) GetNoteReference() string {
	if x != nil {
		return x.NoteReference
	}
	return ""
}

func (x *UserOwnedGrafeasNote) GetPublicKeys() []*AttestorPublicKey {
	if x != nil {
		return x.PublicKeys
	}
	return nil
}

func (x *UserOwnedGrafeasNote) GetDelegationServiceAccountEmail() string {
	if x != nil {
		return x.DelegationServiceAccountEmail
	}
	return ""
}

// A public key in the PkixPublicKey format (see
// https://tools.ietf.org/html/rfc5280#section-4.1.2.7 for details).
// Public keys of this type are typically textually encoded using the PEM
// format.
type PkixPublicKey struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A PEM-encoded public key, as described in
	// https://tools.ietf.org/html/rfc7468#section-13
	PublicKeyPem string `protobuf:"bytes,1,opt,name=public_key_pem,json=publicKeyPem,proto3" json:"public_key_pem,omitempty"`
	// The signature algorithm used to verify a message against a signature using
	// this key.
	// These signature algorithm must match the structure and any object
	// identifiers encoded in `public_key_pem` (i.e. this algorithm must match
	// that of the public key).
	SignatureAlgorithm PkixPublicKey_SignatureAlgorithm `protobuf:"varint,2,opt,name=signature_algorithm,json=signatureAlgorithm,proto3,enum=google.cloud.binaryauthorization.v1.PkixPublicKey_SignatureAlgorithm" json:"signature_algorithm,omitempty"`
}

func (x *PkixPublicKey) Reset() {
	*x = PkixPublicKey{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_binaryauthorization_v1_resources_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PkixPublicKey) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PkixPublicKey) ProtoMessage() {}

func (x *PkixPublicKey) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_binaryauthorization_v1_resources_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PkixPublicKey.ProtoReflect.Descriptor instead.
func (*PkixPublicKey) Descriptor() ([]byte, []int) {
	return file_google_cloud_binaryauthorization_v1_resources_proto_rawDescGZIP(), []int{5}
}

func (x *PkixPublicKey) GetPublicKeyPem() string {
	if x != nil {
		return x.PublicKeyPem
	}
	return ""
}

func (x *PkixPublicKey) GetSignatureAlgorithm() PkixPublicKey_SignatureAlgorithm {
	if x != nil {
		return x.SignatureAlgorithm
	}
	return PkixPublicKey_SIGNATURE_ALGORITHM_UNSPECIFIED
}

// An [attestor public key][google.cloud.binaryauthorization.v1.AttestorPublicKey] that will be used to verify
// attestations signed by this attestor.
type AttestorPublicKey struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. A descriptive comment. This field may be updated.
	Comment string `protobuf:"bytes,1,opt,name=comment,proto3" json:"comment,omitempty"`
	// The ID of this public key.
	// Signatures verified by BinAuthz must include the ID of the public key that
	// can be used to verify them, and that ID must match the contents of this
	// field exactly.
	// Additional restrictions on this field can be imposed based on which public
	// key type is encapsulated. See the documentation on `public_key` cases below
	// for details.
	Id string `protobuf:"bytes,2,opt,name=id,proto3" json:"id,omitempty"`
	// Types that are assignable to PublicKey:
	//
	//	*AttestorPublicKey_AsciiArmoredPgpPublicKey
	//	*AttestorPublicKey_PkixPublicKey
	PublicKey isAttestorPublicKey_PublicKey `protobuf_oneof:"public_key"`
}

func (x *AttestorPublicKey) Reset() {
	*x = AttestorPublicKey{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_binaryauthorization_v1_resources_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AttestorPublicKey) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AttestorPublicKey) ProtoMessage() {}

func (x *AttestorPublicKey) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_binaryauthorization_v1_resources_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AttestorPublicKey.ProtoReflect.Descriptor instead.
func (*AttestorPublicKey) Descriptor() ([]byte, []int) {
	return file_google_cloud_binaryauthorization_v1_resources_proto_rawDescGZIP(), []int{6}
}

func (x *AttestorPublicKey) GetComment() string {
	if x != nil {
		return x.Comment
	}
	return ""
}

func (x *AttestorPublicKey) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (m *AttestorPublicKey) GetPublicKey() isAttestorPublicKey_PublicKey {
	if m != nil {
		return m.PublicKey
	}
	return nil
}

func (x *AttestorPublicKey) GetAsciiArmoredPgpPublicKey() string {
	if x, ok := x.GetPublicKey().(*AttestorPublicKey_AsciiArmoredPgpPublicKey); ok {
		return x.AsciiArmoredPgpPublicKey
	}
	return ""
}

func (x *AttestorPublicKey) GetPkixPublicKey() *PkixPublicKey {
	if x, ok := x.GetPublicKey().(*AttestorPublicKey_PkixPublicKey); ok {
		return x.PkixPublicKey
	}
	return nil
}

type isAttestorPublicKey_PublicKey interface {
	isAttestorPublicKey_PublicKey()
}

type AttestorPublicKey_AsciiArmoredPgpPublicKey struct {
	// ASCII-armored representation of a PGP public key, as the entire output by
	// the command `gpg --export --armor foo@example.com` (either LF or CRLF
	// line endings).
	// When using this field, `id` should be left blank.  The BinAuthz API
	// handlers will calculate the ID and fill it in automatically.  BinAuthz
	// computes this ID as the OpenPGP RFC4880 V4 fingerprint, represented as
	// upper-case hex.  If `id` is provided by the caller, it will be
	// overwritten by the API-calculated ID.
	AsciiArmoredPgpPublicKey string `protobuf:"bytes,3,opt,name=ascii_armored_pgp_public_key,json=asciiArmoredPgpPublicKey,proto3,oneof"`
}

type AttestorPublicKey_PkixPublicKey struct {
	// A raw PKIX SubjectPublicKeyInfo format public key.
	//
	// NOTE: `id` may be explicitly provided by the caller when using this
	// type of public key, but it MUST be a valid RFC3986 URI. If `id` is left
	// blank, a default one will be computed based on the digest of the DER
	// encoding of the public key.
	PkixPublicKey *PkixPublicKey `protobuf:"bytes,5,opt,name=pkix_public_key,json=pkixPublicKey,proto3,oneof"`
}

func (*AttestorPublicKey_AsciiArmoredPgpPublicKey) isAttestorPublicKey_PublicKey() {}

func (*AttestorPublicKey_PkixPublicKey) isAttestorPublicKey_PublicKey() {}

var File_google_cloud_binaryauthorization_v1_resources_proto protoreflect.FileDescriptor

var file_google_cloud_binaryauthorization_v1_resources_proto_rawDesc = []byte{
	0x0a, 0x33, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x62,
	0x69, 0x6e, 0x61, 0x72, 0x79, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x2f, 0x76, 0x31, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x23, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x6e, 0x61, 0x72, 0x79, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72,
	0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68,
	0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xa0, 0x0f, 0x0a, 0x06, 0x50, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x25, 0x0a, 0x0b, 0x64,
	0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x8e, 0x01, 0x0a, 0x1d, 0x67, 0x6c, 0x6f, 0x62, 0x61, 0x6c, 0x5f, 0x70, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x5f, 0x65, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x6d, 0x6f, 0x64, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x46, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x6e, 0x61, 0x72, 0x79,
	0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31,
	0x2e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e, 0x47, 0x6c, 0x6f, 0x62, 0x61, 0x6c, 0x50, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x45, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x6f,
	0x64, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x1a, 0x67, 0x6c, 0x6f, 0x62, 0x61, 0x6c, 0x50,
	0x6f, 0x6c, 0x69, 0x63, 0x79, 0x45, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d,
	0x6f, 0x64, 0x65, 0x12, 0x85, 0x01, 0x0a, 0x1c, 0x61, 0x64, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f,
	0x6e, 0x5f, 0x77, 0x68, 0x69, 0x74, 0x65, 0x6c, 0x69, 0x73, 0x74, 0x5f, 0x70, 0x61, 0x74, 0x74,
	0x65, 0x72, 0x6e, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x6e, 0x61, 0x72, 0x79,
	0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31,
	0x2e, 0x41, 0x64, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x57, 0x68, 0x69, 0x74, 0x65, 0x6c,
	0x69, 0x73, 0x74, 0x50, 0x61, 0x74, 0x74, 0x65, 0x72, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x1a, 0x61, 0x64, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x57, 0x68, 0x69, 0x74, 0x65, 0x6c,
	0x69, 0x73, 0x74, 0x50, 0x61, 0x74, 0x74, 0x65, 0x72, 0x6e, 0x73, 0x12, 0x83, 0x01, 0x0a, 0x17,
	0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x61, 0x64, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f,
	0x6e, 0x5f, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x46, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x6e,
	0x61, 0x72, 0x79, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e, 0x43, 0x6c, 0x75, 0x73, 0x74,
	0x65, 0x72, 0x41, 0x64, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x75, 0x6c, 0x65, 0x73,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x15, 0x63, 0x6c, 0x75, 0x73,
	0x74, 0x65, 0x72, 0x41, 0x64, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x75, 0x6c, 0x65,
	0x73, 0x12, 0xa8, 0x01, 0x0a, 0x24, 0x6b, 0x75, 0x62, 0x65, 0x72, 0x6e, 0x65, 0x74, 0x65, 0x73,
	0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x5f, 0x61, 0x64, 0x6d, 0x69, 0x73,
	0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x18, 0x0a, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x52, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x62, 0x69, 0x6e, 0x61, 0x72, 0x79, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e, 0x4b, 0x75,
	0x62, 0x65, 0x72, 0x6e, 0x65, 0x74, 0x65, 0x73, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63,
	0x65, 0x41, 0x64, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x75, 0x6c, 0x65, 0x73, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x21, 0x6b, 0x75, 0x62, 0x65, 0x72,
	0x6e, 0x65, 0x74, 0x65, 0x73, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x41, 0x64,
	0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x75, 0x6c, 0x65, 0x73, 0x12, 0xb8, 0x01, 0x0a,
	0x2a, 0x6b, 0x75, 0x62, 0x65, 0x72, 0x6e, 0x65, 0x74, 0x65, 0x73, 0x5f, 0x73, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x5f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x5f, 0x61, 0x64, 0x6d, 0x69,
	0x73, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x18, 0x08, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x57, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x62, 0x69, 0x6e, 0x61, 0x72, 0x79, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e, 0x4b,
	0x75, 0x62, 0x65, 0x72, 0x6e, 0x65, 0x74, 0x65, 0x73, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x41, 0x64, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e,
	0x52, 0x75, 0x6c, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x26, 0x6b, 0x75, 0x62, 0x65, 0x72, 0x6e, 0x65, 0x74, 0x65, 0x73, 0x53, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x41, 0x64, 0x6d, 0x69, 0x73, 0x73, 0x69,
	0x6f, 0x6e, 0x52, 0x75, 0x6c, 0x65, 0x73, 0x12, 0xac, 0x01, 0x0a, 0x26, 0x69, 0x73, 0x74, 0x69,
	0x6f, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69,
	0x74, 0x79, 0x5f, 0x61, 0x64, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x75, 0x6c,
	0x65, 0x73, 0x18, 0x09, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x53, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x6e, 0x61, 0x72, 0x79, 0x61, 0x75,
	0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x50,
	0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e, 0x49, 0x73, 0x74, 0x69, 0x6f, 0x53, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x41, 0x64, 0x6d, 0x69, 0x73, 0x73,
	0x69, 0x6f, 0x6e, 0x52, 0x75, 0x6c, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x22, 0x69, 0x73, 0x74, 0x69, 0x6f, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x41, 0x64, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f,
	0x6e, 0x52, 0x75, 0x6c, 0x65, 0x73, 0x12, 0x6d, 0x0a, 0x16, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c,
	0x74, 0x5f, 0x61, 0x64, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x75, 0x6c, 0x65,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x6e, 0x61, 0x72, 0x79, 0x61, 0x75, 0x74, 0x68,
	0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x64, 0x6d,
	0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x75, 0x6c, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x14, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x41, 0x64, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f,
	0x6e, 0x52, 0x75, 0x6c, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x1a, 0x7c, 0x0a, 0x1a, 0x43, 0x6c, 0x75, 0x73, 0x74,
	0x65, 0x72, 0x41, 0x64, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x75, 0x6c, 0x65, 0x73,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x48, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x6e, 0x61, 0x72, 0x79, 0x61, 0x75, 0x74, 0x68,
	0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x64, 0x6d,
	0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x75, 0x6c, 0x65, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a, 0x88, 0x01, 0x0a, 0x26, 0x4b, 0x75, 0x62, 0x65, 0x72, 0x6e,
	0x65, 0x74, 0x65, 0x73, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x41, 0x64, 0x6d,
	0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x75, 0x6c, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b,
	0x65, 0x79, 0x12, 0x48, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x62, 0x69, 0x6e, 0x61, 0x72, 0x79, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x64, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f,
	0x6e, 0x52, 0x75, 0x6c, 0x65, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01,
	0x1a, 0x8d, 0x01, 0x0a, 0x2b, 0x4b, 0x75, 0x62, 0x65, 0x72, 0x6e, 0x65, 0x74, 0x65, 0x73, 0x53,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x41, 0x64, 0x6d,
	0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x75, 0x6c, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b,
	0x65, 0x79, 0x12, 0x48, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x62, 0x69, 0x6e, 0x61, 0x72, 0x79, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x64, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f,
	0x6e, 0x52, 0x75, 0x6c, 0x65, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01,
	0x1a, 0x89, 0x01, 0x0a, 0x27, 0x49, 0x73, 0x74, 0x69, 0x6f, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x41, 0x64, 0x6d, 0x69, 0x73, 0x73, 0x69,
	0x6f, 0x6e, 0x52, 0x75, 0x6c, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03,
	0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x48,
	0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x6e,
	0x61, 0x72, 0x79, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x76, 0x31, 0x2e, 0x41, 0x64, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x75, 0x6c,
	0x65, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x64, 0x0a, 0x1a,
	0x47, 0x6c, 0x6f, 0x62, 0x61, 0x6c, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x45, 0x76, 0x61, 0x6c,
	0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x6f, 0x64, 0x65, 0x12, 0x2d, 0x0a, 0x29, 0x47, 0x4c,
	0x4f, 0x42, 0x41, 0x4c, 0x5f, 0x50, 0x4f, 0x4c, 0x49, 0x43, 0x59, 0x5f, 0x45, 0x56, 0x41, 0x4c,
	0x55, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x4d, 0x4f, 0x44, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50,
	0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x45, 0x4e, 0x41,
	0x42, 0x4c, 0x45, 0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07, 0x44, 0x49, 0x53, 0x41, 0x42, 0x4c, 0x45,
	0x10, 0x02, 0x3a, 0x66, 0xea, 0x41, 0x63, 0x0a, 0x29, 0x62, 0x69, 0x6e, 0x61, 0x72, 0x79, 0x61,
	0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x12, 0x19, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x1b, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x7d, 0x2f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x22, 0x3e, 0x0a, 0x19, 0x41, 0x64,
	0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x57, 0x68, 0x69, 0x74, 0x65, 0x6c, 0x69, 0x73, 0x74,
	0x50, 0x61, 0x74, 0x74, 0x65, 0x72, 0x6e, 0x12, 0x21, 0x0a, 0x0c, 0x6e, 0x61, 0x6d, 0x65, 0x5f,
	0x70, 0x61, 0x74, 0x74, 0x65, 0x72, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x6e,
	0x61, 0x6d, 0x65, 0x50, 0x61, 0x74, 0x74, 0x65, 0x72, 0x6e, 0x22, 0x92, 0x04, 0x0a, 0x0d, 0x41,
	0x64, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x75, 0x6c, 0x65, 0x12, 0x6f, 0x0a, 0x0f,
	0x65, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x6e, 0x61, 0x72, 0x79, 0x61, 0x75, 0x74, 0x68, 0x6f,
	0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x64, 0x6d, 0x69,
	0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x75, 0x6c, 0x65, 0x2e, 0x45, 0x76, 0x61, 0x6c, 0x75, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x6f, 0x64, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0e, 0x65,
	0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x6f, 0x64, 0x65, 0x12, 0x3b, 0x0a,
	0x17, 0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x5f, 0x61, 0x74, 0x74, 0x65, 0x73, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x5f, 0x62, 0x79, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x15, 0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x41, 0x74, 0x74, 0x65,
	0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x42, 0x79, 0x12, 0x72, 0x0a, 0x10, 0x65, 0x6e,
	0x66, 0x6f, 0x72, 0x63, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x42, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x6e, 0x61, 0x72, 0x79, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72,
	0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x64, 0x6d, 0x69, 0x73,
	0x73, 0x69, 0x6f, 0x6e, 0x52, 0x75, 0x6c, 0x65, 0x2e, 0x45, 0x6e, 0x66, 0x6f, 0x72, 0x63, 0x65,
	0x6d, 0x65, 0x6e, 0x74, 0x4d, 0x6f, 0x64, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0f, 0x65,
	0x6e, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x4d, 0x6f, 0x64, 0x65, 0x22, 0x6d,
	0x0a, 0x0e, 0x45, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x6f, 0x64, 0x65,
	0x12, 0x1f, 0x0a, 0x1b, 0x45, 0x56, 0x41, 0x4c, 0x55, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x4d,
	0x4f, 0x44, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10,
	0x00, 0x12, 0x10, 0x0a, 0x0c, 0x41, 0x4c, 0x57, 0x41, 0x59, 0x53, 0x5f, 0x41, 0x4c, 0x4c, 0x4f,
	0x57, 0x10, 0x01, 0x12, 0x17, 0x0a, 0x13, 0x52, 0x45, 0x51, 0x55, 0x49, 0x52, 0x45, 0x5f, 0x41,
	0x54, 0x54, 0x45, 0x53, 0x54, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x02, 0x12, 0x0f, 0x0a, 0x0b,
	0x41, 0x4c, 0x57, 0x41, 0x59, 0x53, 0x5f, 0x44, 0x45, 0x4e, 0x59, 0x10, 0x03, 0x22, 0x70, 0x0a,
	0x0f, 0x45, 0x6e, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x4d, 0x6f, 0x64, 0x65,
	0x12, 0x20, 0x0a, 0x1c, 0x45, 0x4e, 0x46, 0x4f, 0x52, 0x43, 0x45, 0x4d, 0x45, 0x4e, 0x54, 0x5f,
	0x4d, 0x4f, 0x44, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x20, 0x0a, 0x1c, 0x45, 0x4e, 0x46, 0x4f, 0x52, 0x43, 0x45, 0x44, 0x5f, 0x42,
	0x4c, 0x4f, 0x43, 0x4b, 0x5f, 0x41, 0x4e, 0x44, 0x5f, 0x41, 0x55, 0x44, 0x49, 0x54, 0x5f, 0x4c,
	0x4f, 0x47, 0x10, 0x01, 0x12, 0x19, 0x0a, 0x15, 0x44, 0x52, 0x59, 0x52, 0x55, 0x4e, 0x5f, 0x41,
	0x55, 0x44, 0x49, 0x54, 0x5f, 0x4c, 0x4f, 0x47, 0x5f, 0x4f, 0x4e, 0x4c, 0x59, 0x10, 0x02, 0x22,
	0xec, 0x02, 0x0a, 0x08, 0x41, 0x74, 0x74, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x12, 0x17, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x25, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x72, 0x0a, 0x17,
	0x75, 0x73, 0x65, 0x72, 0x5f, 0x6f, 0x77, 0x6e, 0x65, 0x64, 0x5f, 0x67, 0x72, 0x61, 0x66, 0x65,
	0x61, 0x73, 0x5f, 0x6e, 0x6f, 0x74, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x39, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x6e,
	0x61, 0x72, 0x79, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x76, 0x31, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x4f, 0x77, 0x6e, 0x65, 0x64, 0x47, 0x72, 0x61,
	0x66, 0x65, 0x61, 0x73, 0x4e, 0x6f, 0x74, 0x65, 0x48, 0x00, 0x52, 0x14, 0x75, 0x73, 0x65, 0x72,
	0x4f, 0x77, 0x6e, 0x65, 0x64, 0x47, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x4e, 0x6f, 0x74, 0x65,
	0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69,
	0x6d, 0x65, 0x3a, 0x59, 0xea, 0x41, 0x56, 0x0a, 0x2b, 0x62, 0x69, 0x6e, 0x61, 0x72, 0x79, 0x61,
	0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x74, 0x74, 0x65,
	0x73, 0x74, 0x6f, 0x72, 0x12, 0x27, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x61, 0x74, 0x74, 0x65, 0x73, 0x74, 0x6f,
	0x72, 0x73, 0x2f, 0x7b, 0x61, 0x74, 0x74, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x7d, 0x42, 0x0f, 0x0a,
	0x0d, 0x61, 0x74, 0x74, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x22, 0xee,
	0x01, 0x0a, 0x14, 0x55, 0x73, 0x65, 0x72, 0x4f, 0x77, 0x6e, 0x65, 0x64, 0x47, 0x72, 0x61, 0x66,
	0x65, 0x61, 0x73, 0x4e, 0x6f, 0x74, 0x65, 0x12, 0x2a, 0x0a, 0x0e, 0x6e, 0x6f, 0x74, 0x65, 0x5f,
	0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x0d, 0x6e, 0x6f, 0x74, 0x65, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65,
	0x6e, 0x63, 0x65, 0x12, 0x5c, 0x0a, 0x0b, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x5f, 0x6b, 0x65,
	0x79, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x6e, 0x61, 0x72, 0x79, 0x61, 0x75,
	0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x41,
	0x74, 0x74, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x4b, 0x65, 0x79,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x4b, 0x65, 0x79,
	0x73, 0x12, 0x4c, 0x0a, 0x20, 0x64, 0x65, 0x6c, 0x65, 0x67, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x5f,
	0x65, 0x6d, 0x61, 0x69, 0x6c, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x1d, 0x64, 0x65, 0x6c, 0x65, 0x67, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x45, 0x6d, 0x61, 0x69, 0x6c, 0x22,
	0xe1, 0x04, 0x0a, 0x0d, 0x50, 0x6b, 0x69, 0x78, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x4b, 0x65,
	0x79, 0x12, 0x24, 0x0a, 0x0e, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x5f, 0x6b, 0x65, 0x79, 0x5f,
	0x70, 0x65, 0x6d, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x70, 0x75, 0x62, 0x6c, 0x69,
	0x63, 0x4b, 0x65, 0x79, 0x50, 0x65, 0x6d, 0x12, 0x76, 0x0a, 0x13, 0x73, 0x69, 0x67, 0x6e, 0x61,
	0x74, 0x75, 0x72, 0x65, 0x5f, 0x61, 0x6c, 0x67, 0x6f, 0x72, 0x69, 0x74, 0x68, 0x6d, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x45, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x6e, 0x61, 0x72, 0x79, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72,
	0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6b, 0x69, 0x78, 0x50,
	0x75, 0x62, 0x6c, 0x69, 0x63, 0x4b, 0x65, 0x79, 0x2e, 0x53, 0x69, 0x67, 0x6e, 0x61, 0x74, 0x75,
	0x72, 0x65, 0x41, 0x6c, 0x67, 0x6f, 0x72, 0x69, 0x74, 0x68, 0x6d, 0x52, 0x12, 0x73, 0x69, 0x67,
	0x6e, 0x61, 0x74, 0x75, 0x72, 0x65, 0x41, 0x6c, 0x67, 0x6f, 0x72, 0x69, 0x74, 0x68, 0x6d, 0x22,
	0xb1, 0x03, 0x0a, 0x12, 0x53, 0x69, 0x67, 0x6e, 0x61, 0x74, 0x75, 0x72, 0x65, 0x41, 0x6c, 0x67,
	0x6f, 0x72, 0x69, 0x74, 0x68, 0x6d, 0x12, 0x23, 0x0a, 0x1f, 0x53, 0x49, 0x47, 0x4e, 0x41, 0x54,
	0x55, 0x52, 0x45, 0x5f, 0x41, 0x4c, 0x47, 0x4f, 0x52, 0x49, 0x54, 0x48, 0x4d, 0x5f, 0x55, 0x4e,
	0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x17, 0x0a, 0x13, 0x52,
	0x53, 0x41, 0x5f, 0x50, 0x53, 0x53, 0x5f, 0x32, 0x30, 0x34, 0x38, 0x5f, 0x53, 0x48, 0x41, 0x32,
	0x35, 0x36, 0x10, 0x01, 0x12, 0x17, 0x0a, 0x13, 0x52, 0x53, 0x41, 0x5f, 0x50, 0x53, 0x53, 0x5f,
	0x33, 0x30, 0x37, 0x32, 0x5f, 0x53, 0x48, 0x41, 0x32, 0x35, 0x36, 0x10, 0x02, 0x12, 0x17, 0x0a,
	0x13, 0x52, 0x53, 0x41, 0x5f, 0x50, 0x53, 0x53, 0x5f, 0x34, 0x30, 0x39, 0x36, 0x5f, 0x53, 0x48,
	0x41, 0x32, 0x35, 0x36, 0x10, 0x03, 0x12, 0x17, 0x0a, 0x13, 0x52, 0x53, 0x41, 0x5f, 0x50, 0x53,
	0x53, 0x5f, 0x34, 0x30, 0x39, 0x36, 0x5f, 0x53, 0x48, 0x41, 0x35, 0x31, 0x32, 0x10, 0x04, 0x12,
	0x1e, 0x0a, 0x1a, 0x52, 0x53, 0x41, 0x5f, 0x53, 0x49, 0x47, 0x4e, 0x5f, 0x50, 0x4b, 0x43, 0x53,
	0x31, 0x5f, 0x32, 0x30, 0x34, 0x38, 0x5f, 0x53, 0x48, 0x41, 0x32, 0x35, 0x36, 0x10, 0x05, 0x12,
	0x1e, 0x0a, 0x1a, 0x52, 0x53, 0x41, 0x5f, 0x53, 0x49, 0x47, 0x4e, 0x5f, 0x50, 0x4b, 0x43, 0x53,
	0x31, 0x5f, 0x33, 0x30, 0x37, 0x32, 0x5f, 0x53, 0x48, 0x41, 0x32, 0x35, 0x36, 0x10, 0x06, 0x12,
	0x1e, 0x0a, 0x1a, 0x52, 0x53, 0x41, 0x5f, 0x53, 0x49, 0x47, 0x4e, 0x5f, 0x50, 0x4b, 0x43, 0x53,
	0x31, 0x5f, 0x34, 0x30, 0x39, 0x36, 0x5f, 0x53, 0x48, 0x41, 0x32, 0x35, 0x36, 0x10, 0x07, 0x12,
	0x1e, 0x0a, 0x1a, 0x52, 0x53, 0x41, 0x5f, 0x53, 0x49, 0x47, 0x4e, 0x5f, 0x50, 0x4b, 0x43, 0x53,
	0x31, 0x5f, 0x34, 0x30, 0x39, 0x36, 0x5f, 0x53, 0x48, 0x41, 0x35, 0x31, 0x32, 0x10, 0x08, 0x12,
	0x15, 0x0a, 0x11, 0x45, 0x43, 0x44, 0x53, 0x41, 0x5f, 0x50, 0x32, 0x35, 0x36, 0x5f, 0x53, 0x48,
	0x41, 0x32, 0x35, 0x36, 0x10, 0x09, 0x12, 0x17, 0x0a, 0x13, 0x45, 0x43, 0x5f, 0x53, 0x49, 0x47,
	0x4e, 0x5f, 0x50, 0x32, 0x35, 0x36, 0x5f, 0x53, 0x48, 0x41, 0x32, 0x35, 0x36, 0x10, 0x09, 0x12,
	0x15, 0x0a, 0x11, 0x45, 0x43, 0x44, 0x53, 0x41, 0x5f, 0x50, 0x33, 0x38, 0x34, 0x5f, 0x53, 0x48,
	0x41, 0x33, 0x38, 0x34, 0x10, 0x0a, 0x12, 0x17, 0x0a, 0x13, 0x45, 0x43, 0x5f, 0x53, 0x49, 0x47,
	0x4e, 0x5f, 0x50, 0x33, 0x38, 0x34, 0x5f, 0x53, 0x48, 0x41, 0x33, 0x38, 0x34, 0x10, 0x0a, 0x12,
	0x15, 0x0a, 0x11, 0x45, 0x43, 0x44, 0x53, 0x41, 0x5f, 0x50, 0x35, 0x32, 0x31, 0x5f, 0x53, 0x48,
	0x41, 0x35, 0x31, 0x32, 0x10, 0x0b, 0x12, 0x17, 0x0a, 0x13, 0x45, 0x43, 0x5f, 0x53, 0x49, 0x47,
	0x4e, 0x5f, 0x50, 0x35, 0x32, 0x31, 0x5f, 0x53, 0x48, 0x41, 0x35, 0x31, 0x32, 0x10, 0x0b, 0x1a,
	0x02, 0x10, 0x01, 0x22, 0xf0, 0x01, 0x0a, 0x11, 0x41, 0x74, 0x74, 0x65, 0x73, 0x74, 0x6f, 0x72,
	0x50, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x4b, 0x65, 0x79, 0x12, 0x1d, 0x0a, 0x07, 0x63, 0x6f, 0x6d,
	0x6d, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x07, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x69, 0x64, 0x12, 0x40, 0x0a, 0x1c, 0x61, 0x73, 0x63, 0x69,
	0x69, 0x5f, 0x61, 0x72, 0x6d, 0x6f, 0x72, 0x65, 0x64, 0x5f, 0x70, 0x67, 0x70, 0x5f, 0x70, 0x75,
	0x62, 0x6c, 0x69, 0x63, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00,
	0x52, 0x18, 0x61, 0x73, 0x63, 0x69, 0x69, 0x41, 0x72, 0x6d, 0x6f, 0x72, 0x65, 0x64, 0x50, 0x67,
	0x70, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x4b, 0x65, 0x79, 0x12, 0x5c, 0x0a, 0x0f, 0x70, 0x6b,
	0x69, 0x78, 0x5f, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x62, 0x69, 0x6e, 0x61, 0x72, 0x79, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69,
	0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6b, 0x69, 0x78, 0x50, 0x75,
	0x62, 0x6c, 0x69, 0x63, 0x4b, 0x65, 0x79, 0x48, 0x00, 0x52, 0x0d, 0x70, 0x6b, 0x69, 0x78, 0x50,
	0x75, 0x62, 0x6c, 0x69, 0x63, 0x4b, 0x65, 0x79, 0x42, 0x0c, 0x0a, 0x0a, 0x70, 0x75, 0x62, 0x6c,
	0x69, 0x63, 0x5f, 0x6b, 0x65, 0x79, 0x42, 0x8c, 0x02, 0x0a, 0x35, 0x63, 0x6f, 0x6d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x6e, 0x61, 0x72, 0x79,
	0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31,
	0x50, 0x00, 0x5a, 0x59, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x62, 0x69, 0x6e, 0x61, 0x72, 0x79, 0x61, 0x75,
	0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2f, 0x61, 0x70, 0x69, 0x76,
	0x31, 0x2f, 0x62, 0x69, 0x6e, 0x61, 0x72, 0x79, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x70, 0x62, 0x3b, 0x62, 0x69, 0x6e, 0x61, 0x72, 0x79, 0x61, 0x75,
	0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x70, 0x62, 0xf8, 0x01, 0x01,
	0xaa, 0x02, 0x23, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x42, 0x69, 0x6e, 0x61, 0x72, 0x79, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x23, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c,
	0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x42, 0x69, 0x6e, 0x61, 0x72, 0x79, 0x41, 0x75, 0x74, 0x68,
	0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5c, 0x56, 0x31, 0xea, 0x02, 0x26, 0x47,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x42, 0x69,
	0x6e, 0x61, 0x72, 0x79, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_binaryauthorization_v1_resources_proto_rawDescOnce sync.Once
	file_google_cloud_binaryauthorization_v1_resources_proto_rawDescData = file_google_cloud_binaryauthorization_v1_resources_proto_rawDesc
)

func file_google_cloud_binaryauthorization_v1_resources_proto_rawDescGZIP() []byte {
	file_google_cloud_binaryauthorization_v1_resources_proto_rawDescOnce.Do(func() {
		file_google_cloud_binaryauthorization_v1_resources_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_binaryauthorization_v1_resources_proto_rawDescData)
	})
	return file_google_cloud_binaryauthorization_v1_resources_proto_rawDescData
}

var file_google_cloud_binaryauthorization_v1_resources_proto_enumTypes = make([]protoimpl.EnumInfo, 4)
var file_google_cloud_binaryauthorization_v1_resources_proto_msgTypes = make([]protoimpl.MessageInfo, 11)
var file_google_cloud_binaryauthorization_v1_resources_proto_goTypes = []interface{}{
	(Policy_GlobalPolicyEvaluationMode)(0), // 0: google.cloud.binaryauthorization.v1.Policy.GlobalPolicyEvaluationMode
	(AdmissionRule_EvaluationMode)(0),      // 1: google.cloud.binaryauthorization.v1.AdmissionRule.EvaluationMode
	(AdmissionRule_EnforcementMode)(0),     // 2: google.cloud.binaryauthorization.v1.AdmissionRule.EnforcementMode
	(PkixPublicKey_SignatureAlgorithm)(0),  // 3: google.cloud.binaryauthorization.v1.PkixPublicKey.SignatureAlgorithm
	(*Policy)(nil),                         // 4: google.cloud.binaryauthorization.v1.Policy
	(*AdmissionWhitelistPattern)(nil),      // 5: google.cloud.binaryauthorization.v1.AdmissionWhitelistPattern
	(*AdmissionRule)(nil),                  // 6: google.cloud.binaryauthorization.v1.AdmissionRule
	(*Attestor)(nil),                       // 7: google.cloud.binaryauthorization.v1.Attestor
	(*UserOwnedGrafeasNote)(nil),           // 8: google.cloud.binaryauthorization.v1.UserOwnedGrafeasNote
	(*PkixPublicKey)(nil),                  // 9: google.cloud.binaryauthorization.v1.PkixPublicKey
	(*AttestorPublicKey)(nil),              // 10: google.cloud.binaryauthorization.v1.AttestorPublicKey
	nil,                                    // 11: google.cloud.binaryauthorization.v1.Policy.ClusterAdmissionRulesEntry
	nil,                                    // 12: google.cloud.binaryauthorization.v1.Policy.KubernetesNamespaceAdmissionRulesEntry
	nil,                                    // 13: google.cloud.binaryauthorization.v1.Policy.KubernetesServiceAccountAdmissionRulesEntry
	nil,                                    // 14: google.cloud.binaryauthorization.v1.Policy.IstioServiceIdentityAdmissionRulesEntry
	(*timestamppb.Timestamp)(nil),          // 15: google.protobuf.Timestamp
}
var file_google_cloud_binaryauthorization_v1_resources_proto_depIdxs = []int32{
	0,  // 0: google.cloud.binaryauthorization.v1.Policy.global_policy_evaluation_mode:type_name -> google.cloud.binaryauthorization.v1.Policy.GlobalPolicyEvaluationMode
	5,  // 1: google.cloud.binaryauthorization.v1.Policy.admission_whitelist_patterns:type_name -> google.cloud.binaryauthorization.v1.AdmissionWhitelistPattern
	11, // 2: google.cloud.binaryauthorization.v1.Policy.cluster_admission_rules:type_name -> google.cloud.binaryauthorization.v1.Policy.ClusterAdmissionRulesEntry
	12, // 3: google.cloud.binaryauthorization.v1.Policy.kubernetes_namespace_admission_rules:type_name -> google.cloud.binaryauthorization.v1.Policy.KubernetesNamespaceAdmissionRulesEntry
	13, // 4: google.cloud.binaryauthorization.v1.Policy.kubernetes_service_account_admission_rules:type_name -> google.cloud.binaryauthorization.v1.Policy.KubernetesServiceAccountAdmissionRulesEntry
	14, // 5: google.cloud.binaryauthorization.v1.Policy.istio_service_identity_admission_rules:type_name -> google.cloud.binaryauthorization.v1.Policy.IstioServiceIdentityAdmissionRulesEntry
	6,  // 6: google.cloud.binaryauthorization.v1.Policy.default_admission_rule:type_name -> google.cloud.binaryauthorization.v1.AdmissionRule
	15, // 7: google.cloud.binaryauthorization.v1.Policy.update_time:type_name -> google.protobuf.Timestamp
	1,  // 8: google.cloud.binaryauthorization.v1.AdmissionRule.evaluation_mode:type_name -> google.cloud.binaryauthorization.v1.AdmissionRule.EvaluationMode
	2,  // 9: google.cloud.binaryauthorization.v1.AdmissionRule.enforcement_mode:type_name -> google.cloud.binaryauthorization.v1.AdmissionRule.EnforcementMode
	8,  // 10: google.cloud.binaryauthorization.v1.Attestor.user_owned_grafeas_note:type_name -> google.cloud.binaryauthorization.v1.UserOwnedGrafeasNote
	15, // 11: google.cloud.binaryauthorization.v1.Attestor.update_time:type_name -> google.protobuf.Timestamp
	10, // 12: google.cloud.binaryauthorization.v1.UserOwnedGrafeasNote.public_keys:type_name -> google.cloud.binaryauthorization.v1.AttestorPublicKey
	3,  // 13: google.cloud.binaryauthorization.v1.PkixPublicKey.signature_algorithm:type_name -> google.cloud.binaryauthorization.v1.PkixPublicKey.SignatureAlgorithm
	9,  // 14: google.cloud.binaryauthorization.v1.AttestorPublicKey.pkix_public_key:type_name -> google.cloud.binaryauthorization.v1.PkixPublicKey
	6,  // 15: google.cloud.binaryauthorization.v1.Policy.ClusterAdmissionRulesEntry.value:type_name -> google.cloud.binaryauthorization.v1.AdmissionRule
	6,  // 16: google.cloud.binaryauthorization.v1.Policy.KubernetesNamespaceAdmissionRulesEntry.value:type_name -> google.cloud.binaryauthorization.v1.AdmissionRule
	6,  // 17: google.cloud.binaryauthorization.v1.Policy.KubernetesServiceAccountAdmissionRulesEntry.value:type_name -> google.cloud.binaryauthorization.v1.AdmissionRule
	6,  // 18: google.cloud.binaryauthorization.v1.Policy.IstioServiceIdentityAdmissionRulesEntry.value:type_name -> google.cloud.binaryauthorization.v1.AdmissionRule
	19, // [19:19] is the sub-list for method output_type
	19, // [19:19] is the sub-list for method input_type
	19, // [19:19] is the sub-list for extension type_name
	19, // [19:19] is the sub-list for extension extendee
	0,  // [0:19] is the sub-list for field type_name
}

func init() { file_google_cloud_binaryauthorization_v1_resources_proto_init() }
func file_google_cloud_binaryauthorization_v1_resources_proto_init() {
	if File_google_cloud_binaryauthorization_v1_resources_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_binaryauthorization_v1_resources_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Policy); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_binaryauthorization_v1_resources_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AdmissionWhitelistPattern); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_binaryauthorization_v1_resources_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AdmissionRule); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_binaryauthorization_v1_resources_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Attestor); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_binaryauthorization_v1_resources_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UserOwnedGrafeasNote); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_binaryauthorization_v1_resources_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PkixPublicKey); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_binaryauthorization_v1_resources_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AttestorPublicKey); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_binaryauthorization_v1_resources_proto_msgTypes[3].OneofWrappers = []interface{}{
		(*Attestor_UserOwnedGrafeasNote)(nil),
	}
	file_google_cloud_binaryauthorization_v1_resources_proto_msgTypes[6].OneofWrappers = []interface{}{
		(*AttestorPublicKey_AsciiArmoredPgpPublicKey)(nil),
		(*AttestorPublicKey_PkixPublicKey)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_binaryauthorization_v1_resources_proto_rawDesc,
			NumEnums:      4,
			NumMessages:   11,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_binaryauthorization_v1_resources_proto_goTypes,
		DependencyIndexes: file_google_cloud_binaryauthorization_v1_resources_proto_depIdxs,
		EnumInfos:         file_google_cloud_binaryauthorization_v1_resources_proto_enumTypes,
		MessageInfos:      file_google_cloud_binaryauthorization_v1_resources_proto_msgTypes,
	}.Build()
	File_google_cloud_binaryauthorization_v1_resources_proto = out.File
	file_google_cloud_binaryauthorization_v1_resources_proto_rawDesc = nil
	file_google_cloud_binaryauthorization_v1_resources_proto_goTypes = nil
	file_google_cloud_binaryauthorization_v1_resources_proto_depIdxs = nil
}
