/*
 * config_window_encoders_handler.cpp
 */
#include <gtk-2.0/gtk/gtkbox.h>
#include <gtk-2.0/gtk/gtkcheckbutton.h>
#include <gtk-2.0/gtk/gtknotebook.h>
#include <gtk-2.0/gtk/gtkscale.h>
#include <gtk-2.0/gtk/gtkstyle.h>
#include <gtk-2.0/gtk/gtktypeutils.h>

#include "config.h"

#ifdef STDC_HEADERS
# include <stdlib.h>
# include <stddef.h>
#else
# ifdef HAVE_STDLIB_H
#  include <stdlib.h>
# endif
#endif

#include <stdbool.h>
#include <math.h>

#ifdef HAVE_STRING_H
# if !defined STDC_HEADERS && defined HAVE_MEMORY_H
#  include <memory.h>
# endif
# include <string.h>
#else
# ifdef HAVE_STRINGS_H
#  include <strings.h>
# endif
#endif

#include <glib.h>
#include <glib/gi18n.h>
#include <gtk/gtk.h>

#include "interface_common.h"
#include "main_window_handler.h"
#include "select_frame_handler.h"
#include "dir_window_handler.h"
#include "misc_utils.h"
#include "config_rw.h"
#include "config_window_encoders_handler.h"

#include "gtk_cpp_workaround.h"

#include <sstream> // for ostringstream
#include <iomanip> // for setw
#include <string>
#include <iostream>
#include <map>
#include <vector>

using std::string;

// Encoders page handlers
int cw_encoder_mp3_handler(int ops, _main_data *main_data, GtkWidget *notebook);
int cw_encoder_flac_handler(int ops, _main_data *main_data, GtkWidget *notebook);
int cw_encoder_ogg_handler(int ops, _main_data *main_data, GtkWidget *notebook);
int cw_encoder_musepack_handler(int ops, _main_data *main_data, GtkWidget *notebook);
int cw_encoder_opus_handler(int ops, _main_data *main_data, GtkWidget *notebook);
int cw_encoder_mp2_handler(int ops, _main_data *main_data, GtkWidget *notebook);

// UI
static GtkWidget *menu, *menu2, *frame, *hbox, *label, *bitrate_menu;


int cw_encoder_mp3_handler(int ops, _main_data *main_data, GtkWidget *notebook)
{
    static GtkWidget *encoder_menu, *vbox_mp3, *vbox_vbr_qual, *vbox_bitrate;
    static GtkWidget *use_mp3_ckbx, *use_vbr_ckbx, *vbr_qual_scale, *use_high_qual_ckbx, *use_crc_ckbx,
        *bitrate_scale, *extra_options_entry;
    static GtkObject *bitrate_adj, *vbr_qual_adj;
    int i, temp;
    EncoderPlugins *encoder_plugins = get_encoder_plugins();

    switch (ops)
    {
        case WIDGET_CREATE :
        {
            vbox_mp3 = gtk_vbox_new(false, VBOX_SPACING);
            gtk_container_set_border_width(GTK_CONTAINER(vbox_mp3), VBOX_BORDER_WIDTH);

            // Enabled
            int has_any_plugin = has_plugin_available(MP3);
            std::string enabled_label = _("Enabled");
            if (!has_any_plugin)
                enabled_label = enabled_label + " (" + _("No encoder available") + ")";

            use_mp3_ckbx = gtk_check_button_new_with_label(enabled_label.c_str());
            gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(use_mp3_ckbx), config.encoder.mp3.enabled && has_any_plugin);
            gtk_widget_set_sensitive(GTK_WIDGET(use_mp3_ckbx), has_any_plugin);
            gtk_box_pack_start(GTK_BOX(vbox_mp3), use_mp3_ckbx, false, false, 3);

            // Plugin selector menu
            //
            label = gtk_label_new(_("Encoder plugin"));
            gtk_box_pack_start(GTK_BOX(vbox_mp3), label, true, true, 0);
            menu = gtk_option_menu_new();
            encoder_menu = gtk_menu_new();

            for (i = 0; i < encoder_plugins_count; i++)
            {
                if (encoder_plugins[i].encoding_type != MP3)
                    continue;
                encoder_plugins[i].menu_item = gtk_menu_item_new_with_label(encoder_plugins[i].description);
                gtk_menu_append(GTK_MENU(encoder_menu), encoder_plugins[i].menu_item);

                if (!is_found(encoder_plugins[i].encoder))
                    gtk_widget_set_sensitive(GTK_WIDGET(encoder_plugins[i].menu_item), 0);
            }

            // Set menu to current plugin
            for (int j = 0, i = 0; i < encoder_plugins_count; i++)
            {
                if (encoder_plugins[i].encoding_type != MP3)
                    continue;
                if (config.encoder.mp3.plugin == encoder_plugins[i].plugin)
                    gtk_menu_set_active(GTK_MENU(encoder_menu), j);
                j++;
            }

            gtk_option_menu_set_menu(GTK_OPTION_MENU(menu), encoder_menu);
            gtk_box_pack_start(GTK_BOX(vbox_mp3), menu, true, true, 0);

            // Bitrate
            //
            frame = gtk_frame_new(_("Bitrate"));
            gtk_box_pack_start(GTK_BOX(vbox_mp3), frame, false, false, 3);

            vbox_bitrate = gtk_vbox_new(false, 0);
            gtk_container_set_border_width(GTK_CONTAINER(vbox_bitrate), VBOX_BORDER_WIDTH);
            gtk_container_add(GTK_CONTAINER(frame), vbox_bitrate);

            bitrate_adj = gtk_adjustment_new(
                    (gint) CLAMP(config.encoder.mp3.bitrate,
                        MIN_MP3_BITRATE, MAX_MP3_BITRATE),
                    (int) MIN_MP3_BITRATE, (int) MAX_MP3_BITRATE, 1, 16, 0);
            bitrate_scale = gtk_hscale_new(GTK_ADJUSTMENT(bitrate_adj));
            gtk_scale_set_digits(GTK_SCALE(bitrate_scale), 0);

            char str_q[5];
            const std::vector bitrate_vec = { 32, 48, 64, 80, 96, 112, 128, 160, 192, 224, 256, 320 };
            for (int x = 0; x < bitrate_vec.size(); x++)
            {
                if (x == 0 || bitrate_vec[x] > 112)
                    sprintf(str_q, "%dk", bitrate_vec[x]);
                else
                    sprintf(str_q, "%d", bitrate_vec[x]);
                gtk_scale_add_mark(GTK_SCALE(bitrate_scale), bitrate_vec[x], GTK_POS_BOTTOM, str_q);
            }
            gtk_box_pack_start(GTK_BOX(vbox_bitrate), bitrate_scale, false, false, 3);

            // VBR
            //
            use_vbr_ckbx = gtk_check_button_new_with_label(_("Use variable bitrate (VBR)"));
            gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(use_vbr_ckbx),
                                         config.encoder.mp3.use_vbr);

            // VBR quality
            frame = gtk_frame_new(NULL);    // "VBR quality (if available)"
            gtk_frame_set_label_widget(GTK_FRAME(frame), use_vbr_ckbx);
            gtk_container_add(GTK_CONTAINER(vbox_mp3), frame);
            vbox_vbr_qual = gtk_vbox_new(false, 3);
            gtk_container_set_border_width(GTK_CONTAINER(vbox_vbr_qual), VBOX_BORDER_WIDTH);
            gtk_container_add(GTK_CONTAINER(frame), vbox_vbr_qual);

            vbr_qual_adj = gtk_adjustment_new(
                    (gfloat) CLAMP(config.encoder.mp3.vbr_quality,
                        MIN_MP3_VBR_QUALITY, MAX_MP3_VBR_QUALITY),
                    (float) MIN_MP3_VBR_QUALITY, (float) MAX_MP3_VBR_QUALITY, 0.1, 1.0, 0.0);
            vbr_qual_scale = gtk_hscale_new(GTK_ADJUSTMENT(vbr_qual_adj));
            gtk_scale_set_digits(GTK_SCALE(vbr_qual_scale), 2);

            for (int x = 0; x < 10; x++)
            {
                sprintf(str_q, "%d", x);
                gtk_scale_add_mark(GTK_SCALE(vbr_qual_scale), x, GTK_POS_BOTTOM, str_q);
            }
            gtk_scale_add_mark(GTK_SCALE(vbr_qual_scale), 9.99, GTK_POS_BOTTOM, "9.99");

            gtk_container_add(GTK_CONTAINER(vbox_vbr_qual), vbr_qual_scale);
            label = gtk_label_new(_("0=high quality and bigger files, 9.99=smaller files"));
            gtk_container_add(GTK_CONTAINER(vbox_vbr_qual), label);

            // High Quality
            //
            use_high_qual_ckbx = gtk_check_button_new_with_label(_("High quality mode"));
            gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(use_high_qual_ckbx), config.encoder.mp3.use_high_quality);
            gtk_container_add(GTK_CONTAINER(vbox_mp3), use_high_qual_ckbx);

            // CRC
            //
            use_crc_ckbx = gtk_check_button_new_with_label(_("Include CRC error protection"));
            gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(use_crc_ckbx), config.encoder.mp3.use_crc);
            gtk_container_add(GTK_CONTAINER(vbox_mp3), use_crc_ckbx);

            // MP3 Extra options
            //
            hbox = gtk_hbox_new(false, 0);
            gtk_box_pack_start(GTK_BOX(vbox_mp3), hbox, true, true, 0);

            label = gtk_label_new(_("Extra Options: "));
            gtk_box_pack_start(GTK_BOX(hbox), label, false, false, 0);

            extra_options_entry = gtk_entry_new_with_max_length(MAX_OPTIONS_LENGTH - 20);
            gtk_entry_set_text(GTK_ENTRY(extra_options_entry), config.encoder.mp3.extra_options.c_str());
            gtk_box_pack_start(GTK_BOX(hbox), extra_options_entry, true, true, 0);

            // Tab - End of encoder
            std::ostringstream tmp_label;
            tmp_label << "MP3\n(" << _("Lossy") << ")";
            label = gtk_label_new(tmp_label.str().c_str());
            gtk_notebook_append_page_menu(GTK_NOTEBOOK(notebook), vbox_mp3, label, label);

            return 0;
        }

       case OP_OK :
       {
            int cur_plugin, br;
            GtkWidget *item;

            // Encoder plugin
            item = gtk_menu_get_active(GTK_MENU(encoder_menu));
            cur_plugin = 0;
            for (i = 0; i < encoder_plugins_count; i++)
                if (item == encoder_plugins[i].menu_item)
                {
                    cur_plugin = i;
                    break;
                }

            if (cur_plugin == 0)
            {
                config.encoder.mp3.enabled = 0;
                config.encoder.mp3.encoder = "";
                config.encoder.mp3.plugin = "";
            }
            else
            {
                config.encoder.mp3.enabled = (GTK_TOGGLE_BUTTON(use_mp3_ckbx)->active) ? 1 : 0;
                config.encoder.mp3.encoder = encoder_plugins[cur_plugin].encoder;
                config.encoder.mp3.plugin = encoder_plugins[cur_plugin].plugin;
                //config.encoder.mp3.type = encoder_plugins[cur_plugin].encoding_type;
            }

            // Bitrate
            config.encoder.mp3.bitrate = CLAMP((int) GTK_ADJUSTMENT(bitrate_adj)->value, MIN_MP3_BITRATE, MAX_MP3_BITRATE);

            // Other values
            config.encoder.mp3.use_vbr = (GTK_TOGGLE_BUTTON(use_vbr_ckbx)->active) ? 1 : 0;
            config.encoder.mp3.vbr_quality = CLAMP((float) GTK_ADJUSTMENT(vbr_qual_adj)->value,
                    MIN_MP3_VBR_QUALITY, MAX_MP3_VBR_QUALITY);
            config.encoder.mp3.use_high_quality = (GTK_TOGGLE_BUTTON(use_high_qual_ckbx)->active) ? 1 : 0;
            config.encoder.mp3.use_crc = (GTK_TOGGLE_BUTTON(use_crc_ckbx)->active) ? 1 : 0;
            config.encoder.mp3.extra_options = gtk_entry_get_text(GTK_ENTRY(extra_options_entry));

            // Adjust MP3 config values
            std::ostringstream tmp;

            br = config.encoder.mp3.bitrate;
            tmp << config.encoder.mp3.encoder;

            if (config.encoder.mp3.encoder == "l3enc")
            {
                // Bitrate
                if (br == 160) br = 128;
                if (br == 320) br = 256;
                br *= 1000;
                tmp << " " << encoder_plugins[cur_plugin].bitrate_op << br;
            }
            else if (config.encoder.mp3.encoder ==  "mp3enc")
            {
                // Bitrate
                br *= 1000;
                tmp << " " << encoder_plugins[cur_plugin].bitrate_op << br;
            }
            else if (config.encoder.mp3.encoder == "xingmp3enc")
            {
                // Bitrate or VBR
                if(config.encoder.mp3.use_vbr)
                {
                    std::map<int, int> vbr_map =
                    {
                        {112, 30}, {128, 50}, {160, 75}, {192, 100}, {256, 125}, {320, 150}
                    };
                    br = (vbr_map.find(br) == vbr_map.end()) ? 1 : vbr_map[br];
                    tmp << " " << encoder_plugins[cur_plugin].vbr_qual_op << " " << br;
                }
                else
                    tmp << " " << encoder_plugins[cur_plugin].bitrate_op << br;
            } // xingmp3enc
            else
            {
                // Bitrate and VBR
                tmp << " " << encoder_plugins[cur_plugin].bitrate_op << " " << br;
                if (config.encoder.mp3.use_vbr && strlen(encoder_plugins[cur_plugin].vbr_qual_op))
                    tmp << " " << encoder_plugins[cur_plugin].vbr_qual_op << " " << config.encoder.mp3.vbr_quality;
            }

            // Use VBR (no hist and vbr new!)
            if (config.encoder.mp3.use_vbr && strlen(encoder_plugins[cur_plugin].user_vbr_op))
                tmp << " " << encoder_plugins[cur_plugin].user_vbr_op;

            if (config.encoder.mp3.use_high_quality && strlen(encoder_plugins[cur_plugin].high_qual_op))
                tmp << " " << encoder_plugins[cur_plugin].high_qual_op;
            if (config.encoder.mp3.use_crc && strlen(encoder_plugins[cur_plugin].crc_op))
                tmp << " " << encoder_plugins[cur_plugin].crc_op;

            if (!config.encoder.mp3.extra_options.empty())
                tmp << " " << config.encoder.mp3.extra_options;

            config.encoder.mp3.full_command = tmp.str();

            return 0;
       }

       default: break;
    }
    return -1;
}

int cw_encoder_flac_handler(int ops, _main_data *main_data, GtkWidget *notebook)
{
    static GtkWidget *vbox_flac, *vbox_compress;
    static GtkWidget *use_flac_ckbx, *compress_scale, *flac_extra_options_entry;
    static GtkObject *compress_adj;

    switch (ops)
    {
        case WIDGET_CREATE :
        {
            vbox_flac = gtk_vbox_new(false, VBOX_SPACING);
            gtk_container_set_border_width(GTK_CONTAINER(vbox_flac), VBOX_BORDER_WIDTH);

            // Enabled
            int has_any_plugin = has_plugin_available(FLAC);
            std::string enabled_label = _("Enabled");
            if (!has_any_plugin)
                enabled_label = enabled_label + " (" + _("No encoder available") + ")";

            use_flac_ckbx = gtk_check_button_new_with_label(enabled_label.c_str());
            gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(use_flac_ckbx), config.encoder.flac.enabled && has_any_plugin);
            gtk_widget_set_sensitive(GTK_WIDGET(use_flac_ckbx), has_any_plugin);
            gtk_box_pack_start(GTK_BOX(vbox_flac), use_flac_ckbx, false, false, 3);

            // Compression level
            //
            frame = gtk_frame_new(_("Compress Level"));
            gtk_box_pack_start(GTK_BOX(vbox_flac), frame, false, false, 3);

            vbox_compress = gtk_vbox_new(false, 0);
            gtk_container_set_border_width(GTK_CONTAINER(vbox_compress), VBOX_BORDER_WIDTH);
            gtk_container_add(GTK_CONTAINER(frame), vbox_compress);

            compress_adj = gtk_adjustment_new((gfloat) CLAMP(config.encoder.flac.compression_level,
                    MIN_FLAC_COMPRESSION_LEVEL, MAX_FLAC_COMPRESSION_LEVEL),
                    (float) MIN_FLAC_COMPRESSION_LEVEL, (float) MAX_FLAC_COMPRESSION_LEVEL, 1.0, 1.0, 0.0);
            compress_scale = gtk_hscale_new(GTK_ADJUSTMENT(compress_adj));
            gtk_scale_set_digits(GTK_SCALE(compress_scale), 0);

            char str_q[9];
            for (int x = 0; x < 9; x++)
            {
                sprintf(str_q, "%d", x);
                gtk_scale_add_mark(GTK_SCALE(compress_scale), x, GTK_POS_BOTTOM, str_q);
            }
            gtk_box_pack_start(GTK_BOX(vbox_compress), compress_scale, false, false, 3);

            label = gtk_label_new(_("0=fastest compression (--fast), 8=highest compression (--best)"));
            gtk_box_pack_start(GTK_BOX(vbox_compress), label, false, false, 3);

            // FLAC Extra options
            //
            hbox = gtk_hbox_new(false, 0);
            gtk_box_pack_start(GTK_BOX(vbox_flac), hbox, false, false, 3);

            label = gtk_label_new(_("Extra Options: "));
            gtk_box_pack_start(GTK_BOX(hbox), label, false, false, 3);

            flac_extra_options_entry = gtk_entry_new_with_max_length(MAX_OPTIONS_LENGTH - 20);
            gtk_entry_set_text(GTK_ENTRY(flac_extra_options_entry), config.encoder.flac.extra_options.c_str());
            gtk_box_pack_start(GTK_BOX(hbox), flac_extra_options_entry, true, true, 0);

            // Tab - End of encoder
            std::ostringstream tmp_label;
            tmp_label << "FLAC\n(" << _("Lossless") << ")";
            label = gtk_label_new(tmp_label.str().c_str());
            gtk_notebook_append_page_menu(GTK_NOTEBOOK(notebook), vbox_flac, label, label);
            return 0;
        }

        case OP_OK :
        {
            std::ostringstream tmp;

            // Will get the defaults for values w/o config: Encoder, Type and Plugin
            config.encoder.flac.enabled = (GTK_TOGGLE_BUTTON(use_flac_ckbx)->active) ? 1 : 0;
            config.encoder.flac.compression_level = CLAMP((int) GTK_ADJUSTMENT(compress_adj)->value,
                MIN_FLAC_COMPRESSION_LEVEL, MAX_FLAC_COMPRESSION_LEVEL);
            config.encoder.flac.extra_options = gtk_entry_get_text(GTK_ENTRY(flac_extra_options_entry));

            // Full command
            tmp.str("");
            tmp << config.encoder.flac.encoder  << " -" << config.encoder.flac.compression_level;
            tmp << " " << config.encoder.flac.extra_options;
            config.encoder.flac.full_command = tmp.str();

            return 0;
        }

        default: break;
    }
    return -1;
}

int cw_encoder_ogg_handler(int ops, _main_data *main_data, GtkWidget *notebook)
{
    static GtkWidget *vbox_ogg, *vbox_quality;
    static GtkWidget *use_ogg_ckbx, *quality_scale, *ogg_extra_options_entry;
    static GtkObject *quality_adj, *bitrate_adj;
    static GtkWidget *vbox_bitrate, *bitrate_scale, *group, *quality_mode_rbtn, *bitrate_mode_rbtn = NULL,
        *quality_frame;

    switch (ops)
    {
        case WIDGET_CREATE :
        {
            vbox_ogg = gtk_vbox_new(false, VBOX_SPACING);
            gtk_container_set_border_width(GTK_CONTAINER(vbox_ogg), VBOX_BORDER_WIDTH);

            // Enabled
            int has_any_plugin = has_plugin_available(OGG);
            std::string enabled_label = _("Enabled");
            if (!has_any_plugin)
                enabled_label = enabled_label + " (" + _("No encoder available") + ")";

            use_ogg_ckbx = gtk_check_button_new_with_label(enabled_label.c_str());
            gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(use_ogg_ckbx), config.encoder.ogg.enabled && has_any_plugin);
            gtk_widget_set_sensitive(GTK_WIDGET(use_ogg_ckbx), has_any_plugin);
            gtk_box_pack_start(GTK_BOX(vbox_ogg), use_ogg_ckbx, false, false, 3);

            // Select bitrate or quality
            // Quality (VBR)
            //
            string title = string(_("Quality Mode")) + " (VBR)";
            quality_mode_rbtn = gtk_radio_button_new_with_label(NULL, title.c_str());
            gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(quality_mode_rbtn), 0);

            quality_frame = gtk_frame_new(NULL);
            gtk_frame_set_label_widget(GTK_FRAME(quality_frame), quality_mode_rbtn);
            gtk_box_pack_start(GTK_BOX(vbox_ogg), quality_frame, false, false, 3);

            vbox_quality = gtk_vbox_new(false, 0);
            gtk_container_set_border_width(GTK_CONTAINER(vbox_quality), VBOX_BORDER_WIDTH);
            gtk_container_add(GTK_CONTAINER(quality_frame), vbox_quality);

            quality_adj = gtk_adjustment_new((gfloat) CLAMP(config.encoder.ogg.vbr_quality,
                    MIN_OGG_VBR_QUALITY, MAX_OGG_VBR_QUALITY),
                    (float) MIN_OGG_VBR_QUALITY, (float) MAX_OGG_VBR_QUALITY, 0.1, 1.0, 0.0);
            quality_scale = gtk_hscale_new(GTK_ADJUSTMENT(quality_adj));
            gtk_scale_set_digits(GTK_SCALE(quality_scale), 1);

            char str_q[12];
            for (int x = -1; x < 11; x++)
            {
                sprintf(str_q, "%d", x);
                gtk_scale_add_mark(GTK_SCALE(quality_scale), x, GTK_POS_BOTTOM, str_q);
            }
            gtk_box_pack_start(GTK_BOX(vbox_quality), quality_scale, false, false, 3);

            label = gtk_label_new(_("-1.0=very low (faster), 10.0=very high (slower)"));
            gtk_box_pack_start(GTK_BOX(vbox_quality), label, false, false, 3);

            // Bitrate - add min_bitrate, max_bitrate (VBR), --managed ?
            bitrate_mode_rbtn = gtk_radio_button_new_with_label(
                gtk_radio_button_group(GTK_RADIO_BUTTON(quality_mode_rbtn)), _("Bitrate Mode"));
            gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(bitrate_mode_rbtn), 1);

            frame = gtk_frame_new(NULL);
            gtk_frame_set_label_widget(GTK_FRAME(frame), bitrate_mode_rbtn);
            gtk_box_pack_start(GTK_BOX(vbox_ogg), frame, false, false, 3);

            vbox_bitrate = gtk_vbox_new(false, 3);
            gtk_container_set_border_width(GTK_CONTAINER(vbox_bitrate), VBOX_BORDER_WIDTH);
            gtk_container_add(GTK_CONTAINER(frame), vbox_bitrate);

            bitrate_adj = gtk_adjustment_new(
                    (gint) CLAMP(config.encoder.ogg.bitrate,
                        MIN_OGG_BITRATE, MAX_OGG_BITRATE),
                    (float) MIN_OGG_BITRATE, (float) MAX_OGG_BITRATE, 1, 16, 0);
            bitrate_scale = gtk_hscale_new(GTK_ADJUSTMENT(bitrate_adj));
            gtk_scale_set_digits(GTK_SCALE(bitrate_scale), 0);
            gtk_scale_add_mark(GTK_SCALE(bitrate_scale), 48, GTK_POS_BOTTOM, "48k");
            gtk_scale_add_mark(GTK_SCALE(bitrate_scale), 64, GTK_POS_BOTTOM, "64");
            gtk_scale_add_mark(GTK_SCALE(bitrate_scale), 96, GTK_POS_BOTTOM, "96");
            gtk_scale_add_mark(GTK_SCALE(bitrate_scale), 128, GTK_POS_BOTTOM, "128");
            gtk_scale_add_mark(GTK_SCALE(bitrate_scale), 160, GTK_POS_BOTTOM, "160");
            gtk_scale_add_mark(GTK_SCALE(bitrate_scale), 192, GTK_POS_BOTTOM, "192");
            gtk_scale_add_mark(GTK_SCALE(bitrate_scale), 224, GTK_POS_BOTTOM, "224");
            gtk_scale_add_mark(GTK_SCALE(bitrate_scale), 256, GTK_POS_BOTTOM, "256k");
            gtk_scale_add_mark(GTK_SCALE(bitrate_scale), 320, GTK_POS_BOTTOM, "320k");
            gtk_scale_add_mark(GTK_SCALE(bitrate_scale), 384, GTK_POS_BOTTOM, "384k");
            gtk_scale_add_mark(GTK_SCALE(bitrate_scale), 512, GTK_POS_BOTTOM, "512k");
            gtk_container_add(GTK_CONTAINER(vbox_bitrate), bitrate_scale);

            gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(quality_mode_rbtn), config.encoder.ogg.use_quality);

            // OGG Extra options
            //
            hbox = gtk_hbox_new(false, 0);
            gtk_box_pack_start(GTK_BOX(vbox_ogg), hbox, false, false, 0);

            label = gtk_label_new(_("Extra Options: "));
            gtk_box_pack_start(GTK_BOX(hbox), label, false, false, 0);

            ogg_extra_options_entry = gtk_entry_new_with_max_length(MAX_OPTIONS_LENGTH - 20);
            gtk_entry_set_text(GTK_ENTRY(ogg_extra_options_entry), config.encoder.ogg.extra_options.c_str());

            gtk_box_pack_start(GTK_BOX(hbox), ogg_extra_options_entry, true, true, 0);

            // Tab - End of encoder
            std::ostringstream tmp_label;
            tmp_label << "OGG\n(" << _("Lossy") << ")";
            label = gtk_label_new(tmp_label.str().c_str());
            gtk_notebook_append_page_menu(GTK_NOTEBOOK(notebook), vbox_ogg, label, label);
            return 0;
        }

        case OP_OK :
        {
            std::ostringstream tmp;
            int cur_plugin;
            EncoderPlugins *encoder_plugins = get_encoder_plugins();

            cur_plugin = 0;
            for (int i = 0; i < encoder_plugins_count; i++)
                if (encoder_plugins[i].encoder == config.encoder.ogg.encoder)
                    cur_plugin = i;

            if (cur_plugin == 0)
            {
                config.encoder.ogg.enabled = 0;
                config.encoder.ogg.encoder = "";
                config.encoder.ogg.plugin = "";
            }
            else
            {
                config.encoder.ogg.enabled = (GTK_TOGGLE_BUTTON(use_ogg_ckbx)->active) ? 1 : 0;
                config.encoder.ogg.encoder = encoder_plugins[cur_plugin].encoder;
                config.encoder.ogg.plugin = encoder_plugins[cur_plugin].plugin;
            }

            config.encoder.ogg.use_quality = GTK_TOGGLE_BUTTON(quality_mode_rbtn)->active;
            config.encoder.ogg.vbr_quality = CLAMP(
                (float) GTK_ADJUSTMENT(quality_adj)->value, MIN_OGG_VBR_QUALITY, MAX_OGG_VBR_QUALITY);
            config.encoder.ogg.bitrate = CLAMP(
                (float) GTK_ADJUSTMENT(bitrate_adj)->value, MIN_OGG_BITRATE, MAX_OGG_BITRATE);

            config.encoder.ogg.extra_options = gtk_entry_get_text(GTK_ENTRY(ogg_extra_options_entry));

            // Full command
            tmp.str("");
            tmp << config.encoder.ogg.encoder;
            if (config.encoder.ogg.use_quality)
                tmp << " " << encoder_plugins[cur_plugin].vbr_qual_op << " " << config.encoder.ogg.vbr_quality;
            else
                tmp << " " << encoder_plugins[cur_plugin].bitrate_op << " " << config.encoder.ogg.bitrate;
            tmp << " " << config.encoder.ogg.extra_options;
            config.encoder.ogg.full_command = tmp.str();

            return 0;
        }

        default: break;
    }
    return -1;
}

int cw_encoder_musepack_handler(int ops, _main_data *main_data, GtkWidget *notebook)
{
    static GtkWidget *encoder_menu, *vbox_musepack, *vbox_mpp_vbr_qual;
    static GtkWidget *use_musepack_ckbx,*mpp_use_vbr_ckbx, *mpp_vbr_qual_scale, *mpp_extra_options_entry;
    static GtkObject *mpp_vbr_qual_adj;
    int i;
    EncoderPlugins *encoder_plugins = get_encoder_plugins();

    switch (ops)
    {
        case WIDGET_CREATE :
        {
            vbox_musepack = gtk_vbox_new(false, VBOX_SPACING);
            gtk_container_set_border_width(GTK_CONTAINER(vbox_musepack), VBOX_BORDER_WIDTH);

            // Enabled
            int has_any_plugin = has_plugin_available(MUSE);
            std::string enabled_label = _("Enabled");
            if (!has_any_plugin)
                enabled_label = enabled_label + " (" + _("No encoder available") + ")";

            use_musepack_ckbx = gtk_check_button_new_with_label(enabled_label.c_str());
            gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(use_musepack_ckbx), config.encoder.musepack.enabled && has_any_plugin);
            gtk_widget_set_sensitive(GTK_WIDGET(use_musepack_ckbx), has_any_plugin);
            gtk_box_pack_start(GTK_BOX(vbox_musepack), use_musepack_ckbx, false, false, 3);

            // Plugin selector menu
            //
            label = gtk_label_new(_("Encoder plugin"));
            gtk_box_pack_start(GTK_BOX(vbox_musepack), label, false, false, 3);
            menu = gtk_option_menu_new();
            encoder_menu = gtk_menu_new();

            // Build plugin menu
            for (i = 0; i < encoder_plugins_count; i++)
            {
                if (encoder_plugins[i].encoding_type != MUSE)
                    continue;
                encoder_plugins[i].menu_item = gtk_menu_item_new_with_label(encoder_plugins[i].description);
                gtk_menu_append(GTK_MENU(encoder_menu), encoder_plugins[i].menu_item);
                if (!encoder_plugins[i].available)
                    gtk_widget_set_sensitive(GTK_WIDGET(encoder_plugins[i].menu_item), 0);
            }

            // Set menu to current plugin
            for (int j = 0, i = 0; i < encoder_plugins_count; i++)
            {
                if (encoder_plugins[i].encoding_type != MUSE)
                    continue;
                if (config.encoder.musepack.plugin == encoder_plugins[i].plugin)
                    gtk_menu_set_active(GTK_MENU(encoder_menu), j);
                j++;
            }

            gtk_option_menu_set_menu(GTK_OPTION_MENU(menu), encoder_menu);
            gtk_box_pack_start(GTK_BOX(vbox_musepack), menu, false, false, 0);

            // VBR
            //
            mpp_use_vbr_ckbx = gtk_check_button_new_with_label(_("Use variable bitrate (VBR)"));
            gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(mpp_use_vbr_ckbx), 1);  //config.encoder.musepack.use_vbr
            gtk_widget_set_sensitive(GTK_WIDGET(mpp_use_vbr_ckbx), 0);

            // VBR quality
            frame = gtk_frame_new(NULL);    // "VBR quality (if available)"
            gtk_frame_set_label_widget(GTK_FRAME(frame), mpp_use_vbr_ckbx);
            gtk_box_pack_start(GTK_BOX(vbox_musepack), frame, false, false, 3);

            vbox_mpp_vbr_qual = gtk_vbox_new(false, 3);
            gtk_container_set_border_width(GTK_CONTAINER(vbox_mpp_vbr_qual), VBOX_BORDER_WIDTH);
            gtk_container_add(GTK_CONTAINER(frame), vbox_mpp_vbr_qual);

            mpp_vbr_qual_adj = gtk_adjustment_new((gfloat) CLAMP(config.encoder.musepack.vbr_quality,
                    MIN_MUSEPACK_VBR_QUALITY, MAX_MUSEPACK_VBR_QUALITY),
                    (float) MIN_MUSEPACK_VBR_QUALITY, (float) MAX_MUSEPACK_VBR_QUALITY, 0.1, 1.0, 0.0);
            mpp_vbr_qual_scale = gtk_hscale_new(GTK_ADJUSTMENT(mpp_vbr_qual_adj));
            gtk_scale_set_digits(GTK_SCALE(mpp_vbr_qual_scale), 2);

            char str_q[11];
            for (int x = 0; x < 11; x++)
            {
                sprintf(str_q, "%d", x);
                gtk_scale_add_mark(GTK_SCALE(mpp_vbr_qual_scale), x, GTK_POS_BOTTOM, str_q);
            }
            gtk_container_add(GTK_CONTAINER(vbox_mpp_vbr_qual), mpp_vbr_qual_scale);
            label = gtk_label_new(_("0=poor quality,\n5=high quality: standard,\n8=excellent quality: braindead,\n10=excellent quality: above braindead"));
            gtk_container_add(GTK_CONTAINER(vbox_mpp_vbr_qual), label);

            // Musepack Extra options
            //
            hbox = gtk_hbox_new(false, 0);
            gtk_box_pack_start(GTK_BOX(vbox_musepack), hbox, false, false, 3);

            label = gtk_label_new(_("Extra Options: "));
            gtk_box_pack_start(GTK_BOX(hbox), label, false, false, 3);

            mpp_extra_options_entry = gtk_entry_new_with_max_length(MAX_OPTIONS_LENGTH - 20);
            gtk_entry_set_text(GTK_ENTRY(mpp_extra_options_entry), config.encoder.musepack.extra_options.c_str());
            gtk_box_pack_start(GTK_BOX(hbox), mpp_extra_options_entry, true, true, 0);

            // Tab - End of encoder
            std::ostringstream tmp_label;
            tmp_label << "Musepack\n(" << _("Lossy") << ")";
            label = gtk_label_new(tmp_label.str().c_str());
            gtk_notebook_append_page_menu(GTK_NOTEBOOK(notebook), vbox_musepack, label, label);
            return 0;
        }

        case OP_OK :
        {
            int cur_plugin = 0;
            std::ostringstream tmp;
            GtkWidget *item;

            // Plugin
            item = gtk_menu_get_active(GTK_MENU(encoder_menu));
            cur_plugin = 0;
            for (i = 0; i < encoder_plugins_count; i++)
                if (item == encoder_plugins[i].menu_item)
                {
                    cur_plugin = i;
                    break;
                }

            if (cur_plugin == 0)
            {
                config.encoder.musepack.enabled = 0;
                config.encoder.musepack.encoder = "";
                config.encoder.musepack.plugin = "";
            }
            else
            {
                config.encoder.musepack.enabled = (GTK_TOGGLE_BUTTON(use_musepack_ckbx)->active) ? 1 : 0;
                config.encoder.musepack.encoder = encoder_plugins[cur_plugin].encoder;
                config.encoder.musepack.plugin = encoder_plugins[cur_plugin].plugin;
            }

            // Others
            config.encoder.musepack.vbr_quality = CLAMP((float) GTK_ADJUSTMENT(mpp_vbr_qual_adj)->value,
                    MIN_MUSEPACK_VBR_QUALITY, MAX_MUSEPACK_VBR_QUALITY);
            config.encoder.musepack.extra_options = gtk_entry_get_text(GTK_ENTRY(mpp_extra_options_entry));

            //if (config.encoder.musepack.encoder == "mppenc")      // or mpcenc - TODO: Add plugin? and selection
            {
                tmp.str("");
                tmp << config.encoder.musepack.encoder << " --overwrite "
                        << encoder_plugins[cur_plugin].vbr_qual_op << " " << config.encoder.musepack.vbr_quality;
                tmp << " " << config.encoder.musepack.extra_options;
                config.encoder.musepack.full_command = tmp.str();
            }
            return 0;
        }

        default: break;
    }
    return -1;
}

int cw_encoder_opus_handler(int ops, _main_data *main_data, GtkWidget *notebook)
{
    static GtkWidget *vbox_opus, *vbox_bitrate;
    static GtkWidget *use_opus_ckbx, *opus_extra_options_entry;
    static GtkWidget *bitrate_scale;
    static GtkObject *bitrate_adj;

    switch (ops)
    {
        case WIDGET_CREATE :
        {
            vbox_opus = gtk_vbox_new(false, VBOX_SPACING);
            gtk_container_set_border_width(GTK_CONTAINER(vbox_opus), VBOX_BORDER_WIDTH);

            // Enabled
            int has_any_plugin = has_plugin_available(OPUS);
            std::string enabled_label = _("Enabled");
            if (!has_any_plugin)
                enabled_label = enabled_label + " (" + _("No encoder available") + ")";

            use_opus_ckbx = gtk_check_button_new_with_label(_("Enabled"));
            gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(use_opus_ckbx), config.encoder.opus.enabled && has_any_plugin);
            gtk_widget_set_sensitive(GTK_WIDGET(use_opus_ckbx), has_any_plugin);
            gtk_box_pack_start(GTK_BOX(vbox_opus), use_opus_ckbx, false, false, 3);

            // Bitrate
            frame = gtk_frame_new(_("Bitrate"));
            gtk_box_pack_start(GTK_BOX(vbox_opus), frame, false, false, 3);

            vbox_bitrate = gtk_vbox_new(false, 0);
            gtk_container_set_border_width(GTK_CONTAINER(vbox_bitrate), VBOX_BORDER_WIDTH);
            gtk_container_add(GTK_CONTAINER(frame), vbox_bitrate);

            bitrate_adj = gtk_adjustment_new(
                    (gint) CLAMP(config.encoder.opus.bitrate,
                        MIN_OPUS_BITRATE, MAX_OPUS_BITRATE),
                    (float) MIN_OPUS_BITRATE, (float) MAX_OPUS_BITRATE, 1, 16, 0);
            bitrate_scale = gtk_hscale_new(GTK_ADJUSTMENT(bitrate_adj));
            gtk_scale_set_digits(GTK_SCALE(bitrate_scale), 0);

            char str_q[5];
            const std::vector bitrate_vec = { 16, 32, 48, 64, 80, 96, 112, 128, 160, 192, 224, 256, };
            for (int x = 0; x < bitrate_vec.size(); x++)
            {
                sprintf(str_q, "%dk", bitrate_vec[x]);
                gtk_scale_add_mark(GTK_SCALE(bitrate_scale), bitrate_vec[x], GTK_POS_BOTTOM, str_q);
            }
            gtk_box_pack_start(GTK_BOX(vbox_bitrate), bitrate_scale, false, false, 3);

            // Opus Extra options
            //
            hbox = gtk_hbox_new(false, 0);
            gtk_box_pack_start(GTK_BOX(vbox_opus), hbox, false, false, 3);

            label = gtk_label_new(_("Extra Options: "));
            gtk_box_pack_start(GTK_BOX(hbox), label, false, false, 3);

            opus_extra_options_entry = gtk_entry_new_with_max_length(MAX_OPTIONS_LENGTH - 20);
            gtk_entry_set_text(GTK_ENTRY(opus_extra_options_entry), config.encoder.opus.extra_options.c_str());
            gtk_box_pack_start(GTK_BOX(hbox), opus_extra_options_entry, true, true, 0);

            // Tab - End of encoder
            std::ostringstream tmp_label;
            tmp_label << "Opus\n(" << _("Lossy") << ")";
            label = gtk_label_new(tmp_label.str().c_str());
            gtk_notebook_append_page_menu(GTK_NOTEBOOK(notebook), vbox_opus, label, label);
            return 0;
        }

        case OP_OK :
        {
            int i, cur_plugin = 0;
            std::ostringstream tmp;
            EncoderPlugins *encoder_plugins = get_encoder_plugins();

            for (i = 0; i < encoder_plugins_count; i++)
                if (encoder_plugins[i].encoding_type == OPUS)      // Only 1 plugin - opusenc
                {
                    cur_plugin = i;
                    break;
                }

            config.encoder.opus.enabled = (GTK_TOGGLE_BUTTON(use_opus_ckbx)->active) ? 1 : 0;
            config.encoder.opus.bitrate = CLAMP((int) GTK_ADJUSTMENT(bitrate_adj)->value, MIN_OPUS_BITRATE, MAX_OPUS_BITRATE);
            config.encoder.opus.extra_options = gtk_entry_get_text(GTK_ENTRY(opus_extra_options_entry));

            // Full command
            tmp.str("");
            tmp << config.encoder.opus.encoder;
            tmp << " " << encoder_plugins[cur_plugin].bitrate_op << " " << config.encoder.opus.bitrate;
            tmp << " " << config.encoder.opus.extra_options;
            config.encoder.opus.full_command = tmp.str();

            return 0;
        }
        default: break;
    }
    return -1;
}

int cw_encoder_mp2_handler(int ops, _main_data *main_data, GtkWidget *notebook)
{
    static GtkWidget *vbox_mp2, *encoder_menu, *vbox_vbr_qual, *vbox_bitrate;
    static GtkWidget *use_mp2_ckbx, *use_vbr_ckbx, *vbr_qual_scale, *use_crc_ckbx,
        *bitrate_scale, *extra_options_entry;
    static GtkObject *bitrate_adj, *vbr_qual_adj;
    int i;

    EncoderPlugins *encoder_plugins = get_encoder_plugins();

    switch (ops)
    {
        case WIDGET_CREATE :
        {
            vbox_mp2 = gtk_vbox_new(false, VBOX_SPACING);
            gtk_container_set_border_width(GTK_CONTAINER(vbox_mp2), VBOX_BORDER_WIDTH);

            // Enabled
            int has_any_plugin = has_plugin_available(MP2);
            std::string enabled_label = _("Enabled");
            if (!has_any_plugin)
                enabled_label = enabled_label + " (" + _("No encoder available") + ")";

            use_mp2_ckbx = gtk_check_button_new_with_label(_("Enabled"));
            gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(use_mp2_ckbx), config.encoder.mp2.enabled && has_any_plugin);
            gtk_widget_set_sensitive(GTK_WIDGET(use_mp2_ckbx), has_any_plugin);
            gtk_box_pack_start(GTK_BOX(vbox_mp2), use_mp2_ckbx, false, false, 3);

            // Plugin selector menu
            //
            label = gtk_label_new(_("Encoder plugin"));
            gtk_box_pack_start(GTK_BOX(vbox_mp2), label, false, false, 3);
            menu = gtk_option_menu_new();
            encoder_menu = gtk_menu_new();

            // Build plugin menu
            for (i = 0; i < encoder_plugins_count; i++)
            {
                if (encoder_plugins[i].encoding_type != MP2)
                    continue;
                encoder_plugins[i].menu_item = gtk_menu_item_new_with_label(encoder_plugins[i].description);
                gtk_menu_append(GTK_MENU(encoder_menu), encoder_plugins[i].menu_item);
                if (!encoder_plugins[i].available)
                    gtk_widget_set_sensitive(GTK_WIDGET(encoder_plugins[i].menu_item), 0);
            }

            // Set menu to current plugin
            for (int j = 0, i = 0; i < encoder_plugins_count; i++)
            {
                if (encoder_plugins[i].encoding_type != MP2)
                    continue;
                if (config.encoder.mp2.plugin == encoder_plugins[i].plugin)
                    gtk_menu_set_active(GTK_MENU(encoder_menu), j);
                j++;
            }

            gtk_option_menu_set_menu(GTK_OPTION_MENU(menu), encoder_menu);
            gtk_box_pack_start(GTK_BOX(vbox_mp2), menu, false, false, 0);

            // Bitrate
            //
            frame = gtk_frame_new(_("Bitrate"));
            gtk_box_pack_start(GTK_BOX(vbox_mp2), frame, false, false, 3);

            vbox_bitrate = gtk_vbox_new(false, 0);
            gtk_container_set_border_width(GTK_CONTAINER(vbox_bitrate), VBOX_BORDER_WIDTH);
            gtk_container_add(GTK_CONTAINER(frame), vbox_bitrate);

            bitrate_adj = gtk_adjustment_new(
                    (gint) CLAMP(config.encoder.mp2.bitrate,
                        MIN_MP2_BITRATE, MAX_MP2_BITRATE),
                    (int) MIN_MP2_BITRATE, (int) MAX_MP2_BITRATE, 1, 16, 0);
            bitrate_scale = gtk_hscale_new(GTK_ADJUSTMENT(bitrate_adj));
            gtk_scale_set_digits(GTK_SCALE(bitrate_scale), 0);

            char str_q[5];
            const std::vector bitrate_vec = { 32, 48, 64, 80, 96, 112, 128, 160, 192, 224, 256, 320 };
            for (int x = 0; x < bitrate_vec.size(); x++)
            {
                if (x == 0 || bitrate_vec[x] > 112)
                    sprintf(str_q, "%dk", bitrate_vec[x]);
                else
                    sprintf(str_q, "%d", bitrate_vec[x]);
                gtk_scale_add_mark(GTK_SCALE(bitrate_scale), bitrate_vec[x], GTK_POS_BOTTOM, str_q);
            }
            gtk_box_pack_start(GTK_BOX(vbox_bitrate), bitrate_scale, false, false, 3);

            // VBR
            //
            use_vbr_ckbx = gtk_check_button_new_with_label(_("Use variable bitrate (VBR)"));
            gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(use_vbr_ckbx), config.encoder.mp2.use_vbr);

            // VBR quality
            frame = gtk_frame_new(NULL);
            gtk_frame_set_label_widget(GTK_FRAME(frame), use_vbr_ckbx);
            gtk_container_add(GTK_CONTAINER(vbox_mp2), frame);
            vbox_vbr_qual = gtk_vbox_new(false, 3);
            gtk_container_set_border_width(GTK_CONTAINER(vbox_vbr_qual), VBOX_BORDER_WIDTH);
            gtk_container_add(GTK_CONTAINER(frame), vbox_vbr_qual);

            vbr_qual_adj = gtk_adjustment_new(
                    (gfloat) CLAMP(config.encoder.mp2.vbr_quality,
                        MIN_MP2_VBR_QUALITY, MAX_MP2_VBR_QUALITY),
                    (float) MIN_MP2_VBR_QUALITY, (float) MAX_MP2_VBR_QUALITY, 0.1, 1.0, 0.0);
            vbr_qual_scale = gtk_hscale_new(GTK_ADJUSTMENT(vbr_qual_adj));
            gtk_scale_set_digits(GTK_SCALE(vbr_qual_scale), 2);

            for (int x = -50; x < 51; x+=10)
            {
                sprintf(str_q, "%d", x);
                gtk_scale_add_mark(GTK_SCALE(vbr_qual_scale), x, GTK_POS_BOTTOM, str_q);
            }
            gtk_container_add(GTK_CONTAINER(vbox_vbr_qual), vbr_qual_scale);
            label = gtk_label_new(_("-50=low quality and smaller files, 50=high quality and bigger files"));
            gtk_container_add(GTK_CONTAINER(vbox_vbr_qual), label);

            // CRC
            //
            use_crc_ckbx = gtk_check_button_new_with_label(_("Include CRC error protection"));
            gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(use_crc_ckbx), config.encoder.mp2.use_crc);
            gtk_container_add(GTK_CONTAINER(vbox_mp2), use_crc_ckbx);

            // MP2 Extra options
            //
            hbox = gtk_hbox_new(false, 0);
            gtk_box_pack_start(GTK_BOX(vbox_mp2), hbox, true, true, 0);

            label = gtk_label_new(_("Extra Options: "));
            gtk_box_pack_start(GTK_BOX(hbox), label, false, false, 0);

            extra_options_entry = gtk_entry_new_with_max_length(MAX_OPTIONS_LENGTH - 20);
            gtk_entry_set_text(GTK_ENTRY(extra_options_entry), config.encoder.mp2.extra_options.c_str());
            gtk_box_pack_start(GTK_BOX(hbox), extra_options_entry, true, true, 0);

            // Tab - End of encoder
            std::ostringstream tmp_label;
            tmp_label << "MP2\n(" << _("Lossy") << ")";
            label = gtk_label_new(tmp_label.str().c_str());
            gtk_notebook_append_page_menu(GTK_NOTEBOOK(notebook), vbox_mp2, label, label);
            return 0;
        }

        case OP_OK :
        {
            int cur_plugin = 0;
            std::ostringstream tmp;

            GtkWidget *item;

            // Plugin
            item = gtk_menu_get_active(GTK_MENU(encoder_menu));
            cur_plugin = 0;
            for (i = 0; i < encoder_plugins_count; i++)
                if (item == encoder_plugins[i].menu_item)
                {
                    cur_plugin = i;
                    break;
                }

            if (cur_plugin == 0)
            {
                config.encoder.mp2.enabled = 0;
                config.encoder.mp2.encoder = "";
                config.encoder.mp2.plugin = "";
            }
            else
            {
                config.encoder.mp2.enabled = (GTK_TOGGLE_BUTTON(use_mp2_ckbx)->active) ? 1 : 0;
                config.encoder.mp2.encoder = encoder_plugins[cur_plugin].encoder;
                config.encoder.mp2.plugin = encoder_plugins[cur_plugin].plugin;
            }

            // Other
            config.encoder.mp2.enabled = (GTK_TOGGLE_BUTTON(use_mp2_ckbx)->active) ? 1 : 0;
            config.encoder.mp2.encoder = encoder_plugins[cur_plugin].encoder;
            config.encoder.mp2.plugin = encoder_plugins[cur_plugin].plugin;

            config.encoder.mp2.bitrate = CLAMP((int) GTK_ADJUSTMENT(bitrate_adj)->value, MIN_MP2_BITRATE, MAX_MP2_BITRATE);
            config.encoder.mp2.use_vbr = (GTK_TOGGLE_BUTTON(use_vbr_ckbx)->active) ? 1 : 0;
            config.encoder.mp2.vbr_quality = CLAMP((float) GTK_ADJUSTMENT(vbr_qual_adj)->value,
                    MIN_MP2_VBR_QUALITY, MAX_MP2_VBR_QUALITY);
            config.encoder.mp2.use_crc = (GTK_TOGGLE_BUTTON(use_crc_ckbx)->active) ? 1 : 0;
            config.encoder.mp2.extra_options = gtk_entry_get_text(GTK_ENTRY(extra_options_entry));

            // Full command
            tmp.str("");
            tmp << config.encoder.mp2.encoder << " --brief";

            // Bitrate and VBR
            if (config.encoder.mp2.use_vbr)
            {
                if (strlen(encoder_plugins[cur_plugin].vbr_qual_op))
                    tmp << " " << encoder_plugins[cur_plugin].vbr_qual_op << " " << config.encoder.mp2.vbr_quality;
            }
            else
                tmp << " " << encoder_plugins[cur_plugin].bitrate_op << " " << config.encoder.mp2.bitrate;

            if (config.encoder.mp2.use_crc)
                tmp << " " << encoder_plugins[cur_plugin].crc_op;
            if (!config.encoder.mp2.extra_options.empty())
                tmp << " " << config.encoder.mp2.extra_options;

            config.encoder.mp2.full_command = tmp.str();

            return 0;
        }

        default: break;
    }
    return -1;
}

void config_window_encoders_handler(enum InterfaceCommon ops, _main_data *main_data, GtkWidget *main_vbox)
{
    static GtkWidget *enc_notebook = nullptr;
    static _main_data *saved_main_data;

    switch (ops)
    {
        case WIDGET_CREATE :
        {
            saved_main_data = main_data;

            load_plugins_state();
            load_enabled_encoder_types();

            enc_notebook = gtk_notebook_new();
            gtk_notebook_set_tab_pos(GTK_NOTEBOOK(enc_notebook), GTK_POS_TOP);
            gtk_container_set_border_width(GTK_CONTAINER(enc_notebook), 0);
            gtk_box_pack_start(GTK_BOX(main_vbox), enc_notebook, false, true, 0);

            cw_encoder_mp3_handler(WIDGET_CREATE, main_data, enc_notebook);
            cw_encoder_flac_handler(WIDGET_CREATE, main_data, enc_notebook);
            cw_encoder_ogg_handler(WIDGET_CREATE, main_data, enc_notebook);
            cw_encoder_musepack_handler(WIDGET_CREATE, main_data, enc_notebook);
            cw_encoder_opus_handler(WIDGET_CREATE, main_data, enc_notebook);
            cw_encoder_mp2_handler(WIDGET_CREATE, main_data, enc_notebook);
            break;
        }

        case OP_OK :
        {
            main_data = saved_main_data;

            cw_encoder_mp3_handler(OP_OK, main_data, NULL);
            cw_encoder_flac_handler(OP_OK, main_data, NULL);
            cw_encoder_ogg_handler(OP_OK, main_data, NULL);
            cw_encoder_musepack_handler(OP_OK, main_data, NULL);
            cw_encoder_opus_handler(OP_OK, main_data, NULL);
            cw_encoder_mp2_handler(OP_OK, main_data, NULL);

#ifdef DEBUG
            using std::cout, std::endl;

            encoder_common_data ec;
            std::vector<CommonEncoderType> ec_vec;
            ec_vec = get_encoding_types();

            printf("==Debug Info==\n");
            cout << "wav path : " << config.wav_path << " - mp3 path : " << config.mp3_path << "\n" << endl;
            cout << "wav format : " << config.wav_file_name_format << "   mp3 format : "
                    << config.encoded_file_name_format << "\n" << endl;
            cout << "prepend char : " << config.prepend_char << "   make mp3 from existing wav : "
                    << config.encode_from_existing_wav << "\n" << endl;

            printf("--Cd player  --\n");
            cout << "Play : " << config.cd_player.play_command << "    Stop : " << config.cd_player.stop_command << endl;

            printf("--Wav Player --\n");
            cout << "Command : " << config.wav_player.command << endl;

            printf("--Mp3 Player --\n");
            cout << "Command : " << config.mp3_player.command << endl;

            printf("--ripper     --\n");
            cout << "file : " << config.ripper.ripper << " - plugin : " << config.ripper.plugin << endl;

            for (auto const type : ec_vec)
            {
                config.getencoder_common_data(ec, type);

                printf("--encoder    --\n");
                cout << "file : " << ec.encoder << " - plugin : " << ec.plugin << endl;
                cout << "full command : " << ec.full_command << endl;
            }
#endif

            break;
        }

       default: break;
    }
}
