﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/chime-sdk-messaging/ChimeSDKMessaging_EXPORTS.h>
#include <aws/chime-sdk-messaging/model/ExpirationSettings.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace ChimeSDKMessaging {
namespace Model {
class PutChannelExpirationSettingsResult {
 public:
  AWS_CHIMESDKMESSAGING_API PutChannelExpirationSettingsResult() = default;
  AWS_CHIMESDKMESSAGING_API PutChannelExpirationSettingsResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_CHIMESDKMESSAGING_API PutChannelExpirationSettingsResult& operator=(
      const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The channel ARN.</p>
   */
  inline const Aws::String& GetChannelArn() const { return m_channelArn; }
  template <typename ChannelArnT = Aws::String>
  void SetChannelArn(ChannelArnT&& value) {
    m_channelArnHasBeenSet = true;
    m_channelArn = std::forward<ChannelArnT>(value);
  }
  template <typename ChannelArnT = Aws::String>
  PutChannelExpirationSettingsResult& WithChannelArn(ChannelArnT&& value) {
    SetChannelArn(std::forward<ChannelArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Settings that control the interval after which a channel is deleted.</p>
   */
  inline const ExpirationSettings& GetExpirationSettings() const { return m_expirationSettings; }
  template <typename ExpirationSettingsT = ExpirationSettings>
  void SetExpirationSettings(ExpirationSettingsT&& value) {
    m_expirationSettingsHasBeenSet = true;
    m_expirationSettings = std::forward<ExpirationSettingsT>(value);
  }
  template <typename ExpirationSettingsT = ExpirationSettings>
  PutChannelExpirationSettingsResult& WithExpirationSettings(ExpirationSettingsT&& value) {
    SetExpirationSettings(std::forward<ExpirationSettingsT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  PutChannelExpirationSettingsResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_channelArn;
  bool m_channelArnHasBeenSet = false;

  ExpirationSettings m_expirationSettings;
  bool m_expirationSettingsHasBeenSet = false;

  Aws::String m_requestId;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace ChimeSDKMessaging
}  // namespace Aws
