/*
 * Decompiled with CFR 0.152.
 */
package org.testng.xml;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.testng.xml.TestNGContentHandler;
import org.testng.xml.XmlSuite;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class Parser {
    public static final String TESTNG_DTD = "testng-1.0.dtd";
    public static final String DEPRECATED_TESTNG_DTD_URL = "http://beust.com/testng/testng-1.0.dtd";
    public static final String TESTNG_DTD_URL = "http://testng.org/testng-1.0.dtd";
    public static final String DEFAULT_FILENAME = "testng.xml";
    private final String m_fileName;
    private final InputStream m_inputStream;
    private boolean m_lookInJar = false;

    private Parser(String filename, InputStream inputStream) {
        this.m_fileName = filename;
        this.m_inputStream = inputStream;
    }

    public Parser(String fileName) throws FileNotFoundException {
        this(fileName, new FileInputStream(new File(fileName)));
    }

    public Parser(InputStream inputStream) {
        this(null, inputStream);
    }

    public Parser() throws FileNotFoundException {
        this(DEFAULT_FILENAME, Parser.getDefault());
    }

    private static InputStream getDefault() throws FileNotFoundException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        InputStream in = classLoader != null ? classLoader.getResourceAsStream(DEFAULT_FILENAME) : Parser.class.getResourceAsStream(DEFAULT_FILENAME);
        if (in == null) {
            throw new FileNotFoundException("Default property file of testng.xml was not found");
        }
        return in;
    }

    public XmlSuite parse() throws ParserConfigurationException, SAXException, IOException {
        XmlSuite result = null;
        TestNGContentHandler ch = new TestNGContentHandler(this.m_fileName);
        SAXParserFactory spf = null;
        try {
            spf = SAXParserFactory.newInstance();
        }
        catch (FactoryConfigurationError ex) {
            try {
                Class<?> cl = Class.forName("org.apache.crimson.jaxp.SAXParserFactoryImpl");
                spf = (SAXParserFactory)cl.newInstance();
            }
            catch (Exception ex2) {
                ex2.printStackTrace();
            }
        }
        spf.setValidating(true);
        SAXParser saxParser = spf.newSAXParser();
        saxParser.parse(this.m_inputStream, (DefaultHandler)ch);
        result = ch.getSuite();
        return result;
    }
}

