# Acceptance Criteria for memx Library (EARS Format)

## Memory Search Functions

### `memchr`
- **When** `memchr` is called with a buffer and a byte, **the system shall** return the index of the first occurrence of the byte.
- **When** `memchr` is called and the byte is not found, **the system shall** return `None`.

### `memrchr`
- **When** `memrchr` is called with a buffer and a byte, **the system shall** return the index of the last occurrence of the byte.
- **When** `memrchr` is called and the byte is not found, **the system shall** return `None`.

### Multi-byte Search (`memchr_dbl`, `memchr_tpl`, `memchr_qpl`)
- **When** a multi-byte search function is called, **the system shall** return the index of the first occurrence of any of the specified bytes.
- **When** a multi-byte search function is called and none of the bytes are found, **the system shall** return `None`.

### Negated Search (`memnechr`, `memnechr_dbl`, `memnechr_tpl`, `memnechr_qpl`)
- **When** a negated search function is called, **the system shall** return the index of the first byte that is *not* in the specified set.
- **When** a negated search function is called and all bytes in the buffer are in the specified set, **the system shall** return `None`.

### Sub-slice Search (`memmem`, `memrmem`)
- **When** `memmem` is called, **the system shall** return the starting index of the first occurrence of the `needle` in the `haystack`.
- **When** `memrmem` is called, **the system shall** return the starting index of the last occurrence of the `needle` in the `haystack`.
- **If** the `needle` is not found in the `haystack`, **then the system shall** return `None`.

## Memory Comparison Functions

### `memcmp`
- **When** `memcmp` is called, **the system shall** return an `Ordering` value indicating the lexicographical relationship between the two byte slices.

### `memeq`
- **When** `memeq` is called with two equal byte slices, **the system shall** return `true`.
- **When** `memeq` is called with two unequal byte slices, **the system shall** return `false`.

## Memory Manipulation Functions

### `memcpy`
- **When** `memcpy` is called, **the system shall** copy all bytes from the source slice to the destination slice.
- **If** the destination slice has a smaller capacity than the source slice, **then the system shall** return a `RangeError`.

### `memset`
- **When** `memset` is called, **the system shall** fill the entire buffer with the specified byte.

## Iterators

- **When** any iterator function (e.g., `memchr_iter`) is called, **the system shall** return an iterator that yields the indices of all occurrences of the specified byte or sub-slice.

## Performance

- **Where** the target architecture is x86 or x86-64, **the system shall** use the SSE2 and AVX2 optimized implementations for all memory functions.
- **Where** the target architecture is not x86 or x86-64, **the system shall** use the standard, platform-agnostic Rust implementation.

## API and Design

- **While** the system is compiled with the `no_std` flag, **the system shall** provide all `memx` functionalities without relying on the standard library.
