#!/usr/bin/env python
"""Run a set of tests by pytest

To run all tests::

    % export HGPATH=path/to/mercurial
    % ./run-tests.py -m 'not largefiles' --doctest-modules tests
    % ./run-tests.py -m largefiles tests

For details, please see:

- `./run-tests.py --help`
- https://docs.pytest.org/en/stable/
- http://docs.python.org/library/unittest.html
"""
import sys
import pytest
import pytestcaptureexc, pytesthgenv

def main():
    sys.exit(pytest.main(plugins=[pytestcaptureexc.CaptureExcPlugin(),
                                  pytesthgenv.HgEnvPlugin()]))

if __name__ == '__main__':
    main()
