/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.12.0
 *
 *     Copyright: (c) 2020 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_richtext.h"
        #include <wx/richtext/richtextstyles.h>
        #include <wx/richtext/richtextbuffer.h>
        #include <wx/richtext/richtextstyles.h>
        #include <wx/richtext/richtextbuffer.h>
        #include <wx/object.h>
        #include <wx/object.h>
        #include <wx/object.h>


class sipwxRichTextListStyleDefinition : public ::wxRichTextListStyleDefinition
{
public:
    sipwxRichTextListStyleDefinition(const ::wxString&);
    sipwxRichTextListStyleDefinition(const ::wxRichTextListStyleDefinition&);
    virtual ~sipwxRichTextListStyleDefinition();

    /*
     * There is a protected method for every virtual method visible from
     * this class.
     */
protected:
    ::wxRichTextAttr GetStyleMergedWithBase(const ::wxRichTextStyleSheet*) const SIP_OVERRIDE;

public:
    sipSimpleWrapper *sipPySelf;

private:
    sipwxRichTextListStyleDefinition(const sipwxRichTextListStyleDefinition &);
    sipwxRichTextListStyleDefinition &operator = (const sipwxRichTextListStyleDefinition &);

    char sipPyMethods[1];
};

sipwxRichTextListStyleDefinition::sipwxRichTextListStyleDefinition(const ::wxString& name): ::wxRichTextListStyleDefinition(name), sipPySelf(SIP_NULLPTR)
{
    memset(sipPyMethods, 0, sizeof (sipPyMethods));
}

sipwxRichTextListStyleDefinition::sipwxRichTextListStyleDefinition(const ::wxRichTextListStyleDefinition& a0): ::wxRichTextListStyleDefinition(a0), sipPySelf(SIP_NULLPTR)
{
    memset(sipPyMethods, 0, sizeof (sipPyMethods));
}

sipwxRichTextListStyleDefinition::~sipwxRichTextListStyleDefinition()
{
    sipInstanceDestroyedEx(&sipPySelf);
}

::wxRichTextAttr sipwxRichTextListStyleDefinition::GetStyleMergedWithBase(const ::wxRichTextStyleSheet*sheet) const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, const_cast<char *>(&sipPyMethods[0]), const_cast<sipSimpleWrapper **>(&sipPySelf), SIP_NULLPTR, sipName_GetStyleMergedWithBase);

    if (!sipMeth)
        return ::wxRichTextListStyleDefinition::GetStyleMergedWithBase(sheet);

    extern ::wxRichTextAttr sipVH__richtext_158(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, const ::wxRichTextStyleSheet*);

    return sipVH__richtext_158(sipGILState, 0, sipPySelf, sipMeth, sheet);
}


PyDoc_STRVAR(doc_wxRichTextListStyleDefinition_CombineWithParagraphStyle, "CombineWithParagraphStyle(indent, paraStyle, styleSheet=None) -> RichTextAttr\n"
"\n"
"This function combines the given paragraph style with the list style's\n"
"base attributes and level style matching the given indent, returning\n"
"the combined attributes.");

extern "C" {static PyObject *meth_wxRichTextListStyleDefinition_CombineWithParagraphStyle(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxRichTextListStyleDefinition_CombineWithParagraphStyle(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int indent;
        const ::wxRichTextAttr* paraStyle;
        ::wxRichTextStyleSheet* styleSheet = 0;
        ::wxRichTextListStyleDefinition *sipCpp;

        static const char *sipKwdList[] = {
            sipName_indent,
            sipName_paraStyle,
            sipName_styleSheet,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BiJ9|J8", &sipSelf, sipType_wxRichTextListStyleDefinition, &sipCpp, &indent, sipType_wxRichTextAttr, &paraStyle, sipType_wxRichTextStyleSheet, &styleSheet))
        {
            ::wxRichTextAttr*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxRichTextAttr(sipCpp->CombineWithParagraphStyle(indent, *paraStyle, styleSheet));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxRichTextAttr, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_RichTextListStyleDefinition, sipName_CombineWithParagraphStyle, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxRichTextListStyleDefinition_FindLevelForIndent, "FindLevelForIndent(indent) -> int\n"
"\n"
"This function finds the level (from 0 to 9) whose indentation\n"
"attribute mostly closely matches indent (expressed in tenths of a\n"
"millimetre).");

extern "C" {static PyObject *meth_wxRichTextListStyleDefinition_FindLevelForIndent(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxRichTextListStyleDefinition_FindLevelForIndent(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int indent;
        const ::wxRichTextListStyleDefinition *sipCpp;

        static const char *sipKwdList[] = {
            sipName_indent,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bi", &sipSelf, sipType_wxRichTextListStyleDefinition, &sipCpp, &indent))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->FindLevelForIndent(indent);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_RichTextListStyleDefinition, sipName_FindLevelForIndent, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxRichTextListStyleDefinition_GetCombinedStyle, "GetCombinedStyle(indent, styleSheet=None) -> RichTextAttr\n"
"\n"
"This function combines the list style's base attributes and the level\n"
"style matching the given indent, returning the combined attributes.");

extern "C" {static PyObject *meth_wxRichTextListStyleDefinition_GetCombinedStyle(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxRichTextListStyleDefinition_GetCombinedStyle(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int indent;
        ::wxRichTextStyleSheet* styleSheet = 0;
        ::wxRichTextListStyleDefinition *sipCpp;

        static const char *sipKwdList[] = {
            sipName_indent,
            sipName_styleSheet,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bi|J8", &sipSelf, sipType_wxRichTextListStyleDefinition, &sipCpp, &indent, sipType_wxRichTextStyleSheet, &styleSheet))
        {
            ::wxRichTextAttr*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxRichTextAttr(sipCpp->GetCombinedStyle(indent, styleSheet));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxRichTextAttr, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_RichTextListStyleDefinition, sipName_GetCombinedStyle, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxRichTextListStyleDefinition_GetCombinedStyleForLevel, "GetCombinedStyleForLevel(level, styleSheet=None) -> RichTextAttr\n"
"\n"
"This function combines the list style's base attributes and the style\n"
"for the specified level, returning the combined attributes.");

extern "C" {static PyObject *meth_wxRichTextListStyleDefinition_GetCombinedStyleForLevel(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxRichTextListStyleDefinition_GetCombinedStyleForLevel(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int level;
        ::wxRichTextStyleSheet* styleSheet = 0;
        ::wxRichTextListStyleDefinition *sipCpp;

        static const char *sipKwdList[] = {
            sipName_level,
            sipName_styleSheet,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bi|J8", &sipSelf, sipType_wxRichTextListStyleDefinition, &sipCpp, &level, sipType_wxRichTextStyleSheet, &styleSheet))
        {
            ::wxRichTextAttr*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxRichTextAttr(sipCpp->GetCombinedStyleForLevel(level, styleSheet));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxRichTextAttr, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_RichTextListStyleDefinition, sipName_GetCombinedStyleForLevel, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxRichTextListStyleDefinition_GetLevelAttributes, "GetLevelAttributes(level) -> RichTextAttr\n"
"\n"
"Returns the style for the given level.");

extern "C" {static PyObject *meth_wxRichTextListStyleDefinition_GetLevelAttributes(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxRichTextListStyleDefinition_GetLevelAttributes(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int level;
        const ::wxRichTextListStyleDefinition *sipCpp;

        static const char *sipKwdList[] = {
            sipName_level,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bi", &sipSelf, sipType_wxRichTextListStyleDefinition, &sipCpp, &level))
        {
            const ::wxRichTextAttr*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetLevelAttributes(level);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(const_cast< ::wxRichTextAttr *>(sipRes), sipType_wxRichTextAttr, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_RichTextListStyleDefinition, sipName_GetLevelAttributes, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxRichTextListStyleDefinition_GetLevelCount, "GetLevelCount() -> int\n"
"\n"
"Returns the number of levels.");

extern "C" {static PyObject *meth_wxRichTextListStyleDefinition_GetLevelCount(PyObject *, PyObject *);}
static PyObject *meth_wxRichTextListStyleDefinition_GetLevelCount(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxRichTextListStyleDefinition *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxRichTextListStyleDefinition, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetLevelCount();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_RichTextListStyleDefinition, sipName_GetLevelCount, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxRichTextListStyleDefinition_IsNumbered, "IsNumbered(level) -> bool\n"
"\n"
"Returns true if the given level has numbered list attributes.");

extern "C" {static PyObject *meth_wxRichTextListStyleDefinition_IsNumbered(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxRichTextListStyleDefinition_IsNumbered(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int level;
        const ::wxRichTextListStyleDefinition *sipCpp;

        static const char *sipKwdList[] = {
            sipName_level,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bi", &sipSelf, sipType_wxRichTextListStyleDefinition, &sipCpp, &level))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsNumbered(level);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_RichTextListStyleDefinition, sipName_IsNumbered, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxRichTextListStyleDefinition_SetLevelAttributes, "SetLevelAttributes(level, attr) -> None\n"
"\n"
"Sets the style for the given level.");

extern "C" {static PyObject *meth_wxRichTextListStyleDefinition_SetLevelAttributes(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxRichTextListStyleDefinition_SetLevelAttributes(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int level;
        const ::wxRichTextAttr* attr;
        ::wxRichTextListStyleDefinition *sipCpp;

        static const char *sipKwdList[] = {
            sipName_level,
            sipName_attr,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BiJ9", &sipSelf, sipType_wxRichTextListStyleDefinition, &sipCpp, &level, sipType_wxRichTextAttr, &attr))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetLevelAttributes(level, *attr);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_RichTextListStyleDefinition, sipName_SetLevelAttributes, SIP_NULLPTR);

    return SIP_NULLPTR;
}


/* Cast a pointer to a type somewhere in its inheritance hierarchy. */
extern "C" {static void *cast_wxRichTextListStyleDefinition(void *, const sipTypeDef *);}
static void *cast_wxRichTextListStyleDefinition(void *sipCppV, const sipTypeDef *targetType)
{
    ::wxRichTextListStyleDefinition *sipCpp = reinterpret_cast< ::wxRichTextListStyleDefinition *>(sipCppV);

    if (targetType == sipType_wxRichTextListStyleDefinition)
        return sipCppV;

    sipCppV = ((const sipClassTypeDef *)sipType_wxRichTextParagraphStyleDefinition)->ctd_cast(static_cast< ::wxRichTextParagraphStyleDefinition *>(sipCpp), targetType);
    if (sipCppV)
        return sipCppV;

    return SIP_NULLPTR;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxRichTextListStyleDefinition(void *, int);}
static void release_wxRichTextListStyleDefinition(void *sipCppV, int sipState)
{
    Py_BEGIN_ALLOW_THREADS

    if (sipState & SIP_DERIVED_CLASS)
        delete reinterpret_cast<sipwxRichTextListStyleDefinition *>(sipCppV);
    else
        delete reinterpret_cast< ::wxRichTextListStyleDefinition *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void *array_wxRichTextListStyleDefinition(Py_ssize_t);}
static void *array_wxRichTextListStyleDefinition(Py_ssize_t sipNrElem)
{
    return new ::wxRichTextListStyleDefinition[sipNrElem];
}


extern "C" {static void array_delete_wxRichTextListStyleDefinition(void *);}
static void array_delete_wxRichTextListStyleDefinition(void *sipCpp)
{
    delete[] reinterpret_cast< ::wxRichTextListStyleDefinition *>(sipCpp);
}


extern "C" {static void assign_wxRichTextListStyleDefinition(void *, Py_ssize_t, void *);}
static void assign_wxRichTextListStyleDefinition(void *sipDst, Py_ssize_t sipDstIdx, void *sipSrc)
{
    reinterpret_cast< ::wxRichTextListStyleDefinition *>(sipDst)[sipDstIdx] = *reinterpret_cast< ::wxRichTextListStyleDefinition *>(sipSrc);
}


extern "C" {static void *copy_wxRichTextListStyleDefinition(const void *, Py_ssize_t);}
static void *copy_wxRichTextListStyleDefinition(const void *sipSrc, Py_ssize_t sipSrcIdx)
{
    return new ::wxRichTextListStyleDefinition(reinterpret_cast<const ::wxRichTextListStyleDefinition *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_wxRichTextListStyleDefinition(sipSimpleWrapper *);}
static void dealloc_wxRichTextListStyleDefinition(sipSimpleWrapper *sipSelf)
{
    if (sipIsDerivedClass(sipSelf))
        reinterpret_cast<sipwxRichTextListStyleDefinition *>(sipGetAddress(sipSelf))->sipPySelf = SIP_NULLPTR;

    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxRichTextListStyleDefinition(sipGetAddress(sipSelf), sipIsDerivedClass(sipSelf));
    }
}


extern "C" {static void *init_type_wxRichTextListStyleDefinition(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_wxRichTextListStyleDefinition(sipSimpleWrapper *sipSelf, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    sipwxRichTextListStyleDefinition *sipCpp = SIP_NULLPTR;

    {
        const ::wxString& namedef = wxEmptyString;
        const ::wxString* name = &namedef;
        int nameState = 0;

        static const char *sipKwdList[] = {
            sipName_name,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "|J1", sipType_wxString, &name, &nameState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new sipwxRichTextListStyleDefinition(*name);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(name), sipType_wxString, nameState);

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            sipCpp->sipPySelf = sipSelf;

            return sipCpp;
        }
    }

    {
        const ::wxRichTextListStyleDefinition* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J9", sipType_wxRichTextListStyleDefinition, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new sipwxRichTextListStyleDefinition(*a0);
            Py_END_ALLOW_THREADS

            sipCpp->sipPySelf = sipSelf;

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


/* Define this type's super-types. */
static sipEncodedTypeDef supers_wxRichTextListStyleDefinition[] = {{51, 255, 1}};


static PyMethodDef methods_wxRichTextListStyleDefinition[] = {
    {sipName_CombineWithParagraphStyle, SIP_MLMETH_CAST(meth_wxRichTextListStyleDefinition_CombineWithParagraphStyle), METH_VARARGS|METH_KEYWORDS, doc_wxRichTextListStyleDefinition_CombineWithParagraphStyle},
    {sipName_FindLevelForIndent, SIP_MLMETH_CAST(meth_wxRichTextListStyleDefinition_FindLevelForIndent), METH_VARARGS|METH_KEYWORDS, doc_wxRichTextListStyleDefinition_FindLevelForIndent},
    {sipName_GetCombinedStyle, SIP_MLMETH_CAST(meth_wxRichTextListStyleDefinition_GetCombinedStyle), METH_VARARGS|METH_KEYWORDS, doc_wxRichTextListStyleDefinition_GetCombinedStyle},
    {sipName_GetCombinedStyleForLevel, SIP_MLMETH_CAST(meth_wxRichTextListStyleDefinition_GetCombinedStyleForLevel), METH_VARARGS|METH_KEYWORDS, doc_wxRichTextListStyleDefinition_GetCombinedStyleForLevel},
    {sipName_GetLevelAttributes, SIP_MLMETH_CAST(meth_wxRichTextListStyleDefinition_GetLevelAttributes), METH_VARARGS|METH_KEYWORDS, doc_wxRichTextListStyleDefinition_GetLevelAttributes},
    {sipName_GetLevelCount, meth_wxRichTextListStyleDefinition_GetLevelCount, METH_VARARGS, doc_wxRichTextListStyleDefinition_GetLevelCount},
    {sipName_IsNumbered, SIP_MLMETH_CAST(meth_wxRichTextListStyleDefinition_IsNumbered), METH_VARARGS|METH_KEYWORDS, doc_wxRichTextListStyleDefinition_IsNumbered},
    {sipName_SetLevelAttributes, SIP_MLMETH_CAST(meth_wxRichTextListStyleDefinition_SetLevelAttributes), METH_VARARGS|METH_KEYWORDS, doc_wxRichTextListStyleDefinition_SetLevelAttributes}
};

sipVariableDef variables_wxRichTextListStyleDefinition[] = {
    {PropertyVariable, sipName_LevelCount, &methods_wxRichTextListStyleDefinition[5], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
};

PyDoc_STRVAR(doc_wxRichTextListStyleDefinition, "RichTextListStyleDefinition(name='') -> None\n"
"\n"
"This class represents a list style definition, usually added to a\n"
"wxRichTextStyleSheet.");


sipClassTypeDef sipTypeDef__richtext_wxRichTextListStyleDefinition = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_SCC|SIP_TYPE_CLASS,
        sipNameNr_wxRichTextListStyleDefinition,
        SIP_NULLPTR,
        SIP_NULLPTR,
    },
    {
        sipNameNr_RichTextListStyleDefinition,
        {0, 0, 1},
        8, methods_wxRichTextListStyleDefinition,
        0, SIP_NULLPTR,
        1, variables_wxRichTextListStyleDefinition,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_wxRichTextListStyleDefinition,
    -1,
    -1,
    supers_wxRichTextListStyleDefinition,
    SIP_NULLPTR,
    init_type_wxRichTextListStyleDefinition,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_wxRichTextListStyleDefinition,
    assign_wxRichTextListStyleDefinition,
    array_wxRichTextListStyleDefinition,
    copy_wxRichTextListStyleDefinition,
    release_wxRichTextListStyleDefinition,
    cast_wxRichTextListStyleDefinition,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    array_delete_wxRichTextListStyleDefinition,
    sizeof (::wxRichTextListStyleDefinition),
};
