export function __null_aware_to_string(value) {
  return value != null ? "" + value : value
}

const __jsonPathSupport =  __args.jsonPathSupport

export function jsonPath(obj, path) {
  const result = __jsonPathSupport.applyJsonPath(JSON.stringify(obj), "" + path)
  return result
}

const __urlSearchParamsSupport = __args.urlSearchParamsSupport

export function URLSearchParams(options) {
  this.__delegate = __urlSearchParamsSupport(options)

  Object.defineProperty(this, "size", {
    get() {
      return this.__delegate.getSize()
    }
  })

  this.append = function (name, value) {
    this.__delegate.append('' + name, '' + value)
  }

  this.delete = function (name, value) {
    if (value === undefined) {
      value = null
    }
    this.__delegate.delete('' +name, __null_aware_to_string(value))
  }

  this.get = function (name) {
    return __null_aware_to_string(this.__delegate.get('' + name))
  }

  this.getAll = function (name) {
    let result = []
    for (let el of this.__delegate.getAll('' + name)) {
      result.push('' + el)
    }
    return result
  }

  this.has = function (name, value) {
    if (value === undefined) {
      value = null
    }
    return this.__delegate.has('' + name,  __null_aware_to_string(value))
  }

  this.set = function (name, value) {
    this.__delegate.set('' + name, '' + value)
  }

  this.sort = function () {
    this.__delegate.sort()
  }

  this.toString = function () {
    return '' + this.__delegate.toString()
  }

  // iteration
  this.entries = function () {
    const result = [];
    for (let el of this.__delegate.entries()) {
      result.push(['' + el.getFirst(), '' + el.getSecond()])
    }

    return result
  }

  this.keys = function () {
    const result = [];
    for (let [key, _] of this.entries()) {
      result.push(key);
    }
    return result
  }

  this.values = function () {
    const result = [];
    for (let [_, value] of this.entries()) {
      result.push(value);
    }
    return result;
  }

  this.forEach = function (callback) {
    for (let [key, value] of this.entries()) {
      callback(key, value, this)
    }
  }

  this[Symbol.iterator] = function () {
    return this.entries()[Symbol.iterator]()
  }
}

export function Variables(global) {
  this.vars = {}
  this.headers = {
    set: function (key, value) {
      __args.addFileSpecificHttpHeader(key, value);
    },
  }

  for (var key in global) {
    this.vars[key] = global[key]
  }

  this.set = function (varName, varValue) {
    this.vars[varName] = varValue
  }

  this.get = function (varName) {
    return this.vars[varName]
  }

  this.isEmpty = function () {
    return Object.keys(this.vars).length === 0
  }

  this.clear = function (varName) {
    delete this.vars[varName]
  }

  this.clearAll = function () {
    this.vars = {}
  }
};

export const __logPrinter = __args.logSupport;

export function __log() {
  const result = [];

  for (let arg of arguments) {
    if ((arg instanceof NodeList) && !(arg instanceof Node)) {
      result.push([arg, "xml-list"])
      continue
    }
    if ((arg instanceof Node) || (arg instanceof XMLElement) || (arg instanceof XMLDocument)) {
      result.push([arg, "xml"])
      continue
    }
    if (
      (arg instanceof Object && !(arg instanceof Function)) ||
      arg instanceof Array ||
      Object.prototype.toString.call(arg) === "[object JavaMap]" ||
      Object.prototype.toString.call(arg) === "[object JavaArray]" ||
      Object.prototype.toString.call(arg) === "[object JavaList]"
    ) {
      result.push([JSON.stringify(arg, null, 2), "json"])
      continue
    }
    else {
      result.push([String(arg), "text"])
    }
  }

  __logPrinter(result)
};

export const console = {
  log: __log,
};

/**
 * This function is null safeguard to prevent host NPE throwing, making javascript stack trace useless.
 * @param value
 * @private
 */
export function __nullableParameterCheck(value) {
  if (!value)
    throw new Error(`non-nullable value is null or undefined`)
}

export const ExitException = Java.type('com.intellij.httpClient.http.request.run.HttpClientCommonJsHandler.ExitScriptException')
export const _DOMParser = Java.type('com.intellij.httpClient.http.request.run.js.graalvm.dom.DOMParser')
export const XMLDocument = Java.type('com.intellij.httpClient.http.request.run.js.graalvm.dom.xml.XmlDomDocument')
const XMLElement = Java.type('com.intellij.httpClient.http.request.run.js.graalvm.dom.xml.XmlDomElement')
const Node = Java.type('com.intellij.httpClient.http.request.run.js.graalvm.dom.xml.XmlDomNode')
const XmlUtils = Java.type('com.intellij.httpClient.http.request.run.js.graalvm.dom.xml.XmlUtils')
const NodeList = Java.type('com.intellij.httpClient.http.request.run.js.graalvm.dom.xml.XmlDomList')
const XMLSerializer = Java.type('com.intellij.httpClient.http.request.run.js.graalvm.dom.xml.XmlSerializer')
const Window = Java.type('com.intellij.httpClient.http.request.run.js.graalvm.dom.Window')
const ProcessHandler = Java.type("com.intellij.httpClient.http.request.run.js.graalvm.process.ProcessHandler")

function DOMParserImpl() {
  return new _DOMParser();
};

/**
 * This null - parameter is workound, without 1st argument, for some reasons function get only null (should be investigated)
 */
Object.defineProperty(globalThis, "exec", {
  get: () => ProcessHandler.exec(null, __args.registeredCallbacks)
})

Object.defineProperty(globalThis, "spawn", {
  get: () => ProcessHandler.spawn(null, __args.registeredCallbacks)
})

Object.defineProperty(globalThis, "execFile", {
  get: () => ProcessHandler.execFile(null, __args.registeredCallbacks)
})

Object.defineProperty(globalThis, "execSync", {
  get: () => ProcessHandler.execSync
})

Object.defineProperty(globalThis, "spawnSync", {
  get: () => ProcessHandler.spawnSync
})

Object.defineProperty(globalThis, "execFileSync", {
  get: () => ProcessHandler.execFileSync
})


Object.defineProperty(globalThis, "DOMParser", {
  get: () => DOMParserImpl
})

Object.defineProperty(globalThis, "Node", {
  value: Node.consts
})

Object.defineProperty(globalThis, "XMLSerializer", {
  value: XMLSerializer
})

Object.defineProperty(globalThis, "XMLDocument", {
  value: XMLDocument
})


Object.defineProperty(globalThis, "xpath", {
  value: XmlUtils.xpath,
})

Object.defineProperty(globalThis, "console", {
  value: console
})

Object.defineProperty(globalThis, "Window", {
  value: Window
})

class InvalidCharacterError{};

Object.defineProperty(globalThis, "InvalidCharacterError", {
  value: InvalidCharacterError
})

Object.defineProperty(globalThis, "jsonPath", {
  value: jsonPath
})
