/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.completion.full.line.impl.feedback.ide;

import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.util.PlatformUtils;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.completion.full.line.impl.feedback.FeedbackSurveyStateComponent;
import org.jetbrains.completion.full.line.impl.feedback.ide.FullLineInIdeFeedbackSurveyConfig;
import org.jetbrains.completion.full.line.impl.feedback.ide.FullLineInIdeFeedbackSurveyConfigKt;
import org.jetbrains.completion.full.line.language.supporters.FullLineLanguageSupporter;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eJ\u0010\u0010\u000f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/completion/full/line/impl/feedback/ide/SurveyConfigProvider;", "", "<init>", "()V", "config", "Lorg/jetbrains/completion/full/line/impl/feedback/ide/FullLineInIdeFeedbackSurveyConfig$SurveyConfig;", "getConfig", "()Lorg/jetbrains/completion/full/line/impl/feedback/ide/FullLineInIdeFeedbackSurveyConfig$SurveyConfig;", "isSupported", "", "registerCompletion", "", "accepted", "language", "Lcom/intellij/lang/Language;", "isLanguageSupported", "intellij.fullLine.core.impl"})
public final class SurveyConfigProvider {
    @NotNull
    public static final SurveyConfigProvider INSTANCE = new SurveyConfigProvider();

    private SurveyConfigProvider() {
    }

    @Nullable
    public final FullLineInIdeFeedbackSurveyConfig.SurveyConfig getConfig() {
        return PlatformUtils.isIdeaUltimate() ? FullLineInIdeFeedbackSurveyConfig.SurveyConfig.IdeaUltimate : (PlatformUtils.isPyCharm() ? FullLineInIdeFeedbackSurveyConfig.SurveyConfig.PyCharm : (PlatformUtils.isWebStorm() ? FullLineInIdeFeedbackSurveyConfig.SurveyConfig.WebStorm : (PlatformUtils.isRider() ? FullLineInIdeFeedbackSurveyConfig.SurveyConfig.Rider : (PlatformUtils.isPhpStorm() ? FullLineInIdeFeedbackSurveyConfig.SurveyConfig.PhpStorm : (PlatformUtils.isGoIde() ? FullLineInIdeFeedbackSurveyConfig.SurveyConfig.GoIde : (PlatformUtils.isRubyMine() ? FullLineInIdeFeedbackSurveyConfig.SurveyConfig.RubyMine : null))))));
    }

    public final boolean isSupported() {
        if (this.getConfig() == null) {
            return false;
        }
        ApplicationInfo info = ApplicationInfo.getInstance();
        String majorVersion = info.getMajorVersion();
        String minorVersion = info.getMinorVersion();
        if (!StringsKt.startsWith$default((String)FullLineInIdeFeedbackSurveyConfigKt.access$getTARGET_VERSION$p(), (String)(majorVersion + "." + minorVersion), (boolean)false, (int)2, null)) {
            return false;
        }
        return !FeedbackSurveyStateComponent.Companion.getInstance().isNotificationShown();
    }

    public final void registerCompletion(boolean accepted, @NotNull Language language) {
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        if (!this.isSupported() || !this.isLanguageSupported(language)) {
            return;
        }
        FeedbackSurveyStateComponent feedbackState = FeedbackSurveyStateComponent.Companion.getInstance();
        feedbackState.fireCompletionShown(language);
        if (accepted) {
            feedbackState.fireCompletionAccepted();
        }
    }

    private final boolean isLanguageSupported(Language language) {
        return FullLineLanguageSupporter.Companion.getInstance(language) != null;
    }
}

