/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.inline.completion.impl.diagnostic;

import com.intellij.ml.inline.completion.impl.diagnostic.DiagnosticLoggersKt;
import com.intellij.ml.inline.completion.impl.diagnostic.MLCompletionEventListener;
import com.intellij.ml.inline.completion.impl.diagnostic.TextMessage;
import com.intellij.openapi.diagnostic.Logger;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import kotlin.time.TimeSource;
import kotlin.time.TimedValue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promises;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ-\u0010\u0006\u001a\u0002H\f\"\u0004\b\u0000\u0010\f2\u0006\u0010\b\u001a\u00020\t2\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\f0\u000eH\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000fJ\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0013J\u0016\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\tJ\u000e\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\tJ\u000e\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\tJ\u000e\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\tJ\u0016\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u0013J\u0010\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\tH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u001a"}, d2={"Lcom/intellij/ml/inline/completion/impl/diagnostic/MLCompletionLogger;", "", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "<init>", "(Lcom/intellij/openapi/diagnostic/Logger;)V", "logActionTime", "", "actionName", "", "actionTimeMs", "", "T", "action", "Lkotlin/Function0;", "(Ljava/lang/String;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "errorIfNotMessage", "", "throwable", "", "error", "text", "debug", "info", "warn", "sendTextMessage", "intellij.fullLine.core.completion"})
@SourceDebugExtension(value={"SMAP\ndiagnosticLoggers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 diagnosticLoggers.kt\ncom/intellij/ml/inline/completion/impl/diagnostic/MLCompletionLogger\n+ 2 measureTime.kt\nkotlin/time/MeasureTimeKt\n*L\n1#1,220:1\n95#2:221\n135#2,3:222\n*S KotlinDebug\n*F\n+ 1 diagnosticLoggers.kt\ncom/intellij/ml/inline/completion/impl/diagnostic/MLCompletionLogger\n*L\n86#1:221\n86#1:222,3\n*E\n"})
public final class MLCompletionLogger {
    @NotNull
    private final Logger log;

    public MLCompletionLogger(@NotNull Logger log) {
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        this.log = log;
    }

    public final void logActionTime(@NotNull String actionName, long actionTimeMs) {
        Intrinsics.checkNotNullParameter((Object)actionName, (String)"actionName");
        this.info("'" + actionName + "' took " + actionTimeMs + "ms");
    }

    public final <T> T logActionTime(@NotNull String actionName, @NotNull Function0<? extends T> action2) {
        Intrinsics.checkNotNullParameter((Object)actionName, (String)"actionName");
        Intrinsics.checkNotNullParameter(action2, (String)"action");
        boolean $i$f$logActionTime = false;
        boolean $i$f$measureTimedValue = false;
        TimeSource.Monotonic $this$measureTimedValue$iv$iv = TimeSource.Monotonic.INSTANCE;
        boolean $i$f$measureTimedValue2 = false;
        long mark$iv$iv = $this$measureTimedValue$iv$iv.markNow-z9LOYto();
        boolean bl = false;
        Object result$iv$iv = action2.invoke();
        TimedValue timedValue = new TimedValue(result$iv$iv, TimeSource.Monotonic.ValueTimeMark.elapsedNow-UwyO8pc((long)mark$iv$iv), null);
        Object value = timedValue.component1();
        long time = timedValue.component2-UwyO8pc();
        this.logActionTime(actionName, Duration.getInWholeMilliseconds-impl((long)time));
        return (T)value;
    }

    public final boolean errorIfNotMessage(@NotNull Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
        boolean errorLogged = Promises.errorIfNotMessage((Logger)this.log, (Throwable)throwable);
        if (errorLogged) {
            this.sendTextMessage(throwable.toString());
        }
        return errorLogged;
    }

    public final void error(@NotNull Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
        this.log.error(throwable);
        this.sendTextMessage(throwable.toString());
    }

    public final void error(@NotNull String text2, @NotNull Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
        this.log.error(text2, throwable);
        this.sendTextMessage(text2);
    }

    public final void error(@NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        this.log.error(text2);
        this.sendTextMessage(text2);
    }

    public final void debug(@NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        this.log.debug(text2);
        this.sendTextMessage(text2);
    }

    public final void info(@NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        this.log.info(text2);
        this.sendTextMessage(text2);
    }

    public final void warn(@NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        this.log.warn(text2);
        this.sendTextMessage(text2);
    }

    public final void warn(@NotNull String text2, @NotNull Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
        this.log.warn(text2, throwable);
        this.sendTextMessage(text2);
    }

    private final void sendTextMessage(String text2) {
        if (!DiagnosticLoggersKt.access$getDispatcher$p().hasListeners()) {
            return;
        }
        TextMessage message = new TextMessage(text2, System.currentTimeMillis());
        ((MLCompletionEventListener)DiagnosticLoggersKt.access$getDispatcher$p().getMulticaster()).onEvent(message);
    }
}

