/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.inline.completion.features.correctness;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u00002\u00020\u0001J\"\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000bH\u0016\u0082\u0001\u0003\f\r\u000e\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u000f\u00c0\u0006\u0001"}, d2={"Lcom/intellij/ml/inline/completion/features/correctness/EnrichmentTool;", "", "getLocationInSuggestion", "Lcom/intellij/openapi/util/TextRange;", "rangeInFile", "offset", "", "suggestion", "", "getErrorRangeInFile", "problemDescriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "Lcom/intellij/ml/inline/completion/features/correctness/InspectionBasedEnrichmentTool;", "Lcom/intellij/ml/inline/completion/features/correctness/OnRangeElementsEnrichmentTool;", "Lcom/intellij/ml/inline/completion/features/correctness/RawEnrichmentTool;", "intellij.fullLine.core.completion"})
public interface EnrichmentTool {
    @Nullable
    default public TextRange getLocationInSuggestion(@NotNull TextRange rangeInFile, int offset, @NotNull String suggestion2) {
        Intrinsics.checkNotNullParameter((Object)rangeInFile, (String)"rangeInFile");
        Intrinsics.checkNotNullParameter((Object)suggestion2, (String)"suggestion");
        TextRange textRange = new TextRange(0, suggestion2.length()).shiftRight(offset);
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"shiftRight(...)");
        TextRange suggestionLocationInFile = textRange;
        if (!suggestionLocationInFile.intersects(rangeInFile)) {
            return null;
        }
        TextRange textRange2 = suggestionLocationInFile.intersection(rangeInFile);
        Intrinsics.checkNotNull((Object)textRange2);
        return textRange2.shiftLeft(offset);
    }

    @NotNull
    default public TextRange getErrorRangeInFile(@NotNull ProblemDescriptor problemDescriptor) {
        InjectedLanguageManager injectionManager;
        TextRange rangeInElement;
        Intrinsics.checkNotNullParameter((Object)problemDescriptor, (String)"problemDescriptor");
        PsiElement psiElement = problemDescriptor.getPsiElement();
        PsiFile psiFile2 = psiElement.getContainingFile();
        TextRange textRange = problemDescriptor.getTextRangeInElement();
        if (textRange == null) {
            textRange = rangeInElement = new TextRange(0, psiElement.getTextLength());
        }
        if ((injectionManager = InjectedLanguageManager.getInstance((Project)psiElement.getProject())).isInjectedFragment(psiFile2)) {
            int offset = injectionManager.injectedToHost(psiElement, rangeInElement.getStartOffset());
            TextRange textRange2 = rangeInElement.shiftRight(offset);
            Intrinsics.checkNotNullExpressionValue((Object)textRange2, (String)"shiftRight(...)");
            return textRange2;
        }
        TextRange textRange3 = rangeInElement.shiftRight(psiElement.getTextRange().getStartOffset());
        Intrinsics.checkNotNullExpressionValue((Object)textRange3, (String)"shiftRight(...)");
        return textRange3;
    }
}

