/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlrpc;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.TimeZone;
import org.apache.xmlrpc.XmlRpcClientException;
import org.apache.xmlrpc.XmlRpcClientRequest;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.XmlWriter;

public class XmlRpcClientRequestProcessor {
    TimeZone tz;

    public XmlRpcClientRequestProcessor(TimeZone tz) {
        this.tz = tz;
    }

    public void encodeRequest(XmlRpcClientRequest request2, String encoding, OutputStream out) throws XmlRpcClientException, IOException {
        XmlWriter writer = new XmlWriter(out, encoding);
        writer.dateTool.setTimeZone(this.tz);
        writer.startElement("methodCall");
        writer.startElement("methodName");
        writer.write(request2.getMethodName());
        writer.endElement("methodName");
        writer.startElement("params");
        int l = request2.getParameterCount();
        for (int i = 0; i < l; ++i) {
            writer.startElement("param");
            try {
                writer.writeObject(request2.getParameter(i));
            }
            catch (XmlRpcException e) {
                throw new XmlRpcClientException("Failure writing request", e);
            }
            writer.endElement("param");
        }
        writer.endElement("params");
        writer.endElement("methodCall");
        writer.flush();
    }

    public byte[] encodeRequestBytes(XmlRpcClientRequest request2, String encoding) throws XmlRpcClientException {
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            this.encodeRequest(request2, encoding, buffer);
            return buffer.toByteArray();
        }
        catch (IOException ioe) {
            throw new XmlRpcClientException("Error occured encoding XML-RPC request", ioe);
        }
    }

    protected boolean canReUse() {
        return true;
    }
}

