/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.gherkin;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.python.gherkin.PyBDDUnnamedArgumentsGenerator;
import com.intellij.python.gherkin.matchers.PyBDDMatcher;
import com.jetbrains.python.documentation.docstrings.DocStringFormat;
import com.jetbrains.python.documentation.docstrings.DocStringParser;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyFromImportStatement;
import com.jetbrains.python.psi.impl.PyFunctionBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.cucumber.psi.GherkinScenarioOutline;
import org.jetbrains.plugins.cucumber.psi.GherkinStep;

public final class PyBDDCreationTools {
    private static final Pattern BAD_CHARS = Pattern.compile("[^a-zA-Z0-9_]+");
    private static final Pattern OUTLINE_PARAMS = Pattern.compile("<([^><]+)>");

    private PyBDDCreationTools() {
    }

    public static void addImportToFile(@NotNull PsiFile file, @NotNull String importTextToAdd) {
        if (file == null) {
            PyBDDCreationTools.$$$reportNull$$$0(0);
        }
        if (importTextToAdd == null) {
            PyBDDCreationTools.$$$reportNull$$$0(1);
        }
        LanguageLevel languageLevel = LanguageLevel.forElement((PsiElement)file);
        PyElementGenerator generator = PyElementGenerator.getInstance((Project)file.getProject());
        PyFromImportStatement statement = (PyFromImportStatement)generator.createFromText(languageLevel, PyFromImportStatement.class, importTextToAdd);
        file.add((PsiElement)statement);
    }

    /*
     * WARNING - void declaration
     */
    static void addStepDefinition(@NotNull PsiFile file, @NotNull String decoratorName2, @NotNull GherkinStep step, @Nullable PyBDDMatcher bddMatcher, Pair<String, String> ... functionParamWithType) {
        String stepDefDecoratorText;
        if (file == null) {
            PyBDDCreationTools.$$$reportNull$$$0(2);
        }
        if (decoratorName2 == null) {
            PyBDDCreationTools.$$$reportNull$$$0(3);
        }
        if (step == null) {
            PyBDDCreationTools.$$$reportNull$$$0(4);
        }
        if (functionParamWithType == null) {
            PyBDDCreationTools.$$$reportNull$$$0(5);
        }
        ArrayList<Pair<String, String>> params = new ArrayList<Pair<String, String>>(Arrays.asList(functionParamWithType));
        String stepSentence = step.getName();
        if (bddMatcher != null) {
            stepDefDecoratorText = bddMatcher.escapeSpecialChars(stepSentence);
            if (PsiTreeUtil.getParentOfType((PsiElement)step, GherkinScenarioOutline.class) != null) {
                Matcher matcher = OUTLINE_PARAMS.matcher(stepSentence);
                PyBDDUnnamedArgumentsGenerator argumentsGenerator = new PyBDDUnnamedArgumentsGenerator();
                while (matcher.find()) {
                    void var11_11;
                    Object paramName = matcher.group(1);
                    if (BAD_CHARS.matcher((CharSequence)paramName).find()) {
                        String string = bddMatcher.getUnnamedArgumentPlaceholder();
                        paramName = argumentsGenerator.generateArgName();
                    } else {
                        String string = String.format(bddMatcher.getNamedArgumentPlaceholder(), paramName);
                    }
                    stepDefDecoratorText = stepDefDecoratorText.replace(matcher.group(0), (CharSequence)var11_11);
                    params.add((Pair<String, String>)Pair.create((Object)paramName, (Object)"str"));
                }
            }
        } else {
            stepDefDecoratorText = stepSentence;
        }
        PyFunctionBuilder functionBuilder = new PyFunctionBuilder("step_impl", (PsiElement)file);
        functionBuilder.decorate(decoratorName2, stepDefDecoratorText);
        DocStringFormat format = DocStringParser.getConfiguredDocStringFormat((PsiElement)file);
        for (Pair pair : params) {
            if (format != DocStringFormat.PLAIN) {
                functionBuilder.parameterWithType((String)pair.first, (String)pair.second);
                continue;
            }
            functionBuilder.parameter((String)pair.first);
        }
        String stepText = String.format("raise NotImplementedError(u'STEP: %s')", StringUtil.escapeChar((String)step.getText(), (char)'\''));
        file.add((PsiElement)functionBuilder.statement(stepText).buildFunction());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importTextToAdd";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "decoratorName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "step";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionParamWithType";
                break;
            }
        }
        objectArray2[1] = "com/intellij/python/gherkin/PyBDDCreationTools";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addImportToFile";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "addStepDefinition";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

