/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ui.flamegraph;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.project.Project;
import com.intellij.profiler.statistics.ProfilerUsageTriggerCollector;
import com.intellij.profiler.ui.flamegraph.FlameGraphNode;
import com.intellij.profiler.ui.flamegraph.FlameGraphPanel;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JPopupMenu;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B%\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0014"}, d2={"Lcom/intellij/profiler/ui/flamegraph/FlameGraphMouseListener;", "T", "", "Ljava/awt/event/MouseAdapter;", "flameGraphPanel", "Lcom/intellij/profiler/ui/flamegraph/FlameGraphPanel;", "project", "Lcom/intellij/openapi/project/Project;", "actionGroup", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "<init>", "(Lcom/intellij/profiler/ui/flamegraph/FlameGraphPanel;Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/actionSystem/ActionGroup;)V", "getActionGroup", "()Lcom/intellij/openapi/actionSystem/ActionGroup;", "mouseReleased", "", "e", "Ljava/awt/event/MouseEvent;", "mousePressed", "handlePopupMouseEvent", "intellij.profiler.common"})
public class FlameGraphMouseListener<T>
extends MouseAdapter {
    @NotNull
    private final FlameGraphPanel<T> flameGraphPanel;
    @NotNull
    private final Project project;
    @NotNull
    private final ActionGroup actionGroup;

    public FlameGraphMouseListener(@NotNull FlameGraphPanel<T> flameGraphPanel2, @NotNull Project project, @NotNull ActionGroup actionGroup) {
        Intrinsics.checkNotNullParameter(flameGraphPanel2, (String)"flameGraphPanel");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)actionGroup, (String)"actionGroup");
        this.flameGraphPanel = flameGraphPanel2;
        this.project = project;
        this.actionGroup = actionGroup;
    }

    @NotNull
    protected final ActionGroup getActionGroup() {
        return this.actionGroup;
    }

    @Override
    public void mouseReleased(@NotNull MouseEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.handlePopupMouseEvent(e);
    }

    @Override
    public void mousePressed(@NotNull MouseEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.handlePopupMouseEvent(e);
    }

    private final void handlePopupMouseEvent(MouseEvent e) {
        JPopupMenu jPopupMenu;
        if (!e.isPopupTrigger()) {
            return;
        }
        Point point = e.getPoint();
        Intrinsics.checkNotNullExpressionValue((Object)point, (String)"getPoint(...)");
        FlameGraphNode<Point> flameGraphNode = this.flameGraphPanel.getNodeBounds(point);
        if (flameGraphNode == null) {
            return;
        }
        FlameGraphNode<Point> nodeBounds = flameGraphNode;
        this.flameGraphPanel.setSearchEnabled(false);
        FlameGraphPanel.selectNode$default(this.flameGraphPanel, nodeBounds, null, 2, null);
        JPopupMenu $this$handlePopupMouseEvent_u24lambda_u240 = jPopupMenu = ActionManager.getInstance().createActionPopupMenu("ProfilerFlameGraph", this.actionGroup).getComponent();
        boolean bl = false;
        ProfilerUsageTriggerCollector.logSnapshotInteraction$default(ProfilerUsageTriggerCollector.INSTANCE, this.project, ProfilerUsageTriggerCollector.SnapshotActionFusDescriptor.PROFILER_CONTEXT_MENU, this.flameGraphPanel.getComponentId(), null, 8, null);
        $this$handlePopupMouseEvent_u24lambda_u240.show((Component)((Object)this.flameGraphPanel), e.getX(), e.getY());
        this.flameGraphPanel.putClientProperty("FlameGraphPopup", $this$handlePopupMouseEvent_u24lambda_u240);
    }
}

