/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.heap.view.actions;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.project.DumbAwareToggleAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.treeStructure.treetable.TreeTable;
import com.jetbrains.nodejs.NodeJSBundle;
import com.jetbrains.nodejs.run.profile.heap.V8CachingReader;
import com.jetbrains.nodejs.run.profile.heap.calculation.ByteArrayWrapper;
import com.jetbrains.nodejs.run.profile.heap.data.V8HeapEntry;
import com.jetbrains.nodejs.run.profile.heap.view.actions.EntryDataGetter;
import com.jetbrains.nodejs.run.profile.heap.view.components.V8HeapComponent;
import java.util.function.Supplier;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public final class MarkUnmarkAction
extends DumbAwareToggleAction {
    public static final DataKey<V8HeapEntry> SELECTED_NODE = DataKey.create((String)"V8_SELECTED_NODE");
    public static final DataKey<Boolean> UNREACHABLE_NODE = DataKey.create((String)"V8_UNREACHABLE_NODE");
    public static final DataKey<Long> SELECTED_LINK = DataKey.create((String)"V8_SELECTED_LINK");
    public static final DataKey<Runnable> REVALIDATION = DataKey.create((String)"V8_REPAINT_REVALIDATE");
    public static final Supplier<@NlsActions.ActionText String> MARK = NodeJSBundle.messagePointer("action.MarkUnmarkAction.text", new Object[0]);
    public static final Supplier<@NlsActions.ActionDescription String> MARK_OBJECT_WITH_TEXT = NodeJSBundle.messagePointer("action.MarkUnmarkAction.description", new Object[0]);
    private final V8HeapComponent myHeapComponent;
    private final ByteArrayWrapper myDigest;
    private TreeTable myTable;

    public MarkUnmarkAction(@NotNull Project project, @NotNull V8CachingReader reader) {
        if (project == null) {
            MarkUnmarkAction.$$$reportNull$$$0(0);
        }
        if (reader == null) {
            MarkUnmarkAction.$$$reportNull$$$0(1);
        }
        super(MARK, MARK_OBJECT_WITH_TEXT, AllIcons.Actions.SetDefault);
        this.myDigest = reader.getDigest();
        this.myHeapComponent = V8HeapComponent.getInstance(project);
    }

    public void setTable(TreeTable table) {
        this.myTable = table;
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
        if (actionUpdateThread == null) {
            MarkUnmarkAction.$$$reportNull$$$0(2);
        }
        return actionUpdateThread;
    }

    public boolean isSelected(@NotNull AnActionEvent e) {
        if (e == null) {
            MarkUnmarkAction.$$$reportNull$$$0(3);
        }
        EntryDataGetter getter = new EntryDataGetter(e.getDataContext(), this.myTable);
        V8HeapEntry data = getter.getData();
        e.getPresentation().setEnabled(data != null && data.getId() != 0L && getter.getRunnable() != null && getter.getProject() != null);
        return data != null && this.myHeapComponent.getMark(this.myDigest, data) != null;
    }

    public void setSelected(@NotNull AnActionEvent e, boolean state) {
        if (e == null) {
            MarkUnmarkAction.$$$reportNull$$$0(4);
        }
        EntryDataGetter getter = new EntryDataGetter(e.getDataContext(), this.myTable);
        V8HeapEntry entry = getter.getData();
        Runnable runnable = getter.getRunnable();
        Project project = getter.getProject();
        if (project == null) {
            return;
        }
        if (entry != null && runnable != null) {
            MarkUnmarkAction.markOrUnmark(entry, project, this.myHeapComponent, this.myDigest);
            runnable.run();
        }
    }

    public static void markOrUnmark(@NotNull V8HeapEntry entry, @NotNull Project project, @NotNull V8HeapComponent heapComponent, @NotNull ByteArrayWrapper digest) {
        if (entry == null) {
            MarkUnmarkAction.$$$reportNull$$$0(5);
        }
        if (project == null) {
            MarkUnmarkAction.$$$reportNull$$$0(6);
        }
        if (heapComponent == null) {
            MarkUnmarkAction.$$$reportNull$$$0(7);
        }
        if (digest == null) {
            MarkUnmarkAction.$$$reportNull$$$0(8);
        }
        if (!StringUtil.isEmptyOrSpaces((String)heapComponent.getMark(digest, entry))) {
            heapComponent.markOrUnmark(digest, entry, "");
        } else {
            String text = Messages.showInputDialog((Project)project, (String)NodeJSBundle.message("dialog.message.mark.node.with.text", entry.getSnapshotObjectId()), (String)NodeJSBundle.message("dialog.title.mark.heap.object", new Object[0]), (Icon)Messages.getQuestionIcon());
            if (!StringUtil.isEmptyOrSpaces((String)text)) {
                heapComponent.markOrUnmark(digest, entry, text);
            }
        }
        ToolWindow window = ToolWindowManager.getInstance((Project)project).getToolWindow(V8HeapComponent.TOOL_WINDOW_TITLE.get());
        if (window != null) {
            JComponent component = window.getComponent();
            component.revalidate();
            component.repaint();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reader";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/nodejs/run/profile/heap/view/actions/MarkUnmarkAction";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entry";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "heapComponent";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "digest";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/nodejs/run/profile/heap/view/actions/MarkUnmarkAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isSelected";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setSelected";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "markOrUnmark";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

