/*
 * Decompiled with CFR 0.152.
 */
package org.angular2.inspections.quickfixes;

import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.javascript.web.js.WebJSResolveUtil;
import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.psi.impl.ES6ImportPsiUtil;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.angular2.lang.Angular2Bundle;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\r\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007H\u0016J\r\u0010\b\u001a\u00070\u0006\u00a2\u0006\u0002\b\tH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a8\u0006\u0010"}, d2={"Lorg/angular2/inspections/quickfixes/WrapWithForwardRefQuickFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "Lcom/intellij/codeInsight/intention/HighPriorityAction;", "<init>", "()V", "getFamilyName", "", "Lcom/intellij/codeInspection/util/IntentionFamilyName;", "getName", "Lcom/intellij/codeInspection/util/IntentionName;", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "intellij.angular"})
public final class WrapWithForwardRefQuickFix
implements LocalQuickFix,
HighPriorityAction {
    @NotNull
    public String getFamilyName() {
        return Angular2Bundle.Companion.message("angular.quickfix.wrap-with-forwardRef.family", new Object[0]);
    }

    @NotNull
    public String getName() {
        return this.getFamilyName();
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        PsiElement psiElement = descriptor.getPsiElement();
        JSReferenceExpression jSReferenceExpression = psiElement instanceof JSReferenceExpression ? (JSReferenceExpression)psiElement : null;
        if (jSReferenceExpression == null) {
            return;
        }
        JSReferenceExpression reference = jSReferenceExpression;
        PsiElement psiElement2 = WebJSResolveUtil.INSTANCE.resolveSymbolFromNodeModule((PsiElement)reference, "@angular/core", "forwardRef", PsiElement.class);
        if (psiElement2 == null) {
            return;
        }
        PsiElement forwardRefFun = psiElement2;
        ASTNode aSTNode = JSChangeUtil.createExpressionWithContext((String)("forwardRef(() => " + reference.getText() + ")"), (PsiElement)((PsiElement)reference));
        if (aSTNode == null || (aSTNode = aSTNode.getPsi()) == null) {
            return;
        }
        ASTNode forwardRefCall = aSTNode;
        PsiElement newContext = reference.replace((PsiElement)forwardRefCall);
        ES6ImportPsiUtil.insertJSImport((PsiElement)newContext, (String)"forwardRef", (PsiElement)forwardRefFun, null);
    }
}

