/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.editor.ui;

import com.intellij.jupyter.core.editor.ui.NotebookCellTagCompletionProvider;
import com.intellij.jupyter.core.fus.JupyterFeaturesCollector;
import com.intellij.jupyter.core.fus.JupyterFusAddTagResult;
import com.intellij.jupyter.core.fus.JupyterFusAddTagSource;
import com.intellij.jupyter.core.jupyter.JupyterBundle;
import com.intellij.jupyter.core.jupyter.nbformat.metadata.JupyterTag;
import com.intellij.jupyter.core.jupyter.nbformat.tags.JupyterTagsService;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.util.textCompletion.TextCompletionProvider;
import com.intellij.util.textCompletion.TextFieldWithCompletion;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\u000e\u001a\u00020\u000fH\u0014J\b\u0010\u0010\u001a\u00020\u000fH\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/jupyter/core/editor/ui/NotebookCellAddTagDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "cellIndex", "", "source", "Lcom/intellij/jupyter/core/fus/JupyterFusAddTagSource;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/editor/Editor;ILcom/intellij/jupyter/core/fus/JupyterFusAddTagSource;)V", "textField", "Lcom/intellij/util/textCompletion/TextFieldWithCompletion;", "doOKAction", "", "doCancelAction", "createCenterPanel", "Ljavax/swing/JComponent;", "intellij.jupyter.core"})
@ApiStatus.Internal
public final class NotebookCellAddTagDialog
extends DialogWrapper {
    @NotNull
    private final Editor editor;
    private final int cellIndex;
    @NotNull
    private final JupyterFusAddTagSource source;
    @NotNull
    private final TextFieldWithCompletion textField;

    /*
     * WARNING - void declaration
     */
    public NotebookCellAddTagDialog(@NotNull Project project, @NotNull Editor editor, int cellIndex, @NotNull JupyterFusAddTagSource source) {
        void $this$textField_u24lambda_u240;
        TextFieldWithCompletion textFieldWithCompletion;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)((Object)source), (String)"source");
        super(project);
        this.editor = editor;
        this.cellIndex = cellIndex;
        this.source = source;
        TextFieldWithCompletion textFieldWithCompletion2 = textFieldWithCompletion = new TextFieldWithCompletion(project, (TextCompletionProvider)new NotebookCellTagCompletionProvider(this.editor), "", true, true, false);
        NotebookCellAddTagDialog notebookCellAddTagDialog = this;
        boolean bl = false;
        $this$textField_u24lambda_u240.addDocumentListener(new DocumentListener(this){
            final /* synthetic */ NotebookCellAddTagDialog this$0;
            {
                this.this$0 = $receiver;
            }

            public void documentChanged(DocumentEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                String string = event.getDocument().getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                boolean okButtonActive = ((CharSequence)string).length() > 0;
                this.this$0.setOKActionEnabled(okButtonActive);
            }
        });
        $this$textField_u24lambda_u240.setPlaceholder((CharSequence)JupyterBundle.message("jupyter.action.cell.add.tag.dialog.text.field.placeholder", new Object[0]));
        $this$textField_u24lambda_u240.setShowPlaceholderWhenFocused(true);
        $this$textField_u24lambda_u240.setBorder(BorderFactory.createEmptyBorder(6, 0, 8, 0));
        $this$textField_u24lambda_u240.setPreferredWidth($this$textField_u24lambda_u240.getFontMetrics($this$textField_u24lambda_u240.getFont()).stringWidth(StringsKt.repeat((CharSequence)"*", (int)35)));
        notebookCellAddTagDialog.textField = textFieldWithCompletion;
        super.init();
        this.setTitle(JupyterBundle.message("jupyter.action.cell.add.tag.dialog.title", new Object[0]));
        this.setOKButtonText(JupyterBundle.message("jupyter.action.cell.add.tag.dialog.ok.text", new Object[0]));
        String string = this.textField.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        this.setOKActionEnabled(((CharSequence)string).length() > 0);
        this.myPreferredFocusedComponent = (JComponent)this.textField;
    }

    protected void doOKAction() {
        String string = this.textField.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        if (((CharSequence)string).length() == 0) {
            return;
        }
        JupyterTagsService jupyterTagsService = JupyterTagsService.Companion.getInstance();
        String string2 = this.textField.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
        jupyterTagsService.addTagToCell(this.editor, this.cellIndex, new JupyterTag(string2));
        JupyterFeaturesCollector.Companion.onAddTagDialogClosed(this.source, JupyterFusAddTagResult.TAG_ADDED);
        this.close(0);
    }

    public void doCancelAction() {
        JupyterFeaturesCollector.Companion.onAddTagDialogClosed(this.source, JupyterFusAddTagResult.CANCEL);
        super.doCancelAction();
    }

    @NotNull
    protected JComponent createCenterPanel() {
        return (JComponent)this.textField;
    }
}

