/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.actions.colors;

import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.css.util.CssPsiUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.PsiElement;
import com.intellij.psi.css.CssBundle;
import com.intellij.psi.css.CssElementFactory;
import com.intellij.psi.css.actions.colors.CssColorIntentionBase;
import com.intellij.psi.css.browse.ColorDeclarationType;
import com.intellij.psi.css.impl.util.CssPsiColorUtil;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.IncorrectOperationException;
import java.awt.Color;
import org.jetbrains.annotations.NotNull;

public abstract class CssConvertColorIntention
extends CssColorIntentionBase {
    @NotNull
    @NlsSafe
    private final String myColorTypeInFamilyName;
    private boolean myWithAlphaChannel;

    public CssConvertColorIntention(@NotNull @NlsSafe String colorTypeInFamilyName) {
        if (colorTypeInFamilyName == null) {
            CssConvertColorIntention.$$$reportNull$$$0(0);
        }
        this.myColorTypeInFamilyName = colorTypeInFamilyName;
    }

    @NotNull
    protected abstract String convert(@NotNull Color var1, @NotNull PsiElement var2);

    @NotNull
    @NlsSafe
    protected abstract String getNewColorTypeName(boolean var1);

    protected abstract boolean isApplied(@NotNull ColorDeclarationType var1, @NotNull Color var2);

    @NotNull
    @IntentionName
    public String getText() {
        String string = CssBundle.message("css.intentions.color.convert", this.getNewColorTypeName(this.myWithAlphaChannel));
        if (string == null) {
            CssConvertColorIntention.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    @IntentionFamilyName
    public String getFamilyName() {
        String string = CssBundle.message("css.intentions.color.convert", this.myColorTypeInFamilyName);
        if (string == null) {
            CssConvertColorIntention.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public boolean isAvailable(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element) {
        Color color;
        if (project == null) {
            CssConvertColorIntention.$$$reportNull$$$0(3);
        }
        if (editor == null) {
            CssConvertColorIntention.$$$reportNull$$$0(4);
        }
        if (element == null) {
            CssConvertColorIntention.$$$reportNull$$$0(5);
        }
        if (!super.isAvailable(project, editor, element)) {
            return false;
        }
        PsiElement colorTerm = CssConvertColorIntention.getPossibleColorTerm(element);
        if (colorTerm != null && (color = CssPsiColorUtil.getColor(colorTerm)) != null) {
            ColorDeclarationType colorType = ColorDeclarationType.fromColorTerm(colorTerm);
            this.myWithAlphaChannel = colorType.withAlphaChannel();
            return this.isApplied(colorType, color);
        }
        return false;
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        PsiElement colorTerm;
        if (project == null) {
            CssConvertColorIntention.$$$reportNull$$$0(6);
        }
        if (editor == null) {
            CssConvertColorIntention.$$$reportNull$$$0(7);
        }
        if (element == null) {
            CssConvertColorIntention.$$$reportNull$$$0(8);
        }
        if ((colorTerm = CssConvertColorIntention.getPossibleColorTerm(element)) != null) {
            Color color = CssPsiColorUtil.getColor(colorTerm);
            if (color != null) {
                String newColor = this.convert(color, element);
                colorTerm.replace((PsiElement)CssElementFactory.getInstance(project).createTerm(newColor, CssPsiUtil.getStylesheetLanguage(colorTerm)));
            } else {
                CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)CssBundle.message("css.intentions.color.convert.error", colorTerm.getText(), this.getNewColorTypeName(this.myWithAlphaChannel)), (String)"", null);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "colorTypeInFamilyName";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/css/actions/colors/CssConvertColorIntention";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/css/actions/colors/CssConvertColorIntention";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }
}

